/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.client.CallbackPanel;
import org.netbeans.modules.websvc.wsitconf.ui.client.nodes.AdvancedConfigurationClientNode;
import org.netbeans.modules.websvc.wsitconf.ui.client.nodes.BindingContainerClientNode;
import org.netbeans.modules.websvc.wsitconf.ui.client.nodes.CallbackClientNode;
import org.netbeans.modules.websvc.wsitconf.ui.client.nodes.STSClientNode;
import org.netbeans.modules.websvc.wsitconf.ui.client.nodes.TransportClientNode;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RequiredConfigurationHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.UsernameToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ClientView
extends SectionView {
    static final String KEYSTORE_NODE_ID = "keystore";
    static final String CALLBACK_NODE_ID = "callback";
    static final String STS_NODE_ID = "sts";
    static final String TRANSPORT_NODE_ID = "transpotr";
    static final String ADVANCEDCONFIG_NODE_ID = "advancedconfig";

    ClientView(InnerPanelFactory factory, WSDLModel clientModel, WSDLModel serviceModel, Collection<Port> ports) {
        super(factory);
        Children.Array rootChildren = new Children.Array();
        AbstractNode root = new AbstractNode((Children)rootChildren);
        HashSet<Binding> bindings = new HashSet<Binding>();
        WSITModelSupport.fillImportedBindings(clientModel, bindings, new HashSet<FileObject>());
        if (ports != null) {
            for (Port port : ports) {
                QName bqname = port.getBinding().getQName();
                Binding b = (Binding)clientModel.findComponentByName(bqname, Binding.class);
                if (b == null) continue;
                bindings.add(b);
            }
        }
        ArrayList<BindingContainerClientNode> bindingNodes = new ArrayList<BindingContainerClientNode>();
        if (bindings.size() > 1) {
            for (Binding binding : bindings) {
                ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
                Children.Array bindingChildren = new Children.Array();
                BindingContainerClientNode bindingNodeContainer = new BindingContainerClientNode((Children)bindingChildren);
                SectionContainer bindingCont = new SectionContainer((SectionView)this, (Node)bindingNodeContainer, NbBundle.getMessage(ClientView.class, (String)"LBL_Binding", (Object)binding.getName()));
                TransportClientNode transportNode = new TransportClientNode();
                SectionPanel transportPanel = new SectionPanel((SectionView)this, (Node)transportNode, (Object)(TRANSPORT_NODE_ID + binding.getName()), false);
                bindingCont.addSection((NodeSectionPanel)transportPanel);
                nodes.add(transportNode);
                if (this.isCallBackConfigRequired(binding, serviceModel) || this.isStoreConfigRequired(binding, serviceModel)) {
                    CallbackClientNode callbackNode = new CallbackClientNode();
                    SectionPanel callbackPanel = new SectionPanel((SectionView)this, (Node)callbackNode, (Object)(CALLBACK_NODE_ID + binding.getName()), true);
                    bindingCont.addSection((NodeSectionPanel)callbackPanel);
                    nodes.add(callbackNode);
                }
                if (this.isClientSTSConfigRequired(binding, serviceModel)) {
                    STSClientNode stsNode = new STSClientNode();
                    SectionPanel stsPanel = new SectionPanel((SectionView)this, (Node)stsNode, (Object)(STS_NODE_ID + binding.getName()));
                    bindingCont.addSection((NodeSectionPanel)stsPanel);
                    nodes.add(stsNode);
                }
                if (this.isClientAdvancedConfigRequired(binding, serviceModel)) {
                    AdvancedConfigurationClientNode advancedConfigNode = new AdvancedConfigurationClientNode();
                    SectionPanel advancedConfigPanel = new SectionPanel((SectionView)this, (Node)advancedConfigNode, (Object)(ADVANCEDCONFIG_NODE_ID + binding.getName()));
                    bindingCont.addSection((NodeSectionPanel)advancedConfigPanel);
                    nodes.add(advancedConfigNode);
                }
                bindingChildren.add(nodes.toArray(new Node[nodes.size()]));
                this.addSection((NodeSectionPanel)bindingCont, false);
                bindingNodes.add(bindingNodeContainer);
            }
            rootChildren.add(bindingNodes.toArray(new Node[bindingNodes.size()]));
        } else if (bindings.size() > 0) {
            Binding binding = (Binding)bindings.toArray()[0];
            ArrayList<AbstractNode> nodes = new ArrayList<AbstractNode>();
            TransportClientNode transportNode = new TransportClientNode();
            SectionPanel transportPanel = new SectionPanel((SectionView)this, (Node)transportNode, (Object)(TRANSPORT_NODE_ID + binding.getName()), false);
            this.addSection((NodeSectionPanel)transportPanel);
            nodes.add(transportNode);
            if (this.isCallBackConfigRequired(binding, serviceModel) || this.isStoreConfigRequired(binding, serviceModel)) {
                CallbackClientNode callbackNode = new CallbackClientNode();
                SectionPanel callbackPanel = new SectionPanel((SectionView)this, (Node)callbackNode, (Object)(CALLBACK_NODE_ID + binding.getName()), true);
                this.addSection((NodeSectionPanel)callbackPanel);
                nodes.add(callbackNode);
            }
            if (this.isClientSTSConfigRequired(binding, serviceModel)) {
                STSClientNode stsNode = new STSClientNode();
                SectionPanel stsPanel = new SectionPanel((SectionView)this, (Node)stsNode, (Object)(STS_NODE_ID + binding.getName()));
                this.addSection((NodeSectionPanel)stsPanel);
                nodes.add(stsNode);
            }
            if (this.isClientAdvancedConfigRequired(binding, serviceModel)) {
                AdvancedConfigurationClientNode advancedConfigNode = new AdvancedConfigurationClientNode();
                SectionPanel advancedConfigPanel = new SectionPanel((SectionView)this, (Node)advancedConfigNode, (Object)(ADVANCEDCONFIG_NODE_ID + binding.getName()));
                this.addSection((NodeSectionPanel)advancedConfigPanel);
                nodes.add(advancedConfigNode);
            }
            rootChildren.add(nodes.toArray(new Node[nodes.size()]));
        }
        this.setRoot((Node)root);
    }

    private boolean isClientSTSConfigRequired(Binding binding, WSDLModel serviceModel) {
        Binding serviceBinding = PolicyModelHelper.getBinding(serviceModel, binding.getName());
        String profile = ProfilesModelHelper.getWSITSecurityProfile((WSDLComponent)serviceBinding);
        return ComboConstants.PROF_STSISSUED.equals(profile) || ComboConstants.PROF_STSISSUEDENDORSE.equals(profile) || ComboConstants.PROF_STSISSUEDSUPPORTING.equals(profile) || ComboConstants.PROF_STSISSUEDCERT.equals(profile);
    }

    private boolean isClientAdvancedConfigRequired(Binding binding, WSDLModel serviceModel) {
        Binding serviceBinding = PolicyModelHelper.getBinding(serviceModel, binding.getName());
        boolean rmEnabled = RMModelHelper.getInstance(ConfigVersion.CONFIG_1_0).isRMEnabled((WSDLComponent)serviceBinding) || RMModelHelper.getInstance(ConfigVersion.CONFIG_1_3).isRMEnabled((WSDLComponent)serviceBinding) || RMModelHelper.getInstance(ConfigVersion.CONFIG_2_0).isRMEnabled((WSDLComponent)serviceBinding);
        boolean secConvRequired = RequiredConfigurationHelper.isSecureConversationParamRequired((WSDLComponent)serviceBinding);
        return rmEnabled || secConvRequired;
    }

    private boolean isStoreConfigRequired(Binding binding, WSDLModel serviceModel) {
        Binding serviceBinding = PolicyModelHelper.getBinding(serviceModel, binding.getName());
        String profile = ProfilesModelHelper.getWSITSecurityProfile((WSDLComponent)serviceBinding);
        if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)serviceBinding)) {
            return false;
        }
        return CallbackPanel.isStoreConfigRequired(profile, false, serviceBinding) || CallbackPanel.isStoreConfigRequired(profile, true, serviceBinding);
    }

    private boolean isCallBackConfigRequired(Binding binding, WSDLModel serviceModel) {
        Binding serviceBinding = PolicyModelHelper.getBinding(serviceModel, binding.getName());
        String profile = ProfilesModelHelper.getWSITSecurityProfile((WSDLComponent)serviceBinding);
        if (!SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)serviceBinding)) {
            return false;
        }
        ArrayList<Object> compsToTry = new ArrayList<Object>();
        compsToTry.add(serviceBinding);
        Collection ops = serviceBinding.getBindingOperations();
        for (BindingOperation bindingOperation : ops) {
            BindingOutput bo;
            BindingInput bi = bindingOperation.getBindingInput();
            if (bi != null) {
                compsToTry.add(bi);
            }
            if ((bo = bindingOperation.getBindingOutput()) != null) {
                compsToTry.add(bo);
            }
            Collection bfs = bindingOperation.getBindingFaults();
            for (BindingFault bf : bfs) {
                if (bf == null) continue;
                compsToTry.add(bf);
            }
        }
        for (WSDLComponent wSDLComponent : compsToTry) {
            List<WSDLComponent> suppTokens = SecurityTokensModelHelper.getSupportingTokens(wSDLComponent);
            if (suppTokens == null || suppTokens.isEmpty()) continue;
            for (WSDLComponent suppToken : suppTokens) {
                WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(suppToken);
                if (!(token instanceof UsernameToken)) continue;
                return true;
            }
        }
        return !ComboConstants.PROF_MUTUALCERT.equals(profile) && !ComboConstants.PROF_ENDORSCERT.equals(profile) && !ComboConstants.PROF_MSGAUTHSSL.equals(profile) && !ComboConstants.PROF_TRANSPORT.equals(profile);
    }
}

