/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.samples;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.websvc.metro.samples.PanelConfigureProject;
import org.netbeans.modules.websvc.metro.samples.WebSampleProjectGenerator;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WebSampleProjectIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4L;
    int currentIndex;
    transient PanelConfigureProject basicPanel;
    private transient WizardDescriptor wiz;
    private transient FileChangeListener fcl = new NbprojectFileChangeListener();

    static Object create() {
        return new WebSampleProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        return this.basicPanel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.wiz = templateWizard;
        String name = templateWizard.getTemplate().getName();
        templateWizard.putProperty("name", (Object)name);
        this.basicPanel = new PanelConfigureProject();
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.basicPanel = null;
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.currentIndex = -1;
    }

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        File projectLocation = (File)this.wiz.getProperty("projdir");
        String name = (String)this.wiz.getProperty("name");
        String serverID = (String)this.wiz.getProperty("server");
        Collection<FileObject> prjLocs = null;
        prjLocs = WebSampleProjectGenerator.createProjectFromTemplate(templateWizard.getTemplate().getPrimaryFile(), projectLocation, name, serverID);
        HashSet<Object> hset = new HashSet<Object>();
        for (FileObject prj : prjLocs) {
            FileObject nbprojectDir;
            FileObject webRoot = prj.getFileObject("web");
            FileObject index = this.getIndexFile(webRoot);
            if (webRoot != null) {
                hset.add(DataObject.find((FileObject)prj));
            }
            if (index != null) {
                hset.add(DataObject.find((FileObject)index));
            }
            if (!prj.getName().contains("Client") || (nbprojectDir = prj.getFileObject("nbproject")) == null) continue;
            hset.add(nbprojectDir);
            FileChangeListener weakListener = FileUtil.weakFileChangeListener((FileChangeListener)this.fcl, (Object)nbprojectDir);
            nbprojectDir.addFileChangeListener(weakListener);
        }
        return hset;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = new String[]{NbBundle.getMessage(PanelConfigureProject.class, (String)"LBL_NWP1_ProjectTitleName")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", this.currentIndex);
    }

    private FileObject getIndexFile(FileObject webRoot) {
        FileObject file = null;
        file = webRoot.getFileObject("index", "jsp");
        if (file == null) {
            file = webRoot.getFileObject("index", "html");
        }
        return file;
    }

    private static class NbprojectFileChangeListener
    extends FileChangeAdapter {
        private NbprojectFileChangeListener() {
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject nbprojectDir;
            FileObject buildImplFo;
            if ("jaxws-build.xml".equals(fe.getFile().getNameExt()) && (buildImplFo = (nbprojectDir = (FileObject)fe.getSource()).getFileObject("build-impl.xml")) != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-generate"}, null);
                            wsimportTask.waitFinished();
                        }
                        catch (IllegalArgumentException wsimportTask) {
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }, 1000);
            }
        }
    }
}

