/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FileSystemStatCache;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierInfoLookup;
import org.clang.lex.PTHLexer;
import org.clang.lex.Preprocessor;
import org.clang.lex.impl.PTHFileData;
import org.clang.lex.impl.PTHFileLookupCommonTrait;
import org.clang.lex.impl.PTHLexerStatics;
import org.clang.lex.impl.PTHStatCache;
import org.clang.lex.java.PTHManagerDriver;
import org.clang.lex.java.impl.PTHFileLookup;
import org.clang.lex.java.impl.PTHManagerSingleFile;
import org.clang.lex.java.impl.PTHStringIdLookup;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.MutableInteger;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.OnDiskChainedHashTable;
import org.llvm.support.llvm;

public class PTHManager
implements IdentifierInfoLookup,
Destructors.ClassWithDestructor {
    protected final MemoryBuffer Buf;
    private final BumpPtrAllocator Alloc;
    protected final IdentifierInfo[] PerIDCache;
    private final PTHFileLookup FileLookup;
    protected final char.ptr IdDataTable;
    private final PTHStringIdLookup StringIdLookup;
    private final int NumIds;
    protected Preprocessor PP;
    protected final char.ptr SpellingBase;
    private final char.ptr OriginalSourceFile;
    private boolean resetOnDesroyForSharedPTHManager;
    private Exception destroyStack;
    private static final boolean CLEAR_SHARED_PTH_IDENTIFIERS = Boolean.parseBoolean(System.getProperty("clank.clear.pth.identifier", "false"));
    private static final int SIZEOF_CFE_PTH = std.strlen((char.ptr)NativePointer.$cfe_pth) + 1;

    protected PTHManager(MemoryBuffer buf, PTHFileLookup fileLookup, char.ptr idDataTable, IdentifierInfo[] perIDCache, PTHStringIdLookup stringIdLookup, int numIds, char.ptr spellingBase, char.ptr originalSourceFile) {
        this.Buf = buf;
        this.Alloc = new BumpPtrAllocator();
        this.PerIDCache = perIDCache;
        this.FileLookup = fileLookup;
        this.IdDataTable = Native.$toConst((char.ptr)idDataTable);
        this.StringIdLookup = stringIdLookup;
        this.NumIds = numIds;
        this.PP = null;
        this.SpellingBase = Native.$toConst((char.ptr)spellingBase);
        this.OriginalSourceFile = Native.$toConst((char.ptr)originalSourceFile);
    }

    protected PTHManager() {
        assert (this.getClass() == PTHManagerDriver.class) : "this is the special entry point for PTHManagerDriver which is the special PTHManager allowed to be created without the real PTH token-cache file";
        this.Buf = null;
        this.Alloc = null;
        this.PerIDCache = null;
        this.FileLookup = null;
        this.IdDataTable = null;
        this.StringIdLookup = null;
        this.NumIds = -1;
        this.SpellingBase = null;
        this.OriginalSourceFile = null;
    }

    private PTHManager(PTHManager $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void $assign(PTHManager $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private int getSpellingAtPTHOffset(int PTHOffset, type.ref<char.ptr> Buffer) {
        throw new UnsupportedOperationException("getSpellingAtPTHOffset doesn't have implementation");
    }

    public IdentifierInfo GetIdentifierInfo(int PersistentID) {
        IdentifierInfo II = this.PerIDCache[PersistentID];
        if (II != null) {
            return II;
        }
        return this.LazilyCreateIdentifierInfo(PersistentID);
    }

    private IdentifierInfo LazilyCreateIdentifierInfo(int PersistentID) {
        int TableEntry = NativeType.sizeof$uint32() * PersistentID;
        char.ptr IDData = (char.ptr)this.Buf.getBufferStart().$add(llvm.support.endian.read_uint32((char.ptr)this.IdDataTable, (int)TableEntry, (llvm.support.endianness)llvm.support.endianness.little, (int)0));
        assert (IDData.$less((Object)this.Buf.getBufferEnd())) : IDData.$index() + " vs. " + this.Buf.getBufferEnd().$index();
        assert (IDData.$at(0) != 0);
        assert (IDData.$index() >= 2) : "must have two bytes prefix with len " + IDData.$index();
        int Len = (Casts.$char((byte)IDData.$at(-2)) | Casts.$char((byte)IDData.$at(-1)) << 8) - 1;
        assert (std.strlen((char.ptr)IDData) == Len) : "check wasn't here, but could it be non null-termed string?" + Len + " vs. " + IDData;
        IdentifierInfo II = new IdentifierInfo(IDData, Len);
        II.$completeJavaPTHCreation();
        assert (II.getLength() == Len) : Len + " vs. " + II.getLength();
        assert (std.memcmp((char.ptr)IDData, (char.ptr)II.getNameStart(), (int)Len) == 0) : "IDData:" + IDData + " \nvs.\nName:" + II.getNameStart();
        this.PerIDCache[PersistentID] = II;
        assert (II.getNameStart() != null && II.getNameStart().$at(0) != 0);
        return II;
    }

    public MemoryBuffer $markShared(boolean shared) {
        this.checkAlive();
        this.resetOnDesroyForSharedPTHManager = shared;
        return this.Buf;
    }

    public boolean $isShared() {
        return this.resetOnDesroyForSharedPTHManager;
    }

    public MemoryBuffer $getTokenCache() {
        return this.Buf;
    }

    public void $destroy() {
        this.checkAlive();
        assert (this.PP != null) : "destory unused?";
        if (this.resetOnDesroyForSharedPTHManager) {
            this.$release();
            return;
        }
        Native.destroy((Object)((Object)this.StringIdLookup));
        Native.destroy((Object)((Object)this.FileLookup));
        Native.destroy((Object)this.PerIDCache);
        assert (this.Buf == null == (this.Alloc == null)) : "must be both null or non-null " + this.Buf + " vs. " + this.Alloc;
        if (this.Buf != null) {
            this.Alloc.$destroy();
            this.Buf.$destroy();
        }
        assert ((this.destroyStack = new Exception("$destroy call")) != null);
    }

    protected void $release() {
        IdentifierInfo[] cache;
        this.PP = null;
        if (this.PerIDCache != null && (cache = this.PerIDCache) != null) {
            for (int i = 0; i < cache.length; ++i) {
                if (CLEAR_SHARED_PTH_IDENTIFIERS) {
                    cache[i] = null;
                    continue;
                }
                IdentifierInfo II = cache[i];
                if (II == null) continue;
                StringMapImpl.resetStringMapEntryToInitialState((StringMapEntryBase)II);
            }
        }
    }

    private void checkAlive() {
        if (this.destroyStack != null) {
            NativeTrace.printStackTraceOnce((Throwable)new Exception("already destroyed at ", this.destroyStack));
        }
    }

    public char.ptr getOriginalSourceFile() {
        return this.OriginalSourceFile;
    }

    public IdentifierInfo get(char.ptr Name, int Len) {
        if (Native.$is_array_based((char.ptr)Name)) {
            if (NativeTrace.isDebugMode()) {
                NativeTrace.assertTrueInConsole((boolean)false, (String)"use get(byte[],...) version directly if possible");
            }
            return this.get(Name.$array(), Name.$index(), Len);
        }
        assert (Len == 0 || Name.$at(Len - 1) != 0);
        Number I = this.StringIdLookup.get(Name, Len);
        if (I == null) {
            return null;
        }
        Number Data = I;
        assert (Data.intValue() > 0);
        return this.GetIdentifierInfo(Data.intValue() - 1);
    }

    public IdentifierInfo get(byte[] Name, int NameStIndex, int Len) {
        assert (Len == 0 || Name[NameStIndex + Len - 1] != 0);
        Number I = this.StringIdLookup.get(Name, NameStIndex, Len);
        if (I == null) {
            return null;
        }
        Number Data = I;
        assert (Data.intValue() > 0);
        return this.GetIdentifierInfo(Data.intValue() - 1);
    }

    public static ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> CreateMemoryBuffer(std.string TokenCacheFilePath) {
        return MemoryBuffer.getFile((Twine)new Twine(TokenCacheFilePath));
    }

    public static PTHManager Create(StringRef file, DiagnosticsEngine Diags) {
        return PTHManager.Create(file.$basic_string(), Diags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PTHManager Create(std.string file, DiagnosticsEngine Diags) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> FileOrErr = PTHManager.CreateMemoryBuffer(file);
            if (!FileOrErr.$bool()) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(739))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            MemoryBuffer File = (MemoryBuffer)((std_ptr.unique_ptr)FileOrErr.get()).release();
            PTHManager pTHManager = PTHManager.Create(File, Diags);
            return pTHManager;
        }
        finally {
            $c$.$destroy();
        }
    }

    public static PTHManager Create(MemoryBuffer File, DiagnosticsEngine Diags) {
        return PTHManager.CreatePTHManagerImpl(File, Diags, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PTHManager CreatePTHManagerImpl(MemoryBuffer File, DiagnosticsEngine Diags, PTHManagerDriver ParentPTHManager) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            int IDTableOffset;
            char.ptr IData;
            char.ptr file = File.getBufferIdentifier();
            char.ptr BufBeg = Native.$toConst((char.ptr)File.getBufferStart());
            char.ptr BufEnd = Native.$toConst((char.ptr)File.getBufferEnd());
            if (BufEnd.$sub((abstract_iterator)BufBeg) < SIZEOF_CFE_PTH + 4 + 4 || std.memcmp((char.ptr)BufBeg, (char.ptr)NativePointer.$cfe_pth, (int)SIZEOF_CFE_PTH) != 0) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(739))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            char.ptr p = (char.ptr)BufBeg.$add(SIZEOF_CFE_PTH);
            int Version = llvm.support.endian.readNext_uint32((char.ptr)p, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            if (Version < 10) {
                PTHLexerStatics.InvalidPTH(Diags, Version < 10 ? NativePointer.$((String)"PTH file uses an older PTH format that is no longer supported") : NativePointer.$((String)"PTH file uses a newer PTH format that cannot be read"));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            char.ptr PrologueOffset = Native.$noClone((char.ptr)p);
            if (PrologueOffset.$greatereq((Object)BufEnd)) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(739))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            int FileTableOffset = NativeType.sizeof$uint32() * 2;
            char.ptr FileTable = (char.ptr)BufBeg.$add(llvm.support.endian.read_uint32((char.ptr)PrologueOffset, (int)FileTableOffset, (llvm.support.endianness)llvm.support.endianness.little, (int)0));
            if (!FileTable.$greater((Object)BufBeg) || !FileTable.$less((Object)BufEnd)) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(739))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            PTHFileLookup FL = PTHFileLookup.CreatePTHFileLookup(Native.$noClone((char.ptr)FileTable), Native.$noClone((char.ptr)BufBeg), new PTHFileLookupTrait());
            if (FL.isEmpty()) {
                PTHLexerStatics.InvalidPTH(Diags, NativePointer.$((String)"PTH file contains no cached source data"));
            }
            if (!(IData = (char.ptr)BufBeg.$add(llvm.support.endian.read_uint32((char.ptr)PrologueOffset, (int)(IDTableOffset = NativeType.sizeof$uint32() * 0), (llvm.support.endianness)llvm.support.endianness.little, (int)0))).$greatereq((Object)BufBeg) || !IData.$less((Object)BufEnd)) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(739))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            int StringIdTableOffset = NativeType.sizeof$uint32() * 1;
            char.ptr StringIdTable = (char.ptr)BufBeg.$add(llvm.support.endian.read_uint32((char.ptr)PrologueOffset, (int)StringIdTableOffset, (llvm.support.endianness)llvm.support.endianness.little, (int)0));
            if (!StringIdTable.$greatereq((Object)BufBeg) || !StringIdTable.$less((Object)BufEnd)) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(739))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            PTHStringIdLookup SL = PTHStringIdLookup.CreatePTHStringIdLookup(Native.$noClone((char.ptr)StringIdTable), Native.$noClone((char.ptr)BufBeg), new PTHStringLookupTrait());
            int spellingBaseOffset = NativeType.sizeof$uint32() * 3;
            char.ptr spellingBase = (char.ptr)BufBeg.$add(llvm.support.endian.read_uint32((char.ptr)PrologueOffset, (int)spellingBaseOffset, (llvm.support.endianness)llvm.support.endianness.little, (int)0));
            if (!spellingBase.$greatereq((Object)BufBeg) || !spellingBase.$less((Object)BufEnd)) {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)Diags.Report(739))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            int NumIds = llvm.support.endian.readNext_uint32((char.ptr)IData, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
            IdentifierInfo[] PerIDCache = null;
            if (NumIds != 0 && (PerIDCache = new IdentifierInfo[NumIds]) == null) {
                PTHLexerStatics.InvalidPTH(Diags, NativePointer.$((String)"Could not allocate memory for processing PTH file"));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            char.ptr originalSourceBase = (char.ptr)PrologueOffset.$add(NativeType.sizeof$uint32() * 4);
            char len = llvm.support.endian.readNext_uint16((char.ptr)originalSourceBase, (llvm.support.endianness)llvm.support.endianness.little, (int)1);
            if (len == '\u0000') {
                originalSourceBase = null;
            }
            if (ParentPTHManager != null) {
                PTHManagerSingleFile pTHManagerSingleFile = new PTHManagerSingleFile(ParentPTHManager, File, FL, Native.$noClone((char.ptr)IData), PerIDCache, SL, NumIds, Native.$noClone((char.ptr)spellingBase), Native.$noClone((char.ptr)originalSourceBase));
                return pTHManagerSingleFile;
            }
            PTHManager pTHManager = new PTHManager(File, FL, Native.$noClone((char.ptr)IData), PerIDCache, SL, NumIds, Native.$noClone((char.ptr)spellingBase), Native.$noClone((char.ptr)originalSourceBase));
            return pTHManager;
        }
        finally {
            $c$.$destroy();
        }
    }

    public void setPreprocessor(Preprocessor pp) {
        assert (this.PP == null) : "forgot to release shared PTHManager?" + this.resetOnDesroyForSharedPTHManager + "\n" + (Object)((Object)this.PP);
        this.PP = pp;
    }

    public final PTHLexer CreateLexer(FileID FID) {
        return this.CreateLexer(FID.$ID());
    }

    public PTHLexer CreateLexer(int FID) {
        FileEntry FE = this.PP.getSourceManager().getFileEntryForID(FID);
        if (FE == null) {
            return null;
        }
        PTHFileData I = (PTHFileData)this.FileLookup.get(FE);
        if (I == null) {
            return null;
        }
        PTHFileData FileData = I;
        char.ptr BufStart = Native.$noClone((char.ptr)this.Buf.getBufferStart());
        char.ptr data = (char.ptr)BufStart.$add(FileData.getTokenOffset());
        int ppCondOffset = FileData.getPPCondOffset();
        int Len = llvm.support.endian.read_uint32((char.ptr)BufStart, (int)ppCondOffset, (llvm.support.endianness)llvm.support.endianness.little, (int)0);
        char.ptr ppcond = Len == 0 ? null : (char.ptr)BufStart.$add(ppCondOffset += NativeType.sizeof$uint32());
        assert (this.PP != null) : "No preprocessor set yet!";
        return new PTHLexer(this.PP, FID, Native.$noClone((char.ptr)data), Native.$noClone((char.ptr)ppcond), this);
    }

    public std_ptr.unique_ptr<FileSystemStatCache> createStatCache() {
        return new std_ptr.unique_ptr((Object)new PTHStatCache(this.FileLookup));
    }

    public String toString() {
        return "{NumIds=" + this.NumIds + ", OriginalSourceFile=" + this.OriginalSourceFile + ",\nsuppressDesroyOfSharedPTHManager=" + this.resetOnDesroyForSharedPTHManager + ", destroyStack=" + this.destroyStack + '}';
    }

    static {
        assert (SIZEOF_CFE_PTH == NativeType.sizeof$str((String)"cfe-pth"));
    }

    public static final class Unnamed_enum {
        public static final int Version = 10;
    }

    public static final class PTHFileLookupTrait
    extends PTHFileLookupCommonTrait<FileEntry, PTHFileData> {
        private final std_pair.pairUCharType<char.ptr> $IKey = new std_pair.pairUCharType(-1, null);

        public std_pair.pairUCharType<char.ptr> GetInternalKey(FileEntry FE) {
            this.$IKey.first = 1;
            this.$IKey.second = FE.getName();
            return this.$IKey;
        }

        public boolean EqualKey(std_pair.pairUCharType<char.ptr> a, std_pair.pairUCharType<char.ptr> b) {
            return a.first == b.first && std.strcmp((char.ptr)((char.ptr)a.second), (char.ptr)((char.ptr)b.second)) == 0;
        }

        @Override
        public PTHFileData ReadData(std_pair.pairUCharType<char.ptr> k, char.ptr d, int OffsetInBuf, int $Prm2) {
            assert (k.first == 1) : "Only file lookups can match!";
            int x = llvm.support.endian.read_uint32((char.ptr)d, (int)OffsetInBuf, (llvm.support.endianness)llvm.support.endianness.little, (int)1);
            int y = llvm.support.endian.read_uint32((char.ptr)d, (int)(OffsetInBuf += NativeType.sizeof$uint32()), (llvm.support.endianness)llvm.support.endianness.little, (int)1);
            return new PTHFileData(x, y);
        }

        public PTHFileLookupTrait(PTHFileLookupTrait $Prm0) {
            super($Prm0);
        }

        public PTHFileLookupTrait() {
        }

        public FileEntry GetExternalKey(std_pair.pairUCharType<char.ptr> x) {
            throw new UnsupportedOperationException("Must Not Be called for this class.");
        }

        public String toString() {
            return "" + super.toString();
        }
    }

    public static final class PTHStringLookupTrait
    implements OnDiskChainedHashTable.InfoInterface<std_pair.pairTypeInt<char.ptr>, std_pair.pairTypeInt<char.ptr>, Number> {
        private final MutableInteger $Value = new MutableInteger(0);
        private boolean $KeyInUse = false;
        private final std_pair.pairTypeInt<char.ptr> $Key = new std_pair.pairTypeInt((Object)NativePointer.create_reusable_char$ptr(), 0);

        public boolean EqualKey(std_pair.pairTypeInt<char.ptr> a, std_pair.pairTypeInt<char.ptr> b) {
            return a.second == b.second ? std.memcmp((char.ptr)((char.ptr)a.first), (char.ptr)((char.ptr)b.first), (int)a.second) == 0 : false;
        }

        public int ComputeHash(std_pair.pairTypeInt<char.ptr> a) {
            return llvm.HashString((char.ptr)((char.ptr)a.first), (int)a.second);
        }

        public std_pair.pairTypeInt<char.ptr> GetInternalKey(std_pair.pairTypeInt<char.ptr> x) {
            return x;
        }

        public long ReadKeyDataLength(char.ptr d, int OffsetInBuf) {
            return std_pair.wrap_int_int_pair((int)llvm.support.endian.read_uint16((char.ptr)d, (int)OffsetInBuf, (llvm.support.endianness)llvm.support.endianness.little, (int)1), (int)NativeType.sizeof$uint32());
        }

        public int getReadKeyDataLengthBytes() {
            return NativeType.sizeof$uint16();
        }

        public std_pair.pairTypeInt<char.ptr> ReadKey(char.ptr d, int OffsetInBuf, int n) {
            assert (n >= 2 && d.$at(OffsetInBuf + n - 1) == 0) : "n=" + n + ";" + d.$add(OffsetInBuf);
            return this.$getKey(d.$array(), d.$index() + OffsetInBuf, n - 1);
        }

        public Number ReadData(std_pair.pairTypeInt<char.ptr> k, char.ptr d, int OffsetInBuf, int $Prm2) {
            return this.$Value.setValue(llvm.support.endian.read_uint32((char.ptr)d, (int)OffsetInBuf, (llvm.support.endianness)llvm.support.endianness.little, (int)1));
        }

        public PTHStringLookupTrait(PTHStringLookupTrait $Prm0) {
        }

        public PTHStringLookupTrait() {
        }

        private std_pair.pairTypeInt<char.ptr> $getKey(byte[] firstArray, int firstArrayIndex, int second) {
            block5: {
                block6: {
                    if ($assertionsDisabled) break block5;
                    if (this.$KeyInUse) break block6;
                    this.$KeyInUse = true;
                    if (true) break block5;
                }
                throw new AssertionError();
            }
            assert (this.$Key.first != null);
            assert (((char.ptr)this.$Key.first).$array() == null || ((char.ptr)this.$Key.first).$array() == firstArray) : "Different buffer?";
            Native.$setArrayAndIndex((char.ptr)((char.ptr)this.$Key.first), (byte[])firstArray, (int)firstArrayIndex);
            this.$Key.second = second;
            return this.$Key;
        }

        public void $releaseKey(std_pair.pairTypeInt<char.ptr> Key) {
            assert (Key == this.$Key);
            assert (this.$KeyInUse);
            if (!$assertionsDisabled) {
                this.$KeyInUse = false;
                if (!false) {
                    // empty if block
                }
            }
        }

        public std_pair.pairTypeInt<char.ptr> GetExternalKey(std_pair.pairTypeInt<char.ptr> x) {
            throw new UnsupportedOperationException("Must Not Be called for this class");
        }

        public String toString() {
            return "";
        }
    }
}

