/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MutableComboBoxModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.search.ReplacePattern;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.search.EditorFindSupport;
import org.netbeans.modules.editor.search.ReplaceBar;
import org.netbeans.modules.editor.search.SearchButton;
import org.netbeans.modules.editor.search.SearchComboBox;
import org.netbeans.modules.editor.search.SearchComboBoxEditor;
import org.netbeans.modules.editor.search.SearchPropertiesSupport;
import org.openide.awt.CloseButtonFactory;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class SearchBar
extends JPanel
implements PropertyChangeListener {
    private static SearchBar searchbarInstance = null;
    private static final Logger LOG = Logger.getLogger(SearchBar.class.getName());
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Color NOT_FOUND = UIManager.getColor("nb.errorForeground");
    private static final Color INVALID_REGEXP = Color.red;
    private static final int SEARCH_DELAY_TIME_LONG = 300;
    private static final int SEARCH_DELAY_TIME_SHORT = 20;
    private static final Color DEFAULT_FG_COLOR = SearchBar.isCurrentLF("Nimbus") ? UIManager.getColor("text") : UIManager.getColor("textText");
    private WeakReference<JTextComponent> actualTextComponent;
    private final List<PropertyChangeListener> actualComponentListeners = new LinkedList<PropertyChangeListener>();
    private FocusAdapter focusAdapterForComponent;
    private KeyListener keyListenerForComponent;
    private CaretListener caretListenerForComponent;
    private PropertyChangeListener propertyChangeListenerForComponent;
    private final JLabel findLabel;
    private final JComboBox<String> incSearchComboBox;
    private final JTextComponent incSearchTextField;
    private final DocumentListener incSearchTextFieldListener;
    private boolean hadFocusOnIncSearchTextField = false;
    private final JButton findNextButton;
    private final JButton findPreviousButton;
    private final JButton selectAllButton;
    private final JToggleButton matchCase;
    private final JToggleButton wholeWords;
    private final JToggleButton regexp;
    private final JToggleButton highlight;
    private final JToggleButton wrapAround;
    private final JButton closeButton;
    private final JLabel matches;
    private int numOfMatches = -1;
    private SearchPropertiesSupport.SearchProperties searchProps = SearchPropertiesSupport.getSearchProperties();
    private boolean popupMenuWasCanceled = false;
    private Rectangle actualViewPort;
    private boolean highlightCanceled = false;
    private boolean whenOpenedWasNotVisible = false;
    private boolean lastIncrementalSearchWasSuccessful = true;
    private static PropertyChangeListener searchSelectedPatternListener;
    private static PropertyChangeListener editorHistoryChangeListener;
    private static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    private static final String KEYMAPS_FOLDER = "Keymaps";
    public int lastCurrentPosStart = -1;
    public int lastCurrentPosEnd = -1;

    public static SearchBar getInstance() {
        if (searchbarInstance == null) {
            searchbarInstance = new SearchBar();
        }
        return searchbarInstance;
    }

    public static SearchBar getInstance(JTextComponent component) {
        SearchBar searchbarIns = SearchBar.getInstance();
        if (searchbarIns.getActualTextComponent() != component) {
            searchbarIns.setActualTextComponent(component);
        }
        return searchbarIns;
    }

    private SearchBar() {
        SearchBar.loadSearchHistory();
        this.addEscapeKeystrokeFocusBackTo(this);
        this.setLayout(new BoxLayout(this, 2));
        this.setFocusCycleRoot(true);
        this.setForeground(DEFAULT_FG_COLOR);
        this.setBorder(new SeparatorBorder());
        this.add(Box.createHorizontalStrut(8));
        SearchComboBox<String> scb = new SearchComboBox<String>();
        this.incSearchComboBox = scb;
        this.incSearchComboBox.setFocusable(false);
        this.incSearchComboBox.addPopupMenuListener(new SearchPopupMenuListener());
        this.incSearchTextField = scb.getEditorPane();
        this.incSearchTextField.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        this.incSearchTextFieldListener = this.createIncSearchTextFieldListener(this.incSearchTextField);
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
        this.addEnterKeystrokeFindNextTo(this.incSearchTextField);
        this.addShiftEnterKeystrokeFindPreviousTo(this.incSearchTextField);
        this.addAltEnterKeystrokeSelect(this.incSearchTextField);
        if (SearchBar.getCurrentKeyMapProfile().startsWith("Emacs")) {
            this.emacsProfileFix(this.incSearchTextField);
        }
        this.incSearchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SearchBar.this.hadFocusOnIncSearchTextField = true;
            }
        });
        this.findLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.findLabel, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        this.findLabel.setLabelFor(this.incSearchTextField);
        this.add(this.findLabel);
        this.add(this.incSearchComboBox);
        JToolBar.Separator leftSeparator = new JToolBar.Separator();
        leftSeparator.setOrientation(1);
        this.add(leftSeparator);
        this.findPreviousButton = SearchButton.createButton("org/netbeans/modules/editor/search/resources/find_previous.png", "CTL_FindPrevious");
        this.findPreviousButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        this.findPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
        this.add(this.findPreviousButton);
        this.findNextButton = SearchButton.createButton("org/netbeans/modules/editor/search/resources/find_next.png", "CTL_FindNext");
        this.findNextButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
            }
        });
        this.add(this.findNextButton);
        this.selectAllButton = SearchButton.createButton("org/netbeans/modules/editor/search/resources/select_all.png", "CTL_SelectAll");
        this.selectAllButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_SelectAllText"));
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.selectAll();
            }
        });
        this.add(this.selectAllButton);
        JToolBar.Separator rightSeparator = new JToolBar.Separator();
        rightSeparator.setOrientation(1);
        this.add(rightSeparator);
        this.matchCase = SearchButton.createToggleButton("org/netbeans/modules/editor/search/resources/matchCase.png");
        this.processToggleButton(this.matchCase, "find-match-case");
        this.matchCase.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TT_MatchCase"));
        this.add(this.matchCase);
        this.wholeWords = SearchButton.createToggleButton("org/netbeans/modules/editor/search/resources/wholeWord.png");
        this.processToggleButton(this.wholeWords, "find-whole-words");
        this.wholeWords.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TT_WholeWords"));
        this.add(this.wholeWords);
        this.regexp = SearchButton.createToggleButton("org/netbeans/modules/editor/search/resources/regexp.png");
        this.processToggleButton(this.regexp, "find-reg-exp");
        this.regexp.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TT_Regexp"));
        this.add(this.regexp);
        this.highlight = SearchButton.createToggleButton("org/netbeans/modules/editor/search/resources/highlight.png");
        this.processToggleButton(this.highlight, "find-highlight-search");
        this.highlight.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TT_Highlight"));
        this.add(this.highlight);
        this.wrapAround = SearchButton.createToggleButton("org/netbeans/modules/editor/search/resources/wrapAround.png");
        this.processToggleButton(this.wrapAround, "find-wrap-search");
        this.add(this.wrapAround);
        this.wrapAround.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TT_WrapAround"));
        this.selectCheckBoxes();
        this.addCheckBoxesActions(this.incSearchTextField);
        EditorFindSupport.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorFindSupport.getInstance()));
        this.matches = new JLabel();
        this.add(Box.createHorizontalGlue());
        this.add(this.matches);
        this.add(Box.createHorizontalStrut(8));
        this.closeButton = this.createCloseButton();
        this.add(this.closeButton);
        this.setVisible(false);
        SearchBar.usageLogging();
    }

    void addCheckBoxesActions(JTextComponent incSearchTextField) {
        String key = "matchcasekey";
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(67, 512), key);
        incSearchTextField.getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.matchCase.doClick();
            }
        });
        key = "wholewordkey";
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(79, 512), key);
        incSearchTextField.getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.wholeWords.doClick();
            }
        });
        key = "regexpkey";
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(71, 512), key);
        incSearchTextField.getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.regexp.doClick();
            }
        });
        key = "highlightkey";
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(72, 512), key);
        incSearchTextField.getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.highlight.doClick();
            }
        });
        key = "wraparoundkey";
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(85, 512), key);
        incSearchTextField.getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.wrapAround.doClick();
            }
        });
    }

    private static void loadSearchHistory() {
        searchSelectedPatternListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || evt.getPropertyName() == null) {
                    return;
                }
                switch (evt.getPropertyName()) {
                    case "add-to-history": {
                        EditorFindSupport.getInstance().setHistory(SearchHistoryUtility.convertFromSearchHistoryToEditorFindSupport(SearchHistory.getDefault().getSearchPatterns()));
                        break;
                    }
                    case "add-to-replace": {
                        EditorFindSupport.getInstance().setReplaceHistory(SearchHistoryUtility.convertFromReplaceHistoryToEditorFindSupport(SearchHistory.getDefault().getReplacePatterns()));
                    }
                }
            }
        };
        editorHistoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || evt.getPropertyName() == null) {
                    return;
                }
                switch (evt.getPropertyName()) {
                    case "find-history-prop": {
                        EditorFindSupport.SPW spw = (EditorFindSupport.SPW)evt.getNewValue();
                        if (spw == null || spw.getSearchExpression() == null || "".equals(spw.getSearchExpression())) {
                            return;
                        }
                        SearchPattern sp = SearchPattern.create((String)spw.getSearchExpression(), (boolean)spw.isWholeWords(), (boolean)spw.isMatchCase(), (boolean)spw.isRegExp());
                        SearchHistory.getDefault().add(sp);
                        if (SearchBar.getInstance().incSearchTextField.getText().equals(sp.getSearchExpression())) break;
                        SearchBar.getInstance().incSearchTextField.setText(sp.getSearchExpression());
                        break;
                    }
                    case "find-history-changed-prop": {
                        EditorFindSupport.getInstance().setHistory(SearchHistoryUtility.convertFromSearchHistoryToEditorFindSupport(SearchHistory.getDefault().getSearchPatterns()));
                        break;
                    }
                    case "replace-history-prop": {
                        EditorFindSupport.RP rp = (EditorFindSupport.RP)evt.getNewValue();
                        if (rp == null || rp.getReplaceExpression() == null || "".equals(rp.getReplaceExpression())) {
                            return;
                        }
                        ReplacePattern replacePattern = ReplacePattern.create((String)rp.getReplaceExpression(), (boolean)rp.isPreserveCase());
                        SearchHistory.getDefault().addReplace(replacePattern);
                        break;
                    }
                    case "replace-history-changed-prop": {
                        EditorFindSupport.getInstance().setReplaceHistory(SearchHistoryUtility.convertFromReplaceHistoryToEditorFindSupport(SearchHistory.getDefault().getReplacePatterns()));
                    }
                }
            }
        };
        SearchHistory.getDefault().addPropertyChangeListener(searchSelectedPatternListener);
        EditorFindSupport.getInstance().addPropertyChangeListener(editorHistoryChangeListener);
    }

    private static void usageLogging() {
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.editor");
        LogRecord rec = new LogRecord(Level.INFO, "USG_SEARCH_TYPE");
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        rec.setParameters(new Object[]{prefs.get("editor-search-type", "default")});
        rec.setLoggerName(logger.getName());
        logger.log(rec);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null) {
            this.selectCheckBoxes();
        }
    }

    void updateIncSearchComboBoxHistory(String incrementalSearchText) {
        EditorFindSupport.getInstance().addToHistory(new EditorFindSupport.SPW(incrementalSearchText, this.wholeWords.isSelected(), this.matchCase.isSelected(), this.regexp.isSelected()));
        this.incSearchTextField.getDocument().removeDocumentListener(this.incSearchTextFieldListener);
        for (int i = this.incSearchComboBox.getItemCount() - 1; i >= 0; --i) {
            String item = this.incSearchComboBox.getItemAt(i);
            if (!item.equals(incrementalSearchText)) continue;
            this.incSearchComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.incSearchComboBox.getModel()).insertElementAt(incrementalSearchText, 0);
        this.incSearchComboBox.setSelectedIndex(0);
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
    }

    private KeyListener createKeyListenerForComponent() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    ReplaceBar replaceBarInstance;
                    if (SearchBar.this.looseFocus()) {
                        e.consume();
                    }
                    if ((replaceBarInstance = ReplaceBar.getInstance(SearchBar.this)).isVisible()) {
                        replaceBarInstance.looseFocus();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
    }

    private CaretListener createCaretListenerForComponent() {
        return new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (SearchBar.getInstance().isVisible()) {
                    int num = SearchBar.getInstance().getNumOfMatches();
                    SearchBar.getInstance().showNumberOfMatches(null, num);
                }
            }
        };
    }

    private FocusAdapter createFocusAdapterForComponent() {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() instanceof JRootPane) {
                    return;
                }
                SearchBar.this.hadFocusOnIncSearchTextField = false;
                if (SearchBar.isClosingSearchType() && !ReplaceBar.getInstance(SearchBar.getInstance()).isVisible()) {
                    SearchBar.this.looseFocus();
                }
            }
        };
    }

    private PropertyChangeListener createPropertyChangeListenerForComponent() {
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || !"keymap".equals(evt.getPropertyName())) {
                    return;
                }
                JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
                if (lastFocusedComponent == null) {
                    return;
                }
                Keymap keymap = lastFocusedComponent.getKeymap();
                if (keymap instanceof MultiKeymap) {
                    Action[] actions;
                    MultiKeymap multiKeymap = (MultiKeymap)keymap;
                    for (Action action : actions = lastFocusedComponent.getActions()) {
                        String actionName = (String)action.getValue("Name");
                        if (actionName == null) {
                            LOG.log(Level.WARNING, "SearchBar: Null Action.NAME property of action: {0}\n", action);
                            continue;
                        }
                        if (actionName.equals("find-next")) {
                            this.keystrokeForSearchAction(multiKeymap, action, new AbstractAction(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    SearchBar.this.findNext();
                                }
                            });
                            continue;
                        }
                        if (!actionName.equals("find-previous")) continue;
                        this.keystrokeForSearchAction(multiKeymap, action, new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SearchBar.this.findPrevious();
                            }
                        });
                    }
                }
            }

            private void keystrokeForSearchAction(MultiKeymap multiKeymap, Action searchAction, AbstractAction newSearchAction) {
                KeyStroke[] keyStrokes = multiKeymap.getKeyStrokesForAction(searchAction);
                if (keyStrokes != null) {
                    InputMap inputMap = SearchBar.this.getInputMap(1);
                    for (KeyStroke ks : keyStrokes) {
                        LOG.log(Level.FINE, "found {1} search action, {0}", new Object[]{ks, searchAction.getValue("Name")});
                        inputMap.put(ks, (String)searchAction.getValue("Name"));
                    }
                    SearchBar.this.getActionMap().put((String)searchAction.getValue("Name"), newSearchAction);
                }
            }
        };
        pcl.propertyChange(new PropertyChangeEvent(this, "keymap", null, null));
        return pcl;
    }

    private void addAltEnterKeystrokeSelect(JTextComponent incSearchTextField) {
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 8, true), "select-all");
        incSearchTextField.getActionMap().put("select-all", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.selectAll();
            }
        });
    }

    private void addShiftEnterKeystrokeFindPreviousTo(JTextComponent incSearchTextField) {
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "incremental-find-previous");
        incSearchTextField.getActionMap().put("incremental-find-previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
    }

    private void addEnterKeystrokeFindNextTo(JTextComponent incSearchTextField) {
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "incremental-find-next");
        incSearchTextField.getActionMap().put("incremental-find-next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
                if (SearchBar.isClosingSearchType() && !ReplaceBar.getInstance(SearchBar.getInstance()).isVisible()) {
                    SearchBar.this.looseFocus();
                }
            }
        });
    }

    private DocumentListener createIncSearchTextFieldListener(final JTextComponent incSearchTextField) {
        final Timer searchDelayTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.incrementalSearch();
            }
        });
        searchDelayTimer.setRepeats(false);
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (incSearchTextField.getText().length() > 3) {
                    searchDelayTimer.setInitialDelay(20);
                }
                searchDelayTimer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (incSearchTextField.getText().length() <= 3) {
                    searchDelayTimer.setInitialDelay(300);
                }
                searchDelayTimer.restart();
            }
        };
    }

    private JButton createCloseButton() {
        JButton button = CloseButtonFactory.createBigCloseButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
            }
        });
        button.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_CloseIncrementalSearchSidebar"));
        return button;
    }

    void processToggleButton(JToggleButton button, final String findConstant) {
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchFindSupportValue(findConstant);
                SearchBar.this.incrementalSearch();
            }
        });
    }

    JCheckBox createCheckBox(String resName, final String findConstant) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)checkBox, (String)NbBundle.getMessage(SearchBar.class, (String)resName));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchFindSupportValue(findConstant);
                SearchBar.this.incrementalSearch();
            }
        });
        checkBox.setMargin(BUTTON_INSETS);
        checkBox.setFocusable(false);
        return checkBox;
    }

    private void selectCheckBoxes() {
        this.wholeWords.setSelected(this.getFindSupportValue("find-whole-words"));
        this.wholeWords.setEnabled(!this.getRegExp());
        this.matchCase.setSelected(this.getFindSupportValue("find-match-case"));
        this.regexp.setSelected(this.getRegExp());
        this.highlight.setSelected(this.getFindSupportValue("find-highlight-search"));
        this.wrapAround.setSelected(this.getFindSupportValue("find-wrap-search"));
    }

    private void emacsProfileFix(JTextComponent incSearchTextField) {
        String actionName = "caret-begin-line";
        class JumpOutOfSearchAction
        extends AbstractAction {
            private final String actionName;

            public JumpOutOfSearchAction(String n) {
                this.actionName = n;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
                if (SearchBar.this.getActualTextComponent() != null) {
                    ActionEvent ev = new ActionEvent(SearchBar.this.getActualTextComponent(), e.getID(), e.getActionCommand(), e.getModifiers());
                    Action action = SearchBar.this.getActualTextComponent().getActionMap().get(this.actionName);
                    action.actionPerformed(ev);
                }
            }
        }
        JumpOutOfSearchAction a1 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put(actionName, a1);
        actionName = "caret-end-line";
        JumpOutOfSearchAction a2 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put(actionName, a2);
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(80, 2, false), "caret-up-alt");
        actionName = "caret-up";
        JumpOutOfSearchAction a3 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put("caret-up-alt", a3);
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(78, 2, false), "caret-down-alt");
        actionName = "caret-down";
        JumpOutOfSearchAction a4 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put("caret-down-alt", a4);
    }

    public static String getCurrentKeyMapProfile() {
        Object o;
        String currentKeyMapProfile = null;
        FileObject fo = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
        if (fo != null && (o = fo.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE)) instanceof String) {
            currentKeyMapProfile = (String)o;
        }
        if (currentKeyMapProfile == null) {
            currentKeyMapProfile = DEFAULT_PROFILE;
        }
        return currentKeyMapProfile;
    }

    @Override
    public String getName() {
        return "editorSearchBar";
    }

    void addEscapeKeystrokeFocusBackTo(JComponent component) {
        component.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        component.getActionMap().put("loose-focus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SearchBar.this.popupMenuWasCanceled) {
                    SearchBar.this.looseFocus();
                    if (SearchBar.isClosingSearchType()) {
                        SearchBar.this.getActualTextComponent().scrollRectToVisible(SearchBar.this.actualViewPort);
                    }
                } else {
                    SearchBar.this.popupMenuWasCanceled = false;
                }
            }
        });
    }

    private static boolean isClosingSearchType() {
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        return prefs.get("editor-search-type", "default").equals("closing");
    }

    public void gainFocus() {
        String lastSearch = "";
        if (!SearchBar.isClosingSearchType()) {
            lastSearch = this.incSearchTextField.getText();
            Object findWhat = this.searchProps.getProperty("find-what");
            if (findWhat instanceof String) {
                lastSearch = (String)findWhat;
            }
        }
        this.incSearchTextField.getDocument().removeDocumentListener(this.incSearchTextFieldListener);
        SearchComboBoxEditor.changeToOneLineEditorPane((JEditorPane)this.incSearchTextField);
        this.addEnterKeystrokeFindNextTo(this.incSearchTextField);
        MutableComboBoxModel comboBoxModelIncSearch = (MutableComboBoxModel)this.incSearchComboBox.getModel();
        for (int i = comboBoxModelIncSearch.getSize() - 1; i >= 0; --i) {
            comboBoxModelIncSearch.removeElementAt(i);
        }
        for (EditorFindSupport.SPW spw : EditorFindSupport.getInstance().getHistory()) {
            comboBoxModelIncSearch.addElement(spw.getSearchExpression());
        }
        if (!SearchBar.isClosingSearchType()) {
            this.incSearchTextField.setText(lastSearch);
        }
        if (!this.isVisible() && SearchBar.isClosingSearchType()) {
            this.whenOpenedWasNotVisible = true;
        }
        if (this.whenOpenedWasNotVisible) {
            this.incSearchTextField.setText("");
            this.whenOpenedWasNotVisible = false;
        }
        this.hadFocusOnIncSearchTextField = true;
        this.setVisible(true);
        this.initBlockSearch();
        EditorFindSupport.getInstance().setFocusedTextComponent(this.getActualTextComponent());
        this.incSearchTextField.requestFocusInWindow();
        boolean empty = this.incSearchTextField.getText().isEmpty();
        if (!empty) {
            this.incSearchTextField.selectAll();
        }
        this.findPreviousButton.setEnabled(!empty);
        this.findNextButton.setEnabled(!empty);
        ReplaceBar.getInstance(this).getReplaceButton().setEnabled(!empty);
        ReplaceBar.getInstance(this).getReplaceAllButton().setEnabled(!empty);
        this.actualViewPort = this.getActualTextComponent().getVisibleRect();
        if (!SearchBar.isClosingSearchType() && this.highlightCanceled) {
            this.searchProps.setProperty("find-highlight-search", Boolean.TRUE);
            this.highlightCanceled = false;
        }
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
    }

    public boolean looseFocus() {
        this.hadFocusOnIncSearchTextField = false;
        if (!this.isVisible()) {
            return false;
        }
        EditorFindSupport.getInstance().setBlockSearchHighlight(0, 0);
        EditorFindSupport.getInstance().incSearchReset();
        EditorFindSupport.getInstance().setFocusedTextComponent(null);
        if (this.getActualTextComponent() != null) {
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"");
            this.getActualTextComponent().requestFocusInWindow();
        }
        this.setVisible(false);
        if (!SearchBar.isClosingSearchType() && this.getFindSupportValue("find-highlight-search")) {
            this.searchProps.setProperty("find-highlight-search", Boolean.FALSE);
            this.highlightCanceled = true;
        }
        this.searchProps.setProperty("find-block-search", Boolean.FALSE);
        this.searchProps.setProperty("find-block-search-start", null);
        this.searchProps.setProperty("find-block-search-end", null);
        EditorFindSupport.getInstance().putFindProperties(this.searchProps.getProperties());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchBar.this.searchProps.saveToPrefs();
            }
        });
        return true;
    }

    private void incrementalSearch() {
        if (this.getActualTextComponent() == null || this.getActualTextComponent().getCaret() == null) {
            return;
        }
        String incrementalSearchText = this.incSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.findPreviousButton.setEnabled(!empty);
        this.findNextButton.setEnabled(!empty);
        ReplaceBar.getInstance(this).getReplaceButton().setEnabled(!empty);
        ReplaceBar.getInstance(this).getReplaceAllButton().setEnabled(!empty);
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        findSupport.putFindProperties(this.getSearchProperties());
        int caretPosition = this.getActualTextComponent().getSelectionStart();
        if (SearchBar.isClosingSearchType()) {
            caretPosition = this.getActualTextComponent().getCaretPosition();
        }
        if (findSupport.incSearch(this.searchProps.getProperties(), caretPosition) || empty) {
            this.incSearchTextField.setForeground(DEFAULT_FG_COLOR);
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"", (int)900);
            this.showNumberOfMatches(findSupport, -1);
            this.lastIncrementalSearchWasSuccessful = true;
        } else {
            this.incSearchTextField.setForeground(NOT_FOUND);
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)NbBundle.getMessage(SearchBar.class, (String)"find-not-found", (Object)incrementalSearchText), (int)900);
            if (this.lastIncrementalSearchWasSuccessful) {
                Toolkit.getDefaultToolkit().beep();
                this.lastIncrementalSearchWasSuccessful = false;
            }
            this.showNumberOfMatches(findSupport, 0);
        }
    }

    void findNext() {
        this.find(true);
    }

    void findPrevious() {
        this.find(false);
    }

    void selectAll() {
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        JTextComponent textComponent = this.getActualTextComponent();
        Document doc = textComponent.getDocument();
        Caret caret = textComponent.getCaret();
        if (caret instanceof EditorCaret) {
            EditorCaret editorCaret = (EditorCaret)caret;
            try {
                int[] blocks = findSupport.getBlocks(new int[]{-1, -1}, doc, 0, doc.getLength());
                if (blocks[0] >= 0 && blocks.length % 2 == 0) {
                    ArrayList<Position> newCarets = new ArrayList<Position>(editorCaret.getCarets().size() << 1);
                    for (int i = 0; i < blocks.length; i += 2) {
                        int start = blocks[i];
                        int end = blocks[i + 1];
                        if (start == -1 || end == -1) break;
                        Position startPos = doc.createPosition(start);
                        Position endPos = doc.createPosition(end);
                        newCarets.add(endPos);
                        newCarets.add(startPos);
                    }
                    editorCaret.replaceCarets(newCarets, null);
                    textComponent.requestFocusInWindow();
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public int getNumOfMatches() {
        return this.numOfMatches;
    }

    public int showNumberOfMatches(EditorFindSupport findSupport, int numMatches) {
        if (findSupport == null) {
            findSupport = EditorFindSupport.getInstance();
        }
        int pos = 0;
        int currentposStart = this.getActualTextComponent().getSelectionStart();
        int currentposEnd = this.getActualTextComponent().getSelectionEnd();
        if (numMatches < 0 || this.lastCurrentPosStart == currentposStart && this.lastCurrentPosEnd == currentposEnd) {
            numMatches = -1;
            boolean notFound = true;
            try {
                int[] blocks = findSupport.getBlocks(new int[]{-1, -1}, this.getActualTextComponent().getDocument(), 0, this.getActualTextComponent().getDocument().getLength());
                for (int i = 0; i < blocks.length; ++i) {
                    if (blocks[i] > 0) {
                        ++numMatches;
                        if (blocks[i] < currentposStart) {
                            ++pos;
                        }
                        if (blocks[i] != currentposStart || i + 1 >= blocks.length || blocks[i + 1] != currentposEnd) continue;
                        notFound = false;
                        continue;
                    }
                    if (blocks[i] != 0 || i + 1 >= blocks.length || blocks[i + 1] <= 0) continue;
                    ++numMatches;
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            numMatches = numMatches == 0 ? 0 : (numMatches + 1) / 2;
            pos = (pos == 0 ? 0 : (pos + 1) / 2) + 1;
            if (pos > numMatches) {
                pos = 0;
            }
            if (notFound) {
                pos = 0;
            }
        }
        this.lastCurrentPosStart = currentposStart;
        this.lastCurrentPosEnd = currentposEnd;
        if (this.incSearchTextField.getText().isEmpty()) {
            Mnemonics.setLocalizedText((JLabel)this.matches, (String)"");
        } else if (numMatches == 0) {
            Mnemonics.setLocalizedText((JLabel)this.matches, (String)NbBundle.getMessage(SearchBar.class, (String)"0_matches"));
        } else if (numMatches == 1) {
            Mnemonics.setLocalizedText((JLabel)this.matches, (String)NbBundle.getMessage(SearchBar.class, (String)"1_matches"));
        } else if (pos == 0) {
            Mnemonics.setLocalizedText((JLabel)this.matches, (String)NbBundle.getMessage(SearchBar.class, (String)"n_matches", (Object)numMatches));
        } else {
            Mnemonics.setLocalizedText((JLabel)this.matches, (String)NbBundle.getMessage(SearchBar.class, (String)"i_n_matches", (Object)pos, (Object)numMatches));
        }
        this.numOfMatches = numMatches;
        return numMatches;
    }

    private void find(boolean next) {
        String incrementalSearchText = this.incSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.updateIncSearchComboBoxHistory(incrementalSearchText);
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        Map<String, Object> actualfindProps = this.getSearchProperties();
        findSupport.putFindProperties(actualfindProps);
        if (findSupport.find(actualfindProps, !next) || empty) {
            this.incSearchTextField.setForeground(DEFAULT_FG_COLOR);
            this.showNumberOfMatches(findSupport, -1);
        } else {
            this.incSearchTextField.setForeground(NOT_FOUND);
            this.showNumberOfMatches(findSupport, 0);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    void initBlockSearch() {
        JTextComponent c = this.getActualTextComponent();
        boolean blockSearchVisible = false;
        if (c != null) {
            int startSelection = c.getSelectionStart();
            int endSelection = c.getSelectionEnd();
            Document doc = c.getDocument();
            if (doc instanceof BaseDocument) {
                BaseDocument bdoc = (BaseDocument)doc;
                try {
                    int startLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)startSelection);
                    int endLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)endSelection);
                    if (endLine > startLine) {
                        blockSearchVisible = true;
                    }
                }
                catch (BadLocationException startLine) {
                    // empty catch block
                }
            }
            if (!blockSearchVisible) {
                String findWhat;
                String selText = c.getSelectedText();
                if (selText != null && selText.length() > 0) {
                    int n = selText.indexOf(10);
                    if (n >= 0) {
                        selText = selText.substring(0, n);
                    }
                    this.incSearchTextField.setText(selText);
                    this.searchProps.setProperty("find-what", selText);
                } else if (SearchBar.isClosingSearchType() && (findWhat = (String)EditorFindSupport.getInstance().getFindProperty("find-what")) != null && findWhat.length() > 0) {
                    this.incSearchTextField.setText(findWhat);
                }
            }
            int blockSearchStartOffset = blockSearchVisible ? startSelection : 0;
            int blockSearchEndOffset = blockSearchVisible ? endSelection : 0;
            try {
                this.searchProps.setProperty("find-block-search", blockSearchVisible);
                this.searchProps.setProperty("find-block-search-start", doc.createPosition(blockSearchStartOffset));
                this.searchProps.setProperty("find-block-search-end", doc.createPosition(blockSearchEndOffset));
                EditorFindSupport.getInstance().setBlockSearchHighlight(blockSearchStartOffset, blockSearchEndOffset);
            }
            catch (BadLocationException ble) {
                this.searchProps.setProperty("find-block-search", Boolean.FALSE);
                this.searchProps.setProperty("find-block-search-start", null);
                this.searchProps.setProperty("find-block-search-end", null);
            }
            EditorFindSupport.getInstance().putFindProperties(this.searchProps.getProperties());
            this.showNumberOfMatches(null, -1);
        }
    }

    boolean getFindSupportValue(String findConstant) {
        Boolean b = (Boolean)this.searchProps.getProperty(findConstant);
        return b != null ? b : false;
    }

    private void switchFindSupportValue(String findConstant) {
        this.searchProps.setProperty(findConstant, !this.getFindSupportValue(findConstant));
    }

    boolean getRegExp() {
        return this.getFindSupportValue("find-reg-exp");
    }

    boolean hadFocusOnTextField() {
        return this.hadFocusOnIncSearchTextField;
    }

    void lostFocusOnTextField() {
        this.hadFocusOnIncSearchTextField = false;
    }

    void setActualTextComponent(JTextComponent component) {
        if (this.getActualTextComponent() != null) {
            this.getActualTextComponent().removeFocusListener(this.focusAdapterForComponent);
            this.getActualTextComponent().removePropertyChangeListener(this.propertyChangeListenerForComponent);
            this.getActualTextComponent().removeKeyListener(this.keyListenerForComponent);
            this.getActualTextComponent().removeCaretListener(this.caretListenerForComponent);
        }
        if (this.focusAdapterForComponent == null) {
            this.focusAdapterForComponent = this.createFocusAdapterForComponent();
        }
        if (this.propertyChangeListenerForComponent == null) {
            this.propertyChangeListenerForComponent = this.createPropertyChangeListenerForComponent();
        }
        if (this.keyListenerForComponent == null) {
            this.keyListenerForComponent = this.createKeyListenerForComponent();
        }
        if (this.caretListenerForComponent == null) {
            this.caretListenerForComponent = this.createCaretListenerForComponent();
        }
        component.addCaretListener(this.caretListenerForComponent);
        component.addFocusListener(this.focusAdapterForComponent);
        component.addPropertyChangeListener(this.propertyChangeListenerForComponent);
        component.addKeyListener(this.keyListenerForComponent);
        for (PropertyChangeListener pcl : this.actualComponentListeners) {
            pcl.propertyChange(new PropertyChangeEvent(this, "actualTextComponent", this.getActualTextComponent(), component));
        }
        this.actualTextComponent = new WeakReference<JTextComponent>(component);
        EditorFindSupport.getInstance().setFocusedTextComponent(this.getActualTextComponent());
        if (Boolean.TRUE.equals(component.getClientProperty("searchbar.hideHighlightIcon"))) {
            this.highlight.setVisible(false);
        } else if (!this.highlight.isVisible()) {
            this.highlight.setVisible(true);
        }
    }

    void addActualComponentListener(PropertyChangeListener propertyChangeListener) {
        this.actualComponentListeners.add(propertyChangeListener);
    }

    public JTextComponent getActualTextComponent() {
        return this.actualTextComponent != null ? (JTextComponent)this.actualTextComponent.get() : null;
    }

    JTextComponent getIncSearchTextField() {
        return this.incSearchTextField;
    }

    JButton getCloseButton() {
        return this.closeButton;
    }

    JLabel getFindLabel() {
        return this.findLabel;
    }

    JButton getFindNextButton() {
        return this.findNextButton;
    }

    JButton getFindPreviousButton() {
        return this.findPreviousButton;
    }

    public Map<String, Object> getSearchProperties() {
        this.searchProps.setProperty("find-what", this.incSearchTextField.getText());
        this.searchProps.setProperty("find-match-case", this.matchCase.isSelected());
        this.searchProps.setProperty("find-whole-words", this.wholeWords.isSelected());
        this.searchProps.setProperty("find-reg-exp", this.regexp.isSelected());
        this.searchProps.setProperty("find-backward-search", Boolean.FALSE);
        this.searchProps.setProperty("find-inc-search", Boolean.TRUE);
        this.searchProps.setProperty("find-highlight-search", this.highlight.isSelected());
        this.searchProps.setProperty("find-wrap-search", this.wrapAround.isSelected());
        return this.searchProps.getProperties();
    }

    public void setSearchProperties(SearchPropertiesSupport.SearchProperties searchProperties) {
        this.searchProps = searchProperties;
        this.selectCheckBoxes();
    }

    public boolean isPopupMenuWasCanceled() {
        return this.popupMenuWasCanceled;
    }

    public void setPopupMenuWasCanceled(boolean popupMenuWasCanceled) {
        this.popupMenuWasCanceled = popupMenuWasCanceled;
    }

    public JComboBox<String> getIncSearchComboBox() {
        return this.incSearchComboBox;
    }

    private static boolean isCurrentLF(String lf) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        String lfID = laf.getID();
        return lf.equals(lfID);
    }

    private static final class SeparatorBorder
    implements Border {
        private static final int BORDER_WIDTH = 1;
        private final Insets INSETS = new Insets(1, 0, 0, 0);

        private SeparatorBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color originalColor = g.getColor();
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(0, 0, c.getWidth(), 0);
            g.setColor(originalColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.INSETS;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class SearchPopupMenuListener
    implements PopupMenuListener {
        private boolean canceled = false;

        private SearchPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!this.canceled) {
                Object selectedItem = SearchBar.this.getIncSearchComboBox().getModel().getSelectedItem();
                if (selectedItem instanceof String) {
                    String findWhat = (String)selectedItem;
                    for (EditorFindSupport.SPW spw : EditorFindSupport.getInstance().getHistory()) {
                        if (!findWhat.equals(spw.getSearchExpression())) continue;
                        SearchBar.this.searchProps.setProperty("find-reg-exp", spw.isRegExp());
                        break;
                    }
                }
            } else {
                this.canceled = false;
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.canceled = true;
            SearchBar.getInstance().setPopupMenuWasCanceled(true);
        }
    }

    private static class SearchHistoryUtility {
        private SearchHistoryUtility() {
        }

        public static List<EditorFindSupport.SPW> convertFromSearchHistoryToEditorFindSupport(List<SearchPattern> searchPatterns) {
            ArrayList<EditorFindSupport.SPW> history = new ArrayList<EditorFindSupport.SPW>();
            for (int i = 0; i < searchPatterns.size(); ++i) {
                SearchPattern sptr = searchPatterns.get(i);
                EditorFindSupport.SPW spwrap = new EditorFindSupport.SPW(sptr.getSearchExpression(), sptr.isWholeWords(), sptr.isMatchCase(), sptr.isRegExp());
                history.add(spwrap);
            }
            return history;
        }

        public static List<EditorFindSupport.RP> convertFromReplaceHistoryToEditorFindSupport(List<ReplacePattern> replacePatterns) {
            ArrayList<EditorFindSupport.RP> history = new ArrayList<EditorFindSupport.RP>();
            for (int i = 0; i < replacePatterns.size(); ++i) {
                ReplacePattern rp = replacePatterns.get(i);
                EditorFindSupport.RP spwrap = new EditorFindSupport.RP(rp.getReplaceExpression(), rp.isPreserveCase());
                history.add(spwrap);
            }
            return history;
        }
    }
}

