/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Inflector;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifact;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifacts;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;

public class CustomClientSaasBean
extends SaasBean {
    public static final String ARTIFACT_TYPE_TEMPLATE = "template";
    public static final String ARTIFACT_TYPE_LIB = "lib";
    private String url;
    private CustomSaasMethod m;
    private Map<String, Map<String, String>> templates;
    private Map<String, String> libs;
    private boolean canGenerateJaxb;
    private String serviceMethodName;

    public CustomClientSaasBean(CustomSaasMethod m) throws IOException {
        this(m, false);
    }

    public CustomClientSaasBean(CustomSaasMethod m, boolean isDropTargetWeb) throws IOException {
        super(m.getSaas(), CustomClientSaasBean.deriveResourceName(m), null, CustomClientSaasBean.deriveUriTemplate(m), new Constants.MimeType[]{Constants.MimeType.XML}, new String[]{"java.lang.String"}, new Constants.HttpMethodType[]{Constants.HttpMethodType.GET});
        this.m = m;
        this.setIsDropTargetWeb(isDropTargetWeb);
        this.init();
    }

    private void init() throws IOException {
        List artifactsList;
        this.setHttpMethod(Constants.HttpMethodType.GET);
        if (this.m.getHref() != null) {
            this.setResourceClassTemplate(this.m.getHref());
        }
        this.findAuthentication((SaasMethod)this.m);
        ArrayList<Constants.MimeType> mimeTypes = new ArrayList<Constants.MimeType>();
        try {
            Method.Output out = this.m.getOutput();
            this.findSaasMediaType(mimeTypes, out.getMedia());
            if (mimeTypes.size() > 0) {
                this.setMimeTypes(mimeTypes.toArray(new Constants.MimeType[mimeTypes.size()]));
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        this.templates = new HashMap<String, Map<String, String>>();
        this.libs = new HashMap<String, String>();
        SaasMetadata.CodeGen codegen = this.m.getSaas().getSaasMetadata().getCodeGen();
        if (codegen != null && (artifactsList = codegen.getArtifacts()) != null) {
            for (Artifacts artifacts : artifactsList) {
                HashMap<String, String> artifactMap = new HashMap<String, String>();
                String targets = artifacts.getTargets();
                for (String target : targets.split(",")) {
                    this.addArtifactTemplates(target, artifactMap);
                }
                List artifactList = artifacts.getArtifact();
                if (artifactList == null) continue;
                for (Artifact artifact : artifactList) {
                    String type;
                    if (artifact.getRequires() != null) {
                        // empty if block
                    }
                    if ((type = artifact.getType()) == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@type value is null.");
                    }
                    String id = artifact.getId();
                    String artifactUrl = artifact.getUrl();
                    if (id == null || artifactUrl == null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@id|@url value is null.");
                    }
                    if (type.equals(ARTIFACT_TYPE_TEMPLATE)) {
                        if (artifactMap.get(id) != null) {
                            throw new IOException("saas-metadata/code-gen/artifacts/artifact/@" + id + " already exists.");
                        }
                        artifactMap.put(id, artifactUrl);
                        continue;
                    }
                    if (!type.equals(ARTIFACT_TYPE_LIB)) continue;
                    if (this.libs.get(id) != null) {
                        throw new IOException("saas-metadata/code-gen/artifacts/artifact/@" + id + " already exists.");
                    }
                    this.libs.put(id, artifactUrl);
                }
            }
        }
    }

    public String getSaasServiceMethodName() {
        if (this.serviceMethodName == null) {
            this.serviceMethodName = Util.deriveMethodName(this.getMethod().getName());
            this.serviceMethodName = this.serviceMethodName.substring(0, 1).toLowerCase() + this.serviceMethodName.substring(1);
        }
        return this.serviceMethodName;
    }

    public CustomSaasMethod getMethod() {
        return this.m;
    }

    @Override
    protected List<ParameterInfo> initInputParameters() {
        ArrayList<ParameterInfo> inputParams = new ArrayList<ParameterInfo>();
        Method.Input in = this.m.getInput();
        if (in != null && in.getParams() != null && in.getParams().getParam() != null) {
            List params = in.getParams().getParam();
            this.findSaasParams(inputParams, params);
            for (ParameterInfo p : inputParams) {
                p.setStyle(ParameterInfo.ParamStyle.QUERY);
            }
        }
        return inputParams;
    }

    public String getUrl() {
        return this.url;
    }

    protected static String deriveResourceName(CustomSaasMethod m) {
        String name = m.getName();
        if (m.getHref() != null && !m.getHref().trim().equals("")) {
            name = m.getHref();
        }
        return Inflector.getInstance().camelize(name + "Resource");
    }

    protected static String deriveUriTemplate(CustomSaasMethod m) {
        String name = m.getName();
        if (m.getHref() != null && !m.getHref().trim().equals("")) {
            name = m.getHref();
        }
        return Inflector.getInstance().camelize(name, true) + "/";
    }

    public Map<String, String> getArtifactLibs() {
        return this.libs;
    }

    public void setArtifactLibs(Map<String, String> libs) {
        this.libs = libs;
    }

    public Map<String, String> getArtifactTemplates(String target) {
        return this.templates.get(target);
    }

    public void addArtifactTemplates(String target, Map<String, String> templates) {
        this.templates.put(target, templates);
    }

    public boolean canGenerateJAXBUnmarshaller() {
        return this.canGenerateJaxb;
    }

    public void setCanGenerateJAXBUnmarshaller(boolean canGenerateJaxb) {
        this.canGenerateJaxb = canGenerateJaxb;
    }
}

