/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.apduio;

import com.sun.javacard.apduio.CadEvent;
import com.sun.javacard.apduio.CadServerListener;
import com.sun.javacard.apduio.ServerT1Data;
import com.sun.javacard.apduio.T1Block;
import com.sun.javacard.apduio.T1BlockReader;
import com.sun.javacard.apduio.T1Exception;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class CadT1Dual {
    private static final boolean DEBUG = false;
    private static final boolean IDEBUG = false;
    private static final boolean PROTDEBUG = false;
    private static int INTERFACE_CONTACTED = 0;
    private static int INTERFACE_CONTACTLESS = 1;
    byte[] sendBuffer = new byte[40];
    byte[] recvBuffer = new byte[40];
    protected static final int MAX_IFS_SIZE = 32;
    private static final byte BLOCKPROTOCOL_POWERUP = -16;
    private static final byte BLOCKPROTOCOL_POWERDOWN = -32;
    private static final byte BLOCKPROTOCOL_COMMAND = -128;
    private static final int BLOCKPROTOCOL_OFFSET_OPCODE = 0;
    private static final int BLOCKPROTOCOL_OFFSET_LENGTH = 1;
    private static final int BLOCKPROTOCOL_OFFSET_MESSAGE = 3;
    private static final int BLOCKPROTOCOL_HEADER_SIZE = 3;
    private static final int BLOCKPROTOCOL_OVERHEAD_SIZE = 4;
    OutputStream contacted_out;
    OutputStream contactless_out;
    OutputStream out;
    ServerT1Data contacted_state = new ServerT1Data();
    ServerT1Data contactless_state = new ServerT1Data();
    ServerT1Data current_interface_state = this.contacted_state;
    byte[] contacted_atr;
    byte[] contactless_atr;
    T1BlockReader contacted_input_channel;
    T1BlockReader contactless_input_channel;
    T1BlockReader current_input_channel;
    private static final byte T1_EVENT_NONE = 0;
    private static final byte T1_EVENT_POWERUP = 1;
    private static final byte T1_EVENT_POWERDOWN = 2;
    private static final byte T1_EVENT_POWERRESET = 3;
    private byte secondaryInterfaceEvent = 0;
    private boolean waitingForTheFirstBlock = true;
    Vector<CadServerListener> listeners = new Vector();

    public void setContactedATR(byte[] contacted_atr) {
        this.contacted_atr = contacted_atr;
    }

    public void setContactlessATR(byte[] contactless_atr) {
        this.contactless_atr = contactless_atr;
    }

    public byte getSecondaryInterfaceEvent() {
        byte result = this.secondaryInterfaceEvent;
        this.secondaryInterfaceEvent = 0;
        return result;
    }

    private void switchToContacted() {
        this.out = this.contacted_out;
        this.current_interface_state = this.contacted_state;
        this.current_input_channel = this.contacted_input_channel;
    }

    private void switchToContactless() {
        if (this.contactless_out != null && this.out == this.contacted_out) {
            this.out = this.contactless_out;
            this.current_interface_state = this.contactless_state;
            this.current_input_channel = this.contactless_input_channel;
        }
    }

    public byte getActiveInterface() {
        if (this.out != null && this.out == this.contactless_out) {
            return (byte)INTERFACE_CONTACTLESS;
        }
        return (byte)INTERFACE_CONTACTED;
    }

    public CadT1Dual(Socket contactedSocket) {
        try {
            this.current_input_channel = this.contacted_input_channel = new T1BlockReader(contactedSocket);
            this.out = this.contacted_out = contactedSocket.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setContactlessSocket(Socket contactlessSocket) {
        try {
            this.contactless_input_channel = new T1BlockReader(contactlessSocket);
            this.contactless_out = contactlessSocket.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void sendBlockProtocolMessage(int msgLen) throws IOException, T1Exception {
        this.out.write(this.sendBuffer, 0, msgLen);
        this.out.flush();
    }

    private synchronized int receiveBlockProtocolMessage(boolean switchInterface) throws IOException, T1Exception {
        int recvLen;
        while (true) {
            recvLen = 0;
            if (this.waitingForTheFirstBlock || switchInterface) {
                while (true) {
                    this.switchToContactless();
                    recvLen = this.current_input_channel.readT1Block(this.recvBuffer, true);
                    if (recvLen == 0) {
                        this.switchToContacted();
                        recvLen = this.current_input_channel.readT1Block(this.recvBuffer, true);
                        if (recvLen == 0) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    }
                    break;
                }
            } else {
                while ((recvLen = this.current_input_channel.readT1Block(this.recvBuffer, false)) == 0) {
                }
            }
            if (this.recvBuffer[0] == -32) {
                this.powerDown();
                continue;
            }
            if (this.recvBuffer[0] != -16) break;
            this.powerUpAndSendATR();
        }
        if (this.recvBuffer[0] != -128) {
            throw new T1Exception(-126);
        }
        this.waitingForTheFirstBlock = false;
        return recvLen;
    }

    private synchronized boolean exchangeBlock(T1Block blockTo, T1Block blockFrom, boolean switchInterface) throws IOException, T1Exception {
        byte[] blockData = blockTo.toByteArray();
        int blockLen = blockData.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(blockLen >> 8);
        this.sendBuffer[2] = (byte)blockLen;
        System.arraycopy(blockData, 0, this.sendBuffer, 3, blockLen);
        this.sendBuffer[blockLen + 3] = CadT1Dual.computeLRC(this.sendBuffer, 0, blockLen + 3);
        this.sendBlockProtocolMessage(blockLen + 4);
        blockLen = this.receiveBlockProtocolMessage(switchInterface);
        if (blockLen == -1) {
            return false;
        }
        blockFrom.readBlockInstance(this.recvBuffer, 3, blockLen - 4);
        return true;
    }

    public synchronized boolean receiveBlock(T1Block blockFrom, boolean switchInterface) throws IOException, T1Exception {
        int blockLen = this.receiveBlockProtocolMessage(switchInterface);
        blockFrom.readBlockInstance(this.recvBuffer, 3, blockLen - 4);
        return true;
    }

    private boolean sendATR(byte[] atrData) throws IOException, T1Exception {
        int blockLen = atrData.length;
        this.sendBuffer[0] = -128;
        this.sendBuffer[1] = (byte)(blockLen >> 8);
        this.sendBuffer[2] = (byte)blockLen;
        System.arraycopy(atrData, 0, this.sendBuffer, 3, blockLen);
        this.sendBuffer[blockLen + 3] = CadT1Dual.computeLRC(this.sendBuffer, 0, blockLen + 3);
        this.sendBlockProtocolMessage(blockLen + 4);
        this.current_interface_state.serverState = 2;
        return true;
    }

    public int getMaxIFSSize() {
        return 32;
    }

    private static byte computeLRC(byte[] buffer, int offset, int len) {
        byte lrcVal = 0;
        for (int i = 0; i < len; ++i) {
            lrcVal = (byte)(lrcVal ^ buffer[offset + i]);
        }
        return lrcVal;
    }

    public boolean t1Wait() throws T1Exception {
        return this.t1Wait(this.current_interface_state);
    }

    public boolean t1Abort() throws T1Exception {
        return this.t1Abort(this.current_interface_state);
    }

    public boolean t1LastBlockReceived() {
        return this.current_interface_state.lastBlockFlag;
    }

    public void addCadServerListener(CadServerListener listener) {
        this.listeners.addElement(listener);
    }

    private void notifyPowerDown() {
        Vector v = (Vector)this.listeners.clone();
        for (int i = 0; i < v.size(); ++i) {
            ((CadServerListener)v.elementAt(i)).powerDown(new CadEvent(this.current_interface_state));
        }
    }

    public static void discardIncomingGetLe(CadT1Dual cadObj, short[] LEN, short numBytesExpected, short numBytesReceived) {
        ServerT1Data std = cadObj.current_interface_state;
        byte[] data = std.nextIBlock.getINFBytes();
        int dataLen = std.nextIBlock.getLEN() - std.nextBlockDataOffset;
        LEN[0] = (short)dataLen;
        std.lastBlockFlag = std.nextIBlock.isLastBlock();
        numBytesReceived = (short)(numBytesReceived + dataLen);
        short diff = (short)(numBytesExpected - numBytesReceived);
        short leOffset = 0;
        if (diff < 0) {
            if (diff == -1) {
                leOffset = (short)(std.nextBlockDataOffset + dataLen - 1);
                LEN[1] = (short)(data[leOffset] & 0xFF);
            } else if (dataLen >= 2) {
                leOffset = (short)(std.nextBlockDataOffset + dataLen - 2);
                LEN[1] = (short)(data[leOffset] << 8);
                LEN[1] = (short)(LEN[1] + (short)(data[(short)(leOffset + 1)] & 0xFF));
            } else {
                leOffset = (short)(std.nextBlockDataOffset + dataLen - 1);
                LEN[1] = (short)(LEN[1] << 8);
                LEN[1] = (short)(LEN[1] + (short)(data[leOffset] & 0xFF));
            }
        }
        std.nextIBlock = null;
        std.nextBlockDataOffset = 0;
    }

    public static void placeDataInBuffer(CadT1Dual cadObj, byte[] bufferINF, short[] LEN, short offset, short buffSize) {
        ServerT1Data std = cadObj.current_interface_state;
        byte[] data = std.nextIBlock.getINFBytes();
        int dataLen = std.nextIBlock.getLEN() - std.nextBlockDataOffset;
        if (dataLen + offset > buffSize) {
            int maxSize = buffSize - offset;
            System.arraycopy(data, std.nextBlockDataOffset, bufferINF, offset, maxSize);
            LEN[0] = (short)maxSize;
            std.nextBlockDataOffset += maxSize;
            std.lastBlockFlag = false;
        } else {
            System.arraycopy(data, std.nextBlockDataOffset, bufferINF, offset, dataLen);
            LEN[0] = (short)dataLen;
            std.lastBlockFlag = std.nextIBlock.isLastBlock();
            std.nextIBlock = null;
            std.nextBlockDataOffset = 0;
        }
    }

    private short t1ReplySBlock(ServerT1Data std, boolean[] retransmit) throws T1Exception, IOException {
        byte sbType = std.blockIncoming.getSBlockType();
        switch (sbType) {
            case -64: 
            case -63: {
                throw new T1Exception(-125);
            }
            case -61: {
                throw new T1Exception(-124);
            }
            case -62: {
                boolean retransmitSBlock = true;
                while (retransmitSBlock) {
                    boolean seqBlock;
                    byte incomingBlockType;
                    std.blockOutgoing.setSBlock((byte)0, (byte)0, -30, 0);
                    boolean result = this.exchangeBlock(std.blockOutgoing, std.blockIncoming, false);
                    if (!result) {
                        this.notifyPowerDown();
                    }
                    if ((incomingBlockType = std.blockIncoming.getBlockType()) == 0) {
                        seqBlock = std.blockIncoming.getSequence();
                        if (seqBlock != std.numSeqRcv) {
                            std.numSeqRcv = seqBlock;
                            std.nextIBlock = std.blockIncoming;
                            retransmit[0] = false;
                            retransmitSBlock = false;
                            continue;
                        }
                        throw new T1Exception(-126);
                    }
                    if (incomingBlockType == -128) {
                        seqBlock = std.blockIncoming.getSequence();
                        if (seqBlock != std.numSeqTx) {
                            retransmit[0] = true;
                            continue;
                        }
                        throw new T1Exception(-124);
                    }
                    throw new T1Exception(-126);
                }
                break;
            }
            default: {
                throw new T1Exception(-124);
            }
        }
        return 0;
    }

    public short t1SndBlockRcvAck(byte[] buffer, int dataOffset, int dataLength, boolean isLastBlock, boolean switchInterface) throws T1Exception {
        try {
            boolean retransmit = true;
            block7: while (retransmit) {
                this.current_interface_state.blockOutgoing.setIBlock((byte)0, (byte)0, this.current_interface_state.numSeq, isLastBlock, buffer, dataOffset, dataLength);
                T1Block input = new T1Block();
                boolean result = this.exchangeBlock(this.current_interface_state.blockOutgoing, input, switchInterface);
                this.current_interface_state.blockIncoming = input;
                if (!result) {
                    this.notifyPowerDown();
                }
                if (this.current_interface_state.recvFirstBlock) {
                    this.current_interface_state.resetProtocol();
                    this.current_interface_state.recvFirstBlock = false;
                } else {
                    this.current_interface_state.numSeqTx = this.current_interface_state.numSeq;
                    this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                }
                byte incomingBlockType = this.current_interface_state.blockIncoming.getBlockType();
                switch (incomingBlockType) {
                    case 0: {
                        if (!isLastBlock) {
                            throw new T1Exception(-124);
                        }
                        boolean seqBlock = this.current_interface_state.blockIncoming.getSequence();
                        if (seqBlock != this.current_interface_state.numSeqRcv) {
                            this.current_interface_state.numSeqRcv = seqBlock;
                            this.current_interface_state.nextIBlock = this.current_interface_state.blockIncoming;
                            retransmit = false;
                            this.current_interface_state.lastBlockFlag = false;
                            continue block7;
                        }
                        this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                        retransmit = true;
                        continue block7;
                    }
                    case -128: {
                        boolean seqBlock = this.current_interface_state.blockIncoming.getSequence();
                        if (isLastBlock) {
                            if (seqBlock != this.current_interface_state.numSeqTx) {
                                throw new T1Exception(-126);
                            }
                            this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                            retransmit = true;
                            continue block7;
                        }
                        if (seqBlock != this.current_interface_state.numSeqTx) {
                            retransmit = false;
                            continue block7;
                        }
                        this.current_interface_state.numSeq = !this.current_interface_state.numSeq;
                        retransmit = true;
                        continue block7;
                    }
                    case -64: {
                        boolean[] bRetransmit = new boolean[]{retransmit};
                        short sresult = this.t1ReplySBlock(this.current_interface_state, bRetransmit);
                        retransmit = bRetransmit[0];
                        if (sresult == 0) continue block7;
                        return sresult;
                    }
                }
                throw new T1Exception(-126);
            }
            return 0;
        }
        catch (IOException ie) {
            throw new T1Exception(-126);
        }
    }

    public short t1RcvBlock(byte[] bufferINF, short[] LEN, short offset, short buffSize) throws T1Exception {
        try {
            if (this.current_interface_state.nextIBlock == null) {
                boolean retransmit = true;
                block12: while (retransmit) {
                    boolean seqBlock;
                    boolean result;
                    if (this.current_interface_state.recvFirstBlock) {
                        T1Block input = new T1Block();
                        result = this.receiveBlock(input, false);
                        this.current_interface_state.blockIncoming = input;
                        if (!result) {
                            this.notifyPowerDown();
                        }
                        byte inBlockType = this.current_interface_state.blockIncoming.getBlockType();
                        switch (inBlockType) {
                            case 0: {
                                seqBlock = this.current_interface_state.blockIncoming.getSequence();
                                if (this.current_interface_state.recvFirstBlock) {
                                    this.current_interface_state.resetProtocol();
                                    this.current_interface_state.recvFirstBlock = false;
                                }
                                if (seqBlock != this.current_interface_state.numSeqRcv) {
                                    this.current_interface_state.numSeqRcv = seqBlock;
                                    this.current_interface_state.nextIBlock = this.current_interface_state.blockIncoming;
                                    this.current_interface_state.nextBlockDataOffset = 0;
                                    retransmit = false;
                                    break;
                                }
                                retransmit = true;
                                break;
                            }
                            case -128: {
                                throw new T1Exception(-126);
                            }
                            case -64: {
                                throw new T1Exception(-126);
                            }
                            default: {
                                throw new T1Exception(-126);
                            }
                        }
                        continue;
                    }
                    this.current_interface_state.blockOutgoing.setRBlock((byte)0, (byte)0, !this.current_interface_state.numSeqRcv);
                    result = this.exchangeBlock(this.current_interface_state.blockOutgoing, this.current_interface_state.blockIncoming, false);
                    if (!result) {
                        this.notifyPowerDown();
                    }
                    byte inBlockType = this.current_interface_state.blockIncoming.getBlockType();
                    switch (inBlockType) {
                        case 0: {
                            seqBlock = this.current_interface_state.blockIncoming.getSequence();
                            if (seqBlock != this.current_interface_state.numSeqRcv) {
                                this.current_interface_state.numSeqRcv = seqBlock;
                                this.current_interface_state.nextIBlock = this.current_interface_state.blockIncoming;
                                this.current_interface_state.nextBlockDataOffset = 0;
                                retransmit = false;
                                continue block12;
                            }
                            retransmit = true;
                            continue block12;
                        }
                        case -128: {
                            retransmit = true;
                            continue block12;
                        }
                        case -64: {
                            boolean[] bRetransmit = new boolean[]{retransmit};
                            short sresult = this.t1ReplySBlock(this.current_interface_state, bRetransmit);
                            retransmit = bRetransmit[0];
                            if (sresult == 0) continue block12;
                            return sresult;
                        }
                    }
                    throw new T1Exception(-126);
                }
            }
            return 0;
        }
        catch (IOException ei) {
            throw new T1Exception(-126);
        }
    }

    private boolean t1Abort(ServerT1Data std) throws T1Exception {
        try {
            boolean retransmit = true;
            block7: while (retransmit) {
                this.current_interface_state.blockOutgoing.setSBlock((byte)0, (byte)0, -62, 0);
                boolean result = this.exchangeBlock(this.current_interface_state.blockOutgoing, this.current_interface_state.blockIncoming, false);
                if (!result) {
                    this.notifyPowerDown();
                }
                byte incomingBlockType = this.current_interface_state.blockIncoming.getBlockType();
                switch (incomingBlockType) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean seqBlock = this.current_interface_state.blockIncoming.getSequence();
                        if (seqBlock != this.current_interface_state.numSeqTx) {
                            retransmit = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte sbType = this.current_interface_state.blockIncoming.getSBlockType();
                        if (sbType != -30) {
                            throw new T1Exception(-126);
                        }
                        std.lastBlockFlag = false;
                        std.nextIBlock = null;
                        std.nextBlockDataOffset = 0;
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException ie) {
            throw new T1Exception(-126);
        }
    }

    private boolean t1Wait(ServerT1Data std) throws T1Exception {
        try {
            boolean retransmit = true;
            block7: while (retransmit) {
                std.blockOutgoing.setSBlock((byte)0, (byte)0, -61, 0);
                boolean result = this.exchangeBlock(std.blockOutgoing, std.blockIncoming, false);
                if (!result) {
                    this.notifyPowerDown();
                }
                byte incomingBlockType = std.blockIncoming.getBlockType();
                switch (incomingBlockType) {
                    case 0: {
                        throw new T1Exception(-126);
                    }
                    case -128: {
                        boolean seqBlock = std.blockIncoming.getSequence();
                        if (seqBlock != std.numSeqTx) {
                            retransmit = true;
                            continue block7;
                        }
                        throw new T1Exception(-126);
                    }
                    case -64: {
                        byte sbType = std.blockIncoming.getSBlockType();
                        if (sbType != -29) {
                            throw new T1Exception(-126);
                        }
                        return true;
                    }
                }
                throw new T1Exception(-126);
            }
            return false;
        }
        catch (IOException ie) {
            throw new T1Exception(-126);
        }
    }

    public static byte t1GetNAD() {
        return 0;
    }

    public short t1GetIFSC() {
        return 32;
    }

    public short t1GetIFSD() {
        return 32;
    }

    private void powerUpAndSendATR() throws T1Exception, IOException {
        this.current_interface_state.resetProtocol();
        if (this.getActiveInterface() == INTERFACE_CONTACTLESS) {
            this.sendATR(this.contactless_atr);
            if (this.secondaryInterfaceEvent == 2) {
                this.secondaryInterfaceEvent = (byte)3;
            } else if (this.secondaryInterfaceEvent != 3) {
                this.secondaryInterfaceEvent = 1;
            }
        } else {
            this.sendATR(this.contacted_atr);
        }
    }

    private void powerDown() {
        this.current_interface_state.resetProtocol();
        if (this.getActiveInterface() == INTERFACE_CONTACTED) {
            this.notifyPowerDown();
        }
        this.secondaryInterfaceEvent = (byte)2;
        this.current_interface_state.serverState = 0;
    }
}

