/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.ExceptionNode;
import org.netbeans.modules.viewmodel.HyperColumnModel;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.netbeans.swing.etable.ETableColumn;
import org.openide.awt.Actions;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class TreeModelNode
extends AbstractNode {
    private static final int MAX_HTML_LENGTH = 511;
    private static final String HTML_START_TAG = "<html>";
    private static final String HTML_END_TAG = "</html>";
    private Models.CompoundModel model;
    private final ColumnModel[] columns;
    protected TreeModelRoot treeModelRoot;
    protected Object object;
    private final LazyChildrenFactory lazyChildren;
    private String displayName;
    private String oldDisplayName;
    private String htmlDisplayName;
    private final Object displayNameLock = new Object();
    private boolean iconLoaded;
    private String shortDescription;
    private final Object shortDescriptionLock = new Object();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, String> columnIDsMap;
    private static final String EVALUATING_STR = NbBundle.getMessage(TreeModelNode.class, (String)"EvaluatingProp");
    private RequestProcessor.Task refreshTask;
    private final Object refreshTaskLock = new Object();
    private final Set<Models.CompoundModel> childrenRefreshModels = new HashSet<Models.CompoundModel>();
    private static RequestProcessor requestProcessor;
    private PropertyDisplayNameListener propertyDisplayNameListener;
    private Integer depth;
    private static AtomicLong lastPropertyRefresh;

    public TreeModelNode(Models.CompoundModel model, TreeModelRoot treeModelRoot, Object object) {
        this(model, model.getColumns(), treeModelRoot, object);
    }

    public TreeModelNode(Models.CompoundModel model, ColumnModel[] columns, TreeModelRoot treeModelRoot, Object object) {
        this(model, columns, object != model.getRoot() ? new LazyChildrenFactory(model, columns, treeModelRoot, object) : null, object != model.getRoot() ? null : TreeModelNode.createChildren(model, columns, treeModelRoot, object), treeModelRoot, object);
    }

    protected TreeModelNode(Models.CompoundModel model, ColumnModel[] columns, LazyChildrenFactory lazyChildren, Children children, TreeModelRoot treeModelRoot, Object object) {
        this(model, columns, lazyChildren, children, treeModelRoot, object, new Index[]{null});
    }

    private TreeModelNode(Models.CompoundModel model, ColumnModel[] columns, LazyChildrenFactory lazyChildren, Children children, TreeModelRoot treeModelRoot, Object object, Index[] indexPtr) {
        super(lazyChildren != null ? Children.createLazy((Callable)lazyChildren) : children, TreeModelNode.createLookup(object, model, children, indexPtr));
        this.model = model;
        this.treeModelRoot = treeModelRoot;
        this.object = object;
        this.lazyChildren = lazyChildren;
        if (indexPtr[0] != null) {
            ((IndexImpl)indexPtr[0]).setNode((Node)this);
            this.setIndexWatcher(indexPtr[0]);
        }
        if (model.getHelpId() != null) {
            this.setValue("propertiesHelpID", model.getHelpId());
        }
        treeModelRoot.registerNode(object, this);
        this.columnIDsMap = TreeModelNode.createColumnIDsMap(columns);
        this.columns = columns;
    }

    private static Lookup createLookup(Object object, Models.CompoundModel model, Children ch, Index[] indexPtr) {
        boolean canReorder;
        CheckNodeCookieImpl cnc = new CheckNodeCookieImpl(model, object);
        try {
            canReorder = model.canReorder(object);
        }
        catch (UnknownTypeException ex) {
            if (!(object instanceof String)) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + model, ex);
            }
            canReorder = false;
        }
        if (canReorder) {
            IndexImpl i = new IndexImpl(model, object);
            indexPtr[0] = i;
            return Lookups.fixed((Object[])new Object[]{object, cnc, i});
        }
        return Lookups.fixed((Object[])new Object[]{object, cnc});
    }

    private static Map<String, String> createColumnIDsMap(ColumnModel[] columns) {
        HashMap<String, String> cids = null;
        for (ColumnModel cm : columns) {
            if (!(cm instanceof HyperColumnModel)) continue;
            if (cids == null) {
                cids = new HashMap<String, String>();
            }
            HyperColumnModel hcm = (HyperColumnModel)cm;
            String mainID = cm.getID();
            for (String id : hcm.getAllIDs()) {
                cids.put(id, mainID);
            }
        }
        return cids;
    }

    private boolean areChildrenInitialized() {
        if (this.lazyChildren != null) {
            return this.lazyChildren.areChildrenCreated();
        }
        return true;
    }

    private void setIndexWatcher(Index childrenIndex) {
        childrenIndex.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!TreeModelNode.this.areChildrenInitialized()) {
                    return;
                }
                Children ch = TreeModelNode.this.getChildren();
                if (ch instanceof TreeModelChildren) {
                    ((TreeModelChildren)ch).refreshChildren(new TreeModelChildren.RefreshingInfo(false));
                }
            }
        });
    }

    private static Executor asynchronous(Models.CompoundModel model, AsynchronousModelFilter.CALL asynchCall, Object object) {
        Executor exec;
        try {
            exec = model.asynchronous(asynchCall, object);
            if (exec == null) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)new NullPointerException("Provided executor is null."), (String)("model = " + model + ", object = " + object)));
                exec = AsynchronousModelFilter.CURRENT_THREAD;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("model = " + model + ", object = " + object)));
            exec = AsynchronousModelFilter.CURRENT_THREAD;
        }
        return exec;
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        int k = this.columns.length;
        for (int i = 0; i < k; ++i) {
            ps.put((Node.Property)new MyProperty(this.columns[i], this.treeModelRoot));
        }
        sheet.put(ps);
        return sheet;
    }

    private static Children createChildren(Models.CompoundModel model, ColumnModel[] columns, TreeModelRoot treeModelRoot, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            return model.isLeaf(object) ? Children.LEAF : new TreeModelChildren(model, columns, treeModelRoot, object);
        }
        catch (UnknownTypeException e) {
            if (!(object instanceof String)) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + model, e);
            }
            return Children.LEAF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShortDescription() {
        Object object = this.shortDescriptionLock;
        synchronized (object) {
            if (this.shortDescription != null) {
                return this.shortDescription;
            }
        }
        Executor exec = TreeModelNode.asynchronous(this.model, AsynchronousModelFilter.CALL.SHORT_DESCRIPTION, this.object);
        if (exec == AsynchronousModelFilter.CURRENT_THREAD) {
            return this.updateShortDescription();
        }
        exec.execute(new Runnable(){

            @Override
            public void run() {
                TreeModelNode.this.updateShortDescription();
                TreeModelNode.this.fireShortDescriptionChange(null, null);
            }
        });
        return EVALUATING_STR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateShortDescription() {
        try {
            String sd = this.model.getShortDescription(this.object);
            if (sd != null) {
                sd = TreeModelNode.adjustHTML(sd);
            }
            Object object = this.shortDescriptionLock;
            synchronized (object) {
                this.shortDescription = sd;
            }
            return sd;
        }
        catch (UnknownTypeException e) {
            if (!(this.object instanceof String)) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFireShortDescriptionChange() {
        Object object = this.shortDescriptionLock;
        synchronized (object) {
            this.shortDescription = null;
        }
        this.fireShortDescriptionChange(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtmlDisplayName() {
        Object object = this.displayNameLock;
        synchronized (object) {
            if (this.displayName == null) {
                try {
                    this.setModelDisplayName();
                }
                catch (UnknownTypeException ex) {
                    Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, ex);
                }
            }
            if (this.displayName == null) {
                this.displayName = "";
            }
            return this.htmlDisplayName;
        }
    }

    public Action[] getActions(boolean context) {
        Action[] actions;
        if (context) {
            Action[] actionArray = this.treeModelRoot.getRootNode().getActions(false);
        }
        try {
            actions = this.filterActionsWhenSorted(this.model.getActions(this.object));
        }
        catch (UnknownTypeException e) {
            actions = new Action[]{};
        }
        this.presetActionNodes(actions);
        return actions;
    }

    private void presetActionNodes(Action[] actions) {
        for (Action a : actions) {
            if (!(a instanceof ActionOnPresetNodes)) continue;
            ((ActionOnPresetNodes)a).addNode((Node)this);
        }
    }

    private boolean isTableSorted() {
        TableColumnModel tcm = this.treeModelRoot.getOutlineView().getOutline().getColumnModel();
        Enumeration<TableColumn> cen = tcm.getColumns();
        while (cen.hasMoreElements()) {
            ETableColumn etc = (ETableColumn)cen.nextElement();
            if (!etc.isSorted()) continue;
            return true;
        }
        return false;
    }

    private Action[] filterActionsWhenSorted(Action[] actions) {
        if (actions == null || actions.length == 0) {
            return actions;
        }
        for (int i = 0; i < actions.length; ++i) {
            boolean disabled;
            Action a = actions[i];
            if (a == null || !(disabled = Boolean.TRUE.equals(a.getValue("DisabledWhenInSortedTable")))) continue;
            actions[i] = a instanceof DisableableAction ? ((DisableableAction)a).createDisableable(new PrivilegedAction(){

                public Object run() {
                    return !TreeModelNode.this.isTableSorted();
                }
            }) : new DisabledWhenSortedAction(a);
        }
        return actions;
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TreeModelNode.this.model.performDefaultAction(TreeModelNode.this.object);
                }
                catch (UnknownTypeException unknownTypeException) {
                    // empty catch block
                }
            }
        };
    }

    public boolean canDestroy() {
        try {
            Action[] as = this.model.getActions(this.object);
            int k = as.length;
            for (int i = 0; i < k; ++i) {
                Object key;
                if (as[i] == null || (key = as[i].getValue("AcceleratorKey")) == null || !key.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                return as[i].isEnabled();
            }
            return false;
        }
        catch (UnknownTypeException e) {
            return false;
        }
    }

    public boolean canCopy() {
        try {
            return this.model.canCopy(this.object);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            return false;
        }
    }

    public boolean canCut() {
        try {
            return this.model.canCut(this.object);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            return false;
        }
    }

    public void destroy() {
        try {
            Action[] as = this.model.getActions(this.object);
            int k = as.length;
            for (int i = 0; i < k; ++i) {
                Object key;
                if (as[i] == null || (key = as[i].getValue("AcceleratorKey")) == null || !key.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                as[i].actionPerformed(null);
                return;
            }
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
        }
        if (this.model.getRoot() == this.object) {
            this.treeModelRoot.destroy();
        }
    }

    void setObject(Object o) {
        this.setObject(this.model, o);
    }

    void setObject(Models.CompoundModel model, Object o) {
        this.setObjectNoRefresh(o);
        this.refresh(model);
    }

    private void setObjectNoRefresh(Object o) {
        Children ch;
        this.object = o;
        if (this.areChildrenInitialized() && (ch = this.getChildren()) instanceof TreeModelChildren) {
            ((TreeModelChildren)ch).object = o;
        }
    }

    public Object getObject() {
        return this.object;
    }

    Models.CompoundModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(Models.CompoundModel model) {
        Object object = this.properties;
        synchronized (object) {
            this.properties.clear();
        }
        object = this.childrenRefreshModels;
        synchronized (object) {
            this.childrenRefreshModels.add(model);
        }
        object = this.refreshTaskLock;
        synchronized (object) {
            if (this.refreshTask == null) {
                this.refreshTask = this.getRequestProcessor().create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HashSet<Models.CompoundModel> modelsToRefresh;
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeAndWait(this);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (InvocationTargetException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            return;
                        }
                        TreeModelNode.this.refreshNode();
                        TreeModelNode.this.doFireShortDescriptionChange();
                        Set set = TreeModelNode.this.childrenRefreshModels;
                        synchronized (set) {
                            modelsToRefresh = new HashSet<Models.CompoundModel>(TreeModelNode.this.childrenRefreshModels);
                            TreeModelNode.this.childrenRefreshModels.clear();
                        }
                        if (modelsToRefresh.size() > 0) {
                            TreeModelNode.this.refreshTheChildren(modelsToRefresh, new TreeModelChildren.RefreshingInfo(true));
                        }
                    }
                });
            }
            this.refreshTask.schedule(10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(final Models.CompoundModel model, int changeMask) {
        Set<Models.CompoundModel> set;
        if (changeMask == -1) {
            this.refresh(model);
            return;
        }
        boolean refreshed = false;
        if ((1 & changeMask) != 0) {
            boolean doFireDisplayNameChange;
            set = this.displayNameLock;
            synchronized (set) {
                doFireDisplayNameChange = this.displayName != null;
                this.displayName = null;
            }
            if (doFireDisplayNameChange) {
                this.fireDisplayNameChange(null, null);
            }
            refreshed = true;
        }
        if ((2 & changeMask) != 0) {
            if (this.iconLoaded) {
                this.iconLoaded = false;
                this.fireIconChange();
            }
            refreshed = true;
        }
        if ((4 & changeMask) != 0) {
            this.doFireShortDescriptionChange();
            refreshed = true;
        }
        if ((8 & changeMask) != 0) {
            boolean doRefresh;
            set = this.childrenRefreshModels;
            synchronized (set) {
                doRefresh = this.childrenRefreshModels.add(model);
            }
            if (doRefresh) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Set set = TreeModelNode.this.childrenRefreshModels;
                        synchronized (set) {
                            TreeModelNode.this.childrenRefreshModels.remove(model);
                        }
                        TreeModelNode.this.refreshTheChildren(Collections.singleton(model), new TreeModelChildren.RefreshingInfo(false));
                    }
                });
            }
            refreshed = true;
        }
        if ((0x10 & changeMask) != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TreeModelNode.this.expandIfSetToExpanded();
                }
            });
        }
        if (!refreshed) {
            this.refresh(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RequestProcessor getRequestProcessor() {
        Class<TreeModelNode> clazz = TreeModelNode.class;
        synchronized (TreeModelNode.class) {
            if (requestProcessor == null) {
                requestProcessor = new RequestProcessor("TreeModel", 1);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return requestProcessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setName(String name, boolean italics) {
        Object object = this.displayNameLock;
        synchronized (object) {
            String newDisplayName;
            String oldHtmlDisplayName = this.htmlDisplayName;
            String _oldDisplayName = this.oldDisplayName;
            if (name.startsWith(HTML_START_TAG)) {
                this.htmlDisplayName = name;
                newDisplayName = TreeModelNode.removeHTML(name);
            } else if (name.startsWith("<_html>")) {
                this.htmlDisplayName = '<' + name.substring(2);
                newDisplayName = "";
            } else {
                this.htmlDisplayName = null;
                newDisplayName = name;
            }
            this.displayName = newDisplayName;
            this.oldDisplayName = newDisplayName;
            return _oldDisplayName == null || !_oldDisplayName.equals(newDisplayName) || oldHtmlDisplayName == null || !oldHtmlDisplayName.equals(this.htmlDisplayName);
        }
    }

    private String parseDisplayFormat(String name) {
        MessageFormat treeNodeDisplayFormat = this.treeModelRoot.getTreeNodeDisplayFormat();
        if (treeNodeDisplayFormat == null) {
            return name;
        }
        if (this.propertyDisplayNameListener == null) {
            this.propertyDisplayNameListener = new PropertyDisplayNameListener();
            this.addPropertyChangeListener(this.propertyDisplayNameListener);
        }
        Node.Property[] nodeProperties = this.getPropertySets()[0].getProperties();
        Format[] formatsByArgumentIndex = treeNodeDisplayFormat.getFormatsByArgumentIndex();
        String pattern = treeNodeDisplayFormat.toPattern();
        int n = formatsByArgumentIndex.length;
        Object[] args = new Object[n];
        String[] argsHTML = new String[n];
        boolean nonEmptyArgs = false;
        for (int i = 0; i < n; ++i) {
            if (pattern.indexOf("{" + i) >= 0) {
                if (this.columns[i].getType() == null) {
                    if (name.startsWith(HTML_START_TAG)) {
                        argsHTML[i] = name;
                        args[i] = TreeModelNode.removeHTML(name);
                        continue;
                    }
                    if (name.startsWith("<_html>")) {
                        argsHTML[i] = '<' + name.substring(2);
                        args[i] = TreeModelNode.removeHTML(argsHTML[i]);
                        continue;
                    }
                    argsHTML[i] = null;
                    args[i] = name;
                    continue;
                }
                try {
                    args[i] = nodeProperties[i].getValue();
                    argsHTML[i] = (String)nodeProperties[i].getValue("htmlDisplayValue");
                    if ("".equals(args[i])) continue;
                    this.propertyDisplayNameListener.addPropertyName(nodeProperties[i].getName());
                    nonEmptyArgs = true;
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                continue;
            }
            args[i] = null;
        }
        if (nonEmptyArgs) {
            int i;
            boolean isHTML = false;
            int iHTML = -1;
            for (i = 0; i < n; ++i) {
                if (argsHTML[i] != null) {
                    isHTML = true;
                    iHTML = i;
                    args[i] = TreeModelNode.stripHTMLTags(argsHTML[i]);
                    continue;
                }
                if (!isHTML || !(args[i] instanceof String)) continue;
                args[i] = TreeModelNode.adjustHTML((String)args[i]);
            }
            for (i = 0; i < iHTML; ++i) {
                if (!(args[i] instanceof String)) continue;
                args[i] = TreeModelNode.adjustHTML((String)args[i]);
            }
            String format = treeNodeDisplayFormat.format(args);
            if (isHTML) {
                format = HTML_START_TAG + format + HTML_END_TAG;
            }
            return format;
        }
        return name;
    }

    private static String stripHTMLTags(String str) {
        if (str.startsWith(HTML_START_TAG)) {
            str = str.substring(HTML_START_TAG.length());
        }
        if (str.endsWith(HTML_END_TAG)) {
            str = str.substring(0, str.length() - HTML_END_TAG.length());
        }
        return str;
    }

    private void setModelDisplayName() throws UnknownTypeException {
        Executor exec = TreeModelNode.asynchronous(this.model, AsynchronousModelFilter.CALL.DISPLAY_NAME, this.object);
        if (exec == AsynchronousModelFilter.CURRENT_THREAD) {
            String name = this.model.getDisplayName(this.object);
            if (name == null) {
                NullPointerException t = new NullPointerException("Model: " + this.model + ".getDisplayName (" + this.object + ") = null!");
                Exceptions.printStackTrace((Throwable)t);
            } else {
                name = this.parseDisplayFormat(name);
                this.setName(name, false);
            }
        } else {
            final String originalDisplayName = this.oldDisplayName != null ? this.oldDisplayName : "";
            this.setName(EVALUATING_STR, false);
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    String name;
                    try {
                        name = TreeModelNode.this.model.getDisplayName(TreeModelNode.this.object);
                    }
                    catch (UnknownTypeException ex) {
                        Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + TreeModelNode.this.model, ex);
                        TreeModelNode.this.setName(originalDisplayName, false);
                        TreeModelNode.this.fireDisplayNameChange(null, originalDisplayName);
                        return;
                    }
                    if (name == null) {
                        NullPointerException t = new NullPointerException("Model: " + TreeModelNode.this.model + ".getDisplayName (" + TreeModelNode.this.object + ") = null!");
                        Exceptions.printStackTrace((Throwable)t);
                        TreeModelNode.this.setName(originalDisplayName, false);
                        TreeModelNode.this.fireDisplayNameChange(null, originalDisplayName);
                    } else if (TreeModelNode.this.setName(name, false)) {
                        TreeModelNode.this.fireDisplayNameChange(null, name);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName() {
        Object object = this.displayNameLock;
        synchronized (object) {
            if (this.displayName == null) {
                try {
                    this.setModelDisplayName();
                }
                catch (UnknownTypeException ex) {
                    Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, ex);
                }
            }
            if (this.displayName == null) {
                this.displayName = "";
            }
            return this.displayName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisplayName(String s) {
        String sOld;
        Object object = this.displayNameLock;
        synchronized (object) {
            if (this.displayName != null && this.displayName.equals(s)) {
                return;
            }
            sOld = this.displayName;
            this.displayName = this.oldDisplayName = s;
        }
        this.fireDisplayNameChange(sOld, s);
    }

    private void setModelIcon() throws UnknownTypeException {
        String iconBase = null;
        if (this.model.getRoot() != this.object) {
            iconBase = this.model.getIconBaseWithExtension(this.object);
        }
        if (iconBase != null) {
            this.setIconBaseWithExtension(iconBase);
        } else {
            this.setIconBaseWithExtension("org/openide/resources/actions/empty.gif");
        }
    }

    public Image getIcon(int type) {
        if (!this.iconLoaded) {
            try {
                this.setModelIcon();
            }
            catch (UnknownTypeException ex) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, ex);
            }
            this.iconLoaded = true;
        }
        return super.getIcon(type);
    }

    public Image getOpenedIcon(int type) {
        if (!this.iconLoaded) {
            try {
                this.setModelIcon();
            }
            catch (UnknownTypeException ex) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, ex);
            }
            this.iconLoaded = true;
        }
        return super.getOpenedIcon(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNode() {
        boolean doFireDisplayNameChange;
        Object object = this.displayNameLock;
        synchronized (object) {
            doFireDisplayNameChange = this.displayName != null;
            this.displayName = null;
        }
        if (doFireDisplayNameChange) {
            this.fireDisplayNameChange(null, null);
        }
        if (this.iconLoaded) {
            this.iconLoaded = false;
            this.fireIconChange();
        }
        this.firePropertyChange(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumn(String column, int changeMask) {
        String c;
        String visualColumn = column;
        if (this.columnIDsMap != null && (c = this.columnIDsMap.get(column)) != null) {
            visualColumn = c;
        }
        Map<String, Object> map = this.properties;
        synchronized (map) {
            if ((1 & changeMask) != 0) {
                this.properties.remove(column);
            }
            if ((2 & changeMask) != 0) {
                this.properties.remove(column + "#html");
            }
            if ((4 & changeMask) != 0) {
                this.properties.remove(column + "#canWrite");
            }
        }
        this.firePropertyChange(visualColumn, null, null);
    }

    protected void refreshTheChildren(Set<Models.CompoundModel> models, TreeModelChildren.RefreshingInfo refreshInfo) {
        for (Models.CompoundModel model : models) {
            this.refreshTheChildren(model, refreshInfo);
        }
    }

    private void refreshTheChildren(Models.CompoundModel model, TreeModelChildren.RefreshingInfo refreshInfo) {
        if (!this.areChildrenInitialized()) {
            return;
        }
        Children ch = this.getChildren();
        try {
            if (ch instanceof TreeModelChildren) {
                if (model.isLeaf(this.object)) {
                    this.setChildren(Children.LEAF);
                } else {
                    ((TreeModelChildren)ch).refreshChildren(refreshInfo);
                }
            } else if (!model.isLeaf(this.object)) {
                this.setChildren((Children)new TreeModelChildren(model, this.columns, this.treeModelRoot, this.object));
            }
        }
        catch (UnknownTypeException utex) {
            if (!(this.object instanceof String)) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + model, utex);
            }
            this.setChildren(Children.LEAF);
        }
    }

    private static String htmlValue(String name) {
        if (name.length() <= 6 || !name.substring(0, 6).equalsIgnoreCase(HTML_START_TAG)) {
            return null;
        }
        if (name.length() > 511) {
            int endTagsPos = TreeModelNode.findEndTagsPos(name);
            String ending = name.substring(endTagsPos + 1);
            name = name.substring(0, 508 - ending.length());
            int n = name.length();
            for (int i = n - 1; i > n - 6 && name.charAt(i) != ';'; --i) {
                if (name.charAt(i) != '&') continue;
                name = name.substring(0, i);
                break;
            }
            name = name + "..." + ending;
        }
        return TreeModelNode.adjustHTML(name);
    }

    private static int findEndTagsPos(String s) {
        int i;
        int openings = 0;
        for (i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) == '>') {
                ++openings;
                continue;
            }
            if (s.charAt(i) == '<') {
                --openings;
                continue;
            }
            if (openings == 0) break;
        }
        return i;
    }

    private static String removeHTML(String text) {
        if (text.length() <= 6 || !text.substring(0, 6).equalsIgnoreCase(HTML_START_TAG)) {
            return text;
        }
        text = text.replaceAll("<i>", "");
        text = text.replaceAll("</i>", "");
        text = text.replaceAll("<b>", "");
        text = text.replaceAll("</b>", "");
        text = text.replaceAll(HTML_START_TAG, "");
        text = text.replaceAll(HTML_END_TAG, "");
        text = text.replaceAll("</font>", "");
        int i = text.indexOf("<font");
        while (i >= 0) {
            int j = text.indexOf(">", i);
            text = text.substring(0, i) + text.substring(j + 1);
            i = text.indexOf("<font");
        }
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("&gt;", ">");
        text = text.replaceAll("&amp;", "&");
        return text;
    }

    private static String adjustHTML(String text) {
        text = text.replaceAll(Matcher.quoteReplacement("\\"), "\\\\\\\\");
        StringBuffer sb = null;
        int j = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            String replacement = null;
            if (c == '\n') {
                replacement = "\\n";
            } else if (c == '\r') {
                replacement = "\\r";
            } else if (c == '\f') {
                replacement = "\\f";
            } else if (c == '\b') {
                replacement = "\\b";
            }
            if (replacement == null) continue;
            if (sb == null) {
                sb = new StringBuffer(text.substring(0, i));
            } else {
                sb.append(text.substring(j, i));
            }
            sb.append(replacement);
            j = i + 1;
        }
        if (sb == null) {
            return text;
        }
        sb.append(text.substring(j));
        return sb.toString();
    }

    public boolean canRename() {
        try {
            return this.model.canRename(this.object);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            return false;
        }
    }

    public void setName(String s) {
        try {
            this.model.setName(this.object, s);
            super.setName(s);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
        }
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable t;
        try {
            t = this.model.clipboardCopy(this.object);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            t = null;
        }
        if (t == null) {
            return super.clipboardCopy();
        }
        return t;
    }

    public Transferable clipboardCut() throws IOException {
        Transferable t;
        try {
            t = this.model.clipboardCut(this.object);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            t = null;
        }
        if (t == null) {
            return super.clipboardCut();
        }
        return t;
    }

    public Transferable drag() throws IOException {
        Transferable t;
        try {
            t = this.model.drag(this.object);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            t = null;
        }
        if (t == null) {
            return super.drag();
        }
        return t;
    }

    public void createPasteTypes(Transferable t, List<PasteType> l) {
        PasteType[] p;
        try {
            p = this.model.getPasteTypes(this.object, t);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            p = null;
        }
        if (p == null) {
            super.createPasteTypes(t, l);
        } else {
            l.addAll(Arrays.asList(p));
        }
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        PasteType p;
        try {
            p = this.model.getDropType(this.object, t, action, index);
        }
        catch (UnknownTypeException e) {
            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
            p = null;
        }
        if (p == null) {
            return super.getDropType(t, action, index);
        }
        return p;
    }

    private final void expandIfSetToExpanded() {
        try {
            Models.TreeFeatures treeTable;
            DefaultTreeExpansionManager.get(this.model).setChildrenToActOn(this.getTreeDepth());
            if (this.model.isExpanded(this.object) && (treeTable = this.treeModelRoot.getTreeFeatures()) != null) {
                treeTable.expandNode(this.object);
            }
        }
        catch (UnknownTypeException unknownTypeException) {
            // empty catch block
        }
    }

    private Integer getTreeDepth() {
        Node p = this.getParentNode();
        if (p == null) {
            return 0;
        }
        if (this.depth != null) {
            return this.depth;
        }
        int d = 1;
        while ((p = p.getParentNode()) != null) {
            ++d;
        }
        this.depth = new Integer(d);
        return this.depth;
    }

    private static long getPropertyRefreshWaitTime() {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = lastPropertyRefresh.getAndSet(now)) < 1000L) {
            return 1L;
        }
        return 25L;
    }

    static {
        lastPropertyRefresh = new AtomicLong(0L);
    }

    private class MyProperty
    extends PropertySupport
    implements Runnable {
        private final String id;
        private final String propertyId;
        private final ColumnModel columnModel;
        private final boolean nodeColumn;
        private TreeModelRoot treeModelRoot;
        private final int[] evaluated;
        boolean forcedReadOnly;

        MyProperty(ColumnModel columnModel, TreeModelRoot treeModelRoot) {
            super(columnModel.getID(), columnModel.getType() == null ? String.class : columnModel.getType(), Actions.cutAmpersand((String)columnModel.getDisplayName()), columnModel.getShortDescription(), true, true);
            this.evaluated = new int[]{1};
            this.nodeColumn = columnModel.getType() == null;
            this.treeModelRoot = treeModelRoot;
            if (columnModel instanceof HyperColumnModel) {
                this.propertyId = columnModel.getID();
                this.columnModel = ((HyperColumnModel)columnModel).getSpecific();
                this.id = this.columnModel.getID();
            } else {
                this.id = this.propertyId = columnModel.getID();
                this.columnModel = columnModel;
            }
        }

        void forceNotEditable() {
            this.forcedReadOnly = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canWrite() {
            boolean canEdit;
            if (this.forcedReadOnly) {
                return false;
            }
            Map map = TreeModelNode.this.properties;
            synchronized (map) {
                Boolean canWrite = (Boolean)TreeModelNode.this.properties.get(this.id + "#canWrite");
                if (canWrite != null) {
                    return canWrite;
                }
            }
            try {
                canEdit = TreeModelNode.this.model.canEditCell(TreeModelNode.this.object, this.columnModel.getID());
            }
            catch (UnknownTypeException ex) {
                canEdit = false;
            }
            if (!canEdit) {
                if (this.nodeColumn) {
                    canEdit = false;
                } else {
                    try {
                        canEdit = !TreeModelNode.this.model.isReadOnly(TreeModelNode.this.object, this.columnModel.getID());
                    }
                    catch (UnknownTypeException e) {
                        if (!(TreeModelNode.this.object instanceof String)) {
                            Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model, e);
                        }
                        canEdit = false;
                    }
                }
            }
            Map map2 = TreeModelNode.this.properties;
            synchronized (map2) {
                TreeModelNode.this.properties.put(this.id + "#canWrite", canEdit);
            }
            return canEdit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            boolean fire;
            Object nonHtmlValue;
            String htmlValue;
            Object value;
            block31: {
                value = "";
                htmlValue = null;
                nonHtmlValue = null;
                try {
                    nonHtmlValue = value = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                    boolean hasHTML = TreeModelNode.this.model.hasHTMLValueAt(TreeModelNode.this.object, this.id);
                    if (hasHTML) {
                        htmlValue = TreeModelNode.this.model.getHTMLValueAt(TreeModelNode.this.object, this.id);
                    }
                    if (hasHTML || !(value instanceof String)) break block31;
                    htmlValue = TreeModelNode.htmlValue((String)value);
                    nonHtmlValue = TreeModelNode.removeHTML((String)value);
                }
                catch (UnknownTypeException e) {
                    boolean fire2;
                    block32: {
                        if (TreeModelNode.this.object instanceof String) break block32;
                        e.printStackTrace();
                        System.out.println("  Column id:" + this.columnModel.getID());
                        System.out.println(TreeModelNode.this.model);
                        System.out.println();
                    }
                    Map map = TreeModelNode.this.properties;
                    synchronized (map) {
                        TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                        TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                        int[] nArray = this.evaluated;
                        synchronized (this.evaluated) {
                            fire2 = this.evaluated[0] == -1;
                            this.evaluated[0] = 1;
                            this.evaluated.notifyAll();
                            // ** MonitorExit[var6_13] (shouldn't be in output)
                        }
                    }
                    {
                        if (!fire2) return;
                        TreeModelNode.this.firePropertyChange(this.propertyId, null, value);
                        return;
                    }
                }
                catch (Throwable t) {
                    boolean fire3;
                    Exceptions.printStackTrace((Throwable)t);
                    {
                        catch (Throwable throwable) {
                            boolean fire4;
                            Map map = TreeModelNode.this.properties;
                            synchronized (map) {
                                TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                                TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                                int[] nArray = this.evaluated;
                                synchronized (this.evaluated) {
                                    fire4 = this.evaluated[0] == -1;
                                    this.evaluated[0] = 1;
                                    this.evaluated.notifyAll();
                                    // ** MonitorExit[var16_23] (shouldn't be in output)
                                }
                            }
                            {
                                if (!fire4) throw throwable;
                                TreeModelNode.this.firePropertyChange(this.propertyId, null, value);
                                throw throwable;
                            }
                        }
                    }
                    Map map = TreeModelNode.this.properties;
                    synchronized (map) {
                        TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                        TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                        int[] nArray = this.evaluated;
                        synchronized (this.evaluated) {
                            fire3 = this.evaluated[0] == -1;
                            this.evaluated[0] = 1;
                            this.evaluated.notifyAll();
                            // ** MonitorExit[var6_14] (shouldn't be in output)
                        }
                    }
                    {
                        if (!fire3) return;
                        TreeModelNode.this.firePropertyChange(this.propertyId, null, value);
                        return;
                    }
                }
            }
            Map map = TreeModelNode.this.properties;
            synchronized (map) {
                TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                int[] nArray = this.evaluated;
                synchronized (this.evaluated) {
                    fire = this.evaluated[0] == -1;
                    this.evaluated[0] = 1;
                    this.evaluated.notifyAll();
                    // ** MonitorExit[var6_12] (shouldn't be in output)
                }
            }
            {
                if (!fire) return;
                TreeModelNode.this.firePropertyChange(this.propertyId, null, value);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized Object getValue() {
            if (this.nodeColumn) {
                return TreeModelNode.this.getDisplayName();
            }
            Map map = TreeModelNode.this.properties;
            // MONITORENTER : map
            if (TreeModelNode.this.properties.containsKey(this.id)) {
                // MONITOREXIT : map
                return TreeModelNode.this.properties.get(this.id);
            }
            int[] nArray = this.evaluated;
            // MONITORENTER : this.evaluated
            if (this.evaluated[0] != 1) {
                if (this.getValueType() != null && this.getValueType() != String.class) {
                    // MONITOREXIT : nArray
                    // MONITOREXIT : map
                    return null;
                }
                // MONITOREXIT : nArray
                // MONITOREXIT : map
                return EVALUATING_STR;
            }
            // MONITOREXIT : nArray
            // MONITOREXIT : map
            Executor exec = TreeModelNode.asynchronous(TreeModelNode.this.model, AsynchronousModelFilter.CALL.VALUE, TreeModelNode.this.object);
            if (exec == AsynchronousModelFilter.CURRENT_THREAD) {
                return this.getTheValue();
            }
            nArray = this.evaluated;
            // MONITORENTER : this.evaluated
            this.evaluated[0] = 0;
            // MONITOREXIT : nArray
            exec.execute(this);
            String ret = null;
            Object object = this.evaluated;
            // MONITORENTER : this.evaluated
            if (this.evaluated[0] != 1) {
                try {
                    this.evaluated.wait(TreeModelNode.getPropertyRefreshWaitTime());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.evaluated[0] != 1) {
                    this.evaluated[0] = -1;
                    ret = EVALUATING_STR;
                }
            }
            // MONITOREXIT : object
            if (ret == null) {
                Map map2 = TreeModelNode.this.properties;
                object = map2;
                // MONITORENTER : map2
                ret = TreeModelNode.this.properties.get(this.id);
                // MONITOREXIT : object
            }
            if (ret != EVALUATING_STR) return ret;
            if (this.getValueType() == null) return ret;
            if (this.getValueType() == String.class) return ret;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getTheValue() {
            Object value = "";
            String htmlValue = null;
            Object nonHtmlValue = null;
            try {
                nonHtmlValue = value = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                boolean hasHTML = TreeModelNode.this.model.hasHTMLValueAt(TreeModelNode.this.object, this.id);
                if (hasHTML) {
                    htmlValue = TreeModelNode.this.model.getHTMLValueAt(TreeModelNode.this.object, this.id);
                }
                if (!hasHTML && value instanceof String) {
                    htmlValue = TreeModelNode.htmlValue((String)value);
                    nonHtmlValue = TreeModelNode.removeHTML((String)value);
                }
            }
            catch (UnknownTypeException e) {
                if (!(TreeModelNode.this.object instanceof String)) {
                    Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + TreeModelNode.this.model + "\n,Column id:" + this.columnModel.getID(), e);
                }
            }
            finally {
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                    TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(String attributeName) {
            if (attributeName.equals("htmlDisplayValue")) {
                if (this.nodeColumn) {
                    return TreeModelNode.this.getHtmlDisplayName();
                }
                Object object = this.evaluated;
                synchronized (this.evaluated) {
                    if (this.evaluated[0] != 1) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return "<html><font color=\"0000CC\">" + EVALUATING_STR + "</font>" + TreeModelNode.HTML_END_TAG;
                    }
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    Map map = TreeModelNode.this.properties;
                    object = map;
                    synchronized (map) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return TreeModelNode.this.properties.get(this.id + "#html");
                    }
                }
            }
            if (attributeName.equals("suppressCustomEditor")) {
                try {
                    if (TreeModelNode.this.model.canRenderCell(TreeModelNode.this.object, this.id)) {
                        return Boolean.TRUE;
                    }
                }
                catch (UnknownTypeException unknownTypeException) {
                    // empty catch block
                }
            }
            return super.getValue(attributeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getShortDescription() {
            if (this.nodeColumn) {
                return TreeModelNode.this.getShortDescription();
            }
            Map map = TreeModelNode.this.properties;
            synchronized (map) {
                if (!TreeModelNode.this.properties.containsKey(this.id)) {
                    return null;
                }
                String shortDescription = (String)TreeModelNode.this.properties.get(this.id + "#shortDescription");
                if (shortDescription != null) {
                    return shortDescription;
                }
            }
            Executor exec = TreeModelNode.asynchronous(TreeModelNode.this.model, AsynchronousModelFilter.CALL.SHORT_DESCRIPTION, TreeModelNode.this.object);
            if (exec == AsynchronousModelFilter.CURRENT_THREAD) {
                return this.updateShortDescription();
            }
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    MyProperty.this.updateShortDescription();
                    TreeModelNode.this.firePropertyChange(MyProperty.this.propertyId, null, null);
                }
            });
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String updateShortDescription() {
            String string;
            JToolTip tooltip = new JToolTip();
            String sd = null;
            try {
                tooltip.putClientProperty("getShortDescription", TreeModelNode.this.object);
                Object tooltipObj = TreeModelNode.this.model.getValueAt(tooltip, this.id);
                if (tooltipObj != null) {
                    sd = TreeModelNode.adjustHTML(tooltipObj.toString());
                }
                string = sd;
            }
            catch (Throwable throwable) {
                try {
                    tooltip.putClientProperty("getShortDescription", null);
                    Map map = TreeModelNode.this.properties;
                    synchronized (map) {
                        TreeModelNode.this.properties.put(this.id + "#shortDescription", sd);
                    }
                    throw throwable;
                }
                catch (UnknownTypeException e) {
                    return null;
                }
            }
            tooltip.putClientProperty("getShortDescription", null);
            Map map = TreeModelNode.this.properties;
            synchronized (map) {
                TreeModelNode.this.properties.put(this.id + "#shortDescription", sd);
            }
            return string;
        }

        public void setValue(final Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Executor exec = TreeModelNode.asynchronous(TreeModelNode.this.model, AsynchronousModelFilter.CALL.VALUE, TreeModelNode.this.object);
            if (exec == AsynchronousModelFilter.CURRENT_THREAD) {
                try {
                    this.setTheValue(value);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t);
                }
            } else {
                exec.execute(new Runnable(){

                    @Override
                    public void run() {
                        MyProperty.this.setTheValue(value);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTheValue(Object value) {
            try {
                Object v = value;
                TreeModelNode.this.model.setValueAt(TreeModelNode.this.object, this.id, v);
                v = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                String htmlValue = null;
                Object nonHtmlValue = v;
                boolean hasHTML = TreeModelNode.this.model.hasHTMLValueAt(TreeModelNode.this.object, this.id);
                if (hasHTML) {
                    htmlValue = TreeModelNode.this.model.getHTMLValueAt(TreeModelNode.this.object, this.id);
                }
                if (!hasHTML && v instanceof String) {
                    htmlValue = TreeModelNode.htmlValue((String)v);
                    nonHtmlValue = TreeModelNode.removeHTML((String)v);
                }
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    TreeModelNode.this.properties.put(this.id, nonHtmlValue);
                    TreeModelNode.this.properties.put(this.id + "#html", htmlValue);
                }
                TreeModelNode.this.firePropertyChange(this.propertyId, null, null);
            }
            catch (UnknownTypeException e) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model, e);
            }
        }

        public PropertyEditor getPropertyEditor() {
            PropertyEditor pe = null;
            try {
                pe = TreeModelNode.this.model.getPropertyEditor(TreeModelNode.this.object, this.id);
            }
            catch (UnknownTypeException ex) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model, ex);
            }
            if (pe == null) {
                pe = this.columnModel.getPropertyEditor();
            }
            if (pe != null) {
                return pe;
            }
            return super.getPropertyEditor();
        }

        public String toString() {
            return super.toString() + ", Value = " + TreeModelNode.this.properties.get(this.id);
        }
    }

    private static class LazyChildrenFactory
    implements Callable<Children> {
        private final Models.CompoundModel model;
        private final ColumnModel[] columns;
        private final TreeModelRoot treeModelRoot;
        private final Object object;
        private volatile boolean childrenCreated = false;

        LazyChildrenFactory(Models.CompoundModel model, ColumnModel[] columns, TreeModelRoot treeModelRoot, Object object) {
            this.model = model;
            this.columns = columns;
            this.treeModelRoot = treeModelRoot;
            this.object = object;
        }

        @Override
        public Children call() throws Exception {
            this.childrenCreated = true;
            return TreeModelNode.createChildren(this.model, this.columns, this.treeModelRoot, this.object);
        }

        boolean areChildrenCreated() {
            return this.childrenCreated;
        }
    }

    private static final class IndexImpl
    extends Index.Support {
        private Models.CompoundModel model;
        private Object object;
        private Node node;

        IndexImpl(Models.CompoundModel model, Object object) {
            this.model = model;
            this.object = object;
        }

        void setNode(Node node) {
            this.node = node;
        }

        public Node[] getNodes() {
            return this.node.getChildren().getNodes();
        }

        public int getNodesCount() {
            return this.node.getChildren().getNodesCount();
        }

        public void reorder(int[] perm) {
            block2: {
                try {
                    this.model.reorder(this.object, perm);
                    this.fireChangeEvent(new ChangeEvent((Object)this));
                }
                catch (UnknownTypeException ex) {
                    if (this.object instanceof String) break block2;
                    Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, ex);
                }
            }
        }

        void fireChange() {
            this.fireChangeEvent(new ChangeEvent((Object)this));
        }
    }

    static class TreeModelChildren
    extends Children.Keys<Object>
    implements Runnable {
        private boolean initialezed = false;
        private final Models.CompoundModel model;
        private final ColumnModel[] columns;
        protected final TreeModelRoot treeModelRoot;
        protected Object object;
        protected final WeakHashMap<Object, WeakReference<TreeModelNode>> objectToNode = new WeakHashMap();
        private final int[] evaluated = new int[]{0};
        private RefreshingInfo evaluatingRefreshingInfo;
        private Object[] children_evaluated;
        private RefreshingInfo refreshInfo = null;
        private boolean refreshingStarted = true;
        private RequestProcessor.Task task;
        private RequestProcessor lastRp;
        protected static final Object WAIT_KEY = new Object();
        private static AtomicLong lastChildrenRefresh = new AtomicLong(0L);
        private Integer depth;

        TreeModelChildren(Models.CompoundModel model, ColumnModel[] columns, TreeModelRoot treeModelRoot, Object object) {
            this.model = model;
            this.columns = columns;
            this.treeModelRoot = treeModelRoot;
            this.object = object;
        }

        protected void addNotify() {
            if (this.initialezed) {
                return;
            }
            this.initialezed = true;
            this.refreshChildren(new RefreshingInfo(true));
        }

        protected void removeNotify() {
            this.initialezed = false;
            this.setKeys(Collections.emptySet());
        }

        void refreshChildren(RefreshingInfo refreshSubNodes) {
            if (!this.initialezed) {
                return;
            }
            this.refreshLazyChildren(refreshSubNodes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int[] nArray = this.evaluated;
            synchronized (this.evaluated) {
                Object[] ch;
                this.refreshingStarted = false;
                RefreshingInfo rinfo = this.refreshInfo;
                if (this.evaluatingRefreshingInfo == null) {
                    this.evaluatingRefreshingInfo = this.refreshInfo;
                } else if (this.refreshInfo != null) {
                    this.evaluatingRefreshingInfo = this.evaluatingRefreshingInfo.mergeWith(this.refreshInfo);
                }
                this.refreshInfo = null;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                try {
                    ch = this.getModelChildren(rinfo);
                }
                catch (UnknownTypeException e) {
                    ch = new Object[]{};
                    if (!(this.object instanceof String)) {
                        Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, e);
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    Exceptions.printStackTrace((Throwable)t);
                    ch = new Object[]{};
                }
                int[] nArray2 = this.evaluated;
                synchronized (this.evaluated) {
                    boolean fire;
                    int eval = this.evaluated[0];
                    if (this.refreshingStarted) {
                        fire = false;
                    } else {
                        boolean bl = fire = this.evaluated[0] == -1;
                        if (!fire) {
                            this.children_evaluated = ch;
                        } else {
                            this.evaluatingRefreshingInfo = null;
                        }
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                    }
                    // ** MonitorExit[var4_9] (shouldn't be in output)
                    if (fire) {
                        this.applyChildren(ch, rinfo, false);
                    }
                    return;
                }
            }
        }

        protected Object[] getModelChildren(RefreshingInfo refreshInfo) throws UnknownTypeException {
            int count = this.model.getChildrenCount(this.object);
            Object[] ch = this.model.getChildren(this.object, 0, count);
            if (ch == null) {
                Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model + "\nreturned null children for parent '" + this.object + "'");
                ch = new Object[]{};
            }
            return ch;
        }

        protected Executor getModelAsynchronous() {
            return TreeModelNode.asynchronous(this.model, AsynchronousModelFilter.CALL.CHILDREN, this.object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshLazyChildren(RefreshingInfo refreshInfo) {
            Executor exec = this.getModelAsynchronous();
            if (exec == AsynchronousModelFilter.CURRENT_THREAD) {
                Object[] ch;
                block19: {
                    try {
                        ch = this.getModelChildren(refreshInfo);
                    }
                    catch (UnknownTypeException ex) {
                        ch = new Object[]{};
                        if (this.object instanceof String) break block19;
                        Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + this.model, ex);
                    }
                }
                this.applyChildren(ch, refreshInfo, true);
                return;
            }
            Object[] ch = this.evaluated;
            synchronized (this.evaluated) {
                this.evaluated[0] = 0;
                this.refreshingStarted = true;
                this.refreshInfo = this.refreshInfo == null ? refreshInfo : this.refreshInfo.mergeWith(refreshInfo);
                // ** MonitorExit[ch /* !! */ ] (shouldn't be in output)
                exec.execute(this);
                int[] nArray = this.evaluated;
                synchronized (this.evaluated) {
                    if (this.evaluated[0] != 1) {
                        try {
                            this.evaluated.wait(TreeModelChildren.getChildrenRefreshWaitTime());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.evaluated[0] != 1) {
                            this.evaluated[0] = -1;
                            ch = null;
                        } else {
                            ch = this.children_evaluated;
                        }
                    } else {
                        ch = this.children_evaluated;
                    }
                    if (this.children_evaluated == null && this.evaluated[0] == 1) {
                        // ** MonitorExit[var4_6] (shouldn't be in output)
                        return;
                    }
                    this.children_evaluated = null;
                    if (ch != null) {
                        refreshInfo = this.evaluatingRefreshingInfo;
                        this.evaluatingRefreshingInfo = null;
                    }
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    if (ch == null) {
                        this.applyWaitChildren();
                    } else {
                        this.applyChildren(ch, refreshInfo, true);
                    }
                    return;
                }
            }
        }

        private static long getChildrenRefreshWaitTime() {
            long last;
            long now = System.currentTimeMillis();
            if (now - (last = lastChildrenRefresh.getAndSet(now)) < 1000L) {
                return 1L;
            }
            return 200L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyChildren(final Object[] ch, RefreshingInfo refreshInfo, boolean doSetObject) {
            int k = ch.length;
            for (int i = 0; i < k; ++i) {
                TreeModelNode tmn;
                WeakReference<TreeModelNode> wr;
                if (ch[i] == null) {
                    throw new NullPointerException("Null child at index " + i + ", parent: " + this.object + ", model: " + this.model + "\nAll children are: " + Arrays.toString(ch));
                }
                if (!doSetObject) continue;
                WeakHashMap<Object, WeakReference<TreeModelNode>> weakHashMap = this.objectToNode;
                synchronized (weakHashMap) {
                    wr = this.objectToNode.get(ch[i]);
                }
                if (wr == null || (tmn = (TreeModelNode)((Object)wr.get())) == null) continue;
                if (refreshInfo == null || refreshInfo.isRefreshSubNodes(ch[i])) {
                    tmn.setObject(ch[i]);
                    continue;
                }
                tmn.setObjectNoRefresh(ch[i]);
            }
            this.setKeys(ch);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int k = ch.length;
                    for (int i = 0; i < k; ++i) {
                        TreeModelChildren.this.expandIfSetToExpanded(ch[i]);
                    }
                }
            });
        }

        protected void expandIfSetToExpanded(Object child) {
            try {
                Models.TreeFeatures treeTable;
                DefaultTreeExpansionManager.get(this.model).setChildrenToActOn(this.getTreeDepth());
                if (this.model.isExpanded(child) && (treeTable = this.treeModelRoot.getTreeFeatures()) != null && treeTable.isExpanded(this.object)) {
                    treeTable.expandNode(child);
                }
            }
            catch (UnknownTypeException unknownTypeException) {
                // empty catch block
            }
        }

        Integer getTreeDepth() {
            Node p = this.getNode();
            if (p == null) {
                return 0;
            }
            if (this.depth != null) {
                return this.depth;
            }
            int d = 1;
            while ((p = p.getParentNode()) != null) {
                ++d;
            }
            this.depth = new Integer(d);
            return this.depth;
        }

        private void applyWaitChildren() {
            this.setKeys(new Object[]{WAIT_KEY});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Node[] createNodes(Object object) {
            if (object == WAIT_KEY) {
                AbstractNode n = new AbstractNode(Children.LEAF);
                n.setName(NbBundle.getMessage(TreeModelNode.class, (String)"WaitNode"));
                n.setIconBaseWithExtension("org/netbeans/modules/viewmodel/wait.gif");
                return new Node[]{n};
            }
            if (object instanceof Exception) {
                return new Node[]{new ExceptionNode((Exception)object)};
            }
            TreeModelNode tmn = new TreeModelNode(this.model, this.columns, this.treeModelRoot, object);
            WeakHashMap<Object, WeakReference<TreeModelNode>> weakHashMap = this.objectToNode;
            synchronized (weakHashMap) {
                this.objectToNode.put(object, new WeakReference<TreeModelNode>(tmn));
            }
            return new Node[]{tmn};
        }

        protected void destroyNodes(Node[] nodes) {
            super.destroyNodes(nodes);
            for (Node n : nodes) {
                Node[] childrenNodes;
                if (!(n instanceof TreeModelNode)) continue;
                TreeModelNode tmn = (TreeModelNode)n;
                this.treeModelRoot.unregisterNode(tmn.object, tmn);
                if (!tmn.areChildrenInitialized()) continue;
                try {
                    Method testNodes = Children.class.getDeclaredMethod("testNodes", new Class[0]);
                    testNodes.setAccessible(true);
                    childrenNodes = (Node[])testNodes.invoke((Object)tmn.getChildren(), new Object[0]);
                }
                catch (Exception ex) {
                    Logger.getLogger(TreeModelNode.class.getName()).log(Level.INFO, "Children.testNodes() method access problem:", ex);
                    childrenNodes = tmn.getChildren().getNodes();
                }
                if (childrenNodes == null) continue;
                this.destroyNodes(childrenNodes);
            }
        }

        public static class RefreshingInfo {
            protected boolean refreshSubNodes;

            public RefreshingInfo(boolean refreshSubNodes) {
                this.refreshSubNodes = refreshSubNodes;
            }

            public RefreshingInfo mergeWith(RefreshingInfo rinfo) {
                this.refreshSubNodes = this.refreshSubNodes || rinfo.refreshSubNodes;
                return this;
            }

            public boolean isRefreshSubNodes(Object child) {
                return this.refreshSubNodes;
            }
        }
    }

    private static final class CheckNodeCookieImpl
    implements CheckableNode {
        private final Models.CompoundModel model;
        private final Object object;

        public CheckNodeCookieImpl(Models.CompoundModel model, Object object) {
            this.model = model;
            this.object = object;
        }

        public boolean isCheckable() {
            try {
                return this.model.isCheckable(this.object);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Model = " + this.model)));
                return false;
            }
        }

        public boolean isCheckEnabled() {
            try {
                return this.model.isCheckEnabled(this.object);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Model = " + this.model)));
                return false;
            }
        }

        public Boolean isSelected() {
            try {
                return this.model.isSelected(this.object);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Model = " + this.model)));
                return false;
            }
        }

        public void setSelected(Boolean selected) {
            try {
                this.model.setSelected(this.object, selected);
            }
            catch (UnknownTypeException ex) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)("Model = " + this.model)));
            }
        }
    }

    private class DisabledWhenSortedAction
    implements Action {
        private Action a;

        public DisabledWhenSortedAction(Action a) {
            this.a = a;
        }

        @Override
        public Object getValue(String key) {
            return this.a.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.a.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
            this.a.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            if (TreeModelNode.this.isTableSorted()) {
                return false;
            }
            return this.a.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.a.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.a.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.a.actionPerformed(e);
        }
    }

    public static interface ActionOnPresetNodes
    extends Action {
        public void addNode(Node var1);
    }

    public static interface DisableableAction
    extends Action {
        public Action createDisableable(PrivilegedAction var1);
    }

    private class PropertyDisplayNameListener
    implements PropertyChangeListener {
        private Set<String> propertyNames = new HashSet<String>();

        PropertyDisplayNameListener() {
        }

        void addPropertyName(String propertyName) {
            this.propertyNames.add(propertyName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.propertyNames.contains(evt.getPropertyName())) {
                try {
                    TreeModelNode.this.setModelDisplayName();
                    TreeModelNode.this.fireDisplayNameChange(null, null);
                }
                catch (UnknownTypeException ex) {
                    Logger.getLogger(TreeModelNode.class.getName()).log(Level.CONFIG, "Model: " + TreeModelNode.this.model, ex);
                }
            }
        }
    }
}

