/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.Container;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.BreadCrumbsFactory;
import org.netbeans.modules.cnd.qnavigator.navigator.CppDeclarationNode;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileFilter;
import org.netbeans.modules.cnd.qnavigator.navigator.CsmFileModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NavigatorModel {
    private final DataObject cdo;
    private final FileObject fo;
    private final NavigatorPanelUI ui;
    private final Action[] actions;
    private final AbstractNode root;
    private final CsmFileModel fileModel;
    private final Object lock = new Lock();
    private final CsmFile csmFile;

    public NavigatorModel(DataObject cdo, FileObject fo, NavigatorPanelUI ui, String mimeType, final CsmFile csmFile) {
        this.cdo = cdo;
        this.fo = fo;
        this.ui = ui;
        this.actions = new Action[]{new SortByNameAction(), new SortBySourceAction(), new GroupByKindAction(), new ExpandAllAction(), null, new FilterSubmenuAction(mimeType)};
        this.root = new AbstractNode((Children)new Children.Array()){

            public Action[] getActions(boolean context) {
                return NavigatorModel.this.actions;
            }

            public Image getIcon(int type) {
                if (csmFile != null) {
                    return CsmImageLoader.getImage((CsmObject)csmFile);
                }
                return NavigatorModel.this.cdo.getNodeDelegate().getIcon(type);
            }
        };
        this.fileModel = new CsmFileModel(new CsmFileFilter(), this.actions);
        this.csmFile = csmFile;
    }

    public DataObject getDataObject() {
        return this.cdo;
    }

    public CsmFile getCsmFile() {
        return this.csmFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNotify() {
        Object object = this.lock;
        synchronized (object) {
            this.fileModel.clear();
            this.setChildren(null);
            if (this.ui != null) {
                this.ui.selectNodes(new Node[0]);
            }
        }
    }

    private void setChildren(final Node[] nodes) {
        final Children children = this.root.getChildren();
        if (!Children.MUTEX.isReadAccess()) {
            Children.MUTEX.writeAccess(new Runnable(){

                @Override
                public void run() {
                    children.remove(children.getNodes());
                    if (nodes != null) {
                        children.add(nodes);
                    }
                }
            });
        }
    }

    public Node getRoot() {
        return this.root;
    }

    private void refresh(boolean force) {
        this.update(new AtomicBoolean(false), force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(AtomicBoolean canceled, boolean force) {
        block12: {
            if (this.csmFile == null) {
                Object object = this.lock;
                synchronized (object) {
                    this.fileModel.clear();
                    this.setChildren(new Node[0]);
                }
            }
            try {
                CsmCacheManager.enter();
                CsmFileModel.PreBuildModel buildPreModel = this.fileModel.buildPreModel(this.cdo, this.fo, this.csmFile, canceled);
                if (canceled.get()) break block12;
                Object object = this.lock;
                synchronized (object) {
                    if (this.fileModel.buildModel(buildPreModel, this.csmFile, force)) {
                        this.setChildren(this.fileModel.getNodes());
                    }
                }
            }
            finally {
                CsmCacheManager.leave();
            }
        }
        if (!canceled.get() && this.ui != null) {
            this.ui.newContentReady();
        }
    }

    private int storeSelection() {
        Node selected;
        Node[] selection;
        if (this.ui != null && (selection = this.ui.getExplorerManager().getSelectedNodes()) != null && selection.length == 1 && (selected = selection[0]) instanceof CppDeclarationNode) {
            return ((CppDeclarationNode)selected).getOffset();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelection(long caretLineNo, JEditorPane jEditorPane, AtomicBoolean canceled, CharSequence text) {
        Object object = this.lock;
        synchronized (object) {
            Node node = this.fileModel.setSelection(caretLineNo);
            if (node != null) {
                if (this.ui != null) {
                    this.ui.selectNodes(new Node[]{node});
                }
                if (jEditorPane == null) {
                    return;
                }
                BreadCrumbsFactory.createBreadCrumbs(caretLineNo, node, jEditorPane, this.cdo, canceled, text);
            }
        }
    }

    private JEditorPane findCurrentJEditorPane() {
        JTextComponent comp;
        DataObject obj;
        if (this.cdo != null && this.cdo.equals(obj = CsmUtilities.getDataObject((JTextComponent)(comp = EditorRegistry.lastFocusedComponent()))) && comp instanceof JEditorPane) {
            return (JEditorPane)comp;
        }
        return null;
    }

    public CsmFileFilter getFilter() {
        return this.fileModel.getFilter();
    }

    public String toString() {
        return "" + this.cdo;
    }

    private class FilterSubmenuAction
    extends AbstractAction
    implements Presenter.Popup {
        private final String mimeType;

        public FilterSubmenuAction(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
        }

        public final JMenuItem getPopupPresenter() {
            return this.createSubmenu();
        }

        private JMenuItem createSubmenu() {
            JMenu menu = new JMenu(NbBundle.getMessage(NavigatorModel.class, (String)"FilterSubmenu"));
            boolean isC = MIMENames.isHeaderOrCppOrC((String)this.mimeType);
            boolean isCpp = MIMENames.isHeaderOrCpp((String)this.mimeType);
            boolean isCnd = MIMENames.isFortranOrHeaderOrCppOrC((String)this.mimeType);
            if (isC) {
                ((Container)menu).add(new ShowForwardClassDeclarationsAction().getPopupPresenter());
                ((Container)menu).add(new ShowForwardFunctionDeclarationsAction().getPopupPresenter());
                ((Container)menu).add(new ShowMacroAction().getPopupPresenter());
            }
            if (isCnd) {
                ((Container)menu).add(new ShowIncludeAction().getPopupPresenter());
            }
            if (isC) {
                ((Container)menu).add(new ShowTypedefAction().getPopupPresenter());
            }
            if (isCnd) {
                ((Container)menu).add(new ShowVariableAction().getPopupPresenter());
                ((Container)menu).add(new ShowFieldAction().getPopupPresenter());
            }
            if (isCpp) {
                ((Container)menu).add(new ShowUsingAction().getPopupPresenter());
            }
            return menu;
        }
    }

    private class ExpandAllAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ExpandAllAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ExpandAll"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setExpandAll(!NavigatorModel.this.fileModel.getFilter().isExpandAll());
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isExpandAll());
            return this.menuItem;
        }
    }

    private class GroupByKindAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public GroupByKindAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"GroupByKindText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setGroupByKind(!NavigatorModel.this.fileModel.getFilter().isGroupByKind());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(true);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isGroupByKind());
            return this.menuItem;
        }
    }

    private class SortBySourceAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JRadioButtonMenuItem menuItem;

        public SortBySourceAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"SortBySourceText"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/qnavigator/resources/sortPosition.png", (boolean)false));
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NavigatorModel.this.fileModel.getFilter().getSortMode() != CsmFileFilter.SortMode.Offset) {
                NavigatorModel.this.fileModel.getFilter().setSortMode(CsmFileFilter.SortMode.Offset);
                int selection = NavigatorModel.this.storeSelection();
                NavigatorModel.this.refresh(true);
                if (selection >= 0) {
                    NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
                }
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().getSortMode() == CsmFileFilter.SortMode.Offset);
            return this.menuItem;
        }
    }

    private class SortByNameAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JRadioButtonMenuItem menuItem;

        public SortByNameAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"SortByNameText"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/qnavigator/resources/sortAlpha.png", (boolean)false));
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (NavigatorModel.this.fileModel.getFilter().getSortMode() != CsmFileFilter.SortMode.Name) {
                NavigatorModel.this.fileModel.getFilter().setSortMode(CsmFileFilter.SortMode.Name);
                int selection = NavigatorModel.this.storeSelection();
                NavigatorModel.this.refresh(true);
                if (selection >= 0) {
                    NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
                }
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().getSortMode() == CsmFileFilter.SortMode.Name);
            return this.menuItem;
        }
    }

    private class ShowUsingAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowUsingAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowUsingText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowUsing(!NavigatorModel.this.fileModel.getFilter().isShowUsing());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowUsing());
            return this.menuItem;
        }
    }

    private class ShowFieldAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowFieldAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowFieldText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowField(!NavigatorModel.this.fileModel.getFilter().isShowField());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowField());
            return this.menuItem;
        }
    }

    private class ShowVariableAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowVariableAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowVariableText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowVariable(!NavigatorModel.this.fileModel.getFilter().isShowVariable());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowVariable());
            return this.menuItem;
        }
    }

    private class ShowTypedefAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowTypedefAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowTypedefText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowTypedef(!NavigatorModel.this.fileModel.getFilter().isShowTypedef());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowTypedef());
            return this.menuItem;
        }
    }

    private class ShowIncludeAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowIncludeAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowIncludeText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowInclude(!NavigatorModel.this.fileModel.getFilter().isShowInclude());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowInclude());
            return this.menuItem;
        }
    }

    private class ShowMacroAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowMacroAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowMacroText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowMacro(!NavigatorModel.this.fileModel.getFilter().isShowMacro());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowMacro());
            return this.menuItem;
        }
    }

    private class ShowForwardClassDeclarationsAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowForwardClassDeclarationsAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowForwardClassDeclarationsText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowForwardClassDeclarations(!NavigatorModel.this.fileModel.getFilter().isShowForwardClassDeclarations());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowForwardClassDeclarations());
            return this.menuItem;
        }
    }

    private class ShowForwardFunctionDeclarationsAction
    extends AbstractAction
    implements Presenter.Popup {
        private final JCheckBoxMenuItem menuItem;

        public ShowForwardFunctionDeclarationsAction() {
            this.putValue("Name", NbBundle.getMessage(NavigatorModel.class, (String)"ShowForwardFunctionDeclarationsText"));
            this.menuItem = new JCheckBoxMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NavigatorModel.this.fileModel.getFilter().setShowForwardFunctionDeclarations(!NavigatorModel.this.fileModel.getFilter().isShowForwardFunctionDeclarations());
            int selection = NavigatorModel.this.storeSelection();
            NavigatorModel.this.refresh(false);
            if (selection >= 0) {
                NavigatorModel.this.setSelection(selection, NavigatorModel.this.findCurrentJEditorPane(), null, null);
            }
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(NavigatorModel.this.fileModel.getFilter().isShowForwardFunctionDeclarations());
            return this.menuItem;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

