/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.run;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;

public final class KarmaRunInfo {
    private final Project project;
    private final RerunHandler rerunHandler;
    private final String nbConfigFile;
    private final String projectConfigFile;
    private final String testFile;
    private final boolean failOnBrowserError;
    private final Map<String, String> envVars = new ConcurrentHashMap<String, String>();

    private KarmaRunInfo(Builder builder) {
        assert (builder != null);
        assert (builder.project != null);
        assert (builder.rerunHandler != null);
        assert (builder.nbConfigFile != null);
        assert (builder.projectConfigFile != null);
        this.project = builder.project;
        this.rerunHandler = builder.rerunHandler;
        this.nbConfigFile = builder.nbConfigFile;
        this.projectConfigFile = builder.projectConfigFile;
        this.testFile = builder.testFile;
        this.failOnBrowserError = builder.failOnBrowserError;
        this.envVars.putAll(builder.envVars);
    }

    public Project getProject() {
        return this.project;
    }

    public RerunHandler getRerunHandler() {
        return this.rerunHandler;
    }

    public String getNbConfigFile() {
        return this.nbConfigFile;
    }

    public String getProjectConfigFile() {
        return this.projectConfigFile;
    }

    @CheckForNull
    public String getTestFile() {
        return this.testFile;
    }

    public boolean isFailOnBrowserError() {
        return this.failOnBrowserError;
    }

    public Map<String, String> getEnvVars() {
        return new HashMap<String, String>(this.envVars);
    }

    public String toString() {
        return "KarmaRunInfo{project=" + this.project + ", rerunHandler=" + this.rerunHandler + ", nbConfigFile=" + this.nbConfigFile + ", projectConfigFile=" + this.projectConfigFile + ", testFile=" + this.testFile + ", envVars=" + this.envVars + '}';
    }

    public static final class Builder {
        final Project project;
        RerunHandler rerunHandler;
        String nbConfigFile;
        String projectConfigFile;
        String testFile;
        boolean failOnBrowserError;
        Map<String, String> envVars = new HashMap<String, String>();

        public Builder(Project project) {
            this.project = project;
        }

        public Builder setRerunHandler(RerunHandler rerunHandler) {
            assert (rerunHandler != null);
            this.rerunHandler = rerunHandler;
            return this;
        }

        public Builder setNbConfigFile(String nbConfigFile) {
            assert (nbConfigFile != null);
            this.nbConfigFile = nbConfigFile;
            return this;
        }

        public Builder setProjectConfigFile(String projectConfigFile) {
            assert (projectConfigFile != null);
            this.projectConfigFile = projectConfigFile;
            return this;
        }

        public Builder setTestFile(@NullAllowed String testFile) {
            this.testFile = testFile;
            return this;
        }

        public Builder setFailOnBrowserError(boolean failOnBrowserError) {
            this.failOnBrowserError = failOnBrowserError;
            return this;
        }

        public Builder addEnvVar(String name, String value) {
            assert (name != null);
            assert (value != null);
            this.envVars.put(name, value);
            return this;
        }

        public Builder addEnvVars(Map<String, String> envVars) {
            assert (envVars != null);
            this.envVars.putAll(envVars);
            return this;
        }

        public KarmaRunInfo build() {
            return new KarmaRunInfo(this);
        }
    }
}

