/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.LangOptions;
import org.clang.basic.SrcMgr;
import org.clang.frontend.impl.InitHeaderSearchStatics;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.HeaderMap;
import org.clang.lex.HeaderSearch;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.frontend.IncludeDirGroup;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class InitHeaderSearch
implements Destructors.ClassWithDestructor {
    public static final StringRef C_INCLUDE_DIRS = new StringRef(System.getProperty("C_INCLUDE_DIRS", ""));
    private std.vector<std_pair.pair<IncludeDirGroup, DirectoryLookup>> IncludePath = new std.vector((Object)new std_pair.pair((Object)IncludeDirGroup.Quoted, (Object)DirectoryLookup.DEFAULT));
    private std.vector<std_pair.pairTypeBool<std.string>> SystemHeaderPrefixes = new std.vector((Object)new std_pair.pairTypeBool((Object)std.string.EMPTY, false));
    private HeaderSearch Headers;
    private boolean Verbose;
    private std.string IncludeSysroot;
    private boolean HasSysroot;

    public InitHeaderSearch(HeaderSearch HS, boolean verbose, StringRef sysroot) {
        this.Headers = HS;
        this.Verbose = verbose;
        this.IncludeSysroot = new std.string(sysroot.$basic_string());
        this.HasSysroot = !sysroot.empty() && !llvm.$eq_StringRef((StringRef)sysroot, (String)"/");
    }

    public void AddPath(Twine Path, IncludeDirGroup Group, boolean isFramework) {
        SmallString MappedPathStorage;
        StringRef MappedPathStr;
        if (this.HasSysroot && InitHeaderSearchStatics.CanPrefixSysroot(MappedPathStr = Path.toStringRef(MappedPathStorage = new SmallString(256)))) {
            this.AddUnmappedPath(llvm.$add_Twine((Twine)new Twine(this.IncludeSysroot), (Twine)Path), Group, isFramework);
            return;
        }
        this.AddUnmappedPath(Path, Group, isFramework);
    }

    public void AddUnmappedPath(Twine Path, IncludeDirGroup Group, boolean isFramework) {
        HeaderMap HM;
        FileEntry FE;
        assert (!Path.isTriviallyEmpty()) : "can't handle empty path here";
        FileManager FM = this.Headers.getFileMgr();
        SmallString MappedPathStorage = new SmallString(256);
        StringRef MappedPathStr = Path.toStringRef(MappedPathStorage);
        SrcMgr.CharacteristicKind Type2 = Group == IncludeDirGroup.Quoted || Group == IncludeDirGroup.Angled || Group == IncludeDirGroup.IndexHeaderMap ? SrcMgr.CharacteristicKind.C_User : (Group == IncludeDirGroup.ExternCSystem ? SrcMgr.CharacteristicKind.C_ExternCSystem : SrcMgr.CharacteristicKind.C_System);
        DirectoryEntry DE = FM.getDirectory(MappedPathStr);
        if (DE != null) {
            this.IncludePath.push_back((Object)std.make_pair((Object)Group, (Object)new DirectoryLookup(DE, Type2, isFramework)));
            return;
        }
        if (!isFramework && (FE = FM.getFile(MappedPathStr)) != null && (HM = this.Headers.CreateHeaderMap(FE)) != null) {
            this.IncludePath.push_back((Object)std.make_pair((Object)Group, (Object)new DirectoryLookup(HM, Type2, Group == IncludeDirGroup.IndexHeaderMap)));
            return;
        }
        if (this.Verbose) {
            llvm.errs().$out("ignoring nonexistent directory \"").$out(MappedPathStr).$out(NativePointer.$QUOTE_LF);
        }
    }

    public void AddSystemHeaderPrefix(StringRef Prefix, boolean IsSystemHeader) {
        this.SystemHeaderPrefixes.push_back((Object)std.make_pair_T_bool((Object)Prefix.str(), (boolean)IsSystemHeader));
    }

    public void AddGnuCPlusPlusIncludePaths(StringRef Base, StringRef ArchDir, StringRef Dir32, StringRef Dir64, Triple triple) {
        boolean is64bit;
        this.AddPath(new Twine(Base), IncludeDirGroup.CXXSystem, false);
        Triple.ArchType arch = triple.getArch();
        boolean bl = is64bit = arch == Triple.ArchType.ppc64 || arch == Triple.ArchType.x86_64;
        if (is64bit) {
            this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/"), (Twine)new Twine(ArchDir)), (Twine)new Twine("/")), (Twine)new Twine(Dir64)), IncludeDirGroup.CXXSystem, false);
        } else {
            this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/"), (Twine)new Twine(ArchDir)), (Twine)new Twine("/")), (Twine)new Twine(Dir32)), IncludeDirGroup.CXXSystem, false);
        }
        this.AddPath(llvm.$add_StringRef_T((StringRef)Base, (String)"/backward"), IncludeDirGroup.CXXSystem, false);
    }

    public void AddMinGWCPlusPlusIncludePaths(StringRef Base, StringRef Arch, StringRef Version) {
        this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/"), (Twine)new Twine(Arch)), (Twine)new Twine("/")), (Twine)new Twine(Version)), (Twine)new Twine("/include/c++")), IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/"), (Twine)new Twine(Arch)), (Twine)new Twine("/")), (Twine)new Twine(Version)), (Twine)new Twine("/include/c++/")), (Twine)new Twine(Arch)), IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/"), (Twine)new Twine(Arch)), (Twine)new Twine("/")), (Twine)new Twine(Version)), (Twine)new Twine("/include/c++/backward")), IncludeDirGroup.CXXSystem, false);
    }

    public void AddMinGW64CXXPaths(StringRef Base, StringRef Version) {
        this.AddPath(llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/../../../include/c++/"), (Twine)new Twine(Version)), IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/../../../include/c++/"), (Twine)new Twine(Version)), (Twine)new Twine("/x86_64-w64-mingw32")), IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/../../../include/c++/"), (Twine)new Twine(Version)), (Twine)new Twine("/i686-w64-mingw32")), IncludeDirGroup.CXXSystem, false);
        this.AddPath(llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_StringRef_T((StringRef)Base, (String)"/../../../include/c++/"), (Twine)new Twine(Version)), (Twine)new Twine("/backward")), IncludeDirGroup.CXXSystem, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddDefaultCIncludePaths(Triple triple, HeaderSearchOptions HSOpts) {
        Triple.OSType os = triple.getOS();
        if (HSOpts.UseStandardSystemIncludes) {
            switch (os) {
                case FreeBSD: 
                case NetBSD: 
                case OpenBSD: 
                case Bitrig: {
                    break;
                }
                default: {
                    this.AddPath(new Twine(NativePointer.$((String)"/usr/local/include")), IncludeDirGroup.System, false);
                }
            }
        }
        if (HSOpts.UseBuiltinIncludes) {
            SmallString P = null;
            try {
                P = new SmallString(new StringRef(HSOpts.ResourceDir), 128);
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"include"));
                this.AddUnmappedPath(new Twine(P.str()), IncludeDirGroup.ExternCSystem, false);
            }
            finally {
                if (P != null) {
                    P.$destroy();
                }
            }
        }
        if (!HSOpts.UseStandardSystemIncludes) {
            return;
        }
        StringRef CIncludeDirs = new StringRef(NativePointer.$EMPTY);
        if (llvm.$noteq_StringRef((StringRef)CIncludeDirs, (StringRef)StringRef.R$EMPTY)) {
            SmallVector dirs = null;
            try {
                dirs = new SmallVector(5, (Object)new StringRef());
                CIncludeDirs.split((SmallVectorImpl)dirs, new StringRef(NativePointer.$((String)":")));
                SmallVectorImpl.iterator i = dirs.begin();
                while (i.$noteq((Object)dirs.end())) {
                    this.AddPath(new Twine((StringRef)i.$star()), IncludeDirGroup.ExternCSystem, false);
                    i.$preInc();
                }
                return;
            }
            finally {
                if (dirs != null) {
                    dirs.$destroy();
                }
            }
        }
        block5 : switch (os) {
            case Linux: {
                throw new llvm_unreachable("Include management is handled in the driver.");
            }
            case Haiku: {
                this.AddPath(new Twine(NativePointer.$((String)"/boot/common/include")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/app")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/arch")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/device")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/drivers")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/game")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/interface")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/kernel")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/locale")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/mail")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/media")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/midi")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/midi2")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/net")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/storage")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/support")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/translation")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/graphics")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/input_server")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/screen_saver")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/add-ons/tracker")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/be_apps/Deskbar")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/be_apps/NetPositive")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/os/be_apps/Tracker")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/cpp")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/cpp/i586-pc-haiku")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/3rdparty")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/bsd")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/glibc")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers/posix")), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/boot/develop/headers")), IncludeDirGroup.System, false);
                break;
            }
            case RTEMS: {
                break;
            }
            case Win32: {
                switch (triple.getEnvironment()) {
                    default: {
                        throw new llvm_unreachable("Include management is handled in the driver.");
                    }
                    case Cygnus: {
                        this.AddPath(new Twine(NativePointer.$((String)"/usr/include/w32api")), IncludeDirGroup.System, false);
                        break block5;
                    }
                    case GNU: 
                }
                SmallString P = new SmallString(new StringRef(HSOpts.ResourceDir), 128);
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"../../../i686-w64-mingw32/include"));
                this.AddPath(new Twine(P.str()), IncludeDirGroup.System, false);
                P.resize(HSOpts.ResourceDir.size());
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"../../../x86_64-w64-mingw32/include"));
                this.AddPath(new Twine(P.str()), IncludeDirGroup.System, false);
                P.resize(HSOpts.ResourceDir.size());
                path.append((SmallString)P, (char.ptr)NativePointer.$((String)"../../../include"));
                this.AddPath(new Twine(P.str()), IncludeDirGroup.System, false);
                this.AddPath(new Twine(NativePointer.$((String)"/mingw/include")), IncludeDirGroup.System, false);
                break;
            }
        }
        if (os != Triple.OSType.RTEMS) {
            this.AddPath(new Twine(NativePointer.$((String)"/usr/include")), IncludeDirGroup.ExternCSystem, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void AddDefaultCPlusPlusIncludePaths(Triple triple, HeaderSearchOptions HSOpts) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            Triple.OSType os = triple.getOS();
            if (triple.isOSDarwin()) {
                switch (triple.getArch()) {
                    default: {
                        return;
                    }
                    case ppc: 
                    case ppc64: {
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"powerpc-apple-darwin10")), StringRef.R$EMPTY, new StringRef(NativePointer.$((String)"ppc64")), triple);
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.0.0")), new StringRef(NativePointer.$((String)"powerpc-apple-darwin10")), StringRef.R$EMPTY, new StringRef(NativePointer.$((String)"ppc64")), triple);
                        return;
                    }
                    case x86: 
                    case x86_64: {
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"i686-apple-darwin10")), StringRef.R$EMPTY, new StringRef(NativePointer.$((String)"x86_64")), triple);
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.0.0")), new StringRef(NativePointer.$((String)"i686-apple-darwin8")), StringRef.R$EMPTY, StringRef.R$EMPTY, triple);
                        return;
                    }
                    case arm: 
                    case thumb: {
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"arm-apple-darwin10")), new StringRef(NativePointer.$((String)"v7")), StringRef.R$EMPTY, triple);
                        this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"arm-apple-darwin10")), new StringRef(NativePointer.$((String)"v6")), StringRef.R$EMPTY, triple);
                        return;
                    }
                    case aarch64: 
                }
                this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/c++/4.2.1")), new StringRef(NativePointer.$((String)"arm64-apple-darwin10")), StringRef.R$EMPTY, StringRef.R$EMPTY, triple);
                return;
            }
            switch (os) {
                case Linux: {
                    throw new llvm_unreachable("Include management is handled in the driver.");
                }
                case Win32: {
                    switch (triple.getEnvironment()) {
                        default: {
                            throw new llvm_unreachable("Include management is handled in the driver.");
                        }
                        case Cygnus: {
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.7.3")));
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.5.3")));
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.3.4")));
                            this.AddMinGWCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/lib/gcc")), new StringRef(NativePointer.$((String)"i686-pc-cygwin")), new StringRef(NativePointer.$((String)"4.3.2")));
                            break;
                        }
                        case GNU: {
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.0")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.1")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.2")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.7.3")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.8.0")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.8.1")));
                            this.AddMinGW64CXXPaths(new StringRef(HSOpts.ResourceDir), new StringRef(NativePointer.$((String)"4.8.2")));
                        }
                    }
                }
                case DragonFly: {
                    if (fs.exists((Twine)new Twine(NativePointer.$((String)"/usr/lib/gcc47")))) {
                        this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/4.7")), IncludeDirGroup.CXXSystem, false);
                        return;
                    }
                    this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/4.4")), IncludeDirGroup.CXXSystem, false);
                    return;
                }
                case OpenBSD: {
                    std.string t = new std.string(triple.getTriple());
                    if ($c$.clean(std.$eq_str_T((std.string)((std.string)$c$.track((Object)t.substr(0, 6))), (char.iterator)NativePointer.$((String)"x86_64")))) {
                        t.replace(0, 6, NativePointer.$((String)"amd64"));
                    }
                    this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/include/g++")), new StringRef(t), StringRef.R$EMPTY, StringRef.R$EMPTY, triple);
                    return;
                }
                case Minix: {
                    this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/gnu/include/c++/4.4.3")), StringRef.R$EMPTY, StringRef.R$EMPTY, StringRef.R$EMPTY, triple);
                    return;
                }
                case Solaris: {
                    this.AddGnuCPlusPlusIncludePaths(new StringRef(NativePointer.$((String)"/usr/gcc/4.5/include/c++/4.5.2/")), new StringRef(NativePointer.$((String)"i386-pc-solaris2.11")), StringRef.R$EMPTY, StringRef.R$EMPTY, triple);
                    return;
                }
            }
            return;
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AddDefaultIncludePaths(LangOptions Lang, Triple triple, HeaderSearchOptions HSOpts) {
        switch (triple.getOS()) {
            default: {
                break;
            }
            case Linux: {
                return;
            }
            case Win32: {
                if (triple.getEnvironment() != Triple.EnvironmentType.MSVC && triple.getEnvironment() != Triple.EnvironmentType.Itanium && !triple.isOSBinFormatMachO()) break;
                return;
            }
        }
        if (Lang.CPlusPlus && HSOpts.UseStandardCXXIncludes && HSOpts.UseStandardSystemIncludes) {
            if (HSOpts.UseLibcxx) {
                if (triple.isOSDarwin() && !HSOpts.ResourceDir.empty()) {
                    SmallString P = null;
                    try {
                        StringRef NoVer = path.parent_path((StringRef)new StringRef(HSOpts.ResourceDir));
                        StringRef Lib = path.parent_path((StringRef)new StringRef(NoVer));
                        P = new SmallString(path.parent_path((StringRef)new StringRef(Lib)), 128);
                        path.append((SmallString)P, (char.ptr)NativePointer.$((String)"include"), (char.ptr)NativePointer.$((String)"c++"), (char.ptr)NativePointer.$((String)"v1"));
                        this.AddUnmappedPath(new Twine(P.str()), IncludeDirGroup.CXXSystem, false);
                    }
                    finally {
                        if (P != null) {
                            P.$destroy();
                        }
                    }
                }
                if (triple.getOS() == Triple.OSType.Solaris) {
                    this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/v1/support/solaris")), IncludeDirGroup.CXXSystem, false);
                }
                this.AddPath(new Twine(NativePointer.$((String)"/usr/include/c++/v1")), IncludeDirGroup.CXXSystem, false);
            } else {
                this.AddDefaultCPlusPlusIncludePaths(triple, HSOpts);
            }
        }
        this.AddDefaultCIncludePaths(triple, HSOpts);
        if (HSOpts.UseStandardSystemIncludes && triple.isOSDarwin()) {
            this.AddPath(new Twine(NativePointer.$((String)"/System/Library/Frameworks")), IncludeDirGroup.System, true);
            this.AddPath(new Twine(NativePointer.$((String)"/Library/Frameworks")), IncludeDirGroup.System, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Realize(LangOptions Lang) {
        std.vector SearchList = null;
        try {
            SearchList = new std.vector((Object)DirectoryLookup.DEFAULT);
            SearchList.reserve(this.IncludePath.size());
            StdVector.iterator it = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            StdVector.iterator ie = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it, (StdVector.iterator)ie)) {
                if (((std_pair.pair)it.$arrow()).first == IncludeDirGroup.Quoted) {
                    SearchList.push_back(((std_pair.pair)it.$arrow()).second);
                }
                it.$preInc();
            }
            InitHeaderSearchStatics.RemoveDuplicates((std.vector<DirectoryLookup>)SearchList, 0, this.Verbose);
            int NumQuoted = SearchList.size();
            StdVector.iterator it2 = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            StdVector.iterator ie2 = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it2, (StdVector.iterator)ie2)) {
                if (((std_pair.pair)it2.$arrow()).first == IncludeDirGroup.Angled || ((std_pair.pair)it2.$arrow()).first == IncludeDirGroup.IndexHeaderMap) {
                    SearchList.push_back(((std_pair.pair)it2.$arrow()).second);
                }
                it2.$preInc();
            }
            InitHeaderSearchStatics.RemoveDuplicates((std.vector<DirectoryLookup>)SearchList, NumQuoted, this.Verbose);
            int NumAngled = SearchList.size();
            StdVector.iterator it3 = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            StdVector.iterator ie3 = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it3, (StdVector.iterator)ie3)) {
                if (((std_pair.pair)it3.$arrow()).first == IncludeDirGroup.System || ((std_pair.pair)it3.$arrow()).first == IncludeDirGroup.ExternCSystem || !Lang.ObjC1 && !Lang.CPlusPlus && ((std_pair.pair)it3.$arrow()).first == IncludeDirGroup.CSystem || Lang.CPlusPlus && ((std_pair.pair)it3.$arrow()).first == IncludeDirGroup.CXXSystem || Lang.ObjC1 && !Lang.CPlusPlus && ((std_pair.pair)it3.$arrow()).first == IncludeDirGroup.ObjCSystem || Lang.ObjC1 && Lang.CPlusPlus && ((std_pair.pair)it3.$arrow()).first == IncludeDirGroup.ObjCXXSystem) {
                    SearchList.push_back(((std_pair.pair)it3.$arrow()).second);
                }
                it3.$preInc();
            }
            it3 = (StdVector.iterator)Native.$tryClone((NativeCloneable)this.IncludePath.begin());
            ie3 = this.IncludePath.end();
            while (std.$noteq___normal_iterator((StdVector.iterator)it3, (StdVector.iterator)ie3)) {
                if (((std_pair.pair)it3.$arrow()).first == IncludeDirGroup.After) {
                    SearchList.push_back(((std_pair.pair)it3.$arrow()).second);
                }
                it3.$preInc();
            }
            int NonSystemRemoved = InitHeaderSearchStatics.RemoveDuplicates((std.vector<DirectoryLookup>)SearchList, NumQuoted, this.Verbose);
            boolean DontSearchCurDir = false;
            this.Headers.SetSearchPaths(SearchList, NumQuoted, NumAngled -= NonSystemRemoved, DontSearchCurDir);
            this.Headers.SetSystemHeaderPrefixes(new ArrayRef(this.SystemHeaderPrefixes));
            if (this.Verbose) {
                llvm.errs().$out("#include \"...\" search starts here:\n");
                int e = SearchList.size();
                for (int i = 0; i != e; ++i) {
                    String Suffix;
                    if (i == NumQuoted) {
                        llvm.errs().$out("#include <...> search starts here:\n");
                    }
                    char.ptr Name = Native.$tryClone((char.ptr)((DirectoryLookup)SearchList.$at(i)).getName());
                    if (((DirectoryLookup)SearchList.$at(i)).isNormalDir()) {
                        Suffix = "";
                    } else if (((DirectoryLookup)SearchList.$at(i)).isFramework()) {
                        Suffix = " (framework directory)";
                    } else {
                        assert (((DirectoryLookup)SearchList.$at(i)).isHeaderMap()) : "Unknown DirectoryLookup";
                        Suffix = " (headermap)";
                    }
                    llvm.errs().$out(" ").$out(Name).$out(Suffix).$out(NativePointer.$LF);
                }
                llvm.errs().$out("End of search list.\n");
            }
        }
        finally {
            if (SearchList != null) {
                SearchList.$destroy();
            }
        }
    }

    public void $destroy() {
    }
}

