/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.event.DocumentBuilderEvent;

public class EntityReferenceEvent
extends DocumentBuilderEvent {
    private final String entity;

    public EntityReferenceEvent(String entity) {
        this.entity = (String)Preconditions.checkNotNull((Object)entity, (Object)"Must provide entity");
    }

    @Override
    public void invoke(DocumentBuilder builder) {
        builder.entityReference(this.entity);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entity});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityReferenceEvent)) {
            return false;
        }
        return Objects.equal((Object)this.entity, (Object)((EntityReferenceEvent)obj).entity);
    }

    public String toString() {
        return String.format("entityReference(\"%s\")", this.entity);
    }
}

