/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.base;

import com.sun.source.util.TreePath;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.navigation.base.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public class Resolvers {
    private Resolvers() {
        throw new IllegalStateException();
    }

    public static Callable<Pair<URI, ElementHandle<TypeElement>>> createFileResolver(@NonNull JavaSource js) {
        return new FileResolver(js);
    }

    public static Callable<Pair<URI, ElementHandle<TypeElement>>> createEditorResolver(@NonNull JavaSource js, int dot) {
        return new EditorResolver(js, dot);
    }

    private static FileObject getFileForJavaSource(@NonNull JavaSource js) {
        Collection fos = js.getFileObjects();
        if (fos.size() != 1) {
            throw new IllegalArgumentException(String.format("Expecting 1 file, got: %d files.", fos.size()));
        }
        return (FileObject)fos.iterator().next();
    }

    private static final class EditorResolver
    implements Callable<Pair<URI, ElementHandle<TypeElement>>> {
        private final JavaSource js;
        private final FileObject fo;
        private final int dot;

        public EditorResolver(@NonNull JavaSource js, int dot) {
            Parameters.notNull((CharSequence)"js", (Object)js);
            this.js = js;
            this.fo = Resolvers.getFileForJavaSource(js);
            this.dot = dot;
        }

        @Override
        public Pair<URI, ElementHandle<TypeElement>> call() throws Exception {
            final ArrayList ret = new ArrayList();
            ret.add(null);
            this.js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.RESOLVED);
                    Document document = cc.getDocument();
                    if (document != null) {
                        TreePath tp = cc.getTreeUtilities().pathFor(EditorResolver.this.dot);
                        Element element = cc.getTrees().getElement(tp);
                        if (element instanceof TypeElement) {
                            ret.set(0, ElementHandle.create((Element)((TypeElement)element)));
                        } else if (element instanceof VariableElement) {
                            TypeMirror typeMirror = ((VariableElement)element).asType();
                            if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null) {
                                ret.set(0, ElementHandle.create((Element)((TypeElement)element)));
                            }
                        } else if (element instanceof ExecutableElement) {
                            if (element.getKind() == ElementKind.METHOD) {
                                TypeMirror typeMirror = ((ExecutableElement)element).getReturnType();
                                if (typeMirror.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)typeMirror).asElement()) != null) {
                                    ret.set(0, ElementHandle.create((Element)((TypeElement)element)));
                                }
                            } else if (element.getKind() == ElementKind.CONSTRUCTOR && (element = element.getEnclosingElement()) != null) {
                                ret.set(0, ElementHandle.create((Element)((TypeElement)element)));
                            }
                        } else {
                            ret.set(0, FileResolver.findMainElement(cc, EditorResolver.this.fo.getName()));
                        }
                    }
                }
            }, true);
            ElementHandle handle = (ElementHandle)ret.get(0);
            if (handle == null) {
                return null;
            }
            FileObject file = Utils.getFile((ElementHandle<TypeElement>)handle, this.js.getClasspathInfo());
            if (file == null) {
                return null;
            }
            return Pair.of((Object)file.toURI(), (Object)handle);
        }
    }

    private static final class FileResolver
    implements Callable<Pair<URI, ElementHandle<TypeElement>>> {
        private final JavaSource js;
        private final FileObject fo;

        public FileResolver(@NonNull JavaSource js) {
            Parameters.notNull((CharSequence)"js", (Object)js);
            this.js = js;
            this.fo = Resolvers.getFileForJavaSource(js);
        }

        @Override
        public Pair<URI, ElementHandle<TypeElement>> call() throws Exception {
            final ArrayList ret = new ArrayList(1);
            ret.add(null);
            this.js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ret.set(0, FileResolver.findMainElement(cc, FileResolver.this.fo.getName()));
                }
            }, true);
            ElementHandle handle = (ElementHandle)ret.get(0);
            if (handle == null) {
                return null;
            }
            return Pair.of((Object)this.fo.toURI(), (Object)handle);
        }

        @CheckForNull
        static ElementHandle<TypeElement> findMainElement(@NonNull CompilationController cc, @NonNull String fileName) {
            List topLevels = cc.getTopLevelElements();
            if (topLevels.isEmpty()) {
                return null;
            }
            TypeElement candidate = (TypeElement)topLevels.get(0);
            for (int i = 1; i < topLevels.size(); ++i) {
                if (!fileName.contentEquals(((TypeElement)topLevels.get(i)).getSimpleName())) continue;
                candidate = (TypeElement)topLevels.get(i);
                break;
            }
            return ElementHandle.create((Element)candidate);
        }
    }
}

