/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.trace;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;

public class TraceDwarf {
    private TraceDwarf() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String objFileName = args[0];
        Dwarf dump = null;
        try {
            Dwarf.LOG.log(Level.FINE, "TraceDwarf.");
            dump = new Dwarf(objFileName);
            Dwarf.CompilationUnitIterator units = dump.iteratorCompilationUnits();
            int idx = 0;
            if (units.hasNext()) {
                Dwarf.LOG.log(Level.FINE, "\n**** Done. Compilation units were found");
                while (units.hasNext()) {
                    CompilationUnitInterface compilationUnit = units.next();
                    Dwarf.LOG.log(Level.FINE, "{0}: {1}", new Object[]{++idx, compilationUnit.getSourceFileName()});
                }
            }
        }
        catch (FileNotFoundException ex) {
            Dwarf.LOG.log(Level.FINE, "File not found {0}: {1}", new Object[]{objFileName, ex.getMessage()});
        }
        catch (WrongFileFormatException ex) {
            Dwarf.LOG.log(Level.FINE, "Unsuported format of file {0}: {1}", new Object[]{objFileName, ex.getMessage()});
        }
        catch (IOException ex) {
            Dwarf.LOG.log(Level.FINE, "Exception in file " + objFileName, ex);
        }
        catch (Throwable ex) {
            Dwarf.LOG.log(Level.FINE, "Exception in file " + objFileName, ex);
        }
        finally {
            if (dump != null) {
                dump.dispose();
            }
        }
    }
}

