/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.dwarfdump.source.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileLineService {
    private static final String COMPILE_DIRECTORY = "\"directory\": ";
    private static final String SOURCE_FILE = "\"file\": ";
    private static final String COMMAND_LINE = "\"command\": ";
    private static final String SOURCE_PATH = "\"path\": ";
    private static final String LANGUAGE = "\"language\": ";
    private static final String MAIN = "\"main\": ";
    private static final String MAIN_LINE = "\"line\": ";
    private static final String DWARF_DUMP = "\"dwarf\": ";

    private CompileLineService() {
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Not enough parameters.");
            System.err.println("Usage:");
            System.err.println("java -cp org-netbeans-modules-cnd-dwarfdump.jar org.netbeans.modules.cnd.dwarfdump.CompileLineService -file binaryFileName [-dwarf]");
            System.err.println("java -cp org-netbeans-modules-cnd-dwarfdump.jar org.netbeans.modules.cnd.dwarfdump.CompileLineService -folder folderName [-dwarf]");
            return;
        }
        try {
            if (args.length == 3 && "-dwarf".equals(args[2])) {
                CompileLineService.dump(args[0], args[1], true, System.out);
            } else {
                CompileLineService.dump(args[0], args[1], false, System.out);
            }
        }
        catch (Throwable ex) {
            Dwarf.LOG.log(Level.INFO, "File " + args[1], ex);
        }
    }

    private static void dump(String kind, String objFileName, boolean dwarf, PrintStream out) throws IOException, Exception {
        List<SourceFile> res = null;
        if ("-file".equals(kind)) {
            res = CompileLineService.getSourceFileProperties(objFileName, dwarf);
        } else if ("-folder".equals(kind)) {
            res = CompileLineService.getSourceFolderProperties(objFileName, dwarf);
        } else {
            throw new Exception("Wrong arguments: " + kind + " " + objFileName);
        }
        out.println("[");
        boolean first = true;
        for (SourceFile entry : res) {
            if (!first) {
                out.println(",");
            }
            out.println("{");
            boolean finished = true;
            finished = CompileLineService.printLine(out, COMPILE_DIRECTORY, entry.getCompilationDir(), finished);
            finished = CompileLineService.printLine(out, SOURCE_FILE, entry.getSourceFileName(), finished);
            finished = CompileLineService.printLine(out, COMMAND_LINE, entry.getCommandLine(), finished);
            finished = CompileLineService.printLine(out, SOURCE_PATH, entry.getSourceFileAbsolutePath(), finished);
            finished = CompileLineService.printLine(out, LANGUAGE, entry.getSourceLanguage(), finished);
            finished = CompileLineService.printLine(out, MAIN, entry.hasMain(), finished);
            finished = CompileLineService.printLine(out, MAIN_LINE, entry.getMainLine(), finished);
            finished = CompileLineService.printLine(out, DWARF_DUMP, entry.getDwarfDump(), finished);
            out.println("");
            out.print("}");
            first = false;
        }
        if (!first) {
            out.println("");
        }
        out.println("]");
    }

    private static boolean printLine(PrintStream out, String key, String value, boolean finished) {
        if (value != null && value.length() > 0) {
            if (!finished) {
                out.println(",");
            }
            out.print(" ");
            out.print(key);
            out.print("\"");
            out.print(value);
            out.print("\"");
            finished = false;
        }
        return finished;
    }

    private static boolean printLine(PrintStream out, String key, boolean value, boolean finished) {
        if (value) {
            if (!finished) {
                out.println(",");
                finished = false;
            }
            out.print(" ");
            out.print(key);
            out.print("true");
        }
        return finished;
    }

    private static boolean printLine(PrintStream out, String key, int value, boolean finished) {
        if (value != 0) {
            if (!finished) {
                out.println(",");
                finished = false;
            }
            out.print(" ");
            out.print(key);
            out.print("" + value);
        }
        return finished;
    }

    public static List<SourceFile> getSourceProperties(BufferedReader out) throws IOException {
        return CompileLineService.readSourceProperties(out);
    }

    private static List<SourceFile> readSourceProperties(BufferedReader out) throws IOException {
        String line;
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        String compileDir = null;
        String sourceFile = null;
        String compileLine = null;
        String absolutePath = null;
        String sourceLanguage = null;
        boolean hasMain = false;
        int lineNumber = 0;
        String dwarf = null;
        while ((line = out.readLine()) != null) {
            if ((line = line.trim()).startsWith("[") || line.startsWith("]")) continue;
            if (line.startsWith("{")) {
                compileDir = null;
                sourceFile = null;
                compileLine = null;
                absolutePath = null;
                sourceLanguage = null;
                hasMain = false;
                lineNumber = 0;
                dwarf = null;
                continue;
            }
            if (line.startsWith("}")) {
                SourceFile src = SourceFile.createSourceFile(compileDir, sourceFile, compileLine, absolutePath, sourceLanguage, hasMain, lineNumber, dwarf);
                list.add(src);
                continue;
            }
            if (line.startsWith(COMPILE_DIRECTORY)) {
                compileDir = CompileLineService.removeQuotesAndComma(line.substring(COMPILE_DIRECTORY.length()));
                continue;
            }
            if (line.startsWith(SOURCE_FILE)) {
                sourceFile = CompileLineService.removeQuotesAndComma(line.substring(SOURCE_FILE.length()));
                continue;
            }
            if (line.startsWith(COMMAND_LINE)) {
                compileLine = CompileLineService.removeQuotesAndComma(line.substring(COMMAND_LINE.length()));
                continue;
            }
            if (line.startsWith(SOURCE_PATH)) {
                absolutePath = CompileLineService.removeQuotesAndComma(line.substring(SOURCE_PATH.length()));
                continue;
            }
            if (line.startsWith(LANGUAGE)) {
                sourceLanguage = CompileLineService.removeQuotesAndComma(line.substring(LANGUAGE.length()));
                continue;
            }
            if (line.startsWith(MAIN)) {
                hasMain = "true".equals(CompileLineService.removeQuotesAndComma(line.substring(MAIN.length())));
                continue;
            }
            if (line.startsWith(MAIN_LINE)) {
                try {
                    lineNumber = Integer.parseInt(CompileLineService.removeQuotesAndComma(line.substring(MAIN_LINE.length())));
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace(System.err);
                }
                continue;
            }
            if (!line.startsWith(DWARF_DUMP)) continue;
            dwarf = CompileLineService.removeQuotesAndComma(line.substring(DWARF_DUMP.length()));
        }
        return list;
    }

    private static String removeQuotesAndComma(String str) {
        if ((str = str.trim()).endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.length() >= 2 && (str.charAt(0) == '\'' && str.charAt(str.length() - 1) == '\'' || str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"')) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static List<SourceFile> getSourceFolderProperties(String objFolderName, boolean dwarf) {
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        for (String objFileName : CompileLineService.getObjectFiles(objFolderName)) {
            list.addAll(CompileLineService.getSourceFileProperties(objFileName, dwarf));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SourceFile> getSourceFileProperties(String objFileName, boolean dwarf) {
        ArrayList<SourceFile> list = new ArrayList<SourceFile>();
        Dwarf dump = null;
        try {
            dump = new Dwarf(objFileName);
            Dwarf.CompilationUnitIterator iterator = dump.iteratorCompilationUnits();
            while (iterator.hasNext()) {
                CompilationUnitInterface cu = iterator.next();
                if (cu == null) continue;
                if (cu.getSourceFileName() == null) {
                    if (!Dwarf.LOG.isLoggable(Level.FINE)) continue;
                    Dwarf.LOG.log(Level.FINE, "Compilation unit has broken name in file {0}", objFileName);
                    continue;
                }
                String lang = cu.getSourceLanguage();
                if (lang == null) {
                    if (!Dwarf.LOG.isLoggable(Level.FINE)) continue;
                    Dwarf.LOG.log(Level.FINE, "Compilation unit has unresolved language in file {0}for {1}", new Object[]{objFileName, cu.getSourceFileName()});
                    continue;
                }
                if (LANG.DW_LANG_C.toString().equals(lang) || LANG.DW_LANG_C89.toString().equals(lang) || LANG.DW_LANG_C99.toString().equals(lang) || LANG.DW_LANG_C_plus_plus.toString().equals(lang)) {
                    try {
                        list.add(SourceFile.createSourceFile(cu, dwarf));
                        continue;
                    }
                    catch (IOException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        if (!Dwarf.LOG.isLoggable(Level.FINE)) continue;
                        Dwarf.LOG.log(Level.FINE, "Compilation unit {0} {1}", new Object[]{cu.getSourceFileName(), ex.getMessage()});
                        continue;
                    }
                }
                if (!Dwarf.LOG.isLoggable(Level.FINE)) continue;
                Dwarf.LOG.log(Level.FINE, "Unknown language: {0}", lang);
            }
        }
        catch (FileNotFoundException ex) {
            if (Dwarf.LOG.isLoggable(Level.FINE)) {
                Dwarf.LOG.log(Level.FINE, "File not found {0}: {1}", new Object[]{objFileName, ex.getMessage()});
            }
        }
        catch (WrongFileFormatException ex) {
            if (Dwarf.LOG.isLoggable(Level.FINE)) {
                Dwarf.LOG.log(Level.FINE, "Unsuported format of file {0}: {1}", new Object[]{objFileName, ex.getMessage()});
            }
        }
        catch (IOException ex) {
            Dwarf.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
        }
        catch (Throwable ex) {
            Dwarf.LOG.log(Level.INFO, "Exception in file " + objFileName, ex);
        }
        finally {
            if (dump != null) {
                dump.dispose();
            }
        }
        return list;
    }

    public static SourceFile createSourceFile(String compileDir, String sourceFile, String compileLine) {
        return SourceFile.createSourceFile(compileDir, sourceFile, compileLine, null, null, false, -1, null);
    }

    private static Set<String> getObjectFiles(String root) {
        HashSet<String> map = new HashSet<String>();
        CompileLineService.gatherSubFolders(new File(root), map, new HashSet<String>());
        return map;
    }

    private static boolean isExecutable(File file) {
        String name = file.getName();
        return name.indexOf(46) < 0;
    }

    private static void gatherSubFolders(File d, HashSet<String> map, HashSet<String> antiLoop) {
        if (d.exists() && d.isDirectory() && d.canRead()) {
            String canPath;
            if (CompileLineService.ignoreFolder(d)) {
                return;
            }
            try {
                canPath = d.getCanonicalPath();
            }
            catch (IOException ex) {
                Dwarf.LOG.log(Level.INFO, "File " + d.getAbsolutePath(), ex);
                return;
            }
            if (!antiLoop.contains(canPath)) {
                antiLoop.add(canPath);
                File[] ff = d.listFiles();
                if (ff != null) {
                    for (int i = 0; i < ff.length; ++i) {
                        String name;
                        if (ff[i].isDirectory()) {
                            CompileLineService.gatherSubFolders(ff[i], map, antiLoop);
                            continue;
                        }
                        if (!ff[i].isFile() || !(name = ff[i].getName()).endsWith(".o") && !name.endsWith(".so") && !name.endsWith(".a") && !CompileLineService.isExecutable(ff[i])) continue;
                        String path = ff[i].getAbsolutePath();
                        map.add(path);
                    }
                }
            }
        }
    }

    private static boolean ignoreFolder(File file) {
        if (file.isDirectory()) {
            String name = file.getName();
            return name.equals("SCCS") || name.equals("CVS") || name.equals(".hg") || name.equals("SunWS_cache") || name.equals(".svn");
        }
        return false;
    }
}

