/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.OSTargetInfo;
import org.clang.basic.target.impl.TargetInfo;
import org.clank.support.JavaDifferentiators;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class WindowsTargetInfo<Target extends TargetInfo>
extends OSTargetInfo<Target> {
    @Override
    protected void getOSDefines(LangOptions Opts, Triple Triple2, MacroBuilder Builder2) {
        Builder2.defineMacro(new Twine("_WIN32"));
    }

    protected void getVisualStudioDefines(LangOptions Opts, MacroBuilder Builder2) {
        if (Opts.CPlusPlus) {
            if (Opts.RTTIData) {
                Builder2.defineMacro(new Twine("_CPPRTTI"));
            }
            if (Opts.CXXExceptions) {
                Builder2.defineMacro(new Twine("_CPPUNWIND"));
            }
        }
        if (Opts.Bool) {
            Builder2.defineMacro(new Twine("__BOOL_DEFINED"));
        }
        if (!Opts.CharIsSigned) {
            Builder2.defineMacro(new Twine("_CHAR_UNSIGNED"));
        }
        if (Opts.POSIXThreads) {
            Builder2.defineMacro(new Twine("_MT"));
        }
        if (Opts.MSCompatibilityVersion != 0) {
            Builder2.defineMacro(new Twine("_MSC_VER"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, Opts.MSCompatibilityVersion / 100000));
            Builder2.defineMacro(new Twine("_MSC_FULL_VER"), new Twine(JavaDifferentiators.JD$UInt.INSTANCE, Opts.MSCompatibilityVersion));
            Builder2.defineMacro(new Twine("_MSC_BUILD"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, 1));
            if (Opts.CPlusPlus11 && Opts.isCompatibleWithMSVC(LangOptions.MSVCMajorVersion.MSVC2015)) {
                Builder2.defineMacro(new Twine("_HAS_CHAR16_T_LANGUAGE_SUPPORT"), new Twine(JavaDifferentiators.JD$Int.INSTANCE, 1));
            }
            if (Opts.isCompatibleWithMSVC(LangOptions.MSVCMajorVersion.MSVC2015)) {
                if (Opts.CPlusPlus1z) {
                    Builder2.defineMacro(new Twine("_MSVC_LANG"), new Twine("201403L"));
                } else if (Opts.CPlusPlus14) {
                    Builder2.defineMacro(new Twine("_MSVC_LANG"), new Twine("201402L"));
                }
            }
        }
        if (Opts.MicrosoftExt) {
            Builder2.defineMacro(new Twine("_MSC_EXTENSIONS"));
            if (Opts.CPlusPlus11) {
                Builder2.defineMacro(new Twine("_RVALUE_REFERENCES_V2_SUPPORTED"));
                Builder2.defineMacro(new Twine("_RVALUE_REFERENCES_SUPPORTED"));
                Builder2.defineMacro(new Twine("_NATIVE_NULLPTR_SUPPORTED"));
            }
        }
        Builder2.defineMacro(new Twine("_INTEGRAL_MAX_BITS"), new Twine("64"));
    }

    public WindowsTargetInfo(Target T, Triple Triple2, TargetOptions Opts) {
        super(T, Triple2, Opts);
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

