/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierInfoLookup;
import org.clang.basic.IdentifierInfoStringMapEntry;
import org.clang.basic.LangOptions;
import org.clang.basic.impl.IdentifierTableStatics;
import org.clang.basic.impl.StringMapIdentifierInfo;
import org.clang.basic.impl.StringMapIteratorIdentifierInfo;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class IdentifierTable
implements Destructors.ClassWithDestructor {
    private static final int IDENT_TABLE_SIZE = Integer.getInteger("clank.identifiers.size", 8192);
    public static final String REUSE_LEXER_IDENTIFIERS_PROP = "clank.identifiers.reuse";
    public static final boolean REUSE_LEXER_IDENTIFIERS = Boolean.valueOf(System.getProperty("clank.identifiers.reuse", "false"));
    private static final SmallVector<HashTableTy> POOL = new SmallVector(2 * Native.availableProcessors(), null);
    private HashTableTy HashTable;
    private IdentifierInfoLookup ExternalLookup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashTableTy $getHashTable(IdentifierInfoLookup ExternalLookup) {
        if (REUSE_LEXER_IDENTIFIERS && ExternalLookup == null) {
            SmallVector<HashTableTy> smallVector = POOL;
            synchronized (smallVector) {
                if (!POOL.empty()) {
                    return (HashTableTy)((Object)POOL.pop_back_val());
                }
            }
            return new HashTableTy(IDENT_TABLE_SIZE);
        }
        return new HashTableTy(IDENT_TABLE_SIZE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void $releaseHashTable(HashTableTy Table, IdentifierInfoLookup ExternalLookup) {
        if (REUSE_LEXER_IDENTIFIERS && ExternalLookup == null) {
            Table.$release();
            SmallVector<HashTableTy> smallVector = POOL;
            synchronized (smallVector) {
                POOL.push_back((Object)Table);
            }
        } else {
            Table.$destroy();
        }
    }

    public IdentifierTable(LangOptions LangOpts) {
        this(LangOpts, null);
    }

    public IdentifierTable(LangOptions LangOpts, IdentifierInfoLookup externalLookup) {
        this.HashTable = IdentifierTable.$getHashTable(externalLookup);
        this.ExternalLookup = externalLookup;
        this.AddKeywords(LangOpts);
        this.get(NativePointer.$import.$array(), NativePointer.$import.$index(), StringRef.R$import.size()).setModulesImport(true);
    }

    public void setExternalIdentifierLookup(IdentifierInfoLookup IILookup) {
        this.ExternalLookup = IILookup;
    }

    public IdentifierInfoLookup getExternalIdentifierLookup() {
        return this.ExternalLookup;
    }

    public BumpPtrAllocator getAllocator() {
        return this.HashTable.getAllocator();
    }

    public IdentifierInfo get(StringRef Name) {
        return this.get(Name.data(), Name.size());
    }

    public IdentifierInfo get(char.ptr Name, int Len) {
        IdentifierInfoStringMapEntry Entry2;
        IdentifierInfo II;
        if (NativeTrace.isDebugMode()) {
            NativeTrace.assertTrueInConsole((!Native.$is_array_based((char.ptr)Name) ? 1 : 0) != 0, (String)"use get(byte[],...) version directly if possible");
        }
        if ((II = (Entry2 = this.HashTable.GetOrCreateValue(Name, Len)).getValue()) != null) {
            assert (Entry2.getValue() == II);
            assert (II.getEntryImpl() == Entry2);
            return II;
        }
        if (this.ExternalLookup != null && (II = this.ExternalLookup.get(Name, Len)) != null) {
            return II;
        }
        Entry2.setValue(IdentifierInfo.SET_VALUE_PLACEHOLDER);
        II = Entry2.getValue();
        II.setEntry(Entry2);
        assert (Entry2.getValue() == II);
        assert (II.getEntryImpl() == Entry2);
        return II;
    }

    public IdentifierInfo get(byte[] Name, int NameStIndex, int Len) {
        IdentifierInfoStringMapEntry Entry2 = this.HashTable.GetOrCreateValue(Name, NameStIndex, Len);
        IdentifierInfo II = Entry2.getValue();
        if (II != null) {
            assert (Entry2.getValue() == II);
            assert (II.getEntryImpl() == Entry2);
            return II;
        }
        if (this.ExternalLookup != null && (II = this.ExternalLookup.get(Name, NameStIndex, Len)) != null) {
            return II;
        }
        Entry2.setValue(IdentifierInfo.SET_VALUE_PLACEHOLDER);
        II = Entry2.getValue();
        II.setEntry(Entry2);
        assert (Entry2.getValue() == II);
        assert (II.getEntryImpl() == Entry2);
        return II;
    }

    public IdentifierInfo get(StringRef Name, char TokenCode) {
        IdentifierInfo II = this.get(Name);
        II.setTokenID(TokenCode);
        assert (II.$TokenID() == TokenCode) : "TokenCode too large";
        return II;
    }

    public IdentifierInfo getOwn(StringRef Name) {
        IdentifierInfoStringMapEntry Entry2 = this.HashTable.GetOrCreateValue(Name);
        IdentifierInfo II = Entry2.getValue();
        if (II == null) {
            Entry2.setValue(IdentifierInfo.SET_VALUE_PLACEHOLDER);
            II = Entry2.getValue();
            II.setEntry(Entry2);
            if (Name.equals(StringRef.R$import)) {
                II.setModulesImport(true);
            }
        }
        assert (Entry2.getValue() == II);
        assert (II.getEntryImpl() == Entry2);
        return II;
    }

    public StringMapIteratorIdentifierInfo begin() {
        return this.HashTable.begin();
    }

    public StringMapIteratorIdentifierInfo end() {
        return this.HashTable.end();
    }

    public int size() {
        return this.HashTable.size();
    }

    public void PrintStats() {
        this.PrintStats(llvm.errs());
    }

    public long PrintStats(raw_ostream OS) {
        int NumBuckets = this.HashTable.getNumBuckets();
        int NumIdentifiers = this.HashTable.getNumItems();
        int NumEmptyBuckets = NumBuckets - NumIdentifiers;
        int AverageIdentifierSize = 0;
        int MaxIdentifierLength = 0;
        StringMapIteratorIdentifierInfo I = this.HashTable.begin();
        StringMapIteratorIdentifierInfo E = this.HashTable.end();
        while (I.$noteq(E)) {
            int IdLen = I.$arrow().getKeyLength();
            AverageIdentifierSize += IdLen;
            if (MaxIdentifierLength < IdLen) {
                MaxIdentifierLength = IdLen;
            }
            I.$preInc();
        }
        OS.$out(String.format("\n*** Identifier Table Stats:\n", new Object[0]));
        OS.$out(String.format("# Identifiers:   %s\n", NativeTrace.formatNumber((long)NumIdentifiers)));
        NativeTrace.dumpStatisticValue((String)"NumIdentifiers", (long)NumIdentifiers);
        OS.$out(String.format("# Empty Buckets: %s\n", NativeTrace.formatNumber((long)NumEmptyBuckets)));
        OS.$out(String.format("Hash density (#identifiers per bucket): %f\n", (double)NumIdentifiers / (double)NumBuckets));
        OS.$out(String.format("Ave identifier length: %f\n", (double)AverageIdentifierSize / (double)NumIdentifiers));
        OS.$out(String.format("Max identifier length: %d\n", MaxIdentifierLength));
        this.HashTable.getAllocator().PrintStats("IdentifierTableAllocatedBytes", OS);
        return NumIdentifiers;
    }

    public void AddKeywords(LangOptions LangOpts) {
        IdentifierTableStatics.AddKeyword("auto", 'K', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("break", 'L', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("case", 'M', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("char", 'N', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("const", 'O', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("continue", 'P', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("default", 'Q', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("do", 'R', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("double", 'S', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("else", 'T', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("enum", 'U', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("extern", 'V', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("float", 'W', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("for", 'X', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("goto", 'Y', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("if", 'Z', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("inline", '[', 11, LangOpts, this);
        IdentifierTableStatics.AddKeyword("int", '\\', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("long", ']', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("register", '^', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("restrict", '_', 1, LangOpts, this);
        IdentifierTableStatics.AddKeyword("return", '`', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("short", 'a', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("signed", 'b', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("sizeof", 'c', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("static", 'd', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("struct", 'e', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("switch", 'f', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("typedef", 'g', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("union", 'h', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("unsigned", 'i', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("void", 'j', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("volatile", 'k', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("while", 'l', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Alignas", 'm', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Alignof", 'n', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Atomic", 'o', 1044479, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Bool", 'p', 128, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Complex", 'q', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Generic", 'r', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Imaginary", 's', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Noreturn", 't', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Static_assert", 'u', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Thread_local", 'v', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__func__", 'w', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__objc_yes", 'x', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__objc_no", 'y', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("asm", 'z', 10, LangOpts, this);
        IdentifierTableStatics.AddKeyword("bool", '{', 32, LangOpts, this);
        IdentifierTableStatics.AddKeyword("catch", '|', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("class", '}', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("const_cast", '~', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("delete", '\u007f', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("dynamic_cast", '\u0080', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("explicit", '\u0081', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("export", '\u0082', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("false", '\u0083', 32, LangOpts, this);
        IdentifierTableStatics.AddKeyword("friend", '\u0084', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("mutable", '\u0085', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("namespace", '\u0086', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("new", '\u0087', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("operator", '\u0088', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("private", '\u0089', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("protected", '\u008a', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("public", '\u008b', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("reinterpret_cast", '\u008c', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("static_cast", '\u008d', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("template", '\u008e', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("this", '\u008f', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("throw", '\u0090', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("true", '\u0091', 32, LangOpts, this);
        IdentifierTableStatics.AddKeyword("try", '\u0092', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("typename", '\u0093', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("typeid", '\u0094', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("using", '\u0095', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("virtual", '\u0096', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("wchar_t", '\u0097', 16384, LangOpts, this);
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("and", '\u001c', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("and_eq", '\u001d', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("bitand", '\u001b', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("bitor", '8', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("compl", '\'', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("not", '(', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("not_eq", ')', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("or", '9', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("or_eq", ':', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("xor", '6', this);
        }
        if (LangOpts.CXXOperatorNames) {
            IdentifierTableStatics.AddCXXOperatorKeyword("xor_eq", '7', this);
        }
        IdentifierTableStatics.AddKeyword("alignas", '\u0098', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("alignof", '\u0099', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("char16_t", '\u009a', 4100, LangOpts, this);
        IdentifierTableStatics.AddKeyword("char32_t", '\u009b', 4100, LangOpts, this);
        IdentifierTableStatics.AddKeyword("constexpr", '\u009c', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("decltype", '\u009d', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("noexcept", '\u009e', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("nullptr", '\u009f', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("static_assert", '\u00a0', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("thread_local", '\u00a1', 4, LangOpts, this);
        IdentifierTableStatics.AddKeyword("concept", '\u00a2', 65536, LangOpts, this);
        IdentifierTableStatics.AddKeyword("requires", '\u00a3', 65536, LangOpts, this);
        IdentifierTableStatics.AddKeyword("co_await", '\u00a4', 524288, LangOpts, this);
        IdentifierTableStatics.AddKeyword("co_return", '\u00a5', 524288, LangOpts, this);
        IdentifierTableStatics.AddKeyword("co_yield", '\u00a6', 524288, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Decimal32", '\u00a7', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Decimal64", '\u00a8', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Decimal128", '\u00a9', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__null", '\u00aa', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__alignof", '\u00ab', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__attribute", '\u00ac', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_choose_expr", '\u00ad', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_offsetof", '\u00ae', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_types_compatible_p", '\u00af', 128, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_va_arg", '\u00b0', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__extension__", '\u00b1', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__float128", '\u00b2', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__imag", '\u00b3', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__int128", '\u00b4', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__label__", '\u00b5', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__real", '\u00b6', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__thread", '\u00b7', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__FUNCTION__", '\u00b8', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__PRETTY_FUNCTION__", '\u00b9', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__auto_type", '\u00ba', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("typeof", '\u00bb', 8, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__FUNCDNAME__", '\u00bc', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__FUNCSIG__", '\u00bd', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("L__FUNCTION__", '\u00be', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_interface_class", '\u00bf', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_sealed", '\u00c0', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_destructible", '\u00c1', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_nothrow_destructible", '\u00c2', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_nothrow_assignable", '\u00c3', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_constructible", '\u00c4', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_nothrow_constructible", '\u00c5', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_assignable", '\u00c6', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_nothrow_assign", '\u00c7', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_nothrow_move_assign", '\u00c8', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_nothrow_copy", '\u00c9', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_nothrow_constructor", '\u00ca', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_trivial_assign", '\u00cb', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_trivial_move_assign", '\u00cc', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_trivial_copy", '\u00cd', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_trivial_constructor", '\u00ce', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_trivial_move_constructor", '\u00cf', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_trivial_destructor", '\u00d0', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__has_virtual_destructor", '\u00d1', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_abstract", '\u00d2', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_base_of", '\u00d3', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_class", '\u00d4', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_convertible_to", '\u00d5', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_empty", '\u00d6', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_enum", '\u00d7', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_final", '\u00d8', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_literal", '\u00d9', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_literal_type", '\u00d9', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_pod", '\u00da', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_polymorphic", '\u00db', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_trivial", '\u00dc', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_union", '\u00dd', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_trivially_constructible", '\u00de', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_trivially_copyable", '\u00df', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_trivially_assignable", '\u00e0', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__underlying_type", '\u00e1', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_lvalue_expr", '\u00e2', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_rvalue_expr", '\u00e3', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_arithmetic", '\u00e4', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_floating_point", '\u00e5', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_integral", '\u00e6', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_complete_type", '\u00e7', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_void", '\u00e8', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_array", '\u00e9', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_function", '\u00ea', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_reference", '\u00eb', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_lvalue_reference", '\u00ec', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_rvalue_reference", '\u00ed', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_fundamental", '\u00ee', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_object", '\u00ef', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_scalar", '\u00f0', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_compound", '\u00f1', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_pointer", '\u00f2', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_member_object_pointer", '\u00f3', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_member_function_pointer", '\u00f4', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_member_pointer", '\u00f5', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_const", '\u00f6', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_volatile", '\u00f7', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_standard_layout", '\u00f8', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_signed", '\u00f9', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_unsigned", '\u00fa', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_same", '\u00fb', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__is_convertible", '\u00fc', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__array_rank", '\u00fd', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__array_extent", '\u00fe', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__private_extern__", '\u00ff', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__module_private__", '\u0100', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__declspec", '\u0101', 0, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__cdecl", '\u0102', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__stdcall", '\u0103', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__fastcall", '\u0104', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__thiscall", '\u0105', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__vectorcall", '\u0106', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__forceinline", '\u0107', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__unaligned", '\u0108', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__super", '\u0109', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__global", '\u010a', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__local", '\u010b', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__constant", '\u010c', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__private", '\u010d', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__generic", '\u010e', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("global", '\u010a', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("local", '\u010b', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("constant", '\u010c', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("private", '\u010d', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("generic", '\u010e', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__kernel", '\u010f', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("kernel", '\u010f', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__read_only", '\u0110', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__write_only", '\u0111', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__read_write", '\u0112', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("read_only", '\u0110', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("write_only", '\u0111', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("read_write", '\u0112', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_astype", '\u0113', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("vec_step", '\u0114', 262720, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image1d_t", '\u0115', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image1d_array_t", '\u0116', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image1d_buffer_t", '\u0117', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_t", '\u0118', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_array_t", '\u0119', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_depth_t", '\u011a', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_array_depth_t", '\u011b', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_msaa_t", '\u011c', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_array_msaa_t", '\u011d', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_msaa_depth_t", '\u011e', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image2d_array_msaa_depth_t", '\u011f', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("image3d_t", '\u0120', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_omp_required_simd_align", '\u0121', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("pipe", '\u0122', 512, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__pascal", '\u0123', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__vector", '\u0124', 262208, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__pixel", '\u0125', 64, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__bool", '\u0126', 262208, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__fp16", '\u0127', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("half", '\u0127', 32768, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__bridge", '\u0128', 2048, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__bridge_transfer", '\u0129', 2048, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__bridge_retained", '\u012a', 2048, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__bridge_retain", '\u012b', 2048, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__covariant", '\u012c', 131072, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__contravariant", '\u012d', 131072, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__kindof", '\u012e', 131072, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__alignof__", '\u00ab', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__asm", 'z', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__asm__", 'z', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__attribute__", '\u00ac', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__complex", 'q', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__complex__", 'q', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__const", 'O', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__const__", 'O', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__decltype", '\u009d', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__imag__", '\u00b3', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__inline", '[', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__inline__", '[', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__nullptr", '\u009f', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__real__", '\u00b6', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__restrict", '_', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__restrict__", '_', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__signed", 'b', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__signed__", 'b', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__typeof", '\u00bb', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__typeof__", '\u00bb', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__volatile", 'k', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__volatile__", 'k', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Nonnull", '\u012f', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Nullable", '\u0130', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_Null_unspecified", '\u0131', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__ptr64", '\u0132', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__ptr32", '\u0133', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__sptr", '\u0134', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__uptr", '\u0135', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__w64", '\u0136', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__uuidof", '\u0137', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__try", '\u0138', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__finally", '\u0139', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__leave", '\u013a', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__int64", '\u013b', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__if_exists", '\u013c', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__if_not_exists", '\u013d', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__single_inheritance", '\u013e', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__multiple_inheritance", '\u013f', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__virtual_inheritance", '\u0140', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__interface", '\u0141', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__int8", 'N', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_int8", 'N', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__int16", 'a', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_int16", 'a', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__int32", '\\', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_int32", '\\', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_int64", '\u013b', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__wchar_t", '\u0097', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_asm", 'z', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_alignof", '\u00ab', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_alignof", '\u00ab', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_cdecl", '\u0102', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_fastcall", '\u0104', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_stdcall", '\u0103', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_thiscall", '\u0105', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_vectorcall", '\u0106', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_uuidof", '\u0137', 272, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_inline", '[', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_declspec", '\u0101', 16, LangOpts, this);
        IdentifierTableStatics.AddKeyword("_pascal", '\u0123', 256, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_convertvector", '\u0142', 1036287, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__char16_t", '\u009a', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__char32_t", '\u009b', 2, LangOpts, this);
        IdentifierTableStatics.AddKeyword("__builtin_available", '\u0143', 1036287, LangOpts, this);
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("not_keyword", '\u0000', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("class", '\u0001', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("compatibility_alias", '\u0002', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("defs", '\u0003', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("encode", '\u0004', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("end", '\u0005', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("implementation", '\u0006', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("interface", '\u0007', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("private", '\b', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("protected", '\t', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("protocol", '\n', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("public", '\u000b', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("selector", '\f', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("throw", '\r', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("try", '\u000e', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("catch", '\u000f', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("finally", '\u0010', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("synchronized", '\u0011', this);
        }
        if (LangOpts.ObjC1) {
            IdentifierTableStatics.AddObjCKeyword("autoreleasepool", '\u0012', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("property", '\u0013', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("package", '\u0014', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("required", '\u0015', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("optional", '\u0016', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("synthesize", '\u0017', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("dynamic", '\u0018', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("import", '\u0019', this);
        }
        if (LangOpts.ObjC2) {
            IdentifierTableStatics.AddObjCKeyword("available", '\u001a', this);
        }
        if (LangOpts.ParseUnknownAnytype) {
            IdentifierTableStatics.AddKeyword("__unknown_anytype", '\u0144', 1036287, LangOpts, this);
        }
        if (LangOpts.DeclSpecKeyword) {
            IdentifierTableStatics.AddKeyword("__declspec", '\u0101', 1036287, LangOpts, this);
        }
    }

    public void $destroy() {
        IdentifierTable.$releaseHashTable(this.HashTable, this.ExternalLookup);
        this.HashTable = null;
    }

    private static final class HashTableTy
    extends StringMapIdentifierInfo {
        private HashTableTy(int size) {
            super(size, new StringMapBumpPtrAllocator(), null);
        }

        private void $release() {
            super.resetForReuse();
        }
    }
}

