/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileData;
import org.clang.basic.FileEntry;
import org.clang.basic.FileSystemOptions;
import org.clang.basic.FileSystemStatCache;
import org.clang.basic.impl.FileManagerStatics;
import org.clang.basic.vfs.File;
import org.clang.basic.vfs.FileSystem;
import org.clang.basic.vfs.Status;
import org.clang.basic.vfs.VfsGlobals;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.char;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.adt.aliases.SmallVectorWithDestroy;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class FileManager
extends RefCountedBase<FileManager>
implements Destructors.ClassWithDestructor {
    private static final DirectoryEntry NON_EXISTENT_DIR = new DirectoryEntry();
    private static final FileEntry NON_EXISTENT_FILE = new FileEntry(new fs.UniqueID(-1L, -1L));
    private IntrusiveRefCntPtr<FileSystem> FS;
    private FileSystemOptions FileSystemOpts;
    public static final String NORMALIZED_UID_PROP = "clank.normalized.file.uid";
    public static final boolean NORMALIZED_UID = Boolean.valueOf(System.getProperty("clank.normalized.file.uid", NativeTrace.isStandalone() ? "false" : "true"));
    private std.map<fs.UniqueID, DirectoryEntry> UniqueRealDirs;
    private std.map<fs.UniqueID, FileEntry> UniqueRealFiles;
    private SmallVector<std_ptr.unique_ptr<DirectoryEntry>> VirtualDirectoryEntries;
    private SmallVectorWithDestroy<std_ptr.unique_ptr<FileEntry>> VirtualFileEntries;
    private StringMap<DirectoryEntry> SeenDirEntries;
    private StringMap<FileEntry> SeenFileEntries;
    private DenseMap<DirectoryEntry, StringRef> CanonicalDirNames;
    private BumpPtrAllocatorImpl CanonicalNameStorage;
    private int NextFileUID;
    static final int INVALID_UID = Integer.MIN_VALUE;
    private int NumDirLookups;
    private int NumFileLookups;
    private int NumDirCacheMisses;
    private int NumFileCacheMisses;
    private std_ptr.unique_ptr<FileSystemStatCache> StatCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getStatValue(char.ptr Path, int PathLen, FileData Data, boolean isFile, std_ptr.unique_ptr<File> F) {
        SmallString FilePath = null;
        try {
            if (this.FileSystemOpts.WorkingDir.empty()) {
                boolean bl = FileSystemStatCache.get(Path, PathLen, Data, isFile, F, (FileSystemStatCache)this.StatCache.get(), (FileSystem)((Object)this.FS.$star()));
                return bl;
            }
            FilePath = new SmallString(new StringRef(Path, PathLen), 128);
            this.FixupRelativePath((SmallVectorImplChar)FilePath);
            boolean bl = FileSystemStatCache.get(FilePath.c_str(), FilePath.size(), Data, isFile, F, (FileSystemStatCache)this.StatCache.get(), (FileSystem)((Object)this.FS.$star()));
            return bl;
        }
        finally {
            if (FilePath != null) {
                FilePath.$destroy();
            }
        }
    }

    private void addAncestorsAsVirtualDirs(StringRef Path) {
        StringRef DirName = path.parent_path((StringRef)Path);
        if (path.is_empty((StringRef)DirName)) {
            DirName = StringRef.R$DOT;
        }
        StringMapEntry NamedDirEnt = this.SeenDirEntries.GetOrCreateValue(DirName, (Object)null);
        if (NamedDirEnt.second != null && NamedDirEnt.second != NON_EXISTENT_DIR) {
            return;
        }
        std_ptr.unique_ptr UDE = llvm.make_unique((Object)new DirectoryEntry());
        ((DirectoryEntry)UDE.$arrow()).Name = Native.$noClone((char.ptr)NamedDirEnt.getKeyStr());
        ((DirectoryEntry)UDE.$arrow()).NameLen = NamedDirEnt.getKeyLength();
        NamedDirEnt.second = UDE.get();
        this.VirtualDirectoryEntries.push_back((Object)std.move((std_ptr.unique_ptr)UDE));
        this.addAncestorsAsVirtualDirs(DirName);
    }

    public FileManager(FileSystemOptions FSO) {
        this(FSO, (IntrusiveRefCntPtr<FileSystem>)new IntrusiveRefCntPtr((Object)((FileSystem)null)));
    }

    public FileManager(FileSystemOptions FSO, IntrusiveRefCntPtr<FileSystem> FS) {
        this.FS = new IntrusiveRefCntPtr(FS);
        this.FileSystemOpts = new FileSystemOptions(FSO);
        this.UniqueRealDirs = new std.map(fs.UniqueID.COMPARATOR, (Object)new DirectoryEntry());
        this.UniqueRealFiles = new std.map(fs.UniqueID.COMPARATOR, (Object)new FileEntry());
        this.VirtualDirectoryEntries = new SmallVector(4, (Object)new std_ptr.unique_ptr());
        this.VirtualFileEntries = new SmallVectorWithDestroy(4, (Object)new std_ptr.unique_ptr());
        this.SeenDirEntries = new StringMap(64, null);
        this.SeenFileEntries = new StringMap(64, null);
        this.CanonicalDirNames = new DenseMap(DirectoryEntry.DenseMapInfo, (Object)new StringRef());
        this.CanonicalNameStorage = new BumpPtrAllocatorImpl();
        this.NextFileUID = 0;
        this.StatCache = new std_ptr.unique_ptr();
        assert (this.NextFileUID != Integer.MIN_VALUE) : this.NextFileUID + "vs. " + Integer.MIN_VALUE;
        this.NumFileLookups = 0;
        this.NumDirLookups = 0;
        this.NumFileCacheMisses = 0;
        this.NumDirCacheMisses = 0;
        if (!FS.$bool()) {
            this.FS.$assign(VfsGlobals.getRealFileSystem());
        }
    }

    public void $destroy() {
        this.StatCache.$destroy();
        this.CanonicalNameStorage.$destroy();
        this.CanonicalDirNames.$destroy();
        this.SeenFileEntries.$destroy();
        this.SeenDirEntries.$destroy();
        this.VirtualFileEntries.$destroy();
        this.VirtualDirectoryEntries.$destroy();
        this.UniqueRealFiles.$destroy();
        this.UniqueRealDirs.$destroy();
        this.FileSystemOpts.$destroy();
        this.FS.$destroy();
    }

    public void addStatCache(std_ptr.unique_ptr<FileSystemStatCache> statCache) {
        this.addStatCache(statCache, false);
    }

    public void addStatCache(std_ptr.unique_ptr<FileSystemStatCache> statCache, boolean AtBeginning) {
        assert (statCache.$bool()) : "No stat cache provided?";
        if (AtBeginning || this.StatCache.get() == null) {
            ((FileSystemStatCache)statCache.$arrow()).setNextStatCache((std_ptr.unique_ptr<FileSystemStatCache>)new std_ptr.unique_ptr(std.move(this.StatCache)));
            this.StatCache.$assignMove(std.move(statCache));
            return;
        }
        FileSystemStatCache LastCache = (FileSystemStatCache)this.StatCache.get();
        while (LastCache.getNextStatCache() != null) {
            LastCache = LastCache.getNextStatCache();
        }
        LastCache.setNextStatCache((std_ptr.unique_ptr<FileSystemStatCache>)new std_ptr.unique_ptr(std.move(statCache)));
    }

    public void removeStatCache(FileSystemStatCache statCache) {
        FileSystemStatCache PrevCache;
        if (statCache == null) {
            return;
        }
        if (this.StatCache.get() == statCache) {
            this.StatCache.$assignMove(((FileSystemStatCache)this.StatCache.$arrow()).takeNextStatCache());
            return;
        }
        for (PrevCache = (FileSystemStatCache)this.StatCache.get(); PrevCache != null && PrevCache.getNextStatCache() != statCache; PrevCache = PrevCache.getNextStatCache()) {
        }
        assert (PrevCache != null) : "Stat cache not found for removal";
        PrevCache.setNextStatCache(statCache.takeNextStatCache());
    }

    public void clearStatCaches() {
        this.StatCache.reset();
    }

    public DirectoryEntry getDirectory(StringRef DirName) {
        return this.getDirectory(DirName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryEntry getDirectory(StringRef DirName, boolean CacheFailure) {
        FileData Data = null;
        try {
            if (DirName.size() > 1 && llvm.$noteq_StringRef((StringRef)DirName, (StringRef)path.root_path((StringRef)DirName)) && path.is_separator((byte)DirName.back())) {
                DirName.$assign$substr(0, DirName.size() - 1);
            }
            ++this.NumDirLookups;
            StringMapEntry NamedDirEnt = this.SeenDirEntries.GetOrCreateValue(DirName, (Object)null);
            if (NamedDirEnt.second != null) {
                DirectoryEntry directoryEntry = NamedDirEnt.second == NON_EXISTENT_DIR ? null : (DirectoryEntry)NamedDirEnt.second;
                return directoryEntry;
            }
            ++this.NumDirCacheMisses;
            NamedDirEnt.second = NON_EXISTENT_DIR;
            char.ptr InterndDirName = Native.$noClone((char.ptr)NamedDirEnt.getKeyStr());
            int InterndDirNameLen = NamedDirEnt.getKeyLength();
            assert (InterndDirNameLen == std.strlen((char.ptr)InterndDirName)) : "Invalid " + InterndDirNameLen + " for " + InterndDirName;
            assert (llvm.$eq_StringRef((StringRef)DirName, (StringRef)new StringRef(InterndDirName, InterndDirNameLen))) : "must be equal " + DirName + " vs. " + InterndDirName;
            Data = new FileData();
            if (this.getStatValue(InterndDirName, InterndDirNameLen, Data, false, null)) {
                if (!CacheFailure) {
                    this.SeenDirEntries.erase(DirName);
                }
                DirectoryEntry directoryEntry = null;
                return directoryEntry;
            }
            DirectoryEntry UDE = (DirectoryEntry)this.UniqueRealDirs.$at((Object)Data.UniqueID);
            if (UDE.Name != null) {
                if (!NORMALIZED_UID || llvm.$eq_RawStringRef((char.ptr)UDE.Name, (int)UDE.NameLen, (byte[])Data.Name.$array(), (int)0, (int)Data.Name.size())) {
                    NamedDirEnt.second = UDE;
                    DirectoryEntry directoryEntry = UDE;
                    return directoryEntry;
                }
                UDE = null;
            }
            StringMapEntry NormalizedDirEnt = NamedDirEnt;
            if (!llvm.$eq_RawStringRef((char.ptr)InterndDirName, (int)InterndDirNameLen, (byte[])Data.Name.$array(), (int)0, (int)Data.Name.size())) {
                NormalizedDirEnt = this.SeenDirEntries.GetOrCreateValue(Data.Name.$array(), 0, Data.Name.size());
                if (NormalizedDirEnt.second != null) {
                    if (UDE != null) assert (UDE.Name == null) : "expected uninitialized:" + UDE + " for " + this.UniqueRealDirs.find((Object)Data.UniqueID).$star();
                    UDE = (DirectoryEntry)NormalizedDirEnt.second;
                    assert (NormalizedDirEnt.second != this.UniqueRealDirs.$at((Object)Data.UniqueID)) : "must be different:\n" + NormalizedDirEnt + "\nvs.\n" + this.UniqueRealDirs.$at((Object)Data.UniqueID) + "\n when query for " + DirName;
                    this.UniqueRealDirs.replaceValueReference((Object)Data.UniqueID, (Object)UDE);
                    assert (this.UniqueRealDirs.$at((Object)Data.UniqueID) == NormalizedDirEnt.second) : "incorrect reference replacement " + this.UniqueRealDirs.find((Object)Data.UniqueID).$star() + "\nvs.\n" + NormalizedDirEnt;
                    assert (UDE.Name != null) : "must be initialized " + NormalizedDirEnt;
                    NamedDirEnt.second = UDE;
                    DirectoryEntry directoryEntry = UDE;
                    return directoryEntry;
                }
                InterndDirName = Native.$noClone((char.ptr)NormalizedDirEnt.getKeyData());
                InterndDirNameLen = NormalizedDirEnt.getKeyLength();
            }
            assert (NormalizedDirEnt.second == null || NormalizedDirEnt == NamedDirEnt);
            if (UDE == null) {
                UDE = new DirectoryEntry();
            }
            NormalizedDirEnt.second = UDE;
            NamedDirEnt.second = UDE;
            assert (UDE.Name == null) : "expected uninitialized:" + UDE + " for " + NormalizedDirEnt;
            UDE.Name = Native.$noClone((char.ptr)InterndDirName);
            UDE.NameLen = InterndDirNameLen;
            assert (llvm.$eq_StringRef((std.string)Data.Name, (StringRef)new StringRef(UDE.Name))) : "want to use normalized dir path " + Data.Name + " vs. " + UDE.Name + " for " + UDE;
            DirectoryEntry directoryEntry = UDE;
            return directoryEntry;
        }
        finally {
            if (Data != null) {
                Data.$destroy();
            }
        }
    }

    public FileEntry getFile(StringRef Filename) {
        return this.getFile(Filename, false, true);
    }

    public FileEntry getFile(StringRef Filename, boolean openFile) {
        return this.getFile(Filename, openFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry getFile(StringRef Filename, boolean openFile, boolean CacheFailure) {
        std_ptr.unique_ptr F = null;
        FileData Data = null;
        try {
            ErrorOr<std.string> RealPathName;
            ++this.NumFileLookups;
            StringMapEntry NamedFileEnt = this.SeenFileEntries.GetOrCreateValue(Filename, (Object)null);
            if (NamedFileEnt.second != null) {
                FileEntry fileEntry = NamedFileEnt.second == NON_EXISTENT_FILE ? null : (FileEntry)NamedFileEnt.second;
                return fileEntry;
            }
            ++this.NumFileCacheMisses;
            NamedFileEnt.second = NON_EXISTENT_FILE;
            char.ptr InterndFileName = Native.$noClone((char.ptr)NamedFileEnt.getKeyStr());
            int InterndFileNameLen = NamedFileEnt.getKeyLength();
            assert (InterndFileNameLen == std.strlen((char.ptr)InterndFileName)) : "Invalid " + InterndFileNameLen + " for " + InterndFileName;
            assert (llvm.$eq_StringRef((StringRef)Filename, (StringRef)new StringRef(InterndFileName, InterndFileNameLen))) : "must be equal " + Filename + " vs. " + InterndFileNameLen;
            DirectoryEntry DirInfo = FileManagerStatics.getDirectoryFromFile(this, Filename, CacheFailure);
            if (DirInfo == null) {
                if (!CacheFailure) {
                    this.SeenFileEntries.erase(Filename);
                }
                FileEntry fileEntry = null;
                return fileEntry;
            }
            F = new std_ptr.unique_ptr();
            Data = new FileData();
            if (this.getStatValue(InterndFileName, InterndFileNameLen, Data, true, (std_ptr.unique_ptr<File>)(openFile ? F : null))) {
                if (!CacheFailure) {
                    this.SeenFileEntries.erase(Filename);
                }
                FileEntry fileEntry = null;
                return fileEntry;
            }
            assert (openFile || !F.$bool()) : "undesired open file";
            FileEntry UFE = (FileEntry)this.UniqueRealFiles.$at((Object)Data.UniqueID);
            if (UFE.isValid()) {
                if (!NORMALIZED_UID || llvm.$eq_RawStringRef((char.ptr)UFE.Name, (int)UFE.NameLen, (byte[])Data.Name.$array(), (int)0, (int)Data.Name.size())) {
                    NamedFileEnt.second = UFE;
                    FileEntry fileEntry = UFE;
                    return fileEntry;
                }
                UFE = null;
            }
            StringMapEntry NormalizedFileEnt = NamedFileEnt;
            if (!llvm.$eq_RawStringRef((char.ptr)InterndFileName, (int)InterndFileNameLen, (byte[])Data.Name.$array(), (int)0, (int)Data.Name.size())) {
                NormalizedFileEnt = this.SeenFileEntries.GetOrCreateValue(Data.Name.$array(), 0, Data.Name.size());
                if (NormalizedFileEnt.second != null) {
                    assert (UFE == null) : "must be cleared in the check above";
                    UFE = (FileEntry)NormalizedFileEnt.second;
                    assert (UFE != this.UniqueRealFiles.$at((Object)Data.UniqueID)) : "must be different:\n" + NormalizedFileEnt + "\nvs.\n" + this.UniqueRealFiles.$at((Object)Data.UniqueID) + "\n when query for " + Filename;
                    assert (UFE.Name != null) : "must be initialized " + NormalizedFileEnt;
                    NamedFileEnt.second = UFE;
                    FileEntry fileEntry = UFE;
                    return fileEntry;
                }
                InterndFileName = Native.$noClone((char.ptr)NormalizedFileEnt.getKeyData());
                InterndFileNameLen = NormalizedFileEnt.getKeyLength();
            }
            assert (NormalizedFileEnt.second == null || NormalizedFileEnt == NamedFileEnt);
            if (UFE == null) {
                UFE = new FileEntry();
            }
            NormalizedFileEnt.second = UFE;
            NamedFileEnt.second = UFE;
            assert (!UFE.isValid()) : "expected uninitialized:" + UFE + " for " + NormalizedFileEnt;
            assert (UFE.UID == Integer.MIN_VALUE) : "UID must be assigned only once " + UFE;
            UFE.Name = Native.$noClone((char.ptr)InterndFileName);
            UFE.NameLen = InterndFileNameLen;
            UFE.Size = Data.Size;
            UFE.ModTime = Data.ModTime;
            UFE.Dir = DirInfo;
            UFE.UID = this.NextFileUID++;
            UFE.UniqueID.$assign(Data.UniqueID);
            UFE.IsNamedPipe = Data.IsNamedPipe;
            UFE.InPCH = Data.InPCH;
            UFE.File.$assignMove(std.move((std_ptr.unique_ptr)F));
            UFE.IsValid = true;
            if (UFE.File.$bool() && (RealPathName = ((File)UFE.File.$arrow()).getName()).$bool()) {
                UFE.RealPathName.$assign((std.string)RealPathName.$star());
            }
            assert (llvm.$eq_StringRef((std.string)Data.Name, (StringRef)new StringRef(UFE.Name))) : "want to use normalized file path " + Data.Name + " vs. " + UFE.Name + " for " + UFE;
            FileEntry fileEntry = UFE;
            return fileEntry;
        }
        finally {
            if (Data != null) {
                Data.$destroy();
            }
            if (F != null) {
                F.$destroy();
            }
        }
    }

    public FileSystemOptions getFileSystemOpts() {
        return this.FileSystemOpts;
    }

    public IntrusiveRefCntPtr<FileSystem> getVirtualFileSystem() {
        return new IntrusiveRefCntPtr(this.FS);
    }

    public final FileSystem $getVirtualFileSystem() {
        return (FileSystem)((Object)this.FS.$star());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry getVirtualFile(StringRef Filename, long Size, long ModificationTime) {
        FileData Data = null;
        try {
            int InterndFileNameLen;
            ++this.NumFileLookups;
            StringMapEntry NamedFileEnt = this.SeenFileEntries.GetOrCreateValue(Filename, (Object)null);
            if (NamedFileEnt.second != null && NamedFileEnt.second != NON_EXISTENT_FILE) {
                FileEntry fileEntry = (FileEntry)NamedFileEnt.second;
                return fileEntry;
            }
            ++this.NumFileCacheMisses;
            NamedFileEnt.second = NON_EXISTENT_FILE;
            this.addAncestorsAsVirtualDirs(Filename);
            FileEntry UFE = null;
            DirectoryEntry DirInfo = FileManagerStatics.getDirectoryFromFile(this, Filename, true);
            assert (DirInfo != null) : "The directory of a virtual file should already be in the cache.";
            Data = new FileData();
            char.ptr InterndFileName = Native.$noClone((char.ptr)NamedFileEnt.getKeyStr());
            if (!this.getStatValue(InterndFileName, InterndFileNameLen = NamedFileEnt.getKeyLength(), Data, true, null)) {
                assert (llvm.$eq_StringRef((std.string)Data.Name, (StringRef)new StringRef(InterndFileName, InterndFileNameLen))) : "virtual file path must be normalized " + Filename + " vs. " + Data;
                Data.Size = Size;
                Data.ModTime = ModificationTime;
                UFE = (FileEntry)this.UniqueRealFiles.$at((Object)Data.UniqueID);
                NamedFileEnt.second = UFE;
                if (UFE.File.$bool()) {
                    UFE.closeFile();
                }
                if (UFE.isValid()) {
                    FileEntry fileEntry = UFE;
                    return fileEntry;
                }
                UFE.UniqueID.$assign(Data.UniqueID);
                UFE.IsNamedPipe = Data.IsNamedPipe;
                UFE.InPCH = Data.InPCH;
            }
            if (UFE == null) {
                this.VirtualFileEntries.push_back((Object)llvm.make_unique((Object)new FileEntry()));
                UFE = (FileEntry)((std_ptr.unique_ptr)this.VirtualFileEntries.back()).get();
                NamedFileEnt.second = UFE;
            }
            assert (UFE.UID == Integer.MIN_VALUE) : "UID must be assigned only once " + UFE;
            UFE.Name = Native.$noClone((char.ptr)InterndFileName);
            UFE.NameLen = InterndFileNameLen;
            UFE.Size = Size;
            UFE.ModTime = ModificationTime;
            UFE.Dir = DirInfo;
            UFE.UID = this.NextFileUID++;
            UFE.File.reset();
            UFE.IsValid = true;
            FileEntry fileEntry = UFE;
            return fileEntry;
        }
        finally {
            if (Data != null) {
                Data.$destroy();
            }
        }
    }

    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBufferForFile(FileEntry Entry2) {
        return this.getBufferForFile(Entry2, false, true);
    }

    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBufferForFile(FileEntry Entry2, boolean isVolatile) {
        return this.getBufferForFile(Entry2, isVolatile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBufferForFile(FileEntry Entry2, boolean isVolatile, boolean ShouldCloseOpenFile) {
        SmallString FilePath = null;
        try {
            long FileSize = Entry2.getSize();
            if (isVolatile) {
                FileSize = -1L;
            }
            char.ptr Filename = Native.$noClone((char.ptr)Entry2.getName());
            if (Entry2.File.$bool()) {
                ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> Result = ((File)Entry2.File.$arrow()).getBuffer(new Twine(Filename), FileSize, true, isVolatile);
                if (ShouldCloseOpenFile) {
                    Entry2.closeFile();
                }
                ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = Result;
                return errorOr;
            }
            if (this.FileSystemOpts.WorkingDir.empty()) {
                ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = ((FileSystem)((Object)this.FS.$arrow())).getBufferForFile(new Twine(Filename), FileSize, true, isVolatile);
                return errorOr;
            }
            FilePath = new SmallString(new StringRef(Entry2.getName()), 128);
            this.FixupRelativePath((SmallVectorImplChar)FilePath);
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = ((FileSystem)((Object)this.FS.$arrow())).getBufferForFile(new Twine(FilePath), FileSize, true, isVolatile);
            return errorOr;
        }
        finally {
            if (FilePath != null) {
                FilePath.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBufferForFile(StringRef Filename) {
        SmallString FilePath = null;
        try {
            if (this.FileSystemOpts.WorkingDir.empty()) {
                ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = ((FileSystem)((Object)this.FS.$arrow())).getBufferForFile(new Twine(Filename));
                return errorOr;
            }
            FilePath = new SmallString(Filename, 128);
            this.FixupRelativePath((SmallVectorImplChar)FilePath);
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> errorOr = ((FileSystem)((Object)this.FS.$arrow())).getBufferForFile(new Twine(FilePath.c_str()));
            return errorOr;
        }
        finally {
            if (FilePath != null) {
                FilePath.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getNoncachedStatValue(StringRef Path, Status Result) {
        SmallString FilePath = null;
        try {
            FilePath = new SmallString(Path, 128);
            this.FixupRelativePath((SmallVectorImplChar)FilePath);
            ErrorOr<Status> S = ((FileSystem)((Object)this.FS.$arrow())).status(new Twine(FilePath.c_str()));
            if (!S.$bool()) {
                boolean bl = true;
                return bl;
            }
            Result.$assign((Status)S.$star());
            boolean bl = false;
            return bl;
        }
        finally {
            if (FilePath != null) {
                FilePath.$destroy();
            }
        }
    }

    public void invalidateCache(FileEntry Entry2) {
        assert (Entry2 != null) : "Cannot invalidate a NULL FileEntry";
        this.SeenFileEntries.erase(new StringRef(Entry2.getName()));
        this.UniqueRealFiles.erase((Object)Entry2.getUniqueID());
    }

    public boolean FixupRelativePath(SmallVectorImplChar path2) {
        StringRef pathRef = new StringRef(path2.data(), path2.size());
        if (this.FileSystemOpts.WorkingDir.empty() || path.is_absolute((StringRef)pathRef)) {
            return false;
        }
        SmallString NewPath = new SmallString(new StringRef(this.FileSystemOpts.WorkingDir), 128);
        path.append((SmallString)NewPath, (StringRef)pathRef);
        path2.$assign((SmallVectorImplChar)NewPath);
        return true;
    }

    public boolean makeAbsolutePath(SmallString Path) {
        boolean Changed = this.FixupRelativePath((SmallVectorImplChar)Path);
        if (!path.is_absolute((Twine)new Twine(new StringRef(Path.data(), Path.size())))) {
            fs.make_absolute((SmallString)Path);
            Changed = true;
        }
        return Changed;
    }

    public void GetUniqueIDMapping(SmallVectorImpl<FileEntry> UIDToFiles) {
        UIDToFiles.clear();
        UIDToFiles.resize(this.NextFileUID);
        StringMapIterator FE = this.SeenFileEntries.begin();
        StringMapIterator FEEnd = this.SeenFileEntries.end();
        while (FE.$noteq((StringMapConstIterator)FEEnd)) {
            if (FE.$arrow().getValue() != null && FE.$arrow().getValue() != NON_EXISTENT_FILE) {
                UIDToFiles.$set(((FileEntry)FE.$arrow().getValue()).getUID(), FE.$arrow().getValue());
            }
            FE.$preInc();
        }
        for (std_ptr.unique_ptr VFE : this.VirtualFileEntries) {
            if (!VFE.$bool() || VFE.get() == NON_EXISTENT_FILE) continue;
            UIDToFiles.$set(((FileEntry)VFE.$arrow()).getUID(), VFE.get());
        }
    }

    public static void modifyFileEntry(FileEntry File2, long Size, long ModificationTime) {
        File2.Size = Size;
        File2.ModTime = ModificationTime;
    }

    public StringRef getCanonicalName(DirectoryEntry Dir) {
        DenseMapIterator Known = this.CanonicalDirNames.find((Object)Dir);
        if (Known.$noteq(this.CanonicalDirNames.end())) {
            return (StringRef)Known.$star().second;
        }
        StringRef CanonicalName = new StringRef(Dir.getName(), Dir.getNameLen());
        byte[] CanonicalNameBuf = NativePointer.new$char((int)4096, (byte[])new byte[0]);
        if (std.realpath((char.ptr)Dir.getName(), (byte[])CanonicalNameBuf) != null) {
            CanonicalName.$assignMove(new StringRef(CanonicalNameBuf).copy((NativeMemory.Allocator)this.CanonicalNameStorage));
        }
        this.CanonicalDirNames.insert(std.make_pair((Object)Dir, (Object)CanonicalName));
        return CanonicalName;
    }

    public void PrintStats() {
        llvm.errs().$out(NativePointer.$((String)"\n*** File Manager Stats:\n"));
        llvm.errs().$out_ulong((long)this.UniqueRealFiles.size()).$out(NativePointer.$((String)" real files found, ")).$out_ulong((long)this.UniqueRealDirs.size()).$out(NativePointer.$((String)" real dirs found.\n"));
        llvm.errs().$out_ulong((long)this.VirtualFileEntries.size()).$out(NativePointer.$((String)" virtual files found, ")).$out_ulong((long)this.VirtualDirectoryEntries.size()).$out(NativePointer.$((String)" virtual dirs found.\n"));
        llvm.errs().$out_uint(this.NumDirLookups).$out(NativePointer.$((String)" dir lookups, ")).$out_uint(this.NumDirCacheMisses).$out(NativePointer.$((String)" dir cache misses.\n"));
        llvm.errs().$out_uint(this.NumFileLookups).$out(NativePointer.$((String)" file lookups, ")).$out_uint(this.NumFileCacheMisses).$out(NativePointer.$((String)" file cache misses.\n"));
    }

    public String toString() {
        return "FS=" + this.FS + ", FileSystemOpts=" + this.FileSystemOpts + ", UniqueRealDirs=" + this.UniqueRealDirs + ", UniqueRealFiles=" + this.UniqueRealFiles + ", VirtualDirectoryEntries=" + this.VirtualDirectoryEntries + ", VirtualFileEntries=" + this.VirtualFileEntries + ", SeenDirEntries=" + this.SeenDirEntries + ", SeenFileEntries=" + this.SeenFileEntries + ", CanonicalDirNames=" + this.CanonicalDirNames + ", CanonicalNameStorage=" + this.CanonicalNameStorage + ", NextFileUID=" + this.NextFileUID + ", NumDirLookups=" + this.NumDirLookups + ", NumFileLookups=" + this.NumFileLookups + ", NumDirCacheMisses=" + this.NumDirCacheMisses + ", NumFileCacheMisses=" + this.NumFileCacheMisses + ", StatCache=" + this.StatCache + super.toString();
    }
}

