/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FileObjects;

public class CachingPathArchive
implements Archive {
    private static final int[] EMPTY_FOLDER = new int[0];
    private static final byte[] EMPTY_NAMES = new byte[0];
    private final Path root;
    private final String rootURI;
    private final char separator;
    private Map<String, int[]> data;
    private byte[] packedNames;
    private int nameIndex;

    CachingPathArchive(@NonNull Path root, @NullAllowed URI rootURI) {
        assert (root != null);
        this.root = root;
        this.rootURI = rootURI == null ? null : rootURI.toString();
        String sep = root.getFileSystem().getSeparator();
        if (sep.length() != 1) {
            throw new IllegalArgumentException("Multi character separators are unsupported");
        }
        this.separator = sep.charAt(0);
        this.packedNames = EMPTY_NAMES;
    }

    @Override
    @NonNull
    public synchronized Iterable<JavaFileObject> getFiles(@NonNull String folderName, @NullAllowed ClassPath.Entry entry, @NullAllowed Set<JavaFileObject.Kind> kinds, @NullAllowed JavaFileFilterImplementation filter) throws IOException {
        this.init();
        int[] pkgContent = this.data.get(folderName);
        if (pkgContent == null || pkgContent == EMPTY_FOLDER) {
            return Collections.emptyList();
        }
        ArrayList<JavaFileObject> res = new ArrayList<JavaFileObject>(pkgContent.length >>> 1);
        for (int i = 0; i < pkgContent.length; i += 2) {
            String name = this.getName(pkgContent[i], pkgContent[i + 1]);
            if (kinds != null && !kinds.contains((Object)FileObjects.getKind(FileObjects.getExtension(name)))) continue;
            res.add(FileObjects.pathFileObject(folderName, name, this.root, this.rootURI, null));
        }
        return res;
    }

    @Override
    @CheckForNull
    public synchronized JavaFileObject getFile(@NonNull String name) throws IOException {
        this.init();
        String[] fnPair = FileObjects.getFolderAndBaseName(name, '/');
        int[] pkgContent = this.data.get(fnPair[0]);
        if (pkgContent != null) {
            for (int i = 0; i < pkgContent.length; i += 2) {
                String baseName = this.getName(pkgContent[i], pkgContent[i + 1]);
                if (!fnPair[1].equals(baseName)) continue;
                return FileObjects.pathFileObject(fnPair[0], fnPair[1], this.root, this.rootURI, null);
            }
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.data = null;
        this.packedNames = EMPTY_NAMES;
        this.nameIndex = 0;
    }

    @Override
    public JavaFileObject create(String relativeName, JavaFileFilterImplementation filter) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Write not supported");
    }

    private int putName(@NonNull byte[] name) {
        if (this.packedNames.length < this.nameIndex + name.length) {
            this.packedNames = Arrays.copyOfRange(this.packedNames, 0, name.length + this.packedNames.length << 1);
        }
        int start = this.nameIndex;
        System.arraycopy(name, 0, this.packedNames, start, name.length);
        this.nameIndex += name.length;
        return start;
    }

    private String getName(int start, int len) {
        try {
            return new String(this.packedNames, start, len, "UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            throw new IllegalStateException(ue);
        }
    }

    @NonNull
    private String getResourceName(@NonNull Path path) {
        return this.root.relativize(path).toString().replace(this.separator, '/');
    }

    private void init() throws IOException {
        assert (Thread.holdsLock(this));
        if (this.data == null) {
            this.data = new HashMap<String, int[]>();
            Files.walkFileTree(this.root, (FileVisitor<? super Path>)new FileVisitor<Path>(){
                private final Deque<State> states = new ArrayDeque<State>();

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.states.offer(new State());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    State state = this.states.getLast();
                    int[] cf = state.currentFolder;
                    int co = state.currentOffset;
                    if (cf.length < co + 2) {
                        cf = state.currentFolder = Arrays.copyOfRange(cf, 0, 2 + cf.length << 1);
                    }
                    byte[] name = file.getFileName().toString().getBytes("UTF-8");
                    cf[co] = CachingPathArchive.this.putName(name);
                    cf[co + 1] = name.length;
                    state.currentOffset += 2;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    State state = this.states.removeLast();
                    if (state.currentFolder != EMPTY_FOLDER) {
                        CachingPathArchive.this.data.put(CachingPathArchive.this.getResourceName(dir), Arrays.copyOfRange(state.currentFolder, 0, state.currentOffset));
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            this.packedNames = Arrays.copyOfRange(this.packedNames, 0, this.nameIndex);
        }
    }

    private static class State {
        int[] currentFolder = CachingPathArchive.access$100();
        int currentOffset;

        State() {
        }
    }
}

