/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.problems;

import java.util.Objects;
import java.util.concurrent.Future;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.problems.Done;
import org.netbeans.modules.javascript.nodejs.ui.customizer.NodeJsCustomizerProvider;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;

public class CustomizerProblemResolver
implements ProjectProblemResolver {
    private final Project project;
    private final String ident;
    private final ValidationResult result;
    private final String category;

    CustomizerProblemResolver(Project project, String ident, ValidationResult result) {
        this(project, ident, result, null);
    }

    CustomizerProblemResolver(Project project, String ident, String category) {
        this(project, ident, null, category);
    }

    private CustomizerProblemResolver(Project project, String ident, ValidationResult result, String category) {
        assert (project != null);
        assert (ident != null);
        this.project = project;
        this.ident = ident;
        this.result = result;
        this.category = category;
    }

    public Future<ProjectProblemsProvider.Result> resolve() {
        if (this.result != null) {
            NodeJsCustomizerProvider.openCustomizer(this.project, this.result);
        } else {
            assert (this.category != null);
            NodeJsCustomizerProvider.openCustomizer(this.project, this.category);
        }
        return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + Objects.hashCode(this.project);
        hash = 83 * hash + Objects.hashCode(this.ident);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomizerProblemResolver other = (CustomizerProblemResolver)obj;
        if (!Objects.equals(this.project, other.project)) {
            return false;
        }
        return Objects.equals(this.ident, other.ident);
    }
}

