/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AbstractDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ListeningDICookie;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.modules.debugger.jpda.util.Operator;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public class StartActionProvider
extends ActionsProvider
implements Cancellable {
    private static final Logger logger = Logger.getLogger(StartActionProvider.class.getName());
    private static int jdiTrace;
    private final JPDADebuggerImpl debuggerImpl;
    private final ContextProvider lookupProvider;
    private Thread startingThread;
    private final Object startingThreadLock = new Object();

    public StartActionProvider(ContextProvider lookupProvider) {
        this.debuggerImpl = (JPDADebuggerImpl)((Object)lookupProvider.lookupFirst(null, JPDADebugger.class));
        this.lookupProvider = lookupProvider;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_START);
    }

    public void doAction(Object action) {
        logger.fine("S StartActionProvider.doAction ()");
        JPDADebuggerImpl debugger = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class));
        if (debugger != null && debugger.getVirtualMachine() != null) {
            return;
        }
        logger.fine("S StartActionProvider.doAction () setStarting");
        this.debuggerImpl.setStarting();
        AbstractDICookie cookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        this.doStartDebugger(cookie);
        logger.fine("S StartActionProvider.doAction () end");
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        logger.fine("S StartActionProvider.postAction ()");
        JPDADebuggerImpl debugger = (JPDADebuggerImpl)((Object)this.lookupProvider.lookupFirst(null, JPDADebugger.class));
        if (debugger != null && debugger.getVirtualMachine() != null) {
            actionPerformedNotifier.run();
            return;
        }
        final AbstractDICookie cookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
        logger.fine("S StartActionProvider.postAction () setStarting");
        this.debuggerImpl.setStarting();
        logger.fine("S StartActionProvider.postAction () setStarting end");
        this.debuggerImpl.getRequestProcessor().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = StartActionProvider.this.startingThreadLock;
                synchronized (object) {
                    StartActionProvider.this.startingThread = Thread.currentThread();
                }
                try {
                    StartActionProvider.this.doStartDebugger(cookie);
                }
                finally {
                    object = StartActionProvider.this.startingThreadLock;
                    synchronized (object) {
                        StartActionProvider.this.startingThread = null;
                        StartActionProvider.this.startingThreadLock.notifyAll();
                    }
                    actionPerformedNotifier.run();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartDebugger(AbstractDICookie cookie) {
        logger.fine("S StartActionProvider.doStartDebugger");
        Throwable throwable = null;
        try {
            this.debuggerImpl.setAttaching(cookie);
            VirtualMachine virtualMachine = cookie.getVirtualMachine();
            this.debuggerImpl.setAttaching(null);
            VirtualMachineWrapper.setDebugTraceMode(virtualMachine, jdiTrace);
            Object startLock = new Object();
            Operator o = this.createOperator(virtualMachine, startLock);
            Object object = startLock;
            synchronized (object) {
                logger.fine("S StartActionProvider.doAction () - starting operator thread");
                o.start();
                if (cookie instanceof ListeningDICookie) {
                    startLock.wait(1500L);
                }
            }
            this.debuggerImpl.setRunning(virtualMachine, o);
            logger.fine("S StartActionProvider.doStartDebugger end: success");
        }
        catch (InterruptedException iex) {
            throwable = iex;
        }
        catch (IOException ioex) {
            throwable = ioex;
        }
        catch (Exception ex) {
            throwable = ex;
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Error err) {
            throwable = err;
            Exceptions.printStackTrace((Throwable)err);
        }
        if (throwable != null) {
            logger.log(Level.FINE, "S StartActionProvider.doAction ().thread end: threw {0}", throwable);
            this.debuggerImpl.setException(throwable);
            final Session session = (Session)this.lookupProvider.lookupFirst(null, Session.class);
            this.debuggerImpl.getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    session.kill();
                }
            });
        }
    }

    public boolean isEnabled(Object action) {
        return true;
    }

    public void addActionsProviderListener(ActionsProviderListener l) {
    }

    public void removeActionsProviderListener(ActionsProviderListener l) {
    }

    private Operator createOperator(VirtualMachine virtualMachine, final Object startLock) {
        return new Operator(virtualMachine, this.debuggerImpl, new Executor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean exec(Event event) {
                Object object = startLock;
                synchronized (object) {
                    startLock.notify();
                }
                return false;
            }

            @Override
            public void removed(EventRequest eventRequest) {
            }
        }, new Runnable(){

            @Override
            public void run() {
                StartActionProvider.this.debuggerImpl.finish();
            }
        }, this.debuggerImpl.accessLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        Object object = this.startingThreadLock;
        synchronized (object) {
            logger.log(Level.FINE, "StartActionProvider.cancel(): startingThread = {0}", this.startingThread);
            for (int i = 0; i < 10; ++i) {
                if (this.startingThread != null) {
                    logger.log(Level.FINE, "Interrupting {0}", this.startingThread);
                    this.startingThread.interrupt();
                    boolean cancelInterrupted = false;
                    try {
                        this.startingThreadLock.wait(500L);
                    }
                    catch (InterruptedException iex) {
                        cancelInterrupted = true;
                    }
                    AbstractDICookie cookie = (AbstractDICookie)this.lookupProvider.lookupFirst(null, AbstractDICookie.class);
                    logger.log(Level.FINE, "Listening cookie = {0}, is listening = {1}", new Object[]{cookie, cookie instanceof ListeningDICookie});
                    if (cookie instanceof ListeningDICookie) {
                        ListeningDICookie lc = (ListeningDICookie)cookie;
                        try {
                            lc.getListeningConnector().stopListening(lc.getArgs());
                        }
                        catch (IOException iOException) {
                        }
                        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
                            // empty catch block
                        }
                    }
                    if (!cancelInterrupted) continue;
                    return false;
                }
                return true;
            }
            return this.startingThread == null;
        }
    }

    static {
        if (System.getProperty("netbeans.debugger.jditrace") != null) {
            try {
                jdiTrace = Integer.parseInt(System.getProperty("netbeans.debugger.jditrace"));
            }
            catch (NumberFormatException ex) {
                jdiTrace = 0;
            }
        } else {
            jdiTrace = 0;
        }
    }
}

