/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.html.editor.refactoring.api.ExtractInlinedStyleRefactoring;
import org.netbeans.modules.html.editor.refactoring.api.SelectorType;
import org.openide.util.WeakListeners;

public class HtmlPreferences {
    private static boolean autocompleQuotesAfterEQS;
    private static boolean autocompleQuotes;
    public static boolean completionOffersEndTagAfterLt;
    private static boolean autoPopupCompletionWindow;
    private static boolean autoPopupEndTagAutoCompletion;
    private static SelectorType selectorType;
    private static final String SELECTOR_TYPE_PROPERTY_NAME = "extractInlinedStylePanelSelectorType";
    private static SelectorType SELECTOR_TYPE_DEFAULT;
    private static ExtractInlinedStyleRefactoring.Mode sectionMode;
    private static final String SECTION_MODE_PROPERTY_NAME = "extractInlinedStylePanelSectionMode";
    private static ExtractInlinedStyleRefactoring.Mode SECTION_MODE_DEFAULT;
    private static String mimetypesWithEnabledHtmlErrorChecking;
    private static final String mimetypesWithEnabledHtmlErrorChecking_key = "mimetypesWithEnabledHtmlErrorChecking";
    private static String mimetypesWithEnabledHtmlErrorChecking_default;
    private static String mimetypesDelimiter;
    private static AtomicBoolean initialized;
    private static Preferences preferences;
    private static final PreferenceChangeListener preferencesTracker;

    private static void lazyIntialize() {
        if (initialized.compareAndSet(false, true)) {
            preferences = (Preferences)MimeLookup.getLookup((String)"text/html").lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)preferencesTracker, (Object)preferences));
            preferencesTracker.preferenceChange(null);
        }
    }

    private HtmlPreferences() {
    }

    public static boolean autocompleteQuotesAfterEqualSign() {
        HtmlPreferences.lazyIntialize();
        return autocompleQuotesAfterEQS;
    }

    public static boolean autocompleteQuotes() {
        HtmlPreferences.lazyIntialize();
        return autocompleQuotes;
    }

    public static boolean completionOffersEndTagAfterLt() {
        HtmlPreferences.lazyIntialize();
        return completionOffersEndTagAfterLt;
    }

    public static boolean autoPopupCompletionWindow() {
        HtmlPreferences.lazyIntialize();
        return autoPopupCompletionWindow;
    }

    public static boolean autoPopupEndTagAutoCompletion() {
        HtmlPreferences.lazyIntialize();
        return autoPopupEndTagAutoCompletion;
    }

    public static SelectorType extractInlinedStylePanelSelectorType() {
        HtmlPreferences.lazyIntialize();
        return selectorType;
    }

    public static void setExtractInlinedStylePanelSelectorType(SelectorType type) {
        HtmlPreferences.lazyIntialize();
        preferences.put(SELECTOR_TYPE_PROPERTY_NAME, type.name());
    }

    public static ExtractInlinedStyleRefactoring.Mode extractInlinedStylePanelSectionMode() {
        HtmlPreferences.lazyIntialize();
        return sectionMode;
    }

    public static void setExtractInlinedStylePanelSectionMode(ExtractInlinedStyleRefactoring.Mode mode) {
        HtmlPreferences.lazyIntialize();
        preferences.put(SECTION_MODE_PROPERTY_NAME, mode.name());
    }

    public static Collection<String> getMimetypesWithEnabledHtmlErrorChecking() {
        HtmlPreferences.lazyIntialize();
        return HtmlPreferences.getMimetypesWithEnabledHtmlErrorCheckingAsCollection();
    }

    public static boolean isHtmlErrorCheckingEnabledForMimetype(String mimetype) {
        boolean result = HtmlPreferences.getMimetypesWithEnabledHtmlErrorChecking().contains(mimetype);
        return HtmlPreferences.isHtmlMimeType(mimetype) ? !result : result;
    }

    public static void setHtmlErrorChecking(String mimetype, boolean enabled) {
        HtmlPreferences.lazyIntialize();
        Collection<String> mimescol = HtmlPreferences.getMimetypesWithEnabledHtmlErrorCheckingAsCollection();
        boolean html = HtmlPreferences.isHtmlMimeType(mimetype);
        if (html) {
            boolean bl = enabled = !enabled;
        }
        if (mimescol.contains(mimetype)) {
            if (enabled) {
                return;
            }
            mimescol.remove(mimetype);
        } else if (enabled) {
            mimescol.add(mimetype);
        } else {
            return;
        }
        preferences.put(mimetypesWithEnabledHtmlErrorChecking_key, HtmlPreferences.encodeMimetypes(mimescol));
    }

    private static boolean isHtmlMimeType(String mimetype) {
        return "text/html".equals(mimetype) || "text/xhtml".equals(mimetype);
    }

    private static String encodeMimetypes(Collection<String> mimes) {
        StringBuilder b = new StringBuilder();
        for (String m : mimes) {
            b.append(m);
            b.append(mimetypesDelimiter);
        }
        return b.toString();
    }

    private static Collection<String> getMimetypesWithEnabledHtmlErrorCheckingAsCollection() {
        HtmlPreferences.lazyIntialize();
        ArrayList<String> list = new ArrayList<String>();
        if (mimetypesWithEnabledHtmlErrorChecking == null) {
            return Collections.emptyList();
        }
        list.addAll(Arrays.asList(mimetypesWithEnabledHtmlErrorChecking.split(mimetypesDelimiter)));
        return list;
    }

    static {
        SELECTOR_TYPE_DEFAULT = SelectorType.ID;
        SECTION_MODE_DEFAULT = ExtractInlinedStyleRefactoring.Mode.refactorToExistingEmbeddedSection;
        mimetypesWithEnabledHtmlErrorChecking_default = "";
        mimetypesDelimiter = ";";
        initialized = new AtomicBoolean(false);
        preferencesTracker = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                String settingName;
                String string = settingName = evt == null ? null : evt.getKey();
                if (settingName == null || "htmlAutocompleteQuotesAfterEQS".equals(settingName)) {
                    autocompleQuotesAfterEQS = preferences.getBoolean("htmlAutocompleteQuotesAfterEQS", true);
                }
                if (settingName == null || "htmlAutocompleteQuotes".equals(settingName)) {
                    autocompleQuotes = preferences.getBoolean("htmlAutocompleteQuotes", true);
                }
                if (settingName == null || "htmlCompletionOffersEndTagsAfterLt".equals(settingName)) {
                    completionOffersEndTagAfterLt = preferences.getBoolean("htmlCompletionOffersEndTagsAfterLt", false);
                }
                if (settingName == null || "htmlCompletionAutoPopupWindow".equals(settingName)) {
                    autoPopupCompletionWindow = preferences.getBoolean("htmlCompletionAutoPopupWindow", true);
                }
                if (settingName == null || "htmlEndTagAutocompletionAutopopup".equals(settingName)) {
                    autoPopupEndTagAutoCompletion = preferences.getBoolean("htmlEndTagAutocompletionAutopopup", true);
                }
                if (settingName == null || HtmlPreferences.SELECTOR_TYPE_PROPERTY_NAME.equals(settingName)) {
                    selectorType = SelectorType.valueOf(preferences.get(HtmlPreferences.SELECTOR_TYPE_PROPERTY_NAME, SELECTOR_TYPE_DEFAULT.name()));
                }
                if (settingName == null || HtmlPreferences.SECTION_MODE_PROPERTY_NAME.equals(settingName)) {
                    sectionMode = ExtractInlinedStyleRefactoring.Mode.valueOf(preferences.get(HtmlPreferences.SECTION_MODE_PROPERTY_NAME, SECTION_MODE_DEFAULT.name()));
                }
                if (settingName == null || HtmlPreferences.mimetypesWithEnabledHtmlErrorChecking_key.equals(settingName)) {
                    mimetypesWithEnabledHtmlErrorChecking = preferences.get(HtmlPreferences.mimetypesWithEnabledHtmlErrorChecking_key, mimetypesWithEnabledHtmlErrorChecking_default);
                }
            }
        };
    }
}

