/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain;

import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Utilities;

public final class CompilerSetUtils {
    private CompilerSetUtils() {
    }

    public static String getCygwinBase() {
        return ToolUtils.getCygwinBase();
    }

    public static String getCommandFolder(CompilerSet cs) {
        String res = null;
        if (cs != null) {
            if (cs.getCompilerFlavor().isCygwinCompiler()) {
                return res;
            }
            res = cs.getCommandFolder();
        }
        if (res != null) {
            return res;
        }
        return ToolUtils.getCommandFolder();
    }

    public static boolean isMsysBased(CompilerSet cs) {
        if (!Utilities.isWindows()) {
            return false;
        }
        if (cs.getCompilerFlavor().isMinGWCompiler()) {
            return true;
        }
        String commandFolder = CompilerSetUtils.getCommandFolder(cs);
        return commandFolder != null && commandFolder.toLowerCase().replace('\\', '/').contains("/msys");
    }

    public static String getMinGWBaseFolder(CompilerSet cs) {
        if (!Utilities.isWindows()) {
            return null;
        }
        if (cs.getCompilerFlavor().isMinGWCompiler()) {
            return null;
        }
        Tool tool = cs.getTool(PredefinedToolKind.CCompiler);
        if (tool != null && tool.getName().contains("clang")) {
            CompilerSetManager csm = CompilerSetManager.get(ExecutionEnvironmentFactory.getLocal());
            for (CompilerSet acs : csm.getCompilerSets()) {
                if (!acs.getCompilerFlavor().isMinGWCompiler()) continue;
                return acs.getDirectory();
            }
        }
        return null;
    }
}

