/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Pathmap;
import org.netbeans.modules.cnd.debugger.common2.utils.ListUI;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;

class PathmapPanel
extends JPanel
implements PropertyChangeListener,
HelpCtx.Provider {
    private Pathmap pathmap;
    private ListUI pathmapList;
    private PropertyEditorSupport propertyEditor;

    public PathmapPanel(PropertyEditorSupport propertyEditor, PropertyEnv env, Pathmap pathmap) {
        this.propertyEditor = propertyEditor;
        this.initComponents();
        this.adjustButtons();
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        this.pathmap = pathmap;
        this.initValues(pathmap);
    }

    private void initValues(Pathmap pathmap) {
        this.pathmap = pathmap;
        if (pathmap.getPathmap() != null) {
            int n = pathmap.getPathmap().length;
            ArrayList<String> col0 = new ArrayList<String>(n + 3);
            ArrayList<String> col1 = new ArrayList<String>(n + 3);
            for (int i = 0; i < n; ++i) {
                col0.add(pathmap.getPathmap()[i].from());
                if (pathmap.getPathmap()[i].to() == null) {
                    col1.add("");
                    continue;
                }
                col1.add(pathmap.getPathmap()[i].to());
            }
            this.pathmapList.model.setData(n, col0, col1);
        }
    }

    private Object getPropertyValue() throws IllegalStateException {
        this.pathmapList.model.finishEditing();
        int numRows = this.pathmapList.model.getRowCount();
        if (numRows > 0) {
            int num = 0;
            for (int j = 0; j < numRows; ++j) {
                String from = (String)this.pathmapList.model.getValueAt(j, 0);
                if (from.length() == 0) continue;
                String to = (String)this.pathmapList.model.getValueAt(j, 1);
                ++num;
            }
            Pathmap.Item[] map = new Pathmap.Item[num];
            num = 0;
            for (int j = 0; j < numRows; ++j) {
                String from = (String)this.pathmapList.model.getValueAt(j, 0);
                if (from.length() == 0) continue;
                String to = (String)this.pathmapList.model.getValueAt(j, 1);
                if (to.length() == 0) {
                    to = null;
                }
                Pathmap.Item p = new Pathmap.Item(from, to, false);
                map[num++] = p;
            }
            this.pathmap.setPathmap(map);
        } else {
            this.pathmap.setPathmap(null);
        }
        return this.pathmap;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.propertyEditor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("DebuggerOptions");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(12, 12, 12, 12);
        EmptyBorder margin = new EmptyBorder(insets);
        CompoundBorder border = new CompoundBorder(new EtchedBorder(), margin);
        this.setBorder(border);
        this.pathmapList = new ListUI();
        this.pathmapList.labelText = Catalog.get("Pathmap");
        this.pathmapList.labelMnemonic = Catalog.getMnemonic("MNEM_Pathmap");
        this.pathmapList.column0Text = Catalog.get("ExistingPath");
        this.pathmapList.column1Text = Catalog.get("ReplacementPath");
        this.pathmapList.accessibleDescription = Catalog.get("ACSD_PathmapTable");
        this.pathmapList.addText = Catalog.get("AddMap");
        this.pathmapList.addActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathmapPanel.this.addPathmapRow(evt);
            }
        };
        this.pathmapList.remText = Catalog.get("RemoveMap");
        this.pathmapList.remActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathmapPanel.this.deletePathmapRow(evt);
            }
        };
        JPanel pathmapPanel = this.pathmapList.make(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(11, 0, 0, 0);
        this.add((Component)pathmapPanel, gbc);
    }

    private void adjustButtons() {
        this.pathmapList.adjustButtons(false);
    }

    private void deletePathmapRow(ActionEvent evt) {
        int[] selRows = this.pathmapList.table.getSelectedRows();
        if (selRows != null && selRows.length > 0) {
            this.pathmapList.model.removeRows(selRows);
            this.adjustButtons();
        }
    }

    private void addPathmapRow(ActionEvent evt) {
        this.pathmapList.model.addRow();
        this.adjustButtons();
    }
}

