/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.SystemInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.SysCallBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.values.SysCallEE;

class SysCallBreakpointPanel
extends BreakpointPanel {
    private SysCallBreakpoint fb;
    private SystemInfo si_syscalls;
    private ButtonGroup buttonGroup1;
    private JLabel sysCallLabel;
    private JComboBox sysCallCombo;
    private JRadioButton entranceToggle;
    private JRadioButton exitToggle;

    @Override
    protected final void seed(NativeBreakpoint breakpoint) {
        this.seedCommonComponents(breakpoint);
        this.fb = (SysCallBreakpoint)breakpoint;
        if (this.fb.getSysCall() == null) {
            this.sysCallCombo.setSelectedItem(this.si_syscalls.all());
        } else {
            this.sysCallCombo.setSelectedItem(this.fb.getSysCall());
        }
        if (this.fb.getEntryExit() == SysCallEE.ENTRY) {
            this.entranceToggle.setSelected(true);
        } else {
            this.exitToggle.setSelected(true);
        }
    }

    public SysCallBreakpointPanel() {
        this(new SysCallBreakpoint(2), false);
    }

    public SysCallBreakpointPanel(NativeBreakpoint b) {
        this((SysCallBreakpoint)b, true);
    }

    public SysCallBreakpointPanel(SysCallBreakpoint breakpoint, boolean customizing) {
        super(breakpoint, customizing);
        this.fb = breakpoint;
        this.initComponents();
        this.addCommonComponents(3);
        this.entranceToggle.setSelected(true);
        this.sysCallCombo.setEditable(true);
        Component c = this.sysCallCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            Document d = ((JTextComponent)c).getDocument();
            d.addDocumentListener(this);
        }
        Vector<String> comboValues = new Vector<String>(250);
        this.si_syscalls = new SystemInfo.Syscalls(comboValues);
        this.si_syscalls.stuffInto(this.sysCallCombo);
        this.seed(breakpoint);
        this.sysCallCombo.addItemListener(this);
    }

    @Override
    public void setDescriptionEnabled(boolean enabled) {
        this.sysCallCombo.setEnabled(false);
        this.entranceToggle.setEnabled(false);
        this.exitToggle.setEnabled(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sysCallLabel = new JLabel();
        this.sysCallCombo = new JComboBox();
        this.entranceToggle = new JRadioButton();
        this.exitToggle = new JRadioButton();
        this.panel_settings.setLayout(new GridBagLayout());
        this.sysCallLabel.setText(Catalog.get("SystemCall"));
        this.sysCallLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_SystemCall"));
        this.sysCallLabel.setLabelFor(this.sysCallCombo);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.panel_settings.add((Component)this.sysCallLabel, gridBagConstraints1);
        this.sysCallCombo.setEditable(true);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.panel_settings.add((Component)this.sysCallCombo, gridBagConstraints1);
        this.entranceToggle.setText(SysCallEE.ENTRY.toString());
        this.entranceToggle.setMnemonic(Catalog.getMnemonic("MNEM_OnEntrance"));
        this.buttonGroup1.add(this.entranceToggle);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.anchor = 17;
        this.panel_settings.add((Component)this.entranceToggle, gridBagConstraints1);
        this.exitToggle.setText(SysCallEE.EXIT.toString());
        this.exitToggle.setMnemonic(Catalog.getMnemonic("MNEM_OnExit"));
        this.buttonGroup1.add(this.exitToggle);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridwidth = 4;
        gridBagConstraints1.anchor = 17;
        this.panel_settings.add((Component)this.exitToggle, gridBagConstraints1);
        this.sysCallCombo.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_SystemCall"));
        this.entranceToggle.getAccessibleContext().setAccessibleDescription(this.entranceToggle.getText());
        this.exitToggle.getAccessibleContext().setAccessibleDescription(this.exitToggle.getText());
    }

    @Override
    protected void assignProperties() {
        String syscall = this.sysCallCombo.getSelectedItem().toString();
        if (syscall.equals(this.si_syscalls.all())) {
            this.fb.setSysCall(null);
        } else {
            this.fb.setSysCall(syscall);
        }
        if (this.exitToggle.isSelected()) {
            this.fb.setEntryExit(SysCallEE.EXIT);
        } else {
            this.fb.setEntryExit(SysCallEE.ENTRY);
        }
    }

    @Override
    protected boolean propertiesAreValid() {
        Component c = this.sysCallCombo.getEditor().getEditorComponent();
        if (c instanceof JTextComponent) {
            String text = ((JTextComponent)c).getText();
            return !IpeUtils.isEmpty(text);
        }
        return !IpeUtils.isEmpty(this.sysCallCombo.getSelectedItem().toString());
    }
}

