/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.debugger.common2.debugger.Constants;
import org.netbeans.modules.cnd.debugger.common2.debugger.DialogManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelListenerSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.NewBreakpointAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointBag;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.EditBreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DebuggerOption;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionLayers;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.netbeans.modules.cnd.debugger.common2.utils.props.BooleanProperty;
import org.netbeans.modules.cnd.debugger.common2.utils.props.Property;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.CheckNodeModel;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.SystemAction;

public final class BreakpointFilter
extends ModelListenerSupport
implements TreeModelFilter,
TableModelFilter,
NodeActionsProviderFilter,
CheckNodeModelFilter,
AsynchronousModelFilter,
Constants {
    private static final Action DELETE_ACTION = Models.createAction((String)Catalog.get("ACT_BPT_Delete"), (Models.ActionPerformer)new DeleteAction(), (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action ENABLE_ACTION;
    private static final Action DISABLE_ACTION;
    private static final Action CUSTOMIZE_ACTION;
    private static final Action GOTO_SOURCE_ACTION;
    private static final Action ENABLE_ALL_ACTION;
    private static final Action DISABLE_ALL_ACTION;
    private static final Action DELETE_ALL_ACTION;
    private static final Action DELETE_INAPPLICABLE_ACTION;
    private static final Action SAVE_ACTION;
    private static final Action NEW_BREAKPOINT_ACTION;
    private static final Action GHOST_BUSTER_ACTION;
    private static final Action SESSION_ONLY_ACTION;
    private static final Action ONLY_CHILD_ACTION;
    private static final Action ENABLE_DIFFERENTIATES_ACTION;

    private static NativeDebuggerManager manager() {
        return NativeDebuggerManager.get();
    }

    public BreakpointFilter() {
        super("breakpoint");
    }

    private static BreakpointBag breakpointBag() {
        return BreakpointFilter.manager().breakpointBag();
    }

    public Object getRoot(TreeModel original) {
        return "Root";
    }

    private static NativeBreakpoint skipParent(NativeBreakpoint nb) {
        NativeBreakpoint child;
        Object[] children;
        NativeBreakpoint rv = null;
        rv = !NativeBreakpoint.getSkipSingleParent() ? nb : ((children = BreakpointFilter.sessionOnly(nb, nb.getChildren())).length == 1 ? (!(child = (NativeBreakpoint)children[0]).isBound() && child.isMidlevel() && child.isUniqueLite() ? nb : BreakpointFilter.skipParent(child)) : nb);
        return rv;
    }

    private static Object[] sessionOnly(NativeBreakpoint parent, Object[] children) {
        if (!NativeBreakpoint.getSessionOnly()) {
            return children;
        }
        if (parent == null) {
            if (NativeDebuggerManager.isPerTargetBpts()) {
                ArrayList<Object> newChildren = new ArrayList<Object>();
                for (Object child : children) {
                    NativeBreakpoint nb;
                    Object[] inSession;
                    if (!(child instanceof NativeBreakpoint) || (inSession = BreakpointFilter.sessionOnly(nb = (NativeBreakpoint)child, nb.getChildren())).length <= 0) continue;
                    newChildren.add(child);
                }
                return newChildren.toArray();
            }
            return children;
        }
        if (!parent.isToplevel()) {
            return children;
        }
        assert (parent.isToplevel());
        if (NativeDebuggerManager.get().sessionCount() == 0) {
            if (NativeDebuggerManager.isPerTargetBpts()) {
                return new Object[0];
            }
            return children;
        }
        ArrayList<Object> newChildren = new ArrayList<Object>();
        for (Object child : children) {
            if (child instanceof NativeBreakpoint) {
                NativeBreakpoint nb = (NativeBreakpoint)child;
                if (!nb.isCurrent()) continue;
                newChildren.add(child);
                continue;
            }
            newChildren.add(child);
        }
        return newChildren.toArray();
    }

    private static Object[] simplifyHierarchy(NativeBreakpoint parent, Object[] children) {
        children = BreakpointFilter.sessionOnly(parent, children);
        if (Log.Bpt.model) {
            System.out.printf("BreakpointFilter.simplifyHierarchy():\n", new Object[0]);
            System.out.printf("\tafter sessionOnly: %d\n", children.length);
        }
        for (int ox = 0; ox < children.length; ++ox) {
            Object o = children[ox];
            if (!(o instanceof NativeBreakpoint)) continue;
            NativeBreakpoint child = (NativeBreakpoint)o;
            children[ox] = BreakpointFilter.skipParent(child);
        }
        if (Log.Bpt.model) {
            System.out.printf("\t       eventually: %d\n", children.length);
            if (children.length == 0) {
                System.out.printf("\t0 bpt hook\n", new Object[0]);
            }
        }
        return children;
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        CndUtils.assertNonUiThread();
        BreakpointFilter.breakpointBag();
        if (parent == "Root") {
            Object[] oChildren = original.getChildren(parent, 0, original.getChildrenCount(parent));
            return BreakpointFilter.simplifyHierarchy(null, oChildren);
        }
        if (parent instanceof NativeBreakpoint) {
            NativeBreakpoint nb = (NativeBreakpoint)parent;
            return BreakpointFilter.simplifyHierarchy(nb, nb.getChildren());
        }
        Object[] originalChildren = original.getChildren(parent, from, to);
        return originalChildren;
    }

    public int getChildrenCount(TreeModel original, Object parent) throws UnknownTypeException {
        int count;
        CndUtils.assertNonUiThread();
        BreakpointFilter.breakpointBag();
        if (parent instanceof NativeBreakpoint) {
            NativeBreakpoint nb = (NativeBreakpoint)parent;
            count = nb.nChildren();
        } else if (NativeDebuggerManager.isPerTargetBpts()) {
            Object[] oChildren = original.getChildren(parent, 0, original.getChildrenCount(parent));
            Object[] inSession = BreakpointFilter.sessionOnly(null, oChildren);
            count = inSession.length;
        } else {
            count = original.getChildrenCount(parent);
        }
        if (Log.Bpt.model) {
            System.out.printf("BreakpointFilter.getChildrenCount(%s) -> %d\n", parent, count);
        }
        return count;
    }

    private boolean isLeaf(NativeBreakpoint nb) {
        return (nb = BreakpointFilter.skipParent(nb)).nChildren() == 0;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        boolean isLeaf = false;
        if (node instanceof NativeBreakpoint) {
            NativeBreakpoint nb = (NativeBreakpoint)node;
            return this.isLeaf(nb);
        }
        isLeaf = original.isLeaf(node);
        if (Log.Bpt.model) {
            String who = node == "Root" ? "ROOT" : "notours";
            System.out.printf("isLeaf(%s) = %s\n", who, isLeaf);
        }
        return isLeaf;
    }

    public void addModelListener(ModelListener l) {
        if (super.addModelListenerHelp(l)) {
            BreakpointFilter.manager().breakpointUpdater().addListener(this);
        }
    }

    public void removeModelListener(ModelListener l) {
        if (super.removeModelListenerHelp(l)) {
            BreakpointFilter.manager().breakpointUpdater().removeListener(l);
        }
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof NativeBreakpoint) {
            NativeBreakpoint b = (NativeBreakpoint)node;
            return b.getDisplayName();
        }
        return original.getDisplayName(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof NativeBreakpoint) {
            NativeBreakpoint b = (NativeBreakpoint)node;
            return b.getIconBase();
        }
        return original.getIconBase(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof NativeBreakpoint) {
            String summary;
            NativeBreakpoint b = (NativeBreakpoint)node;
            String string = summary = b.getSummary() == null ? "" : b.getSummary();
            if (b.getError() != null) {
                summary = summary + " (" + b.getError() + ")";
            }
            return summary;
        }
        return original.getShortDescription(node);
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (!(node instanceof NativeBreakpoint)) {
            return null;
        }
        NativeBreakpoint b = (NativeBreakpoint)node;
        if (columnID.equals("PROP_BREAKPOINT_TIMESTAMP")) {
            Date timestamp = b.timestamp();
            if (timestamp == null) {
                return "";
            }
            return DateFormat.getTimeInstance(1).format(timestamp);
        }
        Property p = b.propertyByKey(columnID);
        if (Log.Bpt.enabling && columnID.equals("PROP_BREAKPOINT_ENABLE")) {
            if (b.isToplevel()) {
                System.out.println("?T getValueAt() ->" + p);
            } else {
                System.out.println("? S getValueAt() ->" + p);
            }
        }
        if (p != null) {
            if (columnID.equals("PROP_BREAKPOINT_CONTEXT")) {
                return b.embellishedContext(p.toString());
            }
            return p.getAsObject();
        }
        return null;
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (!(node instanceof NativeBreakpoint)) {
            return true;
        }
        NativeBreakpoint b = (NativeBreakpoint)node;
        Property p = b.propertyByKey(columnID);
        if (p != null) {
            return p.isReadOnly();
        }
        return true;
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        if (!(node instanceof NativeBreakpoint)) {
            return;
        }
        NativeBreakpoint b = (NativeBreakpoint)node;
        Property p = b.propertyByKey(columnID);
        if (p == null) {
            System.out.println("BreakpointFilter.setValueAt Property " + p);
        }
        if ("PROP_BREAKPOINT_ENABLE".equals(columnID)) {
            assert (false) : "setValueAt() should nto be called for PROP_BREAKPOINT_ENABLE";
        } else if ("PROP_BREAKPOINT_TEMP".equals(columnID)) {
            p.setFromObject(value);
            b.setPropTemp(((BooleanProperty)p).get());
        } else if ("PROP_BREAKPOINT_JAVA".equals(columnID)) {
            p.setFromObject(value);
            b.setPropJava(((BooleanProperty)p).get());
        } else if ("PROP_BREAKPOINT_THREAD".equals(columnID)) {
            b.setPropThread((String)value);
        } else if ("PROP_BREAKPOINT_LWP".equals(columnID)) {
            b.setPropLwp((String)value);
        } else if ("PROP_BREAKPOINT_WHILEIN".equals(columnID)) {
            b.setPropWhileIn((String)value);
        } else if ("PROP_BREAKPOINT_CONDITION".equals(columnID)) {
            b.setPropCondition((String)value);
        } else if ("PROP_BREAKPOINT_COUNTLIMIT".equals(columnID)) {
            b.setPropCountLimit(value);
        }
    }

    public boolean isCheckable(NodeModel originalNM, Object node) throws UnknownTypeException {
        if (!(originalNM instanceof CheckNodeModel)) {
            throw new UnknownTypeException(node);
        }
        CheckNodeModel original = (CheckNodeModel)originalNM;
        if (node instanceof NativeBreakpoint) {
            return true;
        }
        return original.isCheckable(node);
    }

    public boolean isCheckEnabled(NodeModel originalNM, Object node) throws UnknownTypeException {
        if (!(originalNM instanceof CheckNodeModel)) {
            throw new UnknownTypeException(node);
        }
        CheckNodeModel original = (CheckNodeModel)originalNM;
        if (node instanceof NativeBreakpoint) {
            return true;
        }
        return original.isCheckEnabled(node);
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean isSelected(NodeModel originalNM, Object node) throws UnknownTypeException {
        if (node instanceof NativeBreakpoint) {
            NativeBreakpoint b = (NativeBreakpoint)node;
            Property p = b.propertyByKey("PROP_BREAKPOINT_ENABLE");
            if (Log.Bpt.enabling) {
                if (b.isToplevel()) {
                    System.out.println("?T isSelected() ->" + p);
                } else {
                    System.out.println("? S isSelected() ->" + p);
                }
            }
            if (p != null) {
                Object bObj = p.getAsObject();
                if (bObj instanceof Boolean) {
                    return (Boolean)bObj;
                }
                return null;
            }
            return null;
        }
        if (!(originalNM instanceof CheckNodeModel)) {
            throw new UnknownTypeException(node);
        }
        CheckNodeModel original = (CheckNodeModel)originalNM;
        return original.isSelected(node);
    }

    public void setSelected(NodeModel originalNM, Object node, Boolean selected) throws UnknownTypeException {
        if (node instanceof NativeBreakpoint) {
            NativeBreakpoint b = (NativeBreakpoint)node;
            Property p = b.propertyByKey("PROP_BREAKPOINT_ENABLE");
            if (p != null) {
                p.setFromObject(selected);
                b.setPropEnabled(((BooleanProperty)p).get());
            }
        } else {
            if (!(originalNM instanceof CheckNodeModel)) {
                throw new UnknownTypeException(node);
            }
            CheckNodeModel original = (CheckNodeModel)originalNM;
            original.setSelected(node, selected);
        }
    }

    public Executor asynchronous(Executor arg0, AsynchronousModelFilter.CALL arg1, Object arg2) throws UnknownTypeException {
        switch (arg1) {
            case CHILDREN: 
            case VALUE: {
                return AsynchronousModelFilter.DEFAULT;
            }
            case DISPLAY_NAME: 
            case SHORT_DESCRIPTION: {
                return AsynchronousModelFilter.CURRENT_THREAD;
            }
        }
        assert (false);
        return null;
    }

    private void tackOnDebugging(ArrayList<Action> a) {
        if (Log.Bpt.hierarchy) {
            a.add(null);
            a.add(GHOST_BUSTER_ACTION);
            a.add(SESSION_ONLY_ACTION);
            a.add(ONLY_CHILD_ACTION);
            a.add(ENABLE_DIFFERENTIATES_ACTION);
            a.add(null);
        }
    }

    public Action[] getActions(NodeActionsProvider original, Object o) throws UnknownTypeException {
        Action[] originals = original.getActions(o);
        ArrayList<Action> a = new ArrayList<Action>(originals.length);
        if (NativeDebuggerManager.isPerTargetBpts()) {
            if (o == "Root") {
                a.add(NEW_BREAKPOINT_ACTION);
                a.add(null);
                a.add(ENABLE_ALL_ACTION);
                a.add(DISABLE_ALL_ACTION);
                a.add(DELETE_ALL_ACTION);
                a.add(SAVE_ACTION);
                a.add(null);
                this.tackOnDebugging(a);
            } else if (o instanceof NativeBreakpoint) {
                a.add(GOTO_SOURCE_ACTION);
                a.add(null);
                a.add(((NativeBreakpoint)o).isEnabled() ? DISABLE_ACTION : ENABLE_ACTION);
                a.add(DELETE_ACTION);
                a.add(CUSTOMIZE_ACTION);
                a.add(null);
                a.add(NEW_BREAKPOINT_ACTION);
                a.add(null);
                a.add(ENABLE_ALL_ACTION);
                a.add(DISABLE_ALL_ACTION);
                a.add(DELETE_ALL_ACTION);
                a.add(SAVE_ACTION);
                a.add(null);
                this.tackOnDebugging(a);
            } else {
                for (int ox = 0; ox < originals.length; ++ox) {
                    a.add(originals[ox]);
                }
            }
            return a.toArray(new Action[a.size()]);
        }
        for (int ox = 0; ox < originals.length; ++ox) {
            if (ox == 1) continue;
            a.add(originals[ox]);
        }
        if (!(o instanceof NativeBreakpoint)) {
            a.add(a.size() - 1, DELETE_INAPPLICABLE_ACTION);
            this.tackOnDebugging(a);
            if (NativeDebuggerManager.isStandalone()) {
                a.add(SAVE_ACTION);
            }
        } else {
            a.add(0, GOTO_SOURCE_ACTION);
            a.add(1, null);
            a.add(a.size() - 1, DELETE_INAPPLICABLE_ACTION);
            a.add(CUSTOMIZE_ACTION);
            this.tackOnDebugging(a);
        }
        return a.toArray(new Action[a.size()]);
    }

    public void performDefaultAction(NodeActionsProvider original, Object o) throws UnknownTypeException {
        if (o != "Root") {
            if (o instanceof NativeBreakpoint) {
                NativeBreakpoint breakpoint = (NativeBreakpoint)o;
                breakpoint.visitNextAnnotation();
            } else {
                original.performDefaultAction(o);
            }
        }
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        ENABLE_ACTION = Models.createAction((String)Catalog.get("ACT_BPT_Enable"), (Models.ActionPerformer)new EnableAction(), (int)Models.MULTISELECTION_TYPE_ANY);
        DISABLE_ACTION = Models.createAction((String)Catalog.get("ACT_BPT_Disable"), (Models.ActionPerformer)new EnableAction(), (int)Models.MULTISELECTION_TYPE_ANY);
        CUSTOMIZE_ACTION = Models.createAction((String)Catalog.get("ACT_BPT_Customize"), (Models.ActionPerformer)new CustomizeAction(), (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        GOTO_SOURCE_ACTION = Models.createAction((String)Catalog.get("ACT_BPT_GoToSource"), (Models.ActionPerformer)new GoToSourceAction(), (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        ENABLE_ALL_ACTION = new EnableAllAction();
        DISABLE_ALL_ACTION = new DisableAllAction();
        DELETE_ALL_ACTION = new DeleteAllAction();
        DELETE_INAPPLICABLE_ACTION = new DeleteInapplicableAction();
        SAVE_ACTION = new SaveBptAction();
        NEW_BREAKPOINT_ACTION = SystemAction.get(NewBreakpointAction.class);
        GHOST_BUSTER_ACTION = new GhostBusterAction();
        SESSION_ONLY_ACTION = new SessionOnlyAction();
        ONLY_CHILD_ACTION = new OnlyChildAction();
        ENABLE_DIFFERENTIATES_ACTION = new EnableDifferentiatesAction();
    }

    private static class CustomizeBreakpointProcessor
    extends DialogManager
    implements ActionListener,
    PropertyChangeListener {
        private final DialogDescriptor dd;
        private final EditBreakpointPanel panel;
        private Dialog dialog;

        CustomizeBreakpointProcessor(NativeBreakpoint editableBreakpoint) {
            this.panel = new EditBreakpointPanel(editableBreakpoint);
            boolean isModal = true;
            String title = Catalog.get("CTL_CustomizeBreakpointTitle");
            this.dd = new DialogDescriptor((Object)this.panel, title, isModal, (ActionListener)this);
            Object[] buttons = new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION};
            this.dd.setOptions(buttons);
            this.dd.setClosingOptions(new Object[0]);
            this.dialog = DialogDisplayer.getDefault().createDialog(this.dd);
            this.dialog.pack();
            this.setValid();
            Controller controller = this.panel.getController();
            if (controller != null) {
                controller.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void setVisible(boolean v) {
            this.dialog.setVisible(v);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean ok = e.getSource() == DialogDescriptor.OK_OPTION;
            this.accept(ok);
        }

        @Override
        public void accept(boolean yes) {
            boolean done = false;
            Controller controller = this.panel.getController();
            if (yes) {
                NativeDebuggerManager.get().registerDialog(this);
                done = controller.ok();
            } else {
                done = controller.cancel();
                this.bringDown();
            }
        }

        @Override
        public void bringDown() {
            NativeDebuggerManager.get().deRegisterDialog(this);
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }

        @Override
        public void refocus() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("valid".equals(e.getPropertyName())) {
                this.setValid();
            }
        }

        void setValid() {
            this.dd.setValid(this.panel.getController().isValid());
        }
    }

    private static class EnableDifferentiatesAction
    extends BooleanStateAction {
        EnableDifferentiatesAction() {
        }

        public boolean getBooleanState() {
            return NativeBreakpoint.enableDifferentiates;
        }

        public String getName() {
            return "enabled property differentiates";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            NativeBreakpoint.enableDifferentiates = !NativeBreakpoint.enableDifferentiates;
        }
    }

    private static class OnlyChildAction
    extends BooleanStateAction {
        OnlyChildAction() {
        }

        public boolean getBooleanState() {
            return NativeBreakpoint.getSkipSingleParent();
        }

        public String getName() {
            return "skip single parents";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            NativeBreakpoint.toggleSkipSingleParent();
        }
    }

    private static class SessionOnlyAction
    extends BooleanStateAction {
        SessionOnlyAction() {
        }

        public boolean getBooleanState() {
            return NativeBreakpoint.getSessionOnly();
        }

        public String getName() {
            return "only show bpts in current session";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            NativeBreakpoint.toggleSessionOnly();
        }
    }

    private static class GhostBusterAction
    extends BooleanStateAction {
        GhostBusterAction() {
        }

        public boolean getBooleanState() {
            return NativeBreakpoint.getGhostBuster();
        }

        public String getName() {
            return "ghost buster";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        public void actionPerformed(ActionEvent e) {
            NativeBreakpoint.toggleGhostBuster();
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public static class SaveBptAction
    extends BooleanStateAction {
        OptionSet globalOptions = NativeDebuggerManager.get().globalOptions();

        SaveBptAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DebuggerOption.SAVE_BREAKPOINTS.setEnabled(new OptionLayers(this.globalOptions), !this.getBooleanState());
        }

        public boolean getBooleanState() {
            return DebuggerOption.SAVE_BREAKPOINTS.isEnabled(this.globalOptions);
        }

        public String getName() {
            return Catalog.get("ACT_BPT_SaveBpt");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    public static class DeleteInapplicableAction
    extends BptAction {
        DeleteInapplicableAction() {
            super(Catalog.get("ACT_BPT_DeleteInapplicable"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NativeBreakpoint[] bpts;
            for (NativeBreakpoint b : bpts = BreakpointFilter.breakpointBag().getBreakpoints()) {
                assert (b.isToplevel());
                NativeDebugger d = NativeDebuggerManager.get().currentDebugger();
                NativeBreakpoint m = b.getMidlevelFor(d);
                if (m == null || !m.isBroken()) continue;
                m.dispose();
            }
        }

        @Override
        public boolean isEnabled() {
            NativeBreakpoint[] bpts;
            if (NativeDebuggerManager.get().sessionCount() == 0) {
                return false;
            }
            for (NativeBreakpoint b : bpts = BreakpointFilter.breakpointBag().getBreakpoints()) {
                assert (b.isToplevel());
                NativeDebugger d = NativeDebuggerManager.get().currentDebugger();
                NativeBreakpoint m = b.getMidlevelFor(d);
                if (m == null || !m.isBroken()) continue;
                return true;
            }
            return false;
        }

        public static Action getAction() {
            return DELETE_INAPPLICABLE_ACTION;
        }
    }

    public static class DeleteAllAction
    extends BptAction {
        DeleteAllAction() {
            super(Catalog.get("ACT_BPT_DeleteAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakpointFilter.breakpointBag().postDeleteAllHandlers();
        }

        @Override
        public boolean isEnabled() {
            NativeBreakpoint[] breakpoints = BreakpointFilter.breakpointBag().getBreakpoints();
            return breakpoints.length > 0;
        }

        public static Action getAction() {
            return DELETE_ALL_ACTION;
        }
    }

    public static class DisableAllAction
    extends BptAction {
        DisableAllAction() {
            super(Catalog.get("ACT_BPT_DisableAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakpointFilter.breakpointBag().postEnableAllHandlers(false);
        }

        @Override
        public boolean isEnabled() {
            return BreakpointFilter.breakpointBag().anyEnabled();
        }

        public static Action getAction() {
            return DISABLE_ALL_ACTION;
        }
    }

    public static class EnableAllAction
    extends BptAction {
        EnableAllAction() {
            super(Catalog.get("ACT_BPT_EnableAll"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BreakpointFilter.breakpointBag().postEnableAllHandlers(true);
        }

        @Override
        public boolean isEnabled() {
            return BreakpointFilter.breakpointBag().anyDisabled();
        }

        public static Action getAction() {
            return ENABLE_ALL_ACTION;
        }
    }

    private static class GoToSourceAction
    extends BptActionPerformer {
        private GoToSourceAction() {
        }

        @Override
        public boolean isEnabled(NativeBreakpoint b) {
            return b.isVisitable();
        }

        @Override
        protected void perform(NativeBreakpoint b) {
            b.visitNextAnnotation();
        }
    }

    private static class CustomizeAction
    extends BptActionPerformer {
        private CustomizeAction() {
        }

        @Override
        public boolean isEnabled(NativeBreakpoint b) {
            return true;
        }

        @Override
        protected void perform(NativeBreakpoint b) {
            NativeBreakpoint editableBreakpoint = b.makeEditableCopy();
            CustomizeBreakpointProcessor processor = new CustomizeBreakpointProcessor(editableBreakpoint);
            processor.setVisible(true);
        }
    }

    private static class EnableAction
    extends BptActionPerformer {
        EnableAction() {
        }

        @Override
        public boolean isEnabled(NativeBreakpoint b) {
            return true;
        }

        @Override
        protected void perform(NativeBreakpoint b) {
            if (b.isEnabled()) {
                b.disable();
            } else {
                b.enable();
            }
        }
    }

    private static class DeleteAction
    extends BptActionPerformer {
        DeleteAction() {
        }

        @Override
        public boolean isEnabled(NativeBreakpoint b) {
            return true;
        }

        @Override
        protected void perform(NativeBreakpoint b) {
            b.dispose();
        }
    }

    private static abstract class BptActionPerformer
    implements Models.ActionPerformer {
        private BptActionPerformer() {
        }

        protected NativeDebuggerManager manager() {
            return NativeDebuggerManager.get();
        }

        public boolean isEnabled(Object node) {
            if (!(node instanceof NativeBreakpoint)) {
                return false;
            }
            NativeBreakpoint b = (NativeBreakpoint)node;
            return this.isEnabled(b);
        }

        public void perform(Object[] nodes) {
            for (int nx = 0; nx < nodes.length; ++nx) {
                if (!(nodes[nx] instanceof NativeBreakpoint)) continue;
                NativeBreakpoint b = (NativeBreakpoint)nodes[nx];
                this.perform(b);
            }
        }

        protected abstract void perform(NativeBreakpoint var1);

        protected abstract boolean isEnabled(NativeBreakpoint var1);
    }

    public static abstract class BptAction
    extends AbstractAction {
        protected BptAction(String name) {
            super(name);
        }

        protected NativeDebuggerManager manager() {
            return NativeDebuggerManager.get();
        }
    }
}

