/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.NativeActionsProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.RunToCursorInstAction;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineCapability;
import org.netbeans.modules.cnd.debugger.common2.debugger.api.EngineDescriptor;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.netbeans.spi.debugger.ContextProvider;

public class RunToCursorActionProvider
extends NativeActionsProvider {
    public RunToCursorActionProvider(ContextProvider ctx) {
        super(ctx);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        int lineNo = EditorContextBridge.getCurrentLineNumber();
        if (lineNo < 0) {
            return;
        }
        if (Disassembly.isInDisasm()) {
            RunToCursorInstAction.runToDisLine(lineNo);
        } else {
            String fileName = EditorContextBridge.getCurrentFilePath();
            if (fileName.trim().equals("")) {
                return;
            }
            this.getDebugger().runToCursor(fileName, lineNo);
        }
    }

    @Override
    public void update(State state) {
        boolean enable = false;
        NativeDebugger debugger = this.getDebugger();
        EngineDescriptor descriptor = debugger.getNDI().getEngineDescriptor();
        enable = descriptor.hasCapability(EngineCapability.RUN_AUTOSTART) ? state.isListening() && !state.isCore && state.isLoaded : state.isListening() && !state.isCore && state.isLoaded && state.isProcess;
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, enable);
    }
}

