/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeWatch;
import org.netbeans.modules.cnd.debugger.common2.debugger.WatchBag;
import org.openide.ErrorManager;
import org.xml.sax.Attributes;

class WatchXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private WatchBag bag;
    private NativeWatch currentWatch;
    private NativeWatch watch;
    private static final String TAG_WATCH = "watch";
    private static final String ATTR_RESTRICTED = "restricted";
    private static final String TAG_EXPR = "exp";
    private static final String TAG_QEXPR = "qexp";
    private static final String TAG_SCOPE = "scope";

    WatchXMLCodec(WatchBag bag) {
        this.bag = bag;
    }

    WatchXMLCodec(NativeWatch watch) {
        this.watch = watch;
    }

    NativeWatch currentWatch() {
        return this.currentWatch;
    }

    protected String tag() {
        return TAG_WATCH;
    }

    public void start(Attributes atts) {
        if (Log.Watch.xml) {
            System.out.printf("WatchXMLCodec().start(%s)\n", this.tag());
        }
        String restrictedString = atts.getValue(ATTR_RESTRICTED);
        try {
            this.currentWatch = new NativeWatch(null);
            this.currentWatch.setRestricted(Boolean.parseBoolean(restrictedString));
        }
        catch (Exception x) {
            ErrorManager.getDefault().annotate((Throwable)x, "Failed to parse watch from XML");
            ErrorManager.getDefault().notify((Throwable)x);
        }
    }

    public void end() {
        if (Log.Watch.xml) {
            System.out.printf("WatchXMLCodec().end(%s)\n", this.tag());
        }
        if (this.currentWatch == null) {
            if (Log.Watch.xml) {
                System.out.printf("\tno currentWatch\n", new Object[0]);
            }
            return;
        }
        if (this.bag != null) {
            if (Log.Watch.xml) {
                System.out.printf("\ttoplevel\n", new Object[0]);
            }
            this.bag.restore(this.currentWatch);
        } else if (Log.Watch.xml) {
            System.out.printf("\tno bag\n", new Object[0]);
        }
        this.currentWatch = null;
    }

    public void startElement(String element, Attributes atts) {
        if (Log.Watch.xml) {
            System.out.printf("Watch().startElement(%s)\n", element);
        }
    }

    public void endElement(String element, String currentText) {
        if (Log.Watch.xml) {
            System.out.printf("WatchXMLCodec().endElement(%s)\n", element);
        }
        if (element.equals(TAG_EXPR)) {
            this.currentWatch.setExpression(currentText);
        } else if (element.equals(TAG_QEXPR)) {
            this.currentWatch.setQualifiedExpression(currentText);
        } else if (element.equals(TAG_SCOPE)) {
            this.currentWatch.setScope(currentText);
        }
    }

    public void encode(XMLEncoderStream xes) {
        this.watch.prepareForSaving();
        String restrictedString = Boolean.toString(this.watch.isRestricted());
        AttrValuePair[] watchAttrs = new AttrValuePair[]{new AttrValuePair(ATTR_RESTRICTED, restrictedString)};
        xes.elementOpen(TAG_WATCH, watchAttrs);
        xes.element(TAG_EXPR, this.watch.getExpression());
        xes.element(TAG_QEXPR, this.watch.getQualifiedExpression());
        xes.element(TAG_SCOPE, this.watch.getScope());
        xes.elementClose(TAG_WATCH);
    }
}

