/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;

public class SignalDialog {
    private Dialog dialog;
    private DialogDescriptor dlg;
    private JPanel panel = new JPanel();
    private JTextArea textArea;
    private JCheckBox jc;
    private JButton BDiscardAndPause;
    private JButton BDiscardAndContinue;
    private JButton BForwardAndContinue;
    private String explanation = null;
    private String senderpid = null;
    private String session = null;
    private long receiverPid = -1L;

    public SignalDialog() {
        this.panel.setLayout(new GridBagLayout());
        GridBagConstraints ct = new GridBagConstraints();
        ct.gridwidth = 0;
        ct.anchor = 17;
        ct.fill = 1;
        ct.weightx = 1.0;
        ct.weighty = 1.0;
        ct.insets = new Insets(12, 0, 0, 12);
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setEditable(false);
        this.textArea.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        this.textArea.setRows(9);
        this.textArea.setColumns(40);
        this.textArea.setBorder(BorderFactory.createEmptyBorder());
        Catalog.setAccessibleName(this.textArea, "ACSN_SignalMsgArea");
        Catalog.setAccessibleDescription(this.textArea, "ACSD_SignalMsgArea");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.textArea);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.panel.add((Component)scrollPane, ct);
        ct = new GridBagConstraints();
        ct.gridwidth = 0;
        ct.anchor = 17;
        ct.fill = 1;
        ct.weightx = 1.0;
        ct.weighty = 0.0;
        ct.insets = new Insets(12, 0, 0, 0);
        this.jc = new JCheckBox();
        this.jc.setText(Catalog.get("SignalAddToIgnore"));
        Catalog.setAccessibleDescription(this.jc, "ACSD_Signal_AddToIgnore");
        this.jc.setMnemonic(Catalog.getMnemonic("MNEM_Signal_AddToIgnore"));
        this.panel.add((Component)this.jc, ct);
        this.jc.setSelected(false);
        this.BDiscardAndPause = new JButton();
        this.BDiscardAndPause.setText(Catalog.get("SignalDiscardAndPause"));
        Catalog.setAccessibleDescription(this.BDiscardAndPause, "ACSD_Signal_DiscardAndPause");
        this.BDiscardAndPause.setMnemonic(Catalog.getMnemonic("MNEM_Signal_DiscardAndPause"));
        this.BDiscardAndContinue = new JButton();
        this.BDiscardAndContinue.setText(Catalog.get("SignalDiscardAndContinue"));
        Catalog.setAccessibleDescription(this.BDiscardAndContinue, "ACSD_Signal_DiscardAndContinue");
        this.BDiscardAndContinue.setMnemonic(Catalog.getMnemonic("MNEM_Signal_DiscardAndContinue"));
        this.BForwardAndContinue = new JButton();
        this.BForwardAndContinue.setText(Catalog.get("SignalForwardAndContinue"));
        Catalog.setAccessibleDescription(this.BForwardAndContinue, "ACSD_Signal_ForwardAndContinue");
        this.BForwardAndContinue.setMnemonic(Catalog.getMnemonic("MNEM_Signal_ForwardAndContinue"));
    }

    public void setSignalInfo(String explanation) {
        this.explanation = explanation;
    }

    public void setSenderInfo(String senderpid) {
        this.senderpid = senderpid;
    }

    public void setReceiverInfo(String session, long receiverPid) {
        this.session = session;
        this.receiverPid = receiverPid;
    }

    public void setIgnore(boolean signalKnow, boolean ignore) {
        this.jc.setEnabled(signalKnow);
        this.jc.setSelected(ignore);
    }

    public void hideIgnore() {
        this.jc.setVisible(false);
    }

    private void fillText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.explanation).append('\n');
        if (this.senderpid != null) {
            sb.append(Catalog.format("SignalSrc", this.senderpid)).append('\n');
        }
        sb.append(Catalog.format("SignalDst", this.session, this.receiverPid)).append("\n\n");
        sb.append(Catalog.get("SignalHelp")).append('\n');
        this.textArea.setText(sb.toString());
    }

    public void show() {
        this.fillText();
        String title = Catalog.format("SignalTitle", this.session);
        this.dlg = new DialogDescriptor((Object)this.panel, title, true, (Object[])new JButton[]{this.BDiscardAndPause, this.BDiscardAndContinue, this.BForwardAndContinue}, (Object)this.BDiscardAndPause, 0, null, null);
        this.dlg.setMessageType(2);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dlg);
        Catalog.setAccessibleDescription(this.dialog, "ACSD_SignalCaught");
        this.dialog.setVisible(true);
    }

    public boolean isIgnore() {
        return this.jc.isSelected();
    }

    public boolean discardSignal() {
        Object pressedButton = this.dlg.getValue();
        return pressedButton == this.BDiscardAndPause || pressedButton == this.BDiscardAndContinue;
    }

    public boolean shouldContinue() {
        Object pressedButton = this.dlg.getValue();
        return pressedButton == this.BDiscardAndContinue || pressedButton == this.BForwardAndContinue;
    }
}

