/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.cnd.debugger.common2.debugger.Constants;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelListenerSupport;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeSession;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.datatransfer.PasteType;

public final class SessionFilter
extends ModelListenerSupport
implements TreeModelFilter,
ExtendedNodeModelFilter,
TableModelFilter,
NodeActionsProviderFilter,
Constants {
    public SessionFilter() {
        super("sessions");
    }

    public void addModelListener(ModelListener l) {
        if (super.addModelListenerHelp(l)) {
            NativeDebuggerManager.get().registerSessionModel(this);
        }
    }

    public void removeModelListener(ModelListener l) {
        if (super.removeModelListenerHelp(l)) {
            NativeDebuggerManager.get().registerSessionModel(null);
        }
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) {
        Object[] children = null;
        try {
            children = original.getChildren(parent, from, to);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return children;
    }

    public int getChildrenCount(TreeModel original, Object parent) {
        int count = 0;
        try {
            count = original.getChildrenCount(parent);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count;
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public boolean isLeaf(TreeModel original, Object node) {
        boolean isLeaf = false;
        try {
            isLeaf = original.isLeaf(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isLeaf;
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        if (!(node instanceof Session)) {
            return original.getDisplayName(node);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            return ds.getName();
        }
        return original.getDisplayName(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBase(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        if (!(node instanceof Session)) {
            return original.getShortDescription(node);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            return ds.getTarget();
        }
        return original.getShortDescription(node);
    }

    public boolean canCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (!(node instanceof Session)) {
            return original.canCopy(node);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            return false;
        }
        return original.canCopy(node);
    }

    public Transferable clipboardCopy(ExtendedNodeModel original, Object node) throws UnknownTypeException, IOException {
        if (!(node instanceof Session)) {
            return original.clipboardCopy(node);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            throw new IOException();
        }
        return original.clipboardCopy(node);
    }

    public boolean canCut(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (!(node instanceof Session)) {
            return original.canCut(node);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            return false;
        }
        return original.canCut(node);
    }

    public Transferable clipboardCut(ExtendedNodeModel original, Object node) throws UnknownTypeException, IOException {
        if (!(node instanceof Session)) {
            return original.clipboardCut(node);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            throw new IOException();
        }
        return original.clipboardCut(node);
    }

    public boolean canRename(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        if (!(node instanceof Session)) {
            return original.canRename(node);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            return false;
        }
        return original.canRename(node);
    }

    public void setName(ExtendedNodeModel original, Object node, String name) throws UnknownTypeException {
        NativeSession ds;
        if (!(node instanceof Session)) {
            original.setName(node, name);
        }
        if ((ds = NativeSession.map((Session)node)) != null) {
            return;
        }
        original.setName(node, name);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel original, Object node, Transferable t) throws UnknownTypeException {
        if (!(node instanceof Session)) {
            return original.getPasteTypes(node, t);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            return new PasteType[0];
        }
        return original.getPasteTypes(node, t);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBaseWithExtension(node);
    }

    private Object fallbackGetValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        try {
            return original.getValueAt(node, columnID);
        }
        catch (UnknownTypeException x) {
            return "";
        }
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (!(node instanceof Session)) {
            return this.fallbackGetValueAt(original, node, columnID);
        }
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            if ("PROP_SESSION_PID".equals(columnID)) {
                return new Long(ds.getPid());
            }
            if ("SESSION_DEBUGGER_COLUMN_ID".equals(columnID)) {
                return ds.getSessionEngine();
            }
            if ("SessionState".equals(columnID)) {
                return ds.getSessionState();
            }
            if ("PROP_SESSION_LOCATION".equals(columnID)) {
                return ds.getSessionLocation();
            }
            if ("PROP_SESSION_MODE".equals(columnID)) {
                return ds.getSessionMode();
            }
            if ("PROP_SESSION_ARGS".equals(columnID)) {
                return ds.getSessionArgs();
            }
            if ("PROP_SESSION_CORE".equals(columnID)) {
                return ds.getSessionCore();
            }
            if ("PROP_SESSION_HOST".equals(columnID)) {
                return ds.getSessionHost();
            }
            return original.getValueAt(node, columnID);
        }
        return this.fallbackGetValueAt(original, node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        NativeSession ds = NativeSession.map((Session)node);
        if (ds != null) {
            return true;
        }
        try {
            return original.isReadOnly(node, columnID);
        }
        catch (UnknownTypeException x) {
            return true;
        }
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        NativeSession ds = NativeSession.map((Session)node);
        if (ds == null) {
            original.setValueAt(node, columnID, value);
        }
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions = original.getActions(node);
        Action[] newActions = new Action[actions.length + 1];
        System.arraycopy(actions, 0, newActions, 0, actions.length);
        return newActions;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }
}

