/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.FeatureList;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.modules.languages.parser.StringInput;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.netbeans.modules.languages.parser.TokenInputUtils;

public abstract class Language
extends org.netbeans.api.languages.Language {
    public static Language create(String mimeType) {
        return new EmptyLanguage(mimeType);
    }

    @Override
    public abstract String getMimeType();

    public abstract Parser getParser();

    public abstract LLSyntaxAnalyser getAnalyser();

    public abstract FeatureList getFeatureList();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract int getTokenID(String var1);

    public abstract int getTokenTypeCount();

    public abstract String getTokenType(int var1);

    public abstract int getNTID(String var1);

    public abstract int getNTCount();

    public abstract String getNT(int var1);

    public abstract List<Language> getImportedLanguages();

    public abstract Feature getPreprocessorImport();

    public abstract Map<String, Feature> getTokenImports();

    @Override
    public ASTNode parse(InputStream is) throws IOException, ParseException {
        ASTNode root1;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String ln = br.readLine();
        while (ln != null) {
            sb.append(ln).append('\n');
            ln = br.readLine();
        }
        TokenInput ti = TokenInputUtils.create(this, this.getParser(), new StringInput(sb.toString()));
        ASTNode root = this.getAnalyser().read(ti, true, new ArrayList<SyntaxError>(), new boolean[]{false});
        Feature astProperties = this.getFeatureList().getFeature("AST");
        if (astProperties != null && root != null && (root1 = (ASTNode)astProperties.getValue("process", SyntaxContext.create(null, ASTPath.create(root)))) != null) {
            root = root1;
        }
        return root;
    }

    private static class EmptyLanguage
    extends Language {
        private String mimeType;
        private LLSyntaxAnalyser analyser = LLSyntaxAnalyser.createEmpty(this);
        private FeatureList featureList = new FeatureList();

        EmptyLanguage(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public Parser getParser() {
            return null;
        }

        @Override
        public LLSyntaxAnalyser getAnalyser() {
            return this.analyser;
        }

        @Override
        public FeatureList getFeatureList() {
            return this.featureList;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public int getTokenID(String tokenType) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getTokenTypeCount() {
            return 0;
        }

        @Override
        public String getTokenType(int tokenTypeID) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getNTID(String nt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getNTCount() {
            return 0;
        }

        @Override
        public String getNT(int ntid) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Language> getImportedLanguages() {
            return Collections.emptyList();
        }

        @Override
        public Feature getPreprocessorImport() {
            return null;
        }

        @Override
        public Map<String, Feature> getTokenImports() {
            return Collections.emptyMap();
        }
    }
}

