/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.providers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointAnnotator;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class ProfilingPointAnnotatorImpl
extends ProfilingPointAnnotator.Basic {
    public void annotate(CodeProfilingPoint profilingPoint) {
        this.annotate(profilingPoint, profilingPoint.getAnnotations());
    }

    public void deannotate(CodeProfilingPoint profilingPoint) {
        this.deannotate(profilingPoint.getAnnotations());
    }

    public void annotationChanged(PropertyChangeEvent evt) {
        ProfilingPoint profilingPoint = (ProfilingPoint)evt.getSource();
        this.deannotate((CodeProfilingPoint.Annotation[])evt.getOldValue());
        this.annotate((CodeProfilingPoint)profilingPoint, (CodeProfilingPoint.Annotation[])evt.getNewValue());
    }

    private void annotate(final CodeProfilingPoint profilingPoint, final CodeProfilingPoint.Annotation[] annotations) {
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            @Override
            public void run() {
                for (CodeProfilingPoint.Annotation cppa : annotations) {
                    Line editorLine = Utils.getEditorLine((CodeProfilingPoint)profilingPoint, (CodeProfilingPoint.Annotation)cppa);
                    if (editorLine == null) continue;
                    editorLine.addPropertyChangeListener((PropertyChangeListener)ProfilingPointsManager.getDefault());
                    cppa.attach((Annotatable)editorLine);
                }
            }
        });
    }

    private void deannotate(CodeProfilingPoint.Annotation[] annotations) {
        for (CodeProfilingPoint.Annotation cppa : annotations) {
            Annotatable cppaa = cppa.getAttachedAnnotatable();
            if (cppaa != null) {
                cppaa.removePropertyChangeListener((PropertyChangeListener)ProfilingPointsManager.getDefault());
            }
            cppa.detach();
        }
    }
}

