/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class ArrayTypeSerializer
implements JavonSerializer {
    private Set<ClassData> arrayTypes = new HashSet<ClassData>();

    @Override
    public String getName() {
        return "Array type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        return TypeKind.ARRAY == type.getKind();
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        ArrayType array;
        TypeMirror componentType;
        ClassData cCD;
        if (TypeKind.ARRAY == type.getKind() && (cCD = traversable.traverseType(componentType = (array = (ArrayType)type).getComponentType(), typeCache)) != null) {
            ClassData cd = new ClassData(cCD.getPackage(), cCD.getClassName(), false, true, (JavonSerializer)this);
            cd.setComponentType(cCD);
            traversable.registerType(cCD);
            this.arrayTypes.add(cd);
            return cd;
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping mapping, ClassData type) {
        ClassData componentType = type.getComponentType();
        return componentType.getSerializer().instanceOf(mapping, componentType) + "[]";
    }

    @Override
    public String toObject(JavonMapping mapping, ClassData type, String variable) {
        if (this.arrayTypes.contains(type)) {
            return variable;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromObject(JavonMapping mapping, ClassData type, String object) {
        if (this.arrayTypes.contains(type)) {
            return "(" + mapping.getRegistry().getTypeSerializer(type).instanceOf(mapping, type) + ")" + object;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String toStream(JavonMapping mapping, ClassData type, String stream, String object) {
        if (this.arrayTypes.contains(type)) {
            String serializationCode = "";
            String id = "" + mapping.getRegistry().getRegisteredTypeId(type);
            String instanceOfType = type.getSerializer().instanceOf(mapping, type);
            serializationCode = serializationCode + instanceOfType + " a_result_" + id + " = (" + instanceOfType + ") o;\n";
            serializationCode = serializationCode + stream + ".writeInt( a_result_" + id + ".length );\n";
            serializationCode = serializationCode + "for( int i  = 0; i < a_result_" + id + ".length; i++ ) {\n";
            ClassData componentType = type.getComponentType();
            serializationCode = componentType.isPrimitive() ? serializationCode + "writeObject( " + stream + ", " + componentType.getSerializer().toObject(mapping, componentType, "a_result_" + id + "[i]") + " , " + mapping.getRegistry().getRegisteredTypeId(componentType) + " );\n" : serializationCode + "writeObject( " + stream + ", a_result_" + id + "[i], " + mapping.getRegistry().getRegisteredTypeId(componentType) + " );\n";
            serializationCode = serializationCode + "}\n";
            return serializationCode;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromStream(JavonMapping mapping, ClassData type, String stream, String object) {
        if (this.arrayTypes.contains(type)) {
            String deserializationCode = "";
            String id = "" + mapping.getRegistry().getRegisteredTypeId(type);
            ClassData leafComponentType = type;
            int depth = 0;
            while ((leafComponentType = leafComponentType.getComponentType()).isArray()) {
                ++depth;
            }
            String appendedBrackets = "";
            for (int i = 0; i < depth; ++i) {
                appendedBrackets = appendedBrackets + "[]";
            }
            deserializationCode = deserializationCode + "int a_size_" + id + " = " + stream + ".readInt();\n";
            String instanceOfType = type.getSerializer().instanceOf(mapping, type);
            String leafInstanceOfType = leafComponentType.getSerializer().instanceOf(mapping, leafComponentType);
            deserializationCode = deserializationCode + instanceOfType + " a_result_" + id + " = new " + leafInstanceOfType + "[ a_size_" + id + " ]" + appendedBrackets + ";\n";
            String i = "a_i_" + id;
            deserializationCode = deserializationCode + "for( int " + i + " = 0; " + i + " < a_size_" + id + "; " + i + "++ ) {\n";
            ClassData componentType = type.getComponentType();
            deserializationCode = componentType.isPrimitive() ? deserializationCode + "a_result_" + id + "[" + i + "] = " + componentType.getSerializer().fromObject(mapping, componentType, "readObject( " + stream + " )") + ";\n" : deserializationCode + "a_result_" + id + "[" + i + "] = (" + type.getComponentType().getSerializer().instanceOf(mapping, type.getComponentType()) + ")readObject( " + stream + " );\n";
            deserializationCode = deserializationCode + "}\n";
            deserializationCode = deserializationCode + (object == null ? "" : object + " = a_result_" + id + ";\n");
            return deserializationCode;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData rootClassData, Set<ClassData> usedTypes) {
        HashSet<ClassData> result = new HashSet<ClassData>();
        result.add(rootClassData);
        result.addAll(rootClassData.getComponentType().getSerializer().getReferencedTypes(rootClassData.getComponentType(), usedTypes));
        return result;
    }
}

