/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.JobList;
import org.clang.driver.ToolChain;
import org.clang.driver.java.JavaDriverSupport;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.DenseMapInfoPair;
import org.llvm.adt.DenseMapInfoPointer;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.InputArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;

public class Compilation
implements Destructors.ClassWithDestructor {
    private Driver TheDriver;
    private ToolChain DefaultToolChain;
    private int ActiveOffloadMask;
    private std.multimapUIntType<ToolChain> OrderedOffloadingToolchains;
    private InputArgList Args;
    private DerivedArgList TranslatedArgs;
    private std.vector<std_ptr.unique_ptr<Action>> AllActions;
    private SmallVector<Action> Actions;
    private JobList Jobs;
    private DenseMap<std_pair.pair<ToolChain, char.ptr>, DerivedArgList> TCArgs;
    private ArgStringList TempFiles;
    private DenseMap<JobAction, char.ptr> ResultFiles;
    private DenseMap<JobAction, char.ptr> FailureResultFiles;
    private type.ptr<StringRef> Redirects;
    private boolean ForDiagnostics;

    public Compilation(Driver D, ToolChain _DefaultToolChain, InputArgList _Args, DerivedArgList _TranslatedArgs) {
        this.TheDriver = D;
        this.DefaultToolChain = _DefaultToolChain;
        this.ActiveOffloadMask = 0;
        this.OrderedOffloadingToolchains = new std.multimapUIntType(null);
        this.Args = _Args;
        this.TranslatedArgs = _TranslatedArgs;
        this.AllActions = new std.vector((Object)new std_ptr.unique_ptr());
        this.Actions = new SmallVector(3, (Object)null);
        this.Jobs = new JobList();
        this.TCArgs = new DenseMap((DenseMapInfo)new DenseMapInfoPair((DenseMapInfo)new DenseMapInfoObject((Object)DummyToolChain.EMPTY, (Object)DummyToolChain.TOMBSTONE), (DenseMapInfo)new DenseMapInfoPointer((void.ptr)NativePointer.$EMPTY, (void.ptr)NativePointer.$EMPTY_TOMBSTONE)), (Object)null);
        this.TempFiles = new ArgStringList();
        this.ResultFiles = new DenseMap((DenseMapInfo)new DenseMapInfoObject((Object)JobAction.EMPTY, (Object)JobAction.TOMBSTONE), (Object)null);
        this.FailureResultFiles = new DenseMap((DenseMapInfo)new DenseMapInfoObject((Object)JobAction.EMPTY, (Object)JobAction.TOMBSTONE), (Object)null);
        this.Redirects = null;
        this.ForDiagnostics = false;
        this.OrderedOffloadingToolchains.insert(std.make_pair_uint_Ptr((int)1, (Object)this.DefaultToolChain));
    }

    public void $destroy() {
        if (this.TranslatedArgs != null) {
            this.TranslatedArgs.$destroy();
        }
        if (this.Args != null) {
            this.Args.$destroy();
        }
        DenseMapIterator it = this.TCArgs.begin();
        DenseMapIterator ie = this.TCArgs.end();
        while (it.$noteq(ie)) {
            if (it.$arrow().second != this.TranslatedArgs && it.$arrow().second != null) {
                ((DerivedArgList)it.$arrow().second).$destroy();
            }
            it.$preInc();
        }
        if (this.Redirects != null) {
            Destructors.$destroy((Object)this.Redirects.$at(0));
            Destructors.$destroy((Object)this.Redirects.$at(1));
            Destructors.$destroy((Object)this.Redirects.$at(2));
            Destructors.$destroyArray(this.Redirects);
        }
        this.FailureResultFiles.$destroy();
        this.ResultFiles.$destroy();
        this.TempFiles.$destroy();
        this.TCArgs.$destroy();
        this.Jobs.$destroy();
        this.Actions.$destroy();
        this.AllActions.$destroy();
        this.OrderedOffloadingToolchains.$destroy();
    }

    public Driver getDriver() {
        return this.TheDriver;
    }

    public ToolChain getDefaultToolChain() {
        return this.DefaultToolChain;
    }

    public int isOffloadingHostKind(int Kind2) {
        return this.ActiveOffloadMask & Kind2;
    }

    public std_pair.pair<type.iterator<?, std_pair.pairUIntType<ToolChain>>, type.iterator<?, std_pair.pairUIntType<ToolChain>>> getOffloadToolChains(int Kind2) {
        return this.OrderedOffloadingToolchains.equal_range(Kind2);
    }

    public ToolChain getSingleOffloadToolChain(int Kind2) {
        std_pair.pair<type.iterator<?, std_pair.pairUIntType<ToolChain>>, type.iterator<?, std_pair.pairUIntType<ToolChain>>> TCs = this.getOffloadToolChains(Kind2);
        assert (Native.$noteq_iter((abstract_iterator)((abstract_iterator)TCs.first), (abstract_iterator)((abstract_iterator)TCs.second))) : "No tool chains of the selected kind exist!";
        assert (Native.$eq_iter((abstract_iterator)std.next((abstract_iterator)((abstract_iterator)Native.$tryClone((NativeCloneable)((NativeCloneable)TCs.first)))), (abstract_iterator)((abstract_iterator)TCs.second))) : "More than one tool chain of the this kind exist.";
        return (ToolChain)((std_pair.pairUIntType)((type.iterator)TCs.first).$arrow()).second;
    }

    public void addOffloadDeviceToolChain(ToolChain DeviceToolChain, int OffloadKind2) {
        assert (OffloadKind2 != 1 && OffloadKind2 != 0) : "This is not a device tool chain!";
        this.ActiveOffloadMask |= OffloadKind2;
        this.OrderedOffloadingToolchains.insert(std.make_pair_uint_Ptr((int)OffloadKind2, (Object)DeviceToolChain));
    }

    public InputArgList getInputArgs() {
        return this.Args;
    }

    public DerivedArgList getArgs() {
        return this.TranslatedArgs;
    }

    public SmallVector<Action> getActions() {
        return this.Actions;
    }

    public <T extends Action> T MakeAction(T A) {
        this.AllActions.push_back((Object)new std_ptr.unique_ptr(A));
        return A;
    }

    public JobList getJobs() {
        return this.Jobs;
    }

    public void addCommand(std_ptr.unique_ptr<Command> C) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.Jobs.addJob((std_ptr.unique_ptr<Command>)$c$.track(new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, std.move(C))));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    public ArgStringList getTempFiles() {
        return this.TempFiles;
    }

    public DenseMap<JobAction, char.ptr> getResultFiles() {
        return this.ResultFiles;
    }

    public DenseMap<JobAction, char.ptr> getFailureResultFiles() {
        return this.FailureResultFiles;
    }

    public StringRef getSysRoot() {
        return new StringRef(this.getDriver().SysRoot);
    }

    public DerivedArgList getArgsForToolChain(ToolChain TC, char.ptr BoundArch) {
        DerivedArgList Entry2;
        if (TC == null) {
            TC = this.DefaultToolChain;
        }
        if ((Entry2 = (DerivedArgList)this.TCArgs.$at((Object)std.make_pair_Ptr_Ptr((Object)TC, (Object)BoundArch))) == null && (Entry2 = TC.TranslateArgs(this.TranslatedArgs, BoundArch)) == null) {
            Entry2 = this.TranslatedArgs;
        }
        return Entry2;
    }

    public char.ptr addTempFile(char.ptr Name) {
        this.TempFiles.push_back((Object)Name);
        return Name;
    }

    public char.ptr addResultFile(char.ptr Name, JobAction JA) {
        this.ResultFiles.$set((Object)JA, (Object)Name);
        return Name;
    }

    public char.ptr addFailureResultFile(char.ptr Name, JobAction JA) {
        this.FailureResultFiles.$set((Object)JA, (Object)Name);
        return Name;
    }

    public boolean CleanupFile(char.ptr File) {
        return this.CleanupFile(File, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean CleanupFile(char.ptr File, boolean IssueErrors) {
        if (!fs.can_write((Twine)new Twine(File)) || !fs.is_regular_file((Twine)new Twine(File))) {
            return true;
        }
        std_errors.error_code EC = fs.remove((Twine)new Twine(File));
        if (EC.$bool()) {
            if (IssueErrors) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(357))), (StringRef)new StringRef(EC.message())));
                }
                finally {
                    $c$.$destroy();
                }
            }
            return false;
        }
        return true;
    }

    public boolean CleanupFileList(ArgStringList Files) {
        return this.CleanupFileList(Files, false);
    }

    public boolean CleanupFileList(ArgStringList Files, boolean IssueErrors) {
        boolean Success = true;
        SmallVectorImpl.iterator it = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)Files.begin());
        SmallVectorImpl.iterator ie = (SmallVectorImpl.iterator)Native.$tryClone((NativeCloneable)Files.end());
        while (Native.$noteq_iter((abstract_iterator)it, (abstract_iterator)ie)) {
            Success &= this.CleanupFile((char.ptr)it.$star(), IssueErrors);
            it.$preInc();
        }
        return Success;
    }

    public boolean CleanupFileMap(DenseMap<JobAction, char.ptr> Files, JobAction JA) {
        return this.CleanupFileMap(Files, JA, false);
    }

    public boolean CleanupFileMap(DenseMap<JobAction, char.ptr> Files, JobAction JA, boolean IssueErrors) {
        boolean Success = true;
        DenseMapIterator it = Files.begin();
        DenseMapIterator ie = Files.end();
        while (it.$noteq(ie)) {
            if (JA == null || it.$arrow().first == JA) {
                Success &= this.CleanupFile((char.ptr)it.$arrow().second, IssueErrors);
            }
            it.$preInc();
        }
        return Success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ExecuteCommand(Command C, type.ref<Command> FailingCommand) {
        if ((this.getDriver().CCPrintOptions || this.getArgs().hasArg(new OptSpecifier(options.ID.OPT_v.getValue()))) && !this.getDriver().CCGenDiagnostics) {
            raw_ostream OS = llvm.errs();
            if (this.getDriver().CCPrintOptions && this.getDriver().CCPrintOptionsFilename != null) {
                std_errors.error_code EC = new std_errors.error_code();
                OS = new raw_fd_ostream(new StringRef(this.getDriver().CCPrintOptionsFilename), EC, fs.$bitor_OpenFlags((int)2, (int)4));
                if (EC.$bool()) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(309))), (StringRef)new StringRef(EC.message())));
                        FailingCommand.$set((Object)C);
                        if (OS != null) {
                            OS.$destroy();
                        }
                        int n = 1;
                        return n;
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
            }
            if (this.getDriver().CCPrintOptions) {
                OS.$out("[Logging clang options]");
            }
            C.Print(OS, NativePointer.$LF, this.getDriver().CCPrintOptions);
            if (OS != llvm.errs() && OS != null) {
                OS.$destroy();
            }
        }
        std.string Error2 = new std.string();
        bool.ptr ExecutionFailed = NativePointer.create_bool$ptr();
        int Res = C.Execute(this.Redirects, Error2, ExecutionFailed);
        if (!Error2.empty()) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                assert (Res != 0) : "Error string set with 0 result code!";
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(313))), (StringRef)new StringRef(Error2)));
            }
            finally {
                $c$.$destroy();
            }
        }
        if (Res != 0) {
            FailingCommand.$set((Object)C);
        }
        return ExecutionFailed.$star() ? 1 : Res;
    }

    public void ExecuteJobs(JobList Jobs, SmallVectorImpl<std_pair.pairIntType<Command>> FailingCommands) {
        for (Command Job : Jobs) {
            type.ref FailingCommand;
            int Res = this.ExecuteCommand(Job, (type.ref<Command>)(FailingCommand = NativePointer.create_type$ref((Object)null)));
            if (Res == 0) continue;
            FailingCommands.push_back((Object)std.make_pair_int_Ptr((int)Res, (Object)FailingCommand.$deref()));
            return;
        }
    }

    public void initCompilationForDiagnostics() {
        this.ForDiagnostics = true;
        this.Actions.clear();
        this.AllActions.clear();
        this.Jobs.clear();
        this.TempFiles.clear();
        this.ResultFiles.clear();
        this.FailureResultFiles.clear();
        Object[] OutputOpts = JavaDriverSupport.$IDsToOptSpecifiers(new options.ID[]{options.ID.OPT_o, options.ID.OPT_MD, options.ID.OPT_MMD});
        int e = llvm.array_lengthof((Object[])OutputOpts);
        for (int i = 0; i != e; ++i) {
            if (!this.TranslatedArgs.hasArg((OptSpecifier)OutputOpts[i])) continue;
            this.TranslatedArgs.eraseArg((OptSpecifier)OutputOpts[i]);
        }
        this.TranslatedArgs.ClaimAllArgs();
        this.Redirects = NativePointer.create_type$ptr((Object[])new StringRef[3]);
        this.Redirects.$set(0, null);
        this.Redirects.$set(1, (Object)new StringRef());
        this.Redirects.$set(2, (Object)new StringRef());
    }

    public boolean isForDiagnostics() {
        return this.ForDiagnostics;
    }

    public void Redirect(type.ptr<StringRef> Redirects) {
        this.Redirects = (type.ptr)Native.$tryClone(Redirects);
    }

    public String toString() {
        return "TheDriver=" + this.TheDriver + ", DefaultToolChain=" + this.DefaultToolChain + ", ActiveOffloadMask=" + this.ActiveOffloadMask + ", OrderedOffloadingToolchains=" + this.OrderedOffloadingToolchains + ", Args=" + this.Args + ", TranslatedArgs=" + this.TranslatedArgs + ", AllActions=" + this.AllActions + ", Actions=" + this.Actions + ", Jobs=" + this.Jobs + ", TCArgs=" + this.TCArgs + ", TempFiles=" + this.TempFiles + ", ResultFiles=" + this.ResultFiles + ", FailureResultFiles=" + this.FailureResultFiles + ", Redirects=" + this.Redirects + ", ForDiagnostics=" + this.ForDiagnostics;
    }

    private static class DummyToolChain
    extends ToolChain {
        private static final DummyToolChain EMPTY = new DummyToolChain();
        private static final DummyToolChain TOMBSTONE = new DummyToolChain();

        private DummyToolChain() {
        }

        @Override
        public boolean isPICDefault() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isPIEDefault() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean isPICDefaultForced() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

