/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.netbeans.api.queries.FileEncodingQuery;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AntProjectSupport
implements AntProjectCookie.ParseStatus,
DocumentListener,
PropertyChangeListener,
FileChangeListener {
    private static final Logger LOG = Logger.getLogger(AntProjectSupport.class.getName());
    private FileObject fo;
    private Document projDoc = null;
    private Throwable exception = null;
    private boolean parsed = false;
    private Reference<StyledDocument> styledDocRef = null;
    private final Object parseLock;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private Reference<EditorCookie.Observable> editorRef;
    private DocumentBuilder documentBuilder;
    private FileChangeListener fileListener;
    private static final int REPARSE_DELAY = 3000;
    private final RequestProcessor rp;
    private RequestProcessor.Task task = null;

    public AntProjectSupport(FileObject fo) {
        this.fo = fo;
        this.parseLock = new Object();
        this.rp = new RequestProcessor("AntProjectSupport[" + fo + "]");
    }

    private synchronized EditorCookie.Observable getEditor() {
        EditorCookie.Observable editor;
        FileObject file = this.getFileObject();
        if (file == null) {
            return null;
        }
        EditorCookie.Observable observable = editor = this.editorRef == null ? null : this.editorRef.get();
        if (editor == null) {
            try {
                editor = (EditorCookie.Observable)DataObject.find((FileObject)file).getLookup().lookup(EditorCookie.Observable.class);
                if (editor != null) {
                    editor.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)editor));
                    this.editorRef = new WeakReference<EditorCookie.Observable>(editor);
                }
            }
            catch (DataObjectNotFoundException donfe) {
                LOG.log(Level.INFO, "no editor for " + this.fo, donfe);
            }
        }
        return editor;
    }

    @Override
    public File getFile() {
        FileObject file = this.getFileObject();
        if (file != null) {
            return FileUtil.toFile((FileObject)file);
        }
        return null;
    }

    @Override
    public FileObject getFileObject() {
        if (this.fo != null && !this.fo.isValid()) {
            return null;
        }
        return this.fo;
    }

    public void setFile(File f) {
        this.fo = FileUtil.toFileObject((File)f);
        this.invalidate();
    }

    public void setFileObject(FileObject fo) {
        this.fo = fo;
        this.invalidate();
    }

    @Override
    public boolean isParsed() {
        return this.parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getDocument() {
        Object object = this.parseLock;
        synchronized (object) {
            if (!this.parsed) {
                this.parseDocument();
            }
            if (this.projDoc == null) {
                return null;
            }
            try {
                return (Document)this.projDoc.cloneNode(true);
            }
            catch (DOMException x) {
                Logger.getLogger(AntProjectSupport.class.getName()).log(Level.INFO, "#154502: cloning document for " + this, x);
                return this.projDoc;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable getParseException() {
        Object object = this.parseLock;
        synchronized (object) {
            if (!this.parsed) {
                this.parseDocument();
            }
            return this.exception;
        }
    }

    private static synchronized DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setErrorHandler(ErrHandler.DEFAULT);
        return documentBuilder;
    }

    public static InputSource createInputSource(FileObject fo, final StyledDocument document) throws IOException {
        InputSource in;
        block7: {
            block6: {
                DataObject d;
                if (fo != null && !(d = DataObject.find((FileObject)fo)).isModified()) {
                    try {
                        InputSource s = new InputSource();
                        s.setSystemId(fo.getURL().toExternalForm());
                        s.setByteStream(fo.getInputStream());
                        return s;
                    }
                    catch (FileStateInvalidException e) {
                        if ($assertionsDisabled) break block6;
                        throw new AssertionError((Object)e);
                    }
                }
            }
            final String[] contents = new String[1];
            document.render(new Runnable(){

                @Override
                public void run() {
                    try {
                        contents[0] = document.getText(0, document.getLength());
                    }
                    catch (BadLocationException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            });
            in = new InputSource(new StringReader(contents[0]));
            if (fo != null) {
                try {
                    in.setSystemId(fo.getURL().toExternalForm());
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocument() {
        block28: {
            assert (Thread.holdsLock(this.parseLock));
            FileObject file = this.getFileObject();
            LOG.log(Level.FINE, "AntProjectSupport.parseDocument: fo={0}", file);
            try {
                StyledDocument document;
                if (this.documentBuilder == null) {
                    this.documentBuilder = AntProjectSupport.createDocumentBuilder();
                }
                EditorCookie.Observable ed = this.getEditor();
                Document doc = null;
                if (ed != null && (document = ed.getDocument()) != null) {
                    if (file != null && this.fileListener != null) {
                        file.removeFileChangeListener(this.fileListener);
                    }
                    if (this.styledDocRef != null && this.styledDocRef.get() != document || this.styledDocRef == null) {
                        document.addDocumentListener(this);
                        this.styledDocRef = new WeakReference<StyledDocument>(document);
                    }
                    InputSource in = AntProjectSupport.createInputSource(file, document);
                    try {
                        doc = this.documentBuilder.parse(in);
                    }
                    finally {
                        if (in.getByteStream() != null) {
                            in.getByteStream().close();
                        }
                    }
                }
                if (doc == null) {
                    if (file != null) {
                        if (this.fileListener == null) {
                            this.fileListener = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)file);
                            file.addFileChangeListener(this.fileListener);
                        }
                        try (InputStreamReader reader = new InputStreamReader(file.getInputStream(), FileEncodingQuery.getEncoding((FileObject)file));){
                            InputSource in = new InputSource(reader);
                            in.setSystemId(file.toURL().toExternalForm());
                            doc = this.documentBuilder.parse(in);
                        }
                    } else {
                        this.exception = new FileNotFoundException("Ant script probably deleted");
                        return;
                    }
                }
                this.projDoc = doc;
                this.exception = null;
            }
            catch (Exception e) {
                this.exception = e;
                if (this.exception instanceof SAXParseException) break block28;
                LOG.log(Level.INFO, "Strange parse error in " + this, this.exception);
            }
        }
        this.fireChangeEvent(false);
        this.parsed = true;
    }

    @Override
    public Element getProjectElement() {
        Document doc = this.getDocument();
        if (doc != null) {
            return doc.getDocumentElement();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AntProjectSupport)) {
            return false;
        }
        AntProjectSupport other = (AntProjectSupport)o;
        if (this.fo != null) {
            return this.fo.equals(other.fo);
        }
        return false;
    }

    public int hashCode() {
        return 0x6CB1 ^ (this.fo != null ? this.fo.hashCode() : 0);
    }

    public String toString() {
        FileObject file = this.getFileObject();
        if (file != null) {
            return file.toString();
        }
        return "<missing Ant script>";
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(boolean delay) {
        LOG.log(Level.FINE, "AntProjectSupport.fireChangeEvent: fo={0}", this.fo);
        ChangeFirer f = new ChangeFirer();
        AntProjectSupport antProjectSupport = this;
        synchronized (antProjectSupport) {
            if (this.task == null) {
                this.task = this.rp.post((Runnable)f, delay ? 3000 : 0);
            } else if (!delay) {
                this.task.schedule(0);
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
        this.invalidate();
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    @Override
    public void insertUpdate(DocumentEvent ev) {
        this.invalidate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("document".equals(e.getPropertyName())) {
            this.invalidate();
        }
    }

    public void fileChanged(FileEvent fe) {
        this.invalidate();
    }

    public void fileDeleted(FileEvent fe) {
        this.invalidate();
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
    }

    protected final void invalidate() {
        LOG.log(Level.FINE, "AntProjectSupport.invalidate: fo={0}", this.fo);
        this.parsed = false;
        this.fireChangeEvent(true);
    }

    private final class ChangeFirer
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.log(Level.FINE, "AntProjectSupport.ChangeFirer.run: fo={0}", AntProjectSupport.this.fo);
            AntProjectSupport antProjectSupport = AntProjectSupport.this;
            synchronized (antProjectSupport) {
                if (AntProjectSupport.this.task == null) {
                    return;
                }
                AntProjectSupport.this.task = null;
            }
            AntProjectSupport.this.cs.fireChange();
        }
    }

    private static final class ErrHandler
    implements ErrorHandler {
        static final ErrorHandler DEFAULT = new ErrHandler();

        private ErrHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }
}

