/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.net;

import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.net.ServerSocketFactory;
import sun.security.provider.Sun;

public class SSLSocketFactory
extends ServerSocketFactory {
    private boolean clientAuth = false;
    private SSLServerSocketFactory sslProxy = null;
    static String defaultKeystoreFile = String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore";
    static String defaultKeyPass = "changeit";

    public ServerSocket createSocket(int port) throws IOException {
        if (this.sslProxy == null) {
            this.initProxy();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (this.sslProxy == null) {
            this.initProxy();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (this.sslProxy == null) {
            this.initProxy();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    private KeyStore initKeyStore(String keystoreFile, String keyPass) throws IOException {
        FileInputStream istream = null;
        try {
            KeyStore kstore = KeyStore.getInstance("JKS");
            istream = new FileInputStream(keystoreFile);
            kstore.load(istream, keyPass.toCharArray());
            return kstore;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            throw new IOException("Exception trying to load keystore " + keystoreFile + ": " + ex.getMessage());
        }
    }

    private void initProxy() throws IOException {
        try {
            String keyPass;
            this.clientAuth = "true".equals(this.attributes.get("clientAuth"));
            Security.addProvider(new Sun());
            Security.addProvider((java.security.Provider)new Provider());
            String keystoreFile = (String)this.attributes.get("keystore");
            if (keystoreFile == null) {
                keystoreFile = defaultKeystoreFile;
            }
            if ((keyPass = (String)this.attributes.get("keypass")) == null) {
                keyPass = defaultKeyPass;
            }
            KeyStore kstore = this.initKeyStore(keystoreFile, keyPass);
            SSLContext context = SSLContext.getInstance((String)"TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)"SunX509");
            kmf.init(kstore, keyPass.toCharArray());
            TrustManager[] tm = null;
            if (this.clientAuth) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)"SunX509");
                tmf.init(kstore);
                tm = tmf.getTrustManagers();
            }
            context.init(kmf.getKeyManagers(), tm, null);
            this.sslProxy = context.getServerSocketFactory();
            return;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e.getMessage());
        }
    }

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        String[] cipherSuites = socket.getSupportedCipherSuites();
        socket.setEnabledCipherSuites(cipherSuites);
        socket.setNeedClientAuth(this.clientAuth);
    }

    public void preProcessRequest(Socket socket, Request reqA) {
        try {
            SSLSocket sslSocket = (SSLSocket)socket;
            X509Certificate[] certChain = sslSocket.getSession().getPeerCertificateChain();
            if (certChain != null && certChain.length > 0) {
                reqA.setAttribute("tomcat.request.X509CertificateChain", certChain);
                reqA.setAttribute("javax.servlet.request.X509Certificate", certChain[0]);
            }
        }
        catch (Exception exception) {}
        reqA.setScheme("https");
    }
}

