/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.WLTrustHandler;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerLocalPropertiesPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerLocationPanel;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.ServerRemotePropertiesPanel;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class WLInstantiatingIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final Logger LOGGER = Logger.getLogger(WLInstantiatingIterator.class.getName());
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    public static final String DEFAULT_DEBUGGER_PORT = "8787";
    public static final String DEFAULT_PROXY_ENABLED = "true";
    public static final String DEFAULT_MAC_MEM_OPTS_HEAP = "-Xmx1024m";
    public static final String DEFAULT_MAC_MEM_OPTS_PERM = "-XX:PermSize=256m";
    private static final Version JDK8_ONLY_SERVER_VERSION = Version.fromJsr277NotationWithFallback((String)"12.2.1");
    private WizardDescriptor wizardDescriptor;
    private String serverRoot;
    private String domainRoot;
    private String username;
    private String password;
    private String url;
    private String domainName;
    private String port;
    private String debugPort;
    private String host;
    private boolean remote;
    private boolean ssl;
    private boolean remoteDebug;
    private Version serverVersion;
    private final String[] steps = new String[]{NbBundle.getMessage(WLInstantiatingIterator.class, (String)"SERVER_LOCATION_STEP"), NbBundle.getMessage(WLInstantiatingIterator.class, (String)"SERVER_PROPERTIES_STEP")};
    private ServerLocationPanel serverLocationPanel;
    private WizardDescriptor.Panel serverPropertiesPanel;
    private int index = 0;
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public String name() {
        return "";
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        String displayName = (String)this.wizardDescriptor.getProperty(PROP_DISPLAY_NAME);
        result.add(this.instantiate(displayName));
        return result;
    }

    private InstanceProperties instantiate(String displayName) throws IOException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("serverRoot", this.serverRoot);
        props.put("domainRoot", this.domainRoot);
        props.put("domainName", this.domainName);
        props.put("port", this.port);
        props.put("host", this.host);
        props.put("remote", Boolean.toString(this.remote));
        props.put("secured", Boolean.toString(this.ssl));
        props.put("trustException", null);
        props.put("remoteDebug", Boolean.toString(this.remoteDebug));
        props.put("proxy_enabled", DEFAULT_PROXY_ENABLED);
        if (this.remoteDebug) {
            props.put("debuggerPort", this.debugPort);
        } else {
            props.put("debuggerPort", DEFAULT_DEBUGGER_PORT);
        }
        if (Utilities.isMac()) {
            StringBuilder memOpts = new StringBuilder(DEFAULT_MAC_MEM_OPTS_HEAP);
            Version version = WLPluginProperties.getServerVersion(new File(this.serverRoot));
            if (version != null && !JDK8_ONLY_SERVER_VERSION.isBelowOrEqual(version)) {
                memOpts.append(' ');
                memOpts.append(DEFAULT_MAC_MEM_OPTS_PERM);
            }
            props.put("mem_opts", memOpts.toString());
        }
        try {
            WLTrustHandler.removeFromTrustStore(this.url);
        }
        catch (GeneralSecurityException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        InstanceProperties ip = InstanceProperties.createInstanceProperties((String)this.url, (String)this.username, (String)this.password, (String)displayName, props);
        return ip;
    }

    static String decorateMessage(String message) {
        if (message == null) {
            return null;
        }
        if (message.toUpperCase(Locale.ENGLISH).startsWith("<HTML>")) {
            return message;
        }
        return "<html>" + message.replaceAll("<", "&lt;").replaceAll(">", "&gt;") + "</html>";
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setDomainName(String name) {
        this.domainName = name;
    }

    public void setServerRoot(String serverRoot) {
        this.serverRoot = serverRoot;
        if (this.serverPropertiesPanel instanceof ServerLocalPropertiesPanel) {
            ((ServerLocalPropertiesPanel)this.serverPropertiesPanel).getVisual().updateInstancesList();
            ((ServerLocalPropertiesPanel)this.serverPropertiesPanel).getVisual().updateJpa2Button();
        }
    }

    public String getServerRoot() {
        return this.serverRoot;
    }

    public String getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainRoot(String domainRoot) {
        this.domainRoot = domainRoot;
    }

    public String getDomainRoot() {
        return this.domainRoot;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isRemoteDebug() {
        return this.remoteDebug;
    }

    public void setRemoteDebug(boolean remoteDebug) {
        this.remoteDebug = remoteDebug;
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(String debugPort) {
        this.debugPort = debugPort;
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(Version serverVersion) {
        this.serverVersion = serverVersion;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public boolean hasNext() {
        return this.index < 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public WizardDescriptor.Panel current() {
        switch (this.index) {
            case 0: {
                return this.getLocationPanel();
            }
            case 1: {
                return this.getPropertiesPanel();
            }
        }
        throw new IllegalStateException();
    }

    private WizardDescriptor.Panel getLocationPanel() {
        if (this.serverLocationPanel == null) {
            this.serverLocationPanel = new ServerLocationPanel(this);
            this.initComponent(this.serverLocationPanel.getComponent(), 0);
        }
        return this.serverLocationPanel;
    }

    private WizardDescriptor.Panel getPropertiesPanel() {
        if (this.isRemote() && this.serverPropertiesPanel instanceof ServerRemotePropertiesPanel || !this.isRemote() && this.serverPropertiesPanel instanceof ServerLocalPropertiesPanel) {
            return this.serverPropertiesPanel;
        }
        this.serverPropertiesPanel = this.isRemote() ? this.createRemotePanel() : this.createLocalPanel();
        return this.serverPropertiesPanel;
    }

    private WizardDescriptor.Panel createLocalPanel() {
        ServerLocalPropertiesPanel serverLocalPanel = new ServerLocalPropertiesPanel(this);
        this.initComponent(serverLocalPanel.getComponent(), 1);
        serverLocalPanel.getVisual().updateInstancesList();
        serverLocalPanel.getVisual().updateJpa2Button();
        return serverLocalPanel;
    }

    private WizardDescriptor.Panel createRemotePanel() {
        ServerRemotePropertiesPanel serverRemotePanel = new ServerRemotePropertiesPanel(this);
        this.initComponent(serverRemotePanel.getComponent(), 1);
        return serverRemotePanel;
    }

    private void initComponent(Component c, int step) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", step);
            jc.putClientProperty("WizardPanel_contentData", this.steps);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    private void fireChangeEvent(ChangeEvent event) {
        for (ChangeListener l : this.listeners) {
            l.stateChanged(event);
        }
    }
}

