/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.VersionBridge;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLJpa2SwitchSupport;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.netbeans.modules.weblogic.common.api.DomainConfiguration;
import org.netbeans.modules.weblogic.common.api.WebLogicLayout;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerLocalPropertiesVisual
extends JPanel {
    private transient WLInstantiatingIterator instantiatingIterator;
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private final List<Instance> instances = new ArrayList<Instance>();
    private transient WLJpa2SwitchSupport support;
    private JButton browseButton;
    private JLabel explanationLabel;
    private JLabel jpa2Status;
    private JButton jpa2SwitchButton;
    private JLabel jpa2SwitchLabel;
    private JComboBox localInstancesCombo;
    private JLabel localInstancesLabel;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JTextField usernameField;
    private JLabel usernameLabel;

    public ServerLocalPropertiesVisual(WLInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
        this.setName(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"SERVER_PROPERTIES_STEP"));
        this.initComponents();
        this.localInstancesCombo.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerLocalPropertiesVisual.this.fireChangeEvent();
            }
        });
        this.localInstancesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerLocalPropertiesVisual.this.fireChangeEvent();
            }
        });
        this.usernameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerLocalPropertiesVisual.this.fireChangeEvent();
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerLocalPropertiesVisual.this.fireChangeEvent();
            }
        });
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
        wizardDescriptor.putProperty("WizardPanel_warningMessage", null);
        Object item = this.localInstancesCombo.getEditor().getItem();
        Instance instance = item instanceof Instance ? (Instance)item : this.getServerInstance(item.toString().trim());
        if (instance == null) {
            String value = item.toString().trim();
            for (Instance inst : this.instances) {
                if (!value.equals(inst.getDomainName())) continue;
                instance = inst;
                break;
            }
        }
        if (instance == null || !this.isValidDomainRoot(instance.getDomainPath())) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ERR_INVALID_DOMAIN_ROOT")));
            return false;
        }
        if (InstanceProperties.getInstanceProperties((String)this.getUrl(instance)) != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ERR_ALREADY_REGISTERED")));
            return false;
        }
        if (instance.getDomainVersion() != null && this.instantiatingIterator.getServerVersion() != null && !this.instantiatingIterator.getServerVersion().expand("0").equals((Object)instance.getDomainVersion().expand("0"))) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ERR_INVALID_DOMAIN_VERSION")));
            return false;
        }
        if (instance.isProductionModeEnabled()) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"WARN_PRODUCTION_MODE")));
        }
        if (instance.getName().startsWith("examples") && this.passwordField.getPassword().length <= 0) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ERR_EMPTY_SAMPLE_PASSWORD")));
        } else if (this.passwordField.getPassword().length <= 0) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ERR_EMPTY_PASSWORD")));
        } else {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(this.getClass(), (String)"MSG_RegisterExisting", (Object)instance.getDomainName())));
        }
        this.instantiatingIterator.setUrl(this.getUrl(instance));
        this.instantiatingIterator.setDomainRoot(instance.getDomainPath());
        this.instantiatingIterator.setUsername(this.usernameField.getText());
        this.instantiatingIterator.setPassword(new String(this.passwordField.getPassword()));
        this.instantiatingIterator.setPort(Integer.toString(instance.getPort()));
        this.instantiatingIterator.setDomainName(instance.getDomainName());
        this.instantiatingIterator.setHost(instance.getHost());
        this.instantiatingIterator.setRemote(false);
        this.instantiatingIterator.setSsl(false);
        return true;
    }

    private String getUrl(Instance instance) {
        return WLDeploymentFactory.getUrl(instance.getHost(), instance.getPort(), this.instantiatingIterator.getServerRoot(), instance.getDomainPath());
    }

    private boolean isValidDomainRoot(String path) {
        String[] children = new String[]{"servers", "config", "config/config.xml"};
        return this.hasChildren(path, children);
    }

    private boolean hasChildren(String parent, String[] children) {
        if (parent == null) {
            return false;
        }
        if (children == null) {
            return true;
        }
        for (int i = 0; i < children.length; ++i) {
            if (new File(parent + File.separator + children[i]).exists()) continue;
            return false;
        }
        return true;
    }

    private List<Instance> getServerInstances() {
        ArrayList<Instance> result = new ArrayList<Instance>();
        String[] domains = WLPluginProperties.getRegisteredDomainPaths(this.instantiatingIterator.getServerRoot());
        for (int i = 0; i < domains.length; ++i) {
            Instance localInstance = this.getServerInstance(domains[i]);
            if (localInstance == null) continue;
            result.add(localInstance);
        }
        return result;
    }

    private Instance getServerInstance(String domainPath) {
        DomainConfiguration config = WebLogicLayout.getDomainConfiguration((String)domainPath);
        if (config == null) {
            return null;
        }
        if (config.getAdminServer() == null) {
            return null;
        }
        return new Instance(config.getAdminServer(), config.getHost(), config.getPort(), domainPath, config.getName(), VersionBridge.getVersion(config.getVersion()), config.isProduction());
    }

    public void updateInstancesList() {
        this.instances.clear();
        this.instances.addAll(this.getServerInstances());
        this.localInstancesCombo.setModel(new DefaultComboBoxModel<Object>(this.instances.toArray()));
    }

    public void updateJpa2Button() {
        File root = new File(this.instantiatingIterator.getServerRoot());
        this.support = new WLJpa2SwitchSupport(root);
        boolean statusVisible = this.support.isSwitchSupported();
        boolean buttonVisible = statusVisible && !this.support.isEnabledViaSmartUpdate();
        this.jpa2SwitchLabel.setVisible(statusVisible);
        this.jpa2Status.setVisible(statusVisible);
        this.jpa2SwitchButton.setVisible(buttonVisible);
        this.updateJpa2Status();
    }

    private void updateJpa2Status() {
        if (this.support.isEnabled() || this.support.isEnabledViaSmartUpdate()) {
            this.jpa2Status.setText(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.jpa2Status.enabledText"));
            Mnemonics.setLocalizedText((AbstractButton)this.jpa2SwitchButton, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.jpa2SwitchButton.disableText"));
        } else {
            this.jpa2Status.setText(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.jpa2Status.disabledText"));
            Mnemonics.setLocalizedText((AbstractButton)this.jpa2SwitchButton, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.jpa2SwitchButton.enableText"));
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.localInstancesLabel = new JLabel();
        this.localInstancesCombo = new JComboBox<Object>(new DefaultComboBoxModel<Object>(this.getServerInstances().toArray()));
        this.usernameLabel = new JLabel();
        this.usernameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.browseButton = new JButton();
        this.explanationLabel = new JLabel();
        this.jpa2SwitchLabel = new JLabel();
        this.jpa2Status = new JLabel();
        this.jpa2SwitchButton = new JButton();
        this.localInstancesLabel.setHorizontalAlignment(11);
        this.localInstancesLabel.setLabelFor(this.localInstancesCombo);
        Mnemonics.setLocalizedText((JLabel)this.localInstancesLabel, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"LBL_LOCAL_INSTANCE"));
        this.localInstancesCombo.setEditable(true);
        this.localInstancesCombo.addItemListener(new LocalInstancesItemListener());
        this.usernameLabel.setHorizontalAlignment(11);
        this.usernameLabel.setLabelFor(this.usernameField);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"LBL_USERNAME"));
        this.usernameField.setColumns(15);
        this.usernameField.setText("weblogic");
        this.passwordLabel.setHorizontalAlignment(11);
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"LBL_PASSWORD"));
        this.passwordField.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerLocalPropertiesVisual.this.browseButtonActionPerformed(evt);
            }
        });
        this.explanationLabel.setText(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.explanationLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jpa2SwitchLabel, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.jpa2SwitchLabel.text"));
        this.jpa2Status.setText(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.jpa2Status.disabledText"));
        Mnemonics.setLocalizedText((AbstractButton)this.jpa2SwitchButton, (String)NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ServerLocalPropertiesVisual.jpa2SwitchButton.enableText"));
        this.jpa2SwitchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerLocalPropertiesVisual.this.jpa2SwitchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.localInstancesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localInstancesCombo, 0, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordLabel).addComponent(this.usernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordField, -2, 147, -2).addComponent(this.usernameField, -2, 147, -2)).addGap(0, 204, Short.MAX_VALUE)).addComponent(this.explanationLabel, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jpa2SwitchLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jpa2Status).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jpa2SwitchButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localInstancesLabel).addComponent(this.browseButton).addComponent(this.localInstancesCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.explanationLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameLabel).addComponent(this.usernameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jpa2SwitchLabel).addComponent(this.jpa2Status).addComponent(this.jpa2SwitchButton))));
        this.localInstancesCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ACSD_ServerLocalPropertiesPanel_localInstancesCombo"));
        this.usernameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_usernameField"));
        this.passwordField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerLocalPropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_passwordField"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        Object item = this.localInstancesCombo.getEditor().getItem();
        if (item != null && !item.toString().trim().isEmpty()) {
            chooser.setSelectedFile(new File(item.toString()));
        } else {
            chooser.setSelectedFile(new File(this.instantiatingIterator.getServerRoot()));
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.localInstancesCombo.getEditor().setItem(chooser.getSelectedFile().getAbsolutePath());
            this.fireChangeEvent();
        }
    }

    private void jpa2SwitchButtonActionPerformed(ActionEvent evt) {
        if (!this.support.isEnabled()) {
            this.support.enable();
        } else {
            this.support.disable();
        }
        this.updateJpa2Status();
    }

    private static class Instance
    implements Serializable {
        private String name;
        private String host;
        private int port;
        private String domainPath;
        private String domainName;
        private boolean isProductionModeEnabled;
        private Version domainVersion;

        public Instance(String name, String host, int port, String domainPath, String domainName, Version domainVersion, boolean isProductionModeEnabled) {
            this.name = name;
            this.host = host;
            this.port = port;
            this.domainPath = domainPath;
            this.domainName = domainName;
            this.domainVersion = domainVersion;
            this.isProductionModeEnabled = isProductionModeEnabled;
        }

        public String getName() {
            return this.name;
        }

        public String getDomainName() {
            return this.domainName;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getDomainPath() {
            return this.domainPath;
        }

        public boolean isProductionModeEnabled() {
            return this.isProductionModeEnabled;
        }

        public Version getDomainVersion() {
            return this.domainVersion;
        }

        public String toString() {
            return this.domainPath;
        }
    }

    private class LocalInstancesItemListener
    implements ItemListener {
        private LocalInstancesItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ServerLocalPropertiesVisual.this.fireChangeEvent();
        }
    }
}

