/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.util.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.index.util.zip.AbstractZipHandle;
import org.apache.maven.index.util.zip.EntryNameFilter;
import org.apache.maven.index.util.zip.ZipHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaZipFileHandle
extends AbstractZipHandle
implements ZipHandle {
    private final ZipFile zipFile;

    public JavaZipFileHandle(File targetFile) throws IOException {
        super(targetFile);
        this.zipFile = new ZipFile(targetFile);
    }

    protected ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public boolean hasEntry(String path) throws IOException {
        return this.getZipFile().getEntry(path) != null;
    }

    @Override
    public List<String> getEntries() {
        return this.getEntries(new EntryNameFilter(){

            public boolean accepts(String entryName) {
                return true;
            }
        });
    }

    @Override
    public List<String> getEntries(EntryNameFilter filter) {
        ArrayList<String> entries = new ArrayList<String>();
        Enumeration<? extends ZipEntry> en = this.getZipFile().entries();
        while (en.hasMoreElements()) {
            ZipEntry e = en.nextElement();
            String name = e.getName();
            if (filter != null && !filter.accepts(name)) continue;
            entries.add(name);
        }
        return entries;
    }

    @Override
    public InputStream getEntryContent(String path) throws IOException {
        ZipEntry entry = this.getZipFile().getEntry(path);
        if (entry != null) {
            return this.getZipFile().getInputStream(entry);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.getZipFile().close();
    }
}

