/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeResolverImpl;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Parameters;

public class APTIncludeHandlerImpl
implements APTIncludeHandler {
    private List<IncludeDirEntry> systemIncludePaths;
    private List<IncludeDirEntry> userIncludePaths;
    private List<IncludeDirEntry> userIncludeFilePaths;
    private Map<CharSequence, Integer> recurseIncludes = null;
    private static final int MAX_INCLUDE_FILE_DEEP = 4;
    private static final int CHECK_INCLUDE_DEPTH = -1;
    private LinkedList<PPIncludeHandler.IncludeInfo> inclStack = null;
    private StartEntry startFile;
    private final APTFileSearch fileSearch;

    APTIncludeHandlerImpl(StartEntry startFile) {
        this(startFile, new ArrayList<IncludeDirEntry>(0), new ArrayList<IncludeDirEntry>(0), new ArrayList<IncludeDirEntry>(0), startFile.getFileSearch());
    }

    public APTIncludeHandlerImpl(StartEntry startFile, List<IncludeDirEntry> systemIncludePaths, List<IncludeDirEntry> userIncludePaths, List<IncludeDirEntry> userIncludeFilePaths, APTFileSearch fileSearch) {
        assert (!APTTraceFlags.USE_CLANK);
        Parameters.notNull((CharSequence)"startFile", (Object)startFile);
        this.startFile = startFile;
        this.systemIncludePaths = systemIncludePaths;
        this.userIncludePaths = userIncludePaths;
        this.userIncludeFilePaths = userIncludeFilePaths;
        this.fileSearch = fileSearch;
    }

    @Override
    public PPIncludeHandler.IncludeState pushInclude(FileSystem fs, CharSequence path, int line, int offset, int resolvedDirIndex, int inclDirIndex) {
        return this.pushIncludeImpl(fs, path, line, offset, resolvedDirIndex, inclDirIndex);
    }

    @Override
    public CharSequence popInclude() {
        return this.popIncludeImpl();
    }

    @Override
    public APTIncludeResolver getResolver(FileSystem fs, CharSequence path) {
        return new APTIncludeResolverImpl(fs, path, this.getCurResolvedDirectoryIndex(), this.systemIncludePaths, this.userIncludePaths, this.fileSearch);
    }

    @Override
    public StartEntry getStartEntry() {
        return this.startFile;
    }

    private CharSequence getCurPath() {
        assert (this.inclStack != null);
        PPIncludeHandler.IncludeInfo info = this.inclStack.getLast();
        return info.getIncludedPath();
    }

    private int getCurResolvedDirectoryIndex() {
        if (this.inclStack != null && !this.inclStack.isEmpty()) {
            PPIncludeHandler.IncludeInfo info = this.inclStack.getLast();
            return info.getResolvedDirectoryIndex();
        }
        return 0;
    }

    @Override
    public PPIncludeHandler.State getState() {
        return this.createStateImpl();
    }

    @Override
    public void setState(PPIncludeHandler.State state) {
        if (state instanceof StateImpl) {
            StateImpl stateImpl = (StateImpl)state;
            assert (!stateImpl.isCleaned());
            stateImpl.restoreTo(this);
        }
    }

    private StateImpl createStateImpl() {
        return new StateImpl(this);
    }

    List<IncludeDirEntry> getUserIncludeFilePaths() {
        return Collections.unmodifiableList(this.userIncludeFilePaths);
    }

    List<IncludeDirEntry> getUserIncludePaths() {
        return Collections.unmodifiableList(this.userIncludePaths);
    }

    List<IncludeDirEntry> getSystemIncludePaths() {
        return Collections.unmodifiableList(this.systemIncludePaths);
    }

    boolean isFirstLevel() {
        return this.inclStack == null || this.inclStack.isEmpty();
    }

    private PPIncludeHandler.IncludeState pushIncludeImpl(FileSystem fs, CharSequence path, int directiveLine, int directiveOffset, int resolvedDirIndex, int inclDirIndex) {
        Integer counter;
        assert (CharSequences.isCompact((CharSequence)path)) : "must be char sequence key " + path;
        boolean okToPush = true;
        if (this.recurseIncludes == null) {
            assert (this.inclStack == null) : this.inclStack.toString() + " started on " + this.startFile;
            this.inclStack = new LinkedList();
            this.recurseIncludes = new HashMap<CharSequence, Integer>();
        }
        Integer n = counter = (counter = this.recurseIncludes.get(path)) == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
        if (counter < 4) {
            this.recurseIncludes.put(path, counter);
        } else {
            okToPush = false;
        }
        if (okToPush) {
            this.inclStack.addLast(new IncludeInfoImpl(fs, path, directiveLine, directiveOffset, resolvedDirIndex, inclDirIndex));
            return PPIncludeHandler.IncludeState.Success;
        }
        APTUtils.LOG.log(Level.WARNING, "RECURSIVE inclusion:\n\t{0}\n\tin {1}\n", new Object[]{path, this.getCurPath()});
        return PPIncludeHandler.IncludeState.Recursive;
    }

    private CharSequence popIncludeImpl() {
        assert (this.inclStack != null);
        assert (!this.inclStack.isEmpty());
        PPIncludeHandler.IncludeInfo inclInfo = this.inclStack.removeLast();
        CharSequence path = inclInfo.getIncludedPath();
        assert (this.recurseIncludes != null);
        Integer counter = this.recurseIncludes.remove(path);
        assert (counter != null) : "must be added before";
        counter = counter - 1;
        assert (counter >= 0) : "can't be negative";
        if (counter != 0) {
            this.recurseIncludes.put(path, counter);
        }
        return path;
    }

    public String toString() {
        return APTIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.userIncludeFilePaths, this.inclStack);
    }

    private static String toString(CharSequence startFile, List<IncludeDirEntry> systemIncludePaths, List<IncludeDirEntry> userIncludePaths, List<IncludeDirEntry> userIncludeFilePaths, Collection<PPIncludeHandler.IncludeInfo> inclStack) {
        StringBuilder retValue = new StringBuilder();
        if (!userIncludeFilePaths.isEmpty()) {
            retValue.append("User File Includes:\n");
            retValue.append(APTUtils.includes2String(userIncludeFilePaths));
        }
        retValue.append("User includes:\n");
        retValue.append(APTUtils.includes2String(userIncludePaths));
        retValue.append("\nSys includes:\n");
        retValue.append(APTUtils.includes2String(systemIncludePaths));
        retValue.append("\nInclude Stack starting from:\n");
        retValue.append(startFile).append("\n");
        retValue.append(APTIncludeHandlerImpl.includesStack2String(inclStack));
        return retValue.toString();
    }

    private static String includesStack2String(Collection<PPIncludeHandler.IncludeInfo> inclStack) {
        StringBuilder retValue = new StringBuilder();
        if (inclStack == null) {
            retValue.append("<not from #include>");
        } else {
            Iterator<PPIncludeHandler.IncludeInfo> it = inclStack.iterator();
            while (it.hasNext()) {
                PPIncludeHandler.IncludeInfo info = it.next();
                retValue.append(info);
                if (!it.hasNext()) continue;
                retValue.append("->\n");
            }
        }
        return retValue.toString();
    }

    private static final class IncludeInfoImpl
    implements PPIncludeHandler.IncludeInfo,
    SelfPersistent {
        private final FileSystem fs;
        private final CharSequence path;
        private final int directiveLine;
        private final int directiveOffset;
        private final int resolvedDirectoryIndex;
        private final int includeDirectiveIndex;

        public IncludeInfoImpl(FileSystem fs, CharSequence path, int directiveLine, int directiveOffset, int resolvedDirectoryIndex, int includedDirFileIndex) {
            assert (path != null);
            this.fs = fs;
            this.path = path;
            assert (directiveLine >= 0 || directiveLine < 0 && directiveOffset < 0);
            this.directiveLine = directiveLine;
            this.directiveOffset = directiveOffset;
            this.resolvedDirectoryIndex = resolvedDirectoryIndex;
            this.includeDirectiveIndex = includedDirFileIndex;
        }

        public IncludeInfoImpl(RepositoryDataInput input) throws IOException {
            assert (input != null);
            this.fs = input.readFileSystem();
            this.path = input.readFilePathForFileSystem(this.fs);
            this.directiveLine = input.readInt();
            this.directiveOffset = input.readInt();
            this.resolvedDirectoryIndex = input.readInt();
            this.includeDirectiveIndex = input.readInt();
        }

        @Override
        public FileSystem getFileSystem() {
            return this.fs;
        }

        @Override
        public CharSequence getIncludedPath() {
            return this.path;
        }

        @Override
        public int getIncludeDirectiveLine() {
            return this.directiveLine;
        }

        @Override
        public int getIncludeDirectiveOffset() {
            return this.directiveOffset;
        }

        public String toString() {
            String retValue = "(" + this.getIncludeDirectiveLine() + "/" + this.getIncludeDirectiveOffset() + ": " + this.getIncludedPath() + ":" + this.getResolvedDirectoryIndex() + ";#" + this.getIncludeDirectiveIndex() + ")";
            return retValue;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            IncludeInfoImpl other = (IncludeInfoImpl)obj;
            return this.resolvedDirectoryIndex == other.resolvedDirectoryIndex && this.includeDirectiveIndex == other.includeDirectiveIndex && this.path.equals(other.path);
        }

        public int hashCode() {
            int hash = 3;
            hash = 73 * hash + (this.path != null ? this.path.hashCode() : 0);
            hash = 73 * hash + this.resolvedDirectoryIndex;
            hash = 73 * hash + this.includeDirectiveIndex;
            return hash;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            assert (output != null);
            output.writeFileSystem(this.fs);
            output.writeFilePathForFileSystem(this.fs, this.path);
            output.writeInt(this.directiveLine);
            output.writeInt(this.directiveOffset);
            output.writeInt(this.resolvedDirectoryIndex);
            output.writeInt(this.includeDirectiveIndex);
        }

        @Override
        public int getResolvedDirectoryIndex() {
            return this.resolvedDirectoryIndex;
        }

        @Override
        public int getIncludeDirectiveIndex() {
            return this.includeDirectiveIndex;
        }
    }

    public static final class StateImpl
    implements PPIncludeHandler.State,
    Persistent {
        private static final List<IncludeDirEntry> CLEANED_MARKER = Collections.unmodifiableList(new ArrayList(0));
        private final List<IncludeDirEntry> systemIncludePaths;
        private final List<IncludeDirEntry> userIncludePaths;
        private final List<IncludeDirEntry> userIncludeFilePaths;
        private final StartEntry startFile;
        private static final PPIncludeHandler.IncludeInfo[] EMPTY_STACK = new PPIncludeHandler.IncludeInfo[0];
        private final PPIncludeHandler.IncludeInfo[] inclStack;
        private int hashCode = 0;

        protected StateImpl(APTIncludeHandlerImpl handler) {
            assert (!APTTraceFlags.USE_CLANK);
            this.systemIncludePaths = handler.systemIncludePaths;
            this.userIncludePaths = handler.userIncludePaths;
            this.userIncludeFilePaths = handler.userIncludeFilePaths;
            this.startFile = handler.startFile;
            this.inclStack = handler.inclStack != null && !handler.inclStack.isEmpty() ? handler.inclStack.toArray(new PPIncludeHandler.IncludeInfo[handler.inclStack.size()]) : EMPTY_STACK;
        }

        private StateImpl(StateImpl other, boolean cleanState) {
            CndUtils.assertTrueInConsole((cleanState ? 1 : 0) != 0, (String)"This constructor is only for creating clean states");
            assert (!APTTraceFlags.USE_CLANK);
            this.startFile = other.startFile;
            this.inclStack = other.inclStack;
            if (cleanState) {
                this.systemIncludePaths = CLEANED_MARKER;
                this.userIncludePaths = CLEANED_MARKER;
                this.userIncludeFilePaths = CLEANED_MARKER;
            } else {
                this.systemIncludePaths = other.systemIncludePaths;
                this.userIncludePaths = other.userIncludePaths;
                this.userIncludeFilePaths = other.userIncludeFilePaths;
            }
        }

        int getIncludeStackDepth() {
            return this.inclStack.length;
        }

        private void restoreTo(APTIncludeHandlerImpl handler) {
            handler.userIncludePaths = this.userIncludePaths;
            handler.userIncludeFilePaths = this.userIncludeFilePaths;
            handler.systemIncludePaths = this.systemIncludePaths;
            handler.startFile = this.startFile;
            if (!this.isCleaned() && this.inclStack.length > 0) {
                handler.inclStack = new LinkedList();
                handler.inclStack.addAll(Arrays.asList(this.inclStack));
                handler.recurseIncludes = new HashMap();
                for (PPIncludeHandler.IncludeInfo includeInfo : this.inclStack) {
                    CharSequence path = includeInfo.getIncludedPath();
                    Integer counter = (Integer)handler.recurseIncludes.get(path);
                    counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
                    handler.recurseIncludes.put(path, counter);
                }
            }
        }

        public String toString() {
            return APTIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.userIncludeFilePaths, Arrays.asList(this.inclStack));
        }

        public void write(RepositoryDataOutput output) throws IOException {
            assert (output != null);
            CndUtils.assertTrueInConsole((boolean)this.isCleaned(), (String)"we expect only clean states to be written in storage");
            this.startFile.write(output);
            assert (this.systemIncludePaths == CLEANED_MARKER);
            assert (this.userIncludePaths == CLEANED_MARKER);
            assert (this.userIncludeFilePaths == CLEANED_MARKER);
            output.writeInt(this.inclStack.length);
            for (PPIncludeHandler.IncludeInfo inclInfo : this.inclStack) {
                assert (inclInfo != null);
                IncludeInfoImpl inclInfoImpl = inclInfo instanceof IncludeInfoImpl ? (IncludeInfoImpl)inclInfo : new IncludeInfoImpl(inclInfo.getFileSystem(), inclInfo.getIncludedPath(), inclInfo.getIncludeDirectiveLine(), inclInfo.getIncludeDirectiveOffset(), inclInfo.getResolvedDirectoryIndex(), inclInfo.getIncludeDirectiveIndex());
                assert (inclInfoImpl != null);
                inclInfoImpl.write(output);
            }
        }

        public StateImpl(RepositoryDataInput input) throws IOException {
            assert (input != null);
            this.startFile = new StartEntry(input);
            this.systemIncludePaths = CLEANED_MARKER;
            this.userIncludePaths = CLEANED_MARKER;
            this.userIncludeFilePaths = CLEANED_MARKER;
            int size = input.readInt();
            if (size == 0) {
                this.inclStack = EMPTY_STACK;
            } else {
                this.inclStack = new PPIncludeHandler.IncludeInfo[size];
                for (int i = 0; i < size; ++i) {
                    IncludeInfoImpl impl = new IncludeInfoImpl(input);
                    assert (impl != null);
                    this.inclStack[i] = impl;
                }
            }
        }

        final StartEntry getStartEntry() {
            return this.startFile;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            return this.startFile.equals(other.startFile) && this.compareStacks(this.inclStack, other.inclStack);
        }

        public int hashCode() {
            int hash = this.hashCode;
            if (hash == 0) {
                hash = 5;
                hash = 67 * hash + (this.startFile != null ? this.startFile.hashCode() : 0);
                this.hashCode = hash = 67 * hash + Arrays.hashCode(this.inclStack);
            }
            return hash;
        }

        private boolean compareStacks(PPIncludeHandler.IncludeInfo[] inclStack1, PPIncludeHandler.IncludeInfo[] inclStack2) {
            if (inclStack1 == inclStack2) {
                return true;
            }
            if (inclStack1.length != inclStack2.length) {
                return false;
            }
            for (int i = 0; i < inclStack1.length; ++i) {
                PPIncludeHandler.IncludeInfo cur1 = inclStack1[i];
                PPIncludeHandler.IncludeInfo cur2 = inclStack2[i];
                if (cur1.equals(cur2)) continue;
                return false;
            }
            return true;
        }

        Collection<PPIncludeHandler.IncludeInfo> getIncludeStack() {
            return Arrays.asList(this.inclStack);
        }

        boolean isCleaned() {
            return this.userIncludeFilePaths == CLEANED_MARKER;
        }

        PPIncludeHandler.State copyCleaned() {
            return new StateImpl(this, true);
        }

        PPIncludeHandler.State prepareCachesIfPossible() {
            return this;
        }

        List<IncludeDirEntry> getSysIncludePaths() {
            return this.systemIncludePaths;
        }

        List<IncludeDirEntry> getUserIncludePaths() {
            return this.userIncludePaths;
        }

        List<IncludeDirEntry> getUserIncludeFilePaths() {
            return this.userIncludeFilePaths;
        }
    }
}

