/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.CallNode;
import org.netbeans.modules.cnd.callgraph.impl.FunctionRootNode;
import org.netbeans.modules.cnd.callgraph.impl.LoadingNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class CallChildren
extends Children.Keys<Call> {
    private Call call;
    private Function function;
    private final CallGraphState model;
    private Node parent;
    private volatile boolean isInited = false;
    private final boolean isCalls;
    private static final RequestProcessor RP = new RequestProcessor(CallChildren.class.getName(), 1);

    public CallChildren(Call call, CallGraphState model, boolean isCalls) {
        this.call = call;
        this.model = model;
        this.isCalls = isCalls;
    }

    public CallChildren(Function function, CallGraphState model, boolean isCalls) {
        this.function = function;
        this.model = model;
        this.isCalls = isCalls;
    }

    public void dispose() {
        if (this.isInited) {
            this.isInited = false;
            this.setKeys(new Call[0]);
        }
    }

    void setParent(Node parent) {
        this.parent = parent;
    }

    private synchronized void resetKeys() {
        List<Call> set;
        if (this.isCalls) {
            if (this.call != null) {
                set = this.model.getCallees(this.call.getCallee());
                this.model.setCalleesExpanded(this.call.getCallee(), true);
            } else {
                set = this.model.getCallees(this.function);
                this.model.setCalleesExpanded(this.function, true);
            }
        } else if (this.call != null) {
            set = this.model.getCallers(this.call.getCaller());
            this.model.setCallersExpanded(this.call.getCaller(), true);
        } else {
            set = this.model.getCallers(this.function);
            this.model.setCallersExpanded(this.function, true);
        }
        if (set != null && set.size() > 0) {
            Collections.sort(set);
            this.setKeys(set);
            return;
        }
        this.setKeys(new Call[0]);
    }

    protected Node[] createNodes(Call call) {
        if (call instanceof LoadingNode) {
            return new Node[]{(Node)call};
        }
        CallNode node = new CallNode(call, this.model, this.isCalls);
        return new Node[]{node};
    }

    boolean isRecusion() {
        Function fun = this.isCalls ? (this.call != null ? this.call.getCallee() : this.function) : (this.call != null ? this.call.getCaller() : this.function);
        for (Node p = this.parent; p != null; p = p.getParentNode()) {
            if (p instanceof CallNode) {
                Function f = this.isCalls ? ((CallNode)p).getCall().getCaller() : ((CallNode)p).getCall().getCallee();
                if (!fun.equals(f)) continue;
                return true;
            }
            if (!(p instanceof FunctionRootNode)) continue;
            return fun.equals(((FunctionRootNode)p).getFunction());
        }
        return false;
    }

    void init() {
        if (!this.isInited) {
            this.isInited = true;
            if (this.isRecusion()) {
                this.setKeys(new Call[0]);
            } else {
                this.resetKeys();
            }
        }
    }

    protected void addNotify() {
        if (!this.isInited) {
            this.isInited = true;
            if (this.isRecusion()) {
                this.setKeys(new Call[0]);
            } else {
                this.setKeys(new Call[]{new LoadingNode()});
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        CallChildren.this.resetKeys();
                    }
                });
            }
        }
        super.addNotify();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.dispose();
    }
}

