/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;

public final class XmlScope {
    private static final Logger LOGGER = Logger.getLogger(XmlScope.class.getName());
    private static final String SCENE_FACES_SCOPE_XML = "Faces Configuration Only";
    private static final String SCENE_PROJECT_SCOPE_XML = "Project";
    private static final String SCENE_ALL_FACESCONFIG_XML = "All Faces Configurations";
    private static final String SCENE_FACES_SCOPE = PageFlowToolbarUtilities.getScopeLabel(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG);
    private static final String SCENE_PROJECT_SCOPE = PageFlowToolbarUtilities.getScopeLabel(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT);
    private static final String SCENE_ALL_FACESCONFIG = PageFlowToolbarUtilities.getScopeLabel(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG);
    private String xmlScope;
    private PageFlowToolbarUtilities.Scope scope;
    public static final XmlScope SCOPE_FACES = new XmlScope(PageFlowToolbarUtilities.Scope.SCOPE_FACESCONFIG);
    public static final XmlScope SCOPE_PROJECT = new XmlScope(PageFlowToolbarUtilities.Scope.SCOPE_PROJECT);
    public static final XmlScope SCOPE_ALL = new XmlScope(PageFlowToolbarUtilities.Scope.SCOPE_ALL_FACESCONFIG);

    private XmlScope(PageFlowToolbarUtilities.Scope scope) {
        this.xmlScope = this.getScopeXmlFromScope(scope);
        this.scope = scope;
    }

    public PageFlowToolbarUtilities.Scope getScope() {
        return this.scope;
    }

    public String toString() {
        return this.xmlScope;
    }

    public static final XmlScope getInstance(String strScope) {
        XmlScope myXmlScope = XmlScope.getXmlScopeFromXmlStr(strScope);
        if (myXmlScope == null) {
            myXmlScope = XmlScope.getXmlScopeFromLocStr(strScope);
        }
        assert (myXmlScope != null);
        if (myXmlScope == null) {
            LOGGER.severe(XmlScope.class.getName() + ": myXmlScope is null and it should not be.  For string:" + strScope);
            LOGGER.severe(XmlScope.class.getName() + ": Setting to Project Scope regardless as to not cause unnessary errors.");
            myXmlScope = SCOPE_PROJECT;
        }
        return myXmlScope;
    }

    private final String getScopeXmlFromScope(PageFlowToolbarUtilities.Scope scope) {
        String retVal;
        switch (scope) {
            case SCOPE_FACESCONFIG: {
                retVal = SCENE_FACES_SCOPE_XML;
                break;
            }
            case SCOPE_PROJECT: {
                retVal = SCENE_PROJECT_SCOPE_XML;
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                retVal = SCENE_ALL_FACESCONFIG_XML;
                break;
            }
            default: {
                retVal = null;
            }
        }
        return retVal;
    }

    private static final XmlScope getXmlScopeFromXmlStr(String xmlStr) {
        XmlScope retVal = null;
        if (xmlStr.equals(SCENE_FACES_SCOPE_XML)) {
            retVal = SCOPE_FACES;
        } else if (xmlStr.equals(SCENE_PROJECT_SCOPE_XML)) {
            retVal = SCOPE_PROJECT;
        } else if (xmlStr.equals(SCENE_ALL_FACESCONFIG_XML)) {
            retVal = SCOPE_ALL;
        }
        return retVal;
    }

    private static final XmlScope getXmlScopeFromLocStr(String localizedStr) {
        XmlScope retVal = null;
        if (localizedStr.equals(SCENE_FACES_SCOPE)) {
            retVal = SCOPE_FACES;
        } else if (localizedStr.equals(SCENE_PROJECT_SCOPE)) {
            retVal = SCOPE_PROJECT;
        } else if (localizedStr.equals(SCENE_ALL_FACESCONFIG)) {
            retVal = SCOPE_ALL;
        }
        return retVal;
    }
}

