/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.javascript2.debug.ui.JSUtils;
import org.netbeans.modules.web.javascript.debugger.MiscEditorUtil;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMNode;
import org.netbeans.modules.web.javascript.debugger.breakpoints.EventsBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.XHRBreakpoint;
import org.openide.text.Line;

public class BreakpointsReader
implements Properties.Reader {
    private static final String LINE_NUMBER = "lineNumber";
    private static final String URL = "url";
    private static final String DOM_NODE_PATH = "domNodePath";
    private static final String EVENTS = "events";
    private static final String URL_SUBSTRING = "urlSubstring";
    private static final String ENABED = "enabled";
    private static final String GROUP_NAME = "groupName";
    private static final String OLD_LINE_BP_CLASS_NAME = "org.netbeans.modules.web.javascript.debugger.breakpoints.LineBreakpoint";

    public String[] getSupportedClassNames() {
        return new String[]{OLD_LINE_BP_CLASS_NAME, DOMBreakpoint.class.getName(), EventsBreakpoint.class.getName(), XHRBreakpoint.class.getName()};
    }

    public Object read(String typeID, Properties properties) {
        if (typeID.equals(OLD_LINE_BP_CLASS_NAME)) {
            Line line = MiscEditorUtil.getLine(properties.getString(URL, null), properties.getInt(LINE_NUMBER, 1), 0);
            if (line == null) {
                return null;
            }
            JSLineBreakpoint breakpoint = JSUtils.createLineBreakpoint((Line)line);
            this.readGeneralProperties(properties, (Breakpoint)breakpoint);
            return breakpoint;
        }
        if (typeID.equals(DOMBreakpoint.class.getName())) {
            URL url;
            String nodePathDefinition = properties.getString(DOM_NODE_PATH, null);
            if (nodePathDefinition == null) {
                return null;
            }
            String urlStr = properties.getString(URL, null);
            if (urlStr != null) {
                try {
                    url = new URL(urlStr);
                }
                catch (MalformedURLException ex) {
                    url = null;
                }
            } else {
                url = null;
            }
            if (url == null) {
                return null;
            }
            DOMNode node = DOMNode.create(nodePathDefinition);
            DOMBreakpoint db = new DOMBreakpoint(url, node);
            db.setOnSubtreeModification(properties.getBoolean("subtree-modified", false));
            db.setOnAttributeModification(properties.getBoolean("attribute-modified", false));
            db.setOnNodeRemoval(properties.getBoolean("node-removed", false));
            this.readGeneralProperties(properties, db);
            return db;
        }
        if (typeID.equals(EventsBreakpoint.class.getName())) {
            EventsBreakpoint eb = new EventsBreakpoint();
            Object[] events = properties.getArray(EVENTS, null);
            if (events != null) {
                for (Object event : events) {
                    eb.addEvent((String)event);
                }
            }
            this.readGeneralProperties(properties, eb);
            return eb;
        }
        if (typeID.equals(XHRBreakpoint.class.getName())) {
            String urlSubstring = properties.getString(URL_SUBSTRING, "");
            XHRBreakpoint xb = new XHRBreakpoint(urlSubstring);
            this.readGeneralProperties(properties, xb);
            return xb;
        }
        return null;
    }

    public void write(Object object, Properties properties) {
        if (object instanceof DOMBreakpoint) {
            DOMBreakpoint db = (DOMBreakpoint)((Object)object);
            URL url = db.getURL();
            String urlStr = url != null ? url.toExternalForm() : null;
            properties.setString(URL, urlStr);
            properties.setString(DOM_NODE_PATH, db.getNode().getStringDefinition());
            properties.setBoolean("subtree-modified", db.isOnSubtreeModification());
            properties.setBoolean("attribute-modified", db.isOnAttributeModification());
            properties.setBoolean("node-removed", db.isOnNodeRemoval());
            this.writeGeneralProperties(properties, db);
        } else if (object instanceof EventsBreakpoint) {
            EventsBreakpoint eb = (EventsBreakpoint)((Object)object);
            Set<String> events = eb.getEvents();
            properties.setArray(EVENTS, events.toArray());
            this.writeGeneralProperties(properties, eb);
        } else if (object instanceof XHRBreakpoint) {
            XHRBreakpoint xb = (XHRBreakpoint)((Object)object);
            String urlSubstring = xb.getUrlSubstring();
            properties.setString(URL_SUBSTRING, urlSubstring);
            this.writeGeneralProperties(properties, xb);
        }
    }

    private void readGeneralProperties(Properties properties, Breakpoint breakpoint) {
        if (!properties.getBoolean(ENABED, true)) {
            breakpoint.disable();
        }
        breakpoint.setGroupName(properties.getString(GROUP_NAME, ""));
    }

    private void writeGeneralProperties(Properties properties, Breakpoint breakpoint) {
        properties.setBoolean(ENABED, breakpoint.isEnabled());
        properties.setString(GROUP_NAME, breakpoint.getGroupName());
    }
}

