/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerBacked;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;

public class CPUCCTContainer {
    private static final Logger LOGGER = Logger.getLogger(CPUCCTContainer.class.getName());
    protected static final int OFS_METHODID = 0;
    protected static final int OFS_NCALLS = 2;
    protected static final int OFS_TIME0 = 6;
    protected static final int OFS_SELFTIME0 = 11;
    protected static final int OFS_TIME1 = 16;
    protected static final int OFS_SELFTIME1 = 21;
    protected static final int OFS_NSUBNODES1 = 16;
    protected static final int OFS_NSUBNODES2 = 26;
    protected static final int OFS_SUBNODE01 = 18;
    protected static final int OFS_SUBNODE02 = 28;
    protected static final int CHILD_OFS_SIZE_3 = 3;
    protected static final int CHILD_OFS_SIZE_4 = 4;
    private static double timeInInjectedCodeInMS;
    private static double wholeGraphGrossTimeAbsInMS;
    protected CPUResultsSnapshot cpuResSnapshot;
    protected FlatProfileContainer cachedFlatProfile;
    public PrestimeCPUCCTNode rootNode;
    protected String threadName;
    protected byte[] compactData;
    protected int[] invPerMethodId;
    protected long[] timePerMethodId0;
    protected long[] timePerMethodId1;
    protected long[] totalTimePerMethodId0;
    protected long[] totalTimePerMethodId1;
    protected Set methodsOnStack;
    protected boolean collectingTwoTimeStamps;
    protected boolean displayWholeThreadCPUTime;
    protected double timeInInjectedCodeInAbsCounts;
    protected double timeInInjectedCodeInThreadCPUCounts;
    protected int childOfsSize = -1;
    protected int nodeSize;
    protected int threadId;
    protected long wholeGraphGrossTimeAbs;
    protected long wholeGraphGrossTimeThreadCPU;
    protected long wholeGraphNetTime0;
    protected long wholeGraphNetTime1;
    protected long wholeGraphPureTimeAbs;
    protected long wholeGraphPureTimeThreadCPU;
    private InstrumentationFilter filter;
    private PrestimeCPUCCTNodeFree reverseCCTRootNode;
    private int[] nodeStack;
    private int childTotalNCalls;
    private int currentNodeStackSize;
    private int nodeStackPtr;
    private int selectedMethodId;
    private long childTotalTime0InTimerUnits;
    private long childTotalTime1InTimerUnits;
    long totalInvNo;
    private TimingAdjusterOld timingAdjuster;
    private MethodInfoMapper methodInfoMapper = MethodInfoMapper.DEFAULT;

    public CPUCCTContainer(TimedCPUCCTNode rtRootNode, CPUResultsSnapshot cpuResSnapshot, MethodInfoMapper methodInfoMapper, TimingAdjusterOld timingAdjuster, InstrumentationFilter usedFilter, int nNodes, double[] threadActiveTimesInCounts, int threadId, String threadName) {
        this(cpuResSnapshot);
        this.threadId = threadId;
        this.threadName = threadName;
        this.methodInfoMapper = methodInfoMapper;
        this.timingAdjuster = timingAdjuster;
        this.filter = usedFilter;
        this.collectingTwoTimeStamps = cpuResSnapshot.isCollectingTwoTimeStamps();
        this.generateCompactData(rtRootNode, nNodes);
        this.calculateThreadActiveTimesInMS(threadActiveTimesInCounts);
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (rtRootNode.isRoot()) {
            this.rootNode.setThreadNode();
        }
    }

    protected CPUCCTContainer(CPUResultsSnapshot cpuResSnapshot) {
        this.cpuResSnapshot = cpuResSnapshot;
    }

    public CPUResultsSnapshot getCPUResSnapshot() {
        return this.cpuResSnapshot;
    }

    public int getChildOfsForNodeOfs(int nodeOfs, int childIdx) {
        if (this.childOfsSize == 4) {
            return this.get4Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx);
        }
        return this.get3Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx);
    }

    public boolean isCollectingTwoTimeStamps() {
        return this.collectingTwoTimeStamps;
    }

    public FlatProfileContainer getFlatProfile() {
        return this.generateFlatProfile();
    }

    public String[] getMethodClassNameAndSig(int methodId) {
        return this.cpuResSnapshot.getMethodClassNameAndSig(methodId, 0);
    }

    public int getMethodIdForNodeOfs(int nodeOfs) {
        return this.get2Bytes(nodeOfs + 0);
    }

    public int getNCallsForNodeOfs(int nodeOfs) {
        return this.get4Bytes(nodeOfs + 2);
    }

    public int getNChildrenForNodeOfs(int nodeOfs) {
        return this.get2Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 26 : 16));
    }

    public PrestimeCPUCCTNode getReverseCCT(int methodId) {
        return this.generateReverseCCT(methodId);
    }

    public PrestimeCPUCCTNode getRootNode() {
        return this.rootNode;
    }

    public long getSelfTime0ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 11);
    }

    public long getSelfTime1ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 21);
    }

    public long getSleepTime0ForNodeOfs(int nodeOfs) {
        return 0L;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public static double getTimeInInjectedCodeForDisplayedThread() {
        return timeInInjectedCodeInMS;
    }

    public long getTotalTime0ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 6);
    }

    public long getTotalTime1ForNodeOfs(int nodeOfs) {
        return this.get5Bytes(nodeOfs + 16);
    }

    public long getWaitTime0ForNodeOfs(int nodeOfs) {
        return 0L;
    }

    public static double getWholeGraphGrossTimeAbsForDisplayedThread() {
        return wholeGraphGrossTimeAbsInMS;
    }

    public long getWholeGraphNetTime0() {
        return this.wholeGraphNetTime0;
    }

    public long getWholeGraphNetTime1() {
        return this.wholeGraphNetTime1;
    }

    public long getWholeGraphPureTimeAbs() {
        return this.wholeGraphPureTimeAbs;
    }

    public long getWholeGraphPureTimeThreadCPU() {
        return this.wholeGraphPureTimeThreadCPU;
    }

    public boolean canDisplayWholeGraphCPUTime() {
        return this.displayWholeThreadCPUTime;
    }

    public void readFromStream(DataInputStream in) throws IOException {
        this.threadId = in.readInt();
        this.threadName = in.readUTF();
        this.collectingTwoTimeStamps = in.readBoolean();
        int len = in.readInt();
        this.compactData = new byte[len];
        this.childOfsSize = this.compactData.length > 0xFFFFFF ? 4 : 3;
        in.readFully(this.compactData);
        this.nodeSize = in.readInt();
        this.wholeGraphGrossTimeAbs = in.readLong();
        this.wholeGraphGrossTimeThreadCPU = in.readLong();
        this.timeInInjectedCodeInAbsCounts = in.readDouble();
        this.timeInInjectedCodeInThreadCPUCounts = in.readDouble();
        this.wholeGraphPureTimeAbs = in.readLong();
        this.wholeGraphPureTimeThreadCPU = in.readLong();
        this.wholeGraphNetTime0 = in.readLong();
        this.wholeGraphNetTime1 = in.readLong();
        this.totalInvNo = in.readLong();
        this.displayWholeThreadCPUTime = in.readBoolean();
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, null, 0);
        if (this.getMethodIdForNodeOfs(0) == 0) {
            this.rootNode.setThreadNode();
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.threadId);
        out.writeUTF(this.threadName);
        out.writeBoolean(this.collectingTwoTimeStamps);
        out.writeInt(this.compactData.length);
        out.write(this.compactData);
        out.writeInt(this.nodeSize);
        out.writeLong(this.wholeGraphGrossTimeAbs);
        out.writeLong(this.wholeGraphGrossTimeThreadCPU);
        out.writeDouble(this.timeInInjectedCodeInAbsCounts);
        out.writeDouble(this.timeInInjectedCodeInThreadCPUCounts);
        out.writeLong(this.wholeGraphPureTimeAbs);
        out.writeLong(this.wholeGraphPureTimeThreadCPU);
        out.writeLong(this.wholeGraphNetTime0);
        out.writeLong(this.wholeGraphNetTime1);
        out.writeLong(this.totalInvNo);
        out.writeBoolean(this.displayWholeThreadCPUTime);
    }

    protected void setChildOfsForNodeOfs(int nodeOfs, int childIdx, int val) {
        if (this.childOfsSize == 4) {
            this.store4Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx, val);
        } else {
            this.store3Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 28 : 18) + this.childOfsSize * childIdx, val);
        }
    }

    protected void setMethodIdForNodeOfs(int nodeOfs, int val) {
        this.store2Bytes(nodeOfs + 0, val);
    }

    protected void setNCallsForNodeOfs(int nodeOfs, int val) {
        this.store4Bytes(nodeOfs + 2, val);
    }

    protected void setNChildrenForNodeOfs(int nodeOfs, int val) {
        this.store2Bytes(nodeOfs + (this.collectingTwoTimeStamps ? 26 : 16), val);
    }

    protected void setSelfTime0ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 11, val);
    }

    protected void setSelfTime1ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 21, val);
    }

    protected void setSleepTime0ForNodeOfs(int dataOfs, long waitTime0) {
    }

    protected void setTotalTime0ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 6, val);
    }

    protected void setTotalTime1ForNodeOfs(int nodeOfs, long val) {
        this.store5Bytes(nodeOfs + 16, val);
    }

    protected void setWaitTime0ForNodeOfs(int dataOfs, long waitTime0) {
    }

    protected void addFlatProfTimeForNode(int dataOfs) {
        int methodId = this.getMethodIdForNodeOfs(dataOfs);
        Integer methodIdInt = new Integer(methodId);
        boolean isRecursiveCall = this.methodsOnStack.contains(methodIdInt);
        if (methodId >= this.invPerMethodId.length) {
            LOGGER.log(Level.WARNING, "Method ID ({0}) out of bounds ({1})", new Object[]{methodId, this.invPerMethodId.length});
            return;
        }
        int nChildren = this.getNChildrenForNodeOfs(dataOfs);
        if (nChildren > 0) {
            if (!isRecursiveCall) {
                this.methodsOnStack.add(methodIdInt);
            }
            for (int i = 0; i < nChildren; ++i) {
                int childOfs = this.getChildOfsForNodeOfs(dataOfs, i);
                this.addFlatProfTimeForNode(childOfs);
            }
            if (!isRecursiveCall) {
                this.methodsOnStack.remove(methodIdInt);
            }
        }
        int n = methodId;
        this.timePerMethodId0[n] = this.timePerMethodId0[n] + this.getSelfTime0ForNodeOfs(dataOfs);
        if (!isRecursiveCall) {
            int n2 = methodId;
            this.totalTimePerMethodId0[n2] = this.totalTimePerMethodId0[n2] + this.getTotalTime0ForNodeOfs(dataOfs);
        }
        if (this.collectingTwoTimeStamps) {
            int n3 = methodId;
            this.timePerMethodId1[n3] = this.timePerMethodId1[n3] + this.getSelfTime1ForNodeOfs(dataOfs);
            if (!isRecursiveCall) {
                int n4 = methodId;
                this.totalTimePerMethodId1[n4] = this.totalTimePerMethodId1[n4] + this.getTotalTime1ForNodeOfs(dataOfs);
            }
        }
        int n5 = methodId;
        this.invPerMethodId[n5] = this.invPerMethodId[n5] + this.getNCallsForNodeOfs(dataOfs);
    }

    protected void addToReverseCCT(PrestimeCPUCCTNodeFree reverseNode, int methodId) {
        this.selectedMethodId = methodId;
        this.reverseCCTRootNode = reverseNode;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
    }

    protected void checkStraightGraphNode(int dataOfs) {
        if (this.nodeStackPtr >= this.currentNodeStackSize) {
            int[] newNodeStack = new int[this.currentNodeStackSize * 2];
            System.arraycopy(this.nodeStack, 0, newNodeStack, 0, this.currentNodeStackSize);
            this.nodeStack = newNodeStack;
            this.currentNodeStackSize *= 2;
        }
        this.nodeStack[this.nodeStackPtr++] = dataOfs;
        if (this.getMethodIdForNodeOfs(dataOfs) == this.selectedMethodId) {
            this.addReversePath();
        }
        int nChildren = this.getNChildrenForNodeOfs(dataOfs);
        for (int i = 0; i < nChildren; ++i) {
            this.checkStraightGraphNode(this.getChildOfsForNodeOfs(dataOfs, i));
        }
        --this.nodeStackPtr;
    }

    protected FlatProfileContainer generateFlatProfile() {
        this.preGenerateFlatProfile();
        this.addFlatProfTimeForNode(0);
        return this.postGenerateFlatProfile();
    }

    protected PrestimeCPUCCTNodeFree generateReverseCCT(int methodId) {
        this.selectedMethodId = methodId;
        this.currentNodeStackSize = 320;
        this.nodeStack = new int[this.currentNodeStackSize];
        this.nodeStackPtr = 0;
        this.checkStraightGraphNode(0);
        PrestimeCPUCCTNodeFree ret = this.reverseCCTRootNode;
        this.nodeStack = null;
        this.reverseCCTRootNode = null;
        return ret;
    }

    protected int get2Bytes(int ofs) {
        return (this.compactData[ofs] & 0xFF) << 8 | this.compactData[ofs + 1] & 0xFF;
    }

    protected int get3Bytes(int ofs) {
        return (this.compactData[ofs++] & 0xFF) << 16 | (this.compactData[ofs++] & 0xFF) << 8 | this.compactData[ofs++] & 0xFF;
    }

    protected int get4Bytes(int ofs) {
        return (this.compactData[ofs++] & 0xFF) << 24 | (this.compactData[ofs++] & 0xFF) << 16 | (this.compactData[ofs++] & 0xFF) << 8 | this.compactData[ofs++] & 0xFF;
    }

    protected long get5Bytes(int ofs) {
        return ((long)this.compactData[ofs++] & 0xFFL) << 32 | ((long)this.compactData[ofs++] & 0xFFL) << 24 | ((long)this.compactData[ofs++] & 0xFFL) << 16 | ((long)this.compactData[ofs++] & 0xFFL) << 8 | (long)this.compactData[ofs++] & 0xFFL;
    }

    protected FlatProfileContainer postGenerateFlatProfile() {
        FlatProfileContainerBacked fpc = new FlatProfileContainerBacked(this, this.timePerMethodId0, this.timePerMethodId1, this.totalTimePerMethodId0, this.totalTimePerMethodId1, this.invPerMethodId, this.timePerMethodId0.length);
        this.timePerMethodId1 = null;
        this.timePerMethodId0 = null;
        this.totalTimePerMethodId1 = null;
        this.totalTimePerMethodId0 = null;
        this.invPerMethodId = null;
        this.methodsOnStack = null;
        return fpc;
    }

    protected void preGenerateFlatProfile() {
        int totalMethods = this.cpuResSnapshot.getNInstrMethods();
        this.timePerMethodId0 = new long[totalMethods];
        this.totalTimePerMethodId0 = new long[totalMethods];
        if (this.collectingTwoTimeStamps) {
            this.timePerMethodId1 = new long[totalMethods];
            this.totalTimePerMethodId1 = new long[totalMethods];
        }
        this.invPerMethodId = new int[totalMethods];
        this.timePerMethodId0[0] = -1L;
        this.totalTimePerMethodId0[0] = -1L;
        this.methodsOnStack = new HashSet();
    }

    protected void store2Bytes(int ofs, int data) {
        this.compactData[ofs] = (byte)(data >> 8 & 0xFF);
        this.compactData[ofs + 1] = (byte)(data & 0xFF);
    }

    protected void store3Bytes(int ofs, int data) {
        int curPos = ofs;
        this.compactData[curPos++] = (byte)(data >> 16 & 0xFF);
        this.compactData[curPos++] = (byte)(data >> 8 & 0xFF);
        this.compactData[curPos++] = (byte)(data & 0xFF);
    }

    protected void store4Bytes(int ofs, int data) {
        int curPos = ofs;
        this.compactData[curPos++] = (byte)(data >> 24 & 0xFF);
        this.compactData[curPos++] = (byte)(data >> 16 & 0xFF);
        this.compactData[curPos++] = (byte)(data >> 8 & 0xFF);
        this.compactData[curPos++] = (byte)(data & 0xFF);
    }

    protected void store5Bytes(int ofs, long data) {
        int curPos = ofs;
        this.compactData[curPos++] = (byte)(data >> 32 & 0xFFL);
        this.compactData[curPos++] = (byte)(data >> 24 & 0xFFL);
        this.compactData[curPos++] = (byte)(data >> 16 & 0xFFL);
        this.compactData[curPos++] = (byte)(data >> 8 & 0xFFL);
        this.compactData[curPos++] = (byte)(data & 0xFFL);
    }

    private void addChild(AddChildLocalVars locals) {
        if (locals.node == null || locals.parent == null) {
            return;
        }
        locals.filterStatus = locals.node.getFilteredStatus();
        if (!(locals.node instanceof MethodCPUCCTNode)) {
            locals.filterStatus = 2;
        }
        switch (locals.filterStatus) {
            case 2: {
                locals.compParent = locals.parent;
                break;
            }
            case 1: {
                if (locals.node instanceof MethodCPUCCTNode) {
                    this.methodInfoMapper.lock(false);
                    try {
                        locals.className = this.methodInfoMapper.getInstrMethodClass(((MethodCPUCCTNode)locals.node).getMethodId()).replace('.', '/');
                        if (!this.filter.passes(locals.className)) {
                            locals.compParent = locals.parent;
                            break;
                        }
                        locals.newChild = (TimedCPUCCTNode)locals.node.clone();
                        locals.compParent = locals.newChild;
                        break;
                    }
                    finally {
                        this.methodInfoMapper.unlock();
                    }
                }
                locals.compParent = locals.parent;
                break;
            }
            case 0: {
                locals.existingChild = MethodCPUCCTNode.Locator.locate(((MethodCPUCCTNode)locals.node).getMethodId(), locals.parent.getChildren());
                if (locals.existingChild == null) {
                    locals.newChild = (TimedCPUCCTNode)locals.node.clone();
                    locals.compParent = locals.newChild;
                    break;
                }
                locals.newChild = null;
                locals.existingChild.addNCalls(locals.node.getNCalls());
                locals.existingChild.addNCallsDiff(locals.node.getNCallsDiff());
                locals.existingChild.addNetTime0(locals.node.getNetTime0());
                locals.existingChild.addNetTime1(locals.node.getNetTime1());
                locals.existingChild.addSleepTime0(locals.node.getSleepTime0());
                locals.existingChild.addWaitTime0(locals.node.getWaitTime0());
                locals.compParent = locals.existingChild;
                break;
            }
            default: {
                ProfilerLogger.warning("Unknown filtered status (" + locals.filterStatus + ") for " + locals.node);
            }
        }
        locals.nChildren = locals.node.getChildren() != null ? locals.node.getChildren().length : 0;
        for (int i = 0; i < locals.nChildren; ++i) {
            this.addChild(new AddChildLocalVars((TimedCPUCCTNode)locals.node.getChildren()[i], locals.compParent));
        }
        if (locals.newChild != null) {
            locals.parent.attachNodeAsChild(locals.newChild);
        } else if (locals.compParent == locals.parent && !locals.parent.isRoot()) {
            locals.parent.addNetTime0(locals.node.getNetTime0());
            locals.parent.addSleepTime0(locals.node.getSleepTime0());
            locals.parent.addWaitTime0(locals.node.getWaitTime0());
            locals.parent.addNCallsDiff(locals.node.getNCalls());
            if (this.collectingTwoTimeStamps) {
                locals.parent.addNetTime1(locals.node.getNetTime1());
            }
        }
    }

    private void addReversePath() {
        int stackTopIdx;
        PrestimeCPUCCTNode curNode = null;
        for (int i = stackTopIdx = this.nodeStackPtr - 1; i >= 0; --i) {
            int prevSourceNodeOfs;
            int sourceNodeOfs = this.nodeStack[i];
            int sourceNodeId = this.getMethodIdForNodeOfs(sourceNodeOfs);
            if (sourceNodeId == 0) {
                return;
            }
            boolean matchingChildFound = false;
            if (i < stackTopIdx) {
                PrestimeCPUCCTNodeFree[] curNodeChildren = (PrestimeCPUCCTNodeFree[])curNode.getChildren();
                if (curNodeChildren != null) {
                    for (int j = 0; j < curNodeChildren.length; ++j) {
                        if (curNodeChildren[j].getMethodId() != sourceNodeId) continue;
                        curNode = curNodeChildren[j];
                        if (curNode.isContextCallsNode()) {
                            prevSourceNodeOfs = this.nodeStack[i + 1];
                            this.mergeBySelfTime((PrestimeCPUCCTNodeFree)curNode, prevSourceNodeOfs);
                            curNode = (PrestimeCPUCCTNodeFree)curNode.getChildren()[0];
                        }
                        this.mergeBySelfTime((PrestimeCPUCCTNodeFree)curNode, sourceNodeOfs);
                        matchingChildFound = true;
                        break;
                    }
                }
            } else {
                curNode = this.reverseCCTRootNode;
                if (curNode == null) {
                    curNode = this.createChildlessCopyBySelfTime(sourceNodeOfs);
                    this.reverseCCTRootNode = curNode;
                } else {
                    this.mergeBySelfTime((PrestimeCPUCCTNodeFree)curNode, sourceNodeOfs);
                }
                matchingChildFound = true;
            }
            if (matchingChildFound) continue;
            PrestimeCPUCCTNodeFree newNode = this.createChildlessCopyBySelfTime(sourceNodeOfs);
            PrestimeCPUCCTNodeFree[] curNodeChildren = (PrestimeCPUCCTNodeFree[])curNode.getChildren();
            if (curNodeChildren != null) {
                prevSourceNodeOfs = this.nodeStack[i + 1];
                if (curNodeChildren.length == 1) {
                    PrestimeCPUCCTNodeFree origFirstChild = curNodeChildren[0];
                    PrestimeCPUCCTNodeFree ccNode = ((PrestimeCPUCCTNodeFree)curNode).createChildlessCopy();
                    this.subtractNodeDataBySelfTime(ccNode, prevSourceNodeOfs);
                    ccNode.setMethodId(origFirstChild.getMethodId());
                    ccNode.setContextCallsNode();
                    curNodeChildren[0] = ccNode;
                    ccNode.parent = curNode;
                    ccNode.addChild(origFirstChild);
                    origFirstChild.parent = ccNode;
                }
                PrestimeCPUCCTNodeFree ccNode = this.createChildlessCopyBySelfTime(prevSourceNodeOfs);
                ccNode.setMethodId(this.getMethodIdForNodeOfs(sourceNodeOfs));
                ccNode.setContextCallsNode();
                ((PrestimeCPUCCTNodeFree)curNode).addChild(ccNode);
                ccNode.parent = curNode;
                curNode = ccNode;
            }
            ((PrestimeCPUCCTNodeFree)curNode).addChild(newNode);
            newNode.parent = curNode;
            curNode = newNode;
        }
    }

    private void calculateThreadActiveTimesInMS(double[] threadActiveTimesInCounts) {
        this.wholeGraphGrossTimeAbs = (long)threadActiveTimesInCounts[0];
        this.wholeGraphGrossTimeThreadCPU = (long)threadActiveTimesInCounts[1];
        this.timeInInjectedCodeInAbsCounts = threadActiveTimesInCounts[2];
        this.timeInInjectedCodeInThreadCPUCounts = threadActiveTimesInCounts[3];
        wholeGraphGrossTimeAbsInMS += (double)this.wholeGraphGrossTimeAbs * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0;
        timeInInjectedCodeInMS += this.timeInInjectedCodeInAbsCounts * 1000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond0;
        this.wholeGraphPureTimeAbs += (long)((int)(((double)this.wholeGraphGrossTimeAbs - this.timeInInjectedCodeInAbsCounts) * 1000000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1));
        if (this.wholeGraphGrossTimeThreadCPU > 0L) {
            this.displayWholeThreadCPUTime = true;
            this.wholeGraphPureTimeThreadCPU += (long)((int)(((double)this.wholeGraphGrossTimeThreadCPU - this.timeInInjectedCodeInThreadCPUCounts) * 1000000.0 / (double)this.timingAdjuster.getInstrTimingData().timerCountsInSecond1));
        } else {
            this.displayWholeThreadCPUTime = false;
        }
        if (this.wholeGraphPureTimeAbs < 0L) {
            this.wholeGraphPureTimeAbs = 0L;
        }
        if (this.wholeGraphPureTimeThreadCPU < 0L) {
            this.wholeGraphPureTimeThreadCPU = 0L;
        }
        this.wholeGraphNetTime0 += this.get5Bytes(6);
        if (this.collectingTwoTimeStamps) {
            this.wholeGraphNetTime1 += this.get5Bytes(16);
        }
    }

    private PrestimeCPUCCTNodeFree createChildlessCopyBySelfTime(int sourceNodeDataOfs) {
        PrestimeCPUCCTNodeFree node = new PrestimeCPUCCTNodeFree(this, null, this.getMethodIdForNodeOfs(sourceNodeDataOfs));
        this.mergeBySelfTime(node, sourceNodeDataOfs);
        return node;
    }

    private TimedCPUCCTNode filterCCT(TimedCPUCCTNode rootNode) {
        TimedCPUCCTNode newRoot = (TimedCPUCCTNode)rootNode.clone();
        int nChildren = rootNode.getChildren() != null ? rootNode.getChildren().length : 0;
        for (int i = 0; i < nChildren; ++i) {
            this.addChild(new AddChildLocalVars((TimedCPUCCTNode)rootNode.getChildren()[i], newRoot));
        }
        newRoot.setNetTime0(0L);
        if (this.collectingTwoTimeStamps) {
            newRoot.setNetTime1(0L);
        }
        return newRoot;
    }

    private void generateCompactData(TimedCPUCCTNode rootNode, int nNodes) {
        this.nodeSize = this.collectingTwoTimeStamps ? 28 : 18;
        this.childOfsSize = 3;
        int arraySize = this.nodeSize * nNodes + this.childOfsSize * (nNodes - 1);
        if (arraySize > 0xFFFFFF) {
            this.childOfsSize = 4;
            arraySize = this.nodeSize * nNodes + this.childOfsSize * (nNodes - 1);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "generateCompact data: nNodes {0}", nNodes);
            LOGGER.log(Level.FINEST, "generateCompact data: node size {0}", this.nodeSize);
            LOGGER.log(Level.FINEST, "generateCompact data: array size {0}", arraySize);
            LOGGER.log(Level.FINEST, "generateCompact data: child offset {0}", this.childOfsSize);
        }
        this.compactData = new byte[arraySize];
        rootNode = this.filterCCT(rootNode);
        this.generateMirrorNode(new GenerateMirrorNodeLocalVars(rootNode, 0));
    }

    private int generateMirrorNode(GenerateMirrorNodeLocalVars locals) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Generate mirror node for ofs: {0}, node: {1}", new Object[]{locals.dataOfs, locals.rtNode});
        }
        this.generateNodeBase(locals.rtNode, locals.dataOfs);
        this.totalInvNo += (long)locals.rtNode.getNCalls();
        GenerateMirrorNodeLocalVars.access$1102(locals, locals.rtNode.getChildren());
        locals.nChildren = locals.nodeChildren != null ? locals.nodeChildren.length : 0;
        locals.nextNodeOfs = locals.dataOfs + this.nodeSize + locals.nChildren * this.childOfsSize;
        GenerateMirrorNodeLocalVars generateMirrorNodeLocalVars = locals;
        generateMirrorNodeLocalVars.nCallsFromThisNode = generateMirrorNodeLocalVars.nCallsFromThisNode + locals.rtNode.getNCallsDiff();
        if (locals.nChildren > 0) {
            locals.childCounter = 0;
            locals.i = 0;
            while (locals.i < locals.nChildren) {
                locals.aNode = (RuntimeCPUCCTNode)locals.nodeChildren[locals.i];
                if (locals.aNode instanceof MethodCPUCCTNode) {
                    this.setChildOfsForNodeOfs(locals.dataOfs, locals.childCounter, locals.nextNodeOfs);
                    locals.nextNodeOfs = this.generateMirrorNode(new GenerateMirrorNodeLocalVars((MethodCPUCCTNode)locals.aNode, locals.nextNodeOfs));
                    generateMirrorNodeLocalVars = locals;
                    generateMirrorNodeLocalVars.thisNodeTotalTime0InTimerUnits = generateMirrorNodeLocalVars.thisNodeTotalTime0InTimerUnits + this.childTotalTime0InTimerUnits;
                    if (this.collectingTwoTimeStamps) {
                        generateMirrorNodeLocalVars = locals;
                        generateMirrorNodeLocalVars.thisNodeTotalTime1InTimerUnits = generateMirrorNodeLocalVars.thisNodeTotalTime1InTimerUnits + this.childTotalTime1InTimerUnits;
                    }
                    generateMirrorNodeLocalVars = locals;
                    generateMirrorNodeLocalVars.nCallsFromThisNode = generateMirrorNodeLocalVars.nCallsFromThisNode + ((MethodCPUCCTNode)locals.aNode).getNCalls();
                    generateMirrorNodeLocalVars = locals;
                    generateMirrorNodeLocalVars.totalNCallsFromThisNode = generateMirrorNodeLocalVars.totalNCallsFromThisNode + this.childTotalNCalls;
                    locals.childCounter++;
                }
                locals.i++;
            }
        }
        locals.time = (long)this.timingAdjuster.adjustTime(locals.rtNode.getNetTime0(), locals.rtNode.getNCalls() + locals.rtNode.getNCallsDiff(), locals.nCallsFromThisNode, false);
        if (locals.time < 0L) {
            locals.time = 0L;
        }
        this.setSelfTime0ForNodeOfs(locals.dataOfs, locals.time);
        this.setWaitTime0ForNodeOfs(locals.dataOfs, locals.rtNode.getWaitTime0());
        this.setSleepTime0ForNodeOfs(locals.dataOfs, locals.rtNode.getSleepTime0());
        generateMirrorNodeLocalVars = locals;
        generateMirrorNodeLocalVars.thisNodeTotalTime0InTimerUnits = generateMirrorNodeLocalVars.thisNodeTotalTime0InTimerUnits + locals.rtNode.getNetTime0();
        this.childTotalTime0InTimerUnits = locals.thisNodeTotalTime0InTimerUnits;
        locals.time = (long)this.timingAdjuster.adjustTime(locals.thisNodeTotalTime0InTimerUnits, locals.rtNode.getNCalls() + locals.totalNCallsFromThisNode, locals.totalNCallsFromThisNode, false);
        if (locals.time < 0L) {
            locals.time = 0L;
        }
        this.setTotalTime0ForNodeOfs(locals.dataOfs, locals.time);
        if (this.collectingTwoTimeStamps) {
            locals.time = (long)this.timingAdjuster.adjustTime(locals.rtNode.getNetTime1(), locals.rtNode.getNCalls() + locals.rtNode.getNCallsDiff(), locals.nCallsFromThisNode, true);
            if (locals.time < 0L) {
                locals.time = 0L;
            }
            this.setSelfTime1ForNodeOfs(locals.dataOfs, locals.time);
            generateMirrorNodeLocalVars = locals;
            generateMirrorNodeLocalVars.thisNodeTotalTime1InTimerUnits = generateMirrorNodeLocalVars.thisNodeTotalTime1InTimerUnits + locals.rtNode.getNetTime1();
            this.childTotalTime1InTimerUnits = locals.thisNodeTotalTime1InTimerUnits;
            locals.time = (long)this.timingAdjuster.adjustTime(locals.thisNodeTotalTime1InTimerUnits, locals.rtNode.getNCalls() + locals.totalNCallsFromThisNode, locals.totalNCallsFromThisNode, true);
            if (locals.time < 0L) {
                locals.time = 0L;
            }
            this.setTotalTime1ForNodeOfs(locals.dataOfs, locals.time);
        }
        this.childTotalNCalls = locals.totalNCallsFromThisNode + locals.rtNode.getNCalls();
        return locals.nextNodeOfs;
    }

    private void generateNodeBase(TimedCPUCCTNode rtNode, int nodeDataOfs) {
        int methodId = rtNode instanceof MethodCPUCCTNode ? ((MethodCPUCCTNode)rtNode).getMethodId() : 0;
        int nCalls = rtNode.getNCalls();
        int nChildren = rtNode.getChildren() != null ? rtNode.getChildren().length : 0;
        this.setMethodIdForNodeOfs(nodeDataOfs, methodId);
        this.setNCallsForNodeOfs(nodeDataOfs, nCalls);
        this.setNChildrenForNodeOfs(nodeDataOfs, nChildren);
    }

    private void mergeBySelfTime(PrestimeCPUCCTNodeFree curNode, int sourceNodeDataOfs) {
        curNode.addNCalls(this.getNCallsForNodeOfs(sourceNodeDataOfs));
        curNode.addTotalTime0(this.getSelfTime0ForNodeOfs(sourceNodeDataOfs));
        if (this.collectingTwoTimeStamps) {
            curNode.addTotalTime1(this.getSelfTime1ForNodeOfs(sourceNodeDataOfs));
        }
        curNode.addWaitTime0(this.getWaitTime0ForNodeOfs(sourceNodeDataOfs));
        curNode.addSleepTime0(this.getSleepTime0ForNodeOfs(sourceNodeDataOfs));
    }

    private void subtractNodeDataBySelfTime(PrestimeCPUCCTNodeFree curNode, int sourceNodeDataOfs) {
        curNode.addNCalls(-this.getNCallsForNodeOfs(sourceNodeDataOfs));
        curNode.addTotalTime0(-this.getSelfTime0ForNodeOfs(sourceNodeDataOfs));
        if (this.collectingTwoTimeStamps) {
            curNode.addTotalTime1(-this.getSelfTime1ForNodeOfs(sourceNodeDataOfs));
        }
        curNode.addWaitTime0(-this.getWaitTime0ForNodeOfs(sourceNodeDataOfs));
        curNode.addSleepTime0(-this.getSleepTime0ForNodeOfs(sourceNodeDataOfs));
    }

    private static class GenerateMirrorNodeLocalVars {
        private final TimedCPUCCTNode rtNode;
        private final int dataOfs;
        private long thisNodeTotalTime0InTimerUnits;
        private long thisNodeTotalTime1InTimerUnits;
        private int nCallsFromThisNode;
        private int totalNCallsFromThisNode;
        private RuntimeCCTNode[] nodeChildren;
        private int nChildren;
        private int nextNodeOfs;
        private int childCounter;
        private int i;
        private RuntimeCPUCCTNode aNode;
        private long time;

        private GenerateMirrorNodeLocalVars(TimedCPUCCTNode node, int off) {
            this.rtNode = node;
            this.dataOfs = off;
        }

        static /* synthetic */ RuntimeCCTNode[] access$1102(GenerateMirrorNodeLocalVars x0, RuntimeCCTNode[] x1) {
            x0.nodeChildren = x1;
            return x1;
        }
    }

    private static final class AddChildLocalVars {
        private final TimedCPUCCTNode node;
        private final TimedCPUCCTNode parent;
        private TimedCPUCCTNode compParent;
        private TimedCPUCCTNode newChild;
        private int filterStatus;
        private int nChildren;
        private MethodCPUCCTNode existingChild;
        private String className;

        AddChildLocalVars(TimedCPUCCTNode n, TimedCPUCCTNode p) {
            this.node = n;
            this.parent = p;
        }
    }
}

