/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.netbeans.modules.db.dataview.util.ColorHelper;

public class JXTableDecorator
extends JXTable {
    public static final Color ROW_COLOR = ColorHelper.getTableBackground();
    public static final Color ALTERNATE_ROW_COLOR = ColorHelper.getTableAltbackground();
    public static final Color GRID_COLOR = ColorHelper.getTableGrid();
    public static final Color ROLLOVER_ROW_COLOR = ColorHelper.getTableRollOverRowBackground();

    JXTableDecorator() {
    }

    public JXTableDecorator(TableModel model, TableColumnModel columnModel, ListSelectionModel selectionModel) {
        super(model, columnModel, selectionModel);
    }

    public JXTableDecorator(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public JXTableDecorator(TableModel dm) {
        super(dm);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        if (rowCount * this.rowHeight < height) {
            for (int i = rowCount; i <= height / this.rowHeight; ++i) {
                g.setColor(this.backgroundColorForRow(i));
                g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
                this.drawHorizontalLine(g, clip, i);
            }
            this.drawVerticalLines(g, rowCount, height);
        }
    }

    protected void drawHorizontalLine(Graphics g, Rectangle clip, int i) {
        g.setColor(ResultSetJXTable.GRID_COLOR);
        g.drawLine(clip.x, i * this.rowHeight - 1, clip.x + clip.width, i * this.rowHeight - 1);
    }

    protected void drawVerticalLines(Graphics g, int rowCount, int height) {
        g.setColor(ResultSetJXTable.GRID_COLOR);
        TableColumnModel colModel = this.getColumnModel();
        int x = 0;
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            TableColumn column = colModel.getColumn(i);
            g.drawLine((x += column.getWidth()) - 1, rowCount * this.rowHeight, x - 1, height);
        }
    }

    protected Color backgroundColorForRow(int row) {
        return row % 2 == 0 ? ResultSetJXTable.ROW_COLOR : ResultSetJXTable.ALTERNATE_ROW_COLOR;
    }
}

