/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class RemoteFileChooserUtil {
    public static JFileChooser createFileChooser(FileSystem fs, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileSystem)fs);
        return RemoteFileChooserUtil.createFileChooser(env, titleText, buttonText, mode, filters, initialPath, useParent);
    }

    public static JFileChooser createFileChooser(ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, String initialPath, boolean useParent) {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(execEnv).setPreferences(NbPreferences.forModule(RemoteFileChooserUtil.class));
        FileChooserBuilder.JFileChooserEx fileChooser = fileChooserBuilder.createFileChooser(initialPath);
        fileChooser.setApproveButtonText(buttonText);
        fileChooser.setDialogTitle(titleText);
        fileChooser.setFileSelectionMode(mode);
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                fileChooser.addChoosableFileFilter(filters[i]);
            }
            fileChooser.setFileFilter(filters[0]);
        }
        return fileChooser;
    }

    public static JFileChooser createFileChooser(ExecutionEnvironment execEnv, String titleText, String buttonText, int mode, FileFilter[] filters, Callable<String> initialPath, boolean useParent) {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(execEnv).setPreferences(NbPreferences.forModule(RemoteFileChooserUtil.class));
        FileChooserBuilder.JFileChooserEx fileChooser = fileChooserBuilder.createFileChooser(initialPath);
        fileChooser.setApproveButtonText(buttonText);
        fileChooser.setDialogTitle(titleText);
        fileChooser.setFileSelectionMode(mode);
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                fileChooser.addChoosableFileFilter(filters[i]);
            }
            fileChooser.setFileFilter(filters[0]);
        }
        return fileChooser;
    }

    public static JFileChooser createProjectChooser(ExecutionEnvironment execEnv, String titleText, String description, String buttonText, String initialPath) {
        FileChooserBuilder.JFileChooserEx fileChooser = (FileChooserBuilder.JFileChooserEx)RemoteFileChooserUtil.createFileChooser(execEnv, titleText, buttonText, 1, null, initialPath, true);
        fileChooser.setFileView(new ProjectSelectionFileView((JFileChooser)fileChooser));
        return fileChooser;
    }

    public static String getCurrentChooserFile(String key, ExecutionEnvironment env) {
        if (env.isLocal()) {
            if (FileChooser.getCurrentChooserFile() != null) {
                return FileChooser.getCurrentChooserFile().getPath();
            }
            return null;
        }
        Preferences pref = NbPreferences.forModule(RemoteFileChooserUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        return pref.get("FileChooserPath" + envID + key, null);
    }

    public static void setCurrentChooserFile(String key, String path, ExecutionEnvironment env) {
        if (path == null) {
            return;
        }
        if (env.isLocal()) {
            FileChooser.setCurrentChooserFile((File)new File(path));
        } else {
            Preferences pref = NbPreferences.forModule(RemoteFileChooserUtil.class);
            String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
            pref.put("FileChooserPath" + envID + key, path);
        }
    }

    public static String getCurrentChooserFile(ExecutionEnvironment env) {
        if (env.isLocal()) {
            if (FileChooser.getCurrentChooserFile() != null) {
                return FileChooser.getCurrentChooserFile().getPath();
            }
            return null;
        }
        Preferences pref = NbPreferences.forModule(RemoteFileChooserUtil.class);
        String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        return pref.get("FileChooserPath" + envID, null);
    }

    public static void setCurrentChooserFile(String path, ExecutionEnvironment env) {
        if (path == null) {
            return;
        }
        if (env.isLocal()) {
            FileChooser.setCurrentChooserFile((File)new File(path));
        } else {
            Preferences pref = NbPreferences.forModule(RemoteFileChooserUtil.class);
            String envID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
            pref.put("FileChooserPath" + envID, path);
        }
    }

    private static final class ProjectSelectionFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = new RequestProcessor("ProjectIconFileView").create((Runnable)this);
        private File lookingForIcon;

        public ProjectSelectionFileView(JFileChooser chooser) {
            this.chooser = chooser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && !f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                ProjectSelectionFileView projectSelectionFileView = this;
                synchronized (projectSelectionFileView) {
                    Icon icon = this.knownProjectIcons.get(f);
                    if (icon != null) {
                        return icon;
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                        this.task.schedule(20);
                    }
                }
            }
            return this.chooser.getFileSystemView().getSystemIcon(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String path = this.lookingForIcon.getAbsolutePath();
            String project = path + "/nbproject";
            File projectDir = this.chooser.getFileSystemView().createFileObject(project);
            Icon icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            if (projectDir.exists() && projectDir.isDirectory() && projectDir.canRead()) {
                String projectXml = path + "/nbproject/project.xml";
                File projectFile = this.chooser.getFileSystemView().createFileObject(projectXml);
                if (projectFile.exists()) {
                    String conf = path + "/nbproject/configurations.xml";
                    File configuration = this.chooser.getFileSystemView().createFileObject(conf);
                    if (configuration.exists()) {
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/resources/makeProject.gif", (boolean)true);
                    }
                }
            }
            ProjectSelectionFileView projectSelectionFileView = this;
            synchronized (projectSelectionFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }
}

