/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmTemplateBasedReferencedObject;
import org.netbeans.modules.cnd.modelutil.ClassifiersAntiLoop;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.Lookup;

public abstract class CsmFileReferences {
    private static final CsmFileReferences EMPTY = new Empty();
    private static CsmFileReferences DEFAULT;

    public abstract void accept(CsmScope var1, Document var2, Visitor var3);

    public abstract void accept(CsmScope var1, Document var2, Visitor var3, Set<CsmReferenceKind> var4);

    public abstract void visit(Collection<CsmReference> var1, ReferenceVisitor var2);

    protected CsmFileReferences() {
    }

    public static CsmFileReferences getDefault() {
        if (DEFAULT != null) {
            return DEFAULT;
        }
        DEFAULT = (CsmFileReferences)Lookup.getDefault().lookup(CsmFileReferences.class);
        return DEFAULT == null ? EMPTY : DEFAULT;
    }

    public static boolean isTemplateBased(CsmReferenceContext context) {
        if (2 <= context.size() && CsmFileReferences.isDereference(context.getToken())) {
            CsmReference ref = context.getReference(context.size() - 2);
            if (ref != null) {
                if (CsmFileReferences.getDefault().isThis(ref)) {
                    return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.findContextClass(context), new ClassifiersAntiLoop());
                }
                CsmObject refObj = ref.getReferencedObject();
                if (CsmFileReferences.isTemplateParameterInvolved(refObj)) {
                    return true;
                }
                CsmType type = CsmFileReferences.getType(refObj);
                if (CsmUtilities.isAutoType((CsmType)type) && CsmKindUtilities.isOffsetable((Object)refObj)) {
                    GetTypeClassHandler handler = new GetTypeClassHandler();
                    CsmExpressionResolver.resolveType((CsmOffsetable)refObj, null, handler);
                    return CsmFileReferences.hasTemplateBasedAncestors(handler.clazz, new ClassifiersAntiLoop());
                }
                return CsmFileReferences.hasTemplateBasedAncestors(type, new ClassifiersAntiLoop());
            }
        } else {
            return CsmFileReferences.hasTemplateBasedAncestors(CsmFileReferences.findContextClass(context), new ClassifiersAntiLoop());
        }
        return false;
    }

    private static CsmType getType(CsmObject obj) {
        if (CsmKindUtilities.isFunction((CsmObject)obj)) {
            return ((CsmFunction)obj).getReturnType();
        }
        if (CsmKindUtilities.isVariable((CsmObject)obj)) {
            CsmType varType = ((CsmVariable)obj).getType();
            return varType;
        }
        if (CsmKindUtilities.isTypedef((CsmObject)obj) || CsmKindUtilities.isTypeAlias((CsmObject)obj)) {
            return ((CsmTypedef)obj).getType();
        }
        return null;
    }

    private static CsmClass findContextClass(CsmReferenceContext context) {
        CsmObject owner = context.getReference().getOwner();
        while (CsmKindUtilities.isScopeElement((CsmObject)owner)) {
            CsmFunction decl;
            if (CsmKindUtilities.isClass((CsmObject)owner)) {
                return (CsmClass)owner;
            }
            if (CsmKindUtilities.isClassMember((CsmObject)owner)) {
                return ((CsmMember)owner).getContainingClass();
            }
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)owner) ? CsmKindUtilities.isClassMember((CsmObject)(decl = ((CsmFunctionDefinition)owner).getDeclaration())) : CsmKindUtilities.isVariableDefinition((CsmObject)owner) && CsmKindUtilities.isClassMember((CsmObject)(decl = ((CsmVariableDefinition)owner).getDeclaration()))) {
                return ((CsmMember)decl).getContainingClass();
            }
            owner = ((CsmScopeElement)owner).getScope();
        }
        return null;
    }

    public static boolean hasTemplateBasedAncestors(CsmType type) {
        return CsmFileReferences.hasTemplateBasedAncestors(type, new ClassifiersAntiLoop());
    }

    private static boolean hasTemplateBasedAncestors(CsmType type, ClassifiersAntiLoop handledClasses) {
        CsmClassifier cls;
        if (type != null && CsmKindUtilities.isClass((CsmObject)(cls = type.getClassifier()))) {
            return CsmFileReferences.hasTemplateBasedAncestors((CsmClass)cls, handledClasses);
        }
        return false;
    }

    private static boolean hasTemplateBasedAncestors(CsmClass cls, ClassifiersAntiLoop handledClasses) {
        if (cls != null) {
            if (handledClasses.contains((CsmClassifier)cls)) {
                return false;
            }
            handledClasses.add((CsmClassifier)cls);
            if (CsmFileReferences.isActualInstantiation(cls)) {
                return false;
            }
            for (CsmInheritance inh : cls.getBaseClasses()) {
                if (inh.getAncestorType().isTemplateBased()) {
                    return true;
                }
                CsmClassifier classifier = inh.getClassifier();
                if (!(classifier instanceof CsmClass) || !CsmFileReferences.hasTemplateBasedAncestors((CsmClass)classifier, handledClasses)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isActualInstantiation(CsmClass cls) {
        if (CsmKindUtilities.isInstantiation((CsmObject)cls)) {
            CsmInstantiation instantiation = (CsmInstantiation)cls;
            Map mapping = instantiation.getMapping();
            for (CsmSpecializationParameter param : mapping.values()) {
                if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param) || !((CsmTypeBasedSpecializationParameter)param).isTemplateBased()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isMacroBased(CsmReferenceContext context) {
        CsmReference ref;
        if (2 <= context.size() && CsmFileReferences.isDereference(context.getToken()) && (ref = context.getReference(context.size() - 2)) != null && CsmKindUtilities.isMacro((CsmObject)ref.getReferencedObject())) {
            return true;
        }
        for (int i = context.size() - 1; 0 < i; --i) {
            CsmReference ref2;
            if (context.getToken(i) != CppTokenId.LPAREN || (ref2 = context.getReference(i - 1)) == null || !CsmKindUtilities.isMacro((CsmObject)ref2.getReferencedObject())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBuiltInBased(CsmReference ref) {
        CharSequence txt = null;
        if (ref != null) {
            txt = ref.getText();
        }
        if (txt != null && txt.length() > 0) {
            return CharSequenceUtils.startsWith((CharSequence)txt, (CharSequence)"__");
        }
        return false;
    }

    public static boolean isAfterUnresolved(CsmReferenceContext context) {
        CsmObject referencedObject;
        CsmReference ref;
        return 2 <= context.size() && CsmFileReferences.isDereference(context.getToken()) && (ref = context.getReference(context.size() - 2)) != null && !CsmFileReferences.getDefault().isThis(ref) && ((referencedObject = ref.getReferencedObject()) == null || referencedObject instanceof CsmTemplateBasedReferencedObject);
    }

    public static boolean isTemplateParameterInvolved(CsmObject obj) {
        if (CsmKindUtilities.isTemplateParameter((CsmObject)obj)) {
            return true;
        }
        CsmType type = CsmFileReferences.getType(obj);
        if (CsmUtilities.isAutoType((CsmType)type) && CsmKindUtilities.isOffsetable((Object)obj)) {
            IsTypeTemplateBasedHandler handler = new IsTypeTemplateBasedHandler();
            CsmExpressionResolver.resolveType((CsmOffsetable)obj, null, handler);
            return handler.isTemplateBased;
        }
        return type == null ? false : type.isTemplateBased();
    }

    public static boolean isDereference(CppTokenId token) {
        if (token == null) {
            return false;
        }
        switch (token) {
            case DOT: 
            case DOTMBR: 
            case ARROW: 
            case ARROWMBR: 
            case SCOPE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBracket(CppTokenId token) {
        if (token == null) {
            return false;
        }
        switch (token) {
            case LBRACE: 
            case LBRACKET: 
            case LPAREN: 
            case LT: {
                return true;
            }
        }
        return false;
    }

    protected boolean isThis(CsmReference ref) {
        return ref != null && "this".equals(ref.getText());
    }

    private static final class IsTypeTemplateBasedHandler
    implements CsmExpressionResolver.ResolvedTypeHandler {
        boolean isTemplateBased = false;

        private IsTypeTemplateBasedHandler() {
        }

        @Override
        public void process(CsmType resolvedType) {
            if (resolvedType != null) {
                this.isTemplateBased = resolvedType.isTemplateBased();
            }
        }
    }

    private static class GetTypeClassHandler
    implements CsmExpressionResolver.ResolvedTypeHandler {
        CsmClass clazz = null;

        private GetTypeClassHandler() {
        }

        @Override
        public void process(CsmType resolvedType) {
            CsmClassifier cls;
            if (resolvedType != null && CsmKindUtilities.isClass((CsmObject)(cls = resolvedType.getClassifier()))) {
                this.clazz = (CsmClass)cls;
            }
        }
    }

    public static interface ReferenceVisitor
    extends Interrupter {
        public void visit(CsmReference var1);
    }

    public static interface Visitor
    extends Interrupter {
        public void visit(CsmReferenceContext var1);
    }

    private static final class Empty
    extends CsmFileReferences {
        Empty() {
        }

        @Override
        public void accept(CsmScope csmScope, Document doc, Visitor visitor) {
        }

        @Override
        public void accept(CsmScope csmScope, Document doc, Visitor visitor, Set<CsmReferenceKind> preferedKinds) {
        }

        @Override
        public void visit(Collection<CsmReference> refs, ReferenceVisitor visitor) {
        }
    }
}

