/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lib.uno.helper.ComponentBase;
import com.sun.star.lib.uno.helper.PropertySetMixin;
import com.sun.star.report.meta.XFormulaParser;
import com.sun.star.sheet.FormulaOpCodeMapEntry;
import com.sun.star.sheet.FormulaToken;
import com.sun.star.sheet.XFormulaOpCodeMapper;
import com.sun.star.table.CellAddress;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.libreoffice.report.pentaho.SOFormulaOpCodeMapper;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.GeneratedFormulaParserConstants;
import org.pentaho.reporting.libraries.formula.parser.GeneratedFormulaParserTokenManager;
import org.pentaho.reporting.libraries.formula.parser.JavaCharStream;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.parser.Token;
import org.pentaho.reporting.libraries.formula.parser.TokenMgrError;

public final class SOFormulaParser
extends ComponentBase
implements XFormulaParser,
XServiceInfo {
    public static final int SEPARATORS = 0;
    public static final int ARRAY_SEPARATORS = 1;
    public static final int UNARY_OPERATORS = 2;
    public static final int BINARY_OPERATORS = 3;
    public static final int FUNCTIONS = 4;
    private final PropertySetMixin m_prophlp;
    private static final String __serviceName = "com.sun.star.report.meta.FormulaParser";
    private static final String OPERATORS = "org.pentaho.reporting.libraries.formula.operators.";
    private final List<FormulaOpCodeMapEntry> m_OpCodeMap = new ArrayList<FormulaOpCodeMapEntry>();
    private XFormulaOpCodeMapper formulaOpCodeMapper = null;
    private final Map<Integer, FormulaOpCodeMapEntry> parserAllOpCodes = new HashMap<Integer, FormulaOpCodeMapEntry>();
    private final Map<String, FormulaOpCodeMapEntry> parserNames = new HashMap<String, FormulaOpCodeMapEntry>();
    private final StringOpcodeMap[] groupOpCodes = new StringOpcodeMap[5];
    private final List<FormulaOpCodeMapEntry> specialOpCodes = new ArrayList<FormulaOpCodeMapEntry>();
    private int ownTokenCounter = 1000;
    private final FormulaOpCodeMapEntry opCodePush;
    private final FormulaParser parser;

    public SOFormulaParser(XComponentContext context) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.parser = new FormulaParser();
        try {
            int i;
            XFormulaOpCodeMapper mapper = (XFormulaOpCodeMapper)UnoRuntime.queryInterface(XFormulaOpCodeMapper.class, (Object)context.getServiceManager().createInstanceWithContext("simple.formula.FormulaOpCodeMapperObj", context));
            FormulaOpCodeMapEntry[] opCodes = mapper.getAvailableMappings(0, 16);
            DefaultFormulaContext defaultContext = new DefaultFormulaContext();
            FunctionRegistry functionRegistry = defaultContext.getFunctionRegistry();
            String[] names = functionRegistry.getFunctionNames();
            this.addOpCodes(names, opCodes, 4);
            names = this.getOperators(defaultContext, OPERATORS);
            opCodes = mapper.getAvailableMappings(0, 4);
            this.addOpCodes(names, opCodes, 2);
            opCodes = mapper.getAvailableMappings(0, 8);
            this.addOpCodes(names, opCodes, 3);
            names = (String[])GeneratedFormulaParserConstants.tokenImage.clone();
            for (i = 0; i < names.length; ++i) {
                String token = names[i];
                if (token == null || token.length() <= 0 || token.charAt(0) != '\"') continue;
                names[i] = token.substring(1, token.length() - 1);
            }
            opCodes = mapper.getAvailableMappings(0, 1);
            this.addOpCodes(names, opCodes, 0, false);
            opCodes = mapper.getAvailableMappings(0, 2);
            this.addOpCodes(names, opCodes, 1, false);
            opCodes = mapper.getAvailableMappings(0, 0);
            for (i = 0; i < opCodes.length; ++i) {
                FormulaOpCodeMapEntry opCode = opCodes[i];
                this.parserAllOpCodes.put(opCode.Token.OpCode, opCode);
                this.specialOpCodes.add(opCode);
            }
        }
        catch (com.sun.star.uno.Exception ex) {
            ex.printStackTrace();
        }
        this.opCodePush = this.specialOpCodes.get(0);
        Thread.currentThread().setContextClassLoader(cl);
        this.m_prophlp = new PropertySetMixin(context, (XInterface)this, new Type(XFormulaParser.class), null);
    }

    public FormulaToken[] parseFormula(String aFormula, CellAddress aReferencePos) {
        ArrayList<FormulaToken> tokens = new ArrayList<FormulaToken>();
        if (!"=".equals(aFormula)) {
            String formula = aFormula.charAt(0) == '=' ? aFormula.substring(1) : aFormula;
            ArrayList<String> images = new ArrayList<String>();
            try {
                int brackets = 0;
                GeneratedFormulaParserTokenManager tokenParser = new GeneratedFormulaParserTokenManager(new JavaCharStream((Reader)new StringReader(formula), 1, 1));
                Token token = tokenParser.getNextToken();
                while (token.kind != 0) {
                    FormulaToken formulaToken;
                    FormulaOpCodeMapEntry opCode;
                    images.add(token.image);
                    String upper = token.image.toUpperCase();
                    if (this.parserNames.containsKey(upper)) {
                        if ("(".equals(token.image)) {
                            ++brackets;
                        } else if (")".equals(token.image)) {
                            --brackets;
                        }
                        opCode = this.parserNames.get(upper);
                        formulaToken = opCode.Token;
                    } else if (token.kind == 1) {
                        opCode = this.specialOpCodes.get(8);
                        formulaToken = opCode.Token;
                    } else {
                        formulaToken = new FormulaToken();
                        formulaToken.OpCode = this.opCodePush.Token.OpCode;
                        formulaToken.Data = new Any(Type.STRING, (Object)token.image);
                    }
                    tokens.add(formulaToken);
                    token = tokenParser.getNextToken();
                }
                if (brackets > 0) {
                    FormulaOpCodeMapEntry opCode = this.parserNames.get(")");
                    while (brackets-- != 0) {
                        formula = formula.concat(")");
                        images.add(")");
                        tokens.add(opCode.Token);
                    }
                }
                this.parser.parse(formula);
            }
            catch (ParseException ex) {
                boolean found = false;
                for (int i = 0; i < tokens.size(); ++i) {
                    if (!found && ex.currentToken != null && ((String)images.get(i)).equals(ex.currentToken.image)) {
                        found = true;
                    }
                    if (!found) continue;
                    FormulaToken dest = new FormulaToken();
                    dest.OpCode = this.specialOpCodes.get((int)7).Token.OpCode;
                    dest.Data = new Any(Type.STRING, images.get(i));
                    tokens.remove(i);
                    tokens.add(i, dest);
                }
            }
            catch (Exception exception) {
            }
            catch (TokenMgrError tokenMgrError) {
                // empty catch block
            }
        }
        return tokens.toArray(new FormulaToken[tokens.size()]);
    }

    public String printFormula(FormulaToken[] aTokens, CellAddress aReferencePos) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < aTokens.length; ++i) {
            FormulaToken formulaToken = aTokens[i];
            if (formulaToken.OpCode == this.opCodePush.Token.OpCode && !formulaToken.Data.equals(Any.VOID)) {
                ret.append(formulaToken.Data);
                continue;
            }
            if (!this.parserAllOpCodes.containsKey(formulaToken.OpCode)) continue;
            FormulaOpCodeMapEntry opCode = this.parserAllOpCodes.get(formulaToken.OpCode);
            if (opCode.Name.length() > 0) {
                ret.append(opCode.Name);
                continue;
            }
            if (formulaToken.Data.equals(Any.VOID)) continue;
            ret.append(formulaToken.Data);
        }
        return ret.toString();
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this.m_prophlp.getPropertySetInfo();
    }

    public void setPropertyValue(String aPropertyName, Object aValue) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        this.m_prophlp.setPropertyValue(aPropertyName, aValue);
    }

    public Object getPropertyValue(String aPropertyName) throws UnknownPropertyException, WrappedTargetException {
        return this.m_prophlp.getPropertyValue(aPropertyName);
    }

    public void addPropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addPropertyChangeListener(aPropertyName, xListener);
    }

    public void removePropertyChangeListener(String aPropertyName, XPropertyChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removePropertyChangeListener(aPropertyName, xListener);
    }

    public void addVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.addVetoableChangeListener(aPropertyName, xListener);
    }

    public void removeVetoableChangeListener(String aPropertyName, XVetoableChangeListener xListener) throws UnknownPropertyException, WrappedTargetException {
        this.m_prophlp.removeVetoableChangeListener(aPropertyName, xListener);
    }

    public FormulaOpCodeMapEntry[] getOpCodeMap() {
        return this.m_OpCodeMap.toArray(new FormulaOpCodeMapEntry[this.m_OpCodeMap.size()]);
    }

    public void setOpCodeMap(FormulaOpCodeMapEntry[] the_value) {
    }

    public String getImplementationName() {
        return SOFormulaParser.class.getName();
    }

    public boolean supportsService(String sServiceName) {
        return sServiceName.equals(__serviceName);
    }

    public String[] getSupportedServiceNames() {
        return SOFormulaParser.getServiceNames();
    }

    public static String[] getServiceNames() {
        return new String[]{__serviceName};
    }

    public XFormulaOpCodeMapper getFormulaOpCodeMapper() {
        if (this.formulaOpCodeMapper == null) {
            this.formulaOpCodeMapper = new SOFormulaOpCodeMapper(this);
        }
        return this.formulaOpCodeMapper;
    }

    private void addOpCodes(String[] names, FormulaOpCodeMapEntry[] opCodes, int group) {
        this.addOpCodes(names, opCodes, group, true);
    }

    private void addOpCodes(String[] names, FormulaOpCodeMapEntry[] opCodes, int group, boolean add) {
        this.groupOpCodes[group] = new StringOpcodeMap();
        for (int j = 0; j < names.length; ++j) {
            int i;
            FormulaOpCodeMapEntry opCode = null;
            for (i = 0; i < opCodes.length; ++i) {
                opCode = opCodes[i];
                if (names[j].equals(opCode.Name)) break;
            }
            if (i >= opCodes.length) {
                if (!add) continue;
                FormulaToken token = new FormulaToken(this.ownTokenCounter++, (Object)Any.VOID);
                opCode = new FormulaOpCodeMapEntry(names[j], token);
            }
            this.parserNames.put(names[j], opCode);
            this.parserAllOpCodes.put(opCode.Token.OpCode, opCode);
            this.groupOpCodes[group].put(opCode.Token.OpCode, opCode);
        }
    }

    public Map<String, FormulaOpCodeMapEntry> getNames() {
        return this.parserNames;
    }

    public Map<Integer, FormulaOpCodeMapEntry> getGroup(int group) {
        return this.groupOpCodes[group];
    }

    private String[] getOperators(DefaultFormulaContext defaultContext, String _kind) {
        ArrayList<String> ops = new ArrayList<String>();
        Configuration configuration = defaultContext.getConfiguration();
        Iterator iter = configuration.findPropertyKeys(_kind);
        while (iter.hasNext()) {
            String tokenKey;
            String token;
            String operatorClass;
            String configKey = (String)iter.next();
            if (!configKey.endsWith(".class") || (operatorClass = configuration.getConfigProperty(configKey)) == null || operatorClass.length() == 0 || (token = configuration.getConfigProperty(tokenKey = configKey.substring(0, configKey.length() - ".class".length()) + ".token")) == null) continue;
            ops.add(token.trim());
        }
        return ops.toArray(new String[ops.size()]);
    }

    public List<FormulaOpCodeMapEntry> getSpecialOpCodes() {
        return this.specialOpCodes;
    }

    private static class StringOpcodeMap
    extends HashMap<Integer, FormulaOpCodeMapEntry> {
        private StringOpcodeMap() {
        }
    }
}

