/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.itext;

public final class BaseFontRecordKey {
    private String fileName;
    private final String encoding;
    private boolean embedded;
    private Integer hashCode;

    public BaseFontRecordKey(String fileName, String encoding, boolean embedded) {
        if (fileName == null) {
            throw new NullPointerException("font name is null.");
        }
        if (encoding == null) {
            throw new NullPointerException("Encoding is null.");
        }
        this.fileName = fileName;
        this.encoding = encoding;
        this.embedded = embedded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseFontRecordKey)) {
            return false;
        }
        BaseFontRecordKey key = (BaseFontRecordKey)o;
        if (this.embedded != key.embedded) {
            return false;
        }
        if (!this.fileName.equals(key.fileName)) {
            return false;
        }
        return this.encoding.equals(key.encoding);
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = this.fileName.hashCode();
            result = 29 * result + this.encoding.hashCode();
            result = 29 * result + (this.embedded ? 1 : 0);
            this.hashCode = new Integer(result);
        }
        return this.hashCode;
    }

    public String toString() {
        return "FontKey={name=" + this.fileName + "; encoding=" + this.encoding + "; embedded=" + this.embedded + '}';
    }
}

