/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.parser.FormulaParseException;
import org.pentaho.reporting.libraries.formula.parser.FormulaParser;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import org.pentaho.reporting.libraries.formula.parser.TokenMgrError;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.StaticArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.ErrorType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class Formula
implements Serializable,
Cloneable {
    private static final Log logger = LogFactory.getLog(Formula.class);
    private LValue rootReference;
    private static final long serialVersionUID = -1176925812499923546L;

    public Formula(String formulaText) throws ParseException {
        if (formulaText == null) {
            throw new NullPointerException();
        }
        try {
            FormulaParser parser = new FormulaParser();
            this.rootReference = parser.parse(formulaText.trim());
        }
        catch (TokenMgrError tokenMgrError) {
            throw new FormulaParseException(tokenMgrError);
        }
    }

    public Formula(LValue rootReference) {
        if (rootReference == null) {
            throw new NullPointerException();
        }
        this.rootReference = rootReference;
    }

    public void initialize(FormulaContext context) throws EvaluationException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.rootReference.initialize(context);
    }

    public LValue getRootReference() {
        return this.rootReference;
    }

    public TypeValuePair evaluateTyped() {
        try {
            TypeValuePair typeValuePair = this.rootReference.evaluate();
            if (typeValuePair == null) {
                return new TypeValuePair(ErrorType.TYPE, LibFormulaErrorValue.ERROR_NA_VALUE);
            }
            Type type = typeValuePair.getType();
            if (type.isFlagSet("type.error")) {
                logger.debug((Object)("Error: " + typeValuePair.getValue()));
            } else if (type.isFlagSet("type.array")) {
                Object value = typeValuePair.getValue();
                if (value instanceof ArrayCallback) {
                    return new TypeValuePair(type, new StaticArrayCallback((ArrayCallback)value));
                }
            } else {
                Object value = typeValuePair.getValue();
                if (value instanceof Number) {
                    return new TypeValuePair(type, NumberUtil.performTuneRounding(NumberUtil.getAsBigDecimal((Number)value)));
                }
            }
            return typeValuePair;
        }
        catch (EvaluationException ee) {
            return new TypeValuePair(ErrorType.TYPE, ee.getErrorValue());
        }
        catch (Exception e) {
            logger.warn((Object)"Evaluation failed unexpectedly: ", (Throwable)e);
            return new TypeValuePair(ErrorType.TYPE, LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    public Object evaluate() {
        TypeValuePair pair = this.evaluateTyped();
        Object value = pair.getValue();
        if (LibFormulaErrorValue.ERROR_NA_VALUE.equals(value)) {
            return null;
        }
        return value;
    }

    public Object clone() throws CloneNotSupportedException {
        Formula o = (Formula)super.clone();
        o.rootReference = (LValue)this.rootReference.clone();
        return o;
    }
}

