/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import org.jfree.layouting.input.style.keys.box.DisplayRole;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.renderer.model.PageAreaRenderBox;
import org.jfree.layouting.renderer.model.ParagraphPoolBox;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.table.TableCellRenderBox;
import org.jfree.layouting.renderer.model.table.TableColumnGroupNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableSectionRenderBox;
import org.jfree.layouting.renderer.process.BoxShifter;
import org.jfree.layouting.renderer.process.IterateVisualProcessStep;

public class PaginationStep
extends IterateVisualProcessStep {
    private long pageStartOffset;
    private boolean pageOverflow;
    private long shift;
    private long[] physicalBreaks;
    private long headerHeight;
    private long footerHeight;
    private long stickyMarker;
    private BoxShifter boxShifter = new BoxShifter();

    public boolean performPagebreak(LogicalPageBox logicalPageBox) {
        this.pageStartOffset = 0L;
        this.pageOverflow = false;
        this.shift = 0L;
        this.physicalBreaks = null;
        this.headerHeight = 0L;
        this.footerHeight = 0L;
        this.stickyMarker = 0L;
        this.pageStartOffset = logicalPageBox.getPageOffset();
        this.pageOverflow = false;
        this.stickyMarker = logicalPageBox.getChangeTracker();
        this.shift = 0L;
        this.startRootProcessing(logicalPageBox);
        return this.pageOverflow;
    }

    public long getNextOffset() {
        return this.physicalBreaks[this.physicalBreaks.length - 1];
    }

    private boolean isCrossingBreak(RenderNode renderNode) {
        int n = -1;
        int n2 = -1;
        long l = renderNode.getY() + this.shift;
        long l2 = l + renderNode.getHeight();
        for (int i = 0; i < this.physicalBreaks.length; ++i) {
            long l3 = this.physicalBreaks[i];
            if (l >= l3) {
                n = i;
            }
            if (l2 < l3) continue;
            n2 = i;
        }
        return n != n2;
    }

    private void startRootProcessing(LogicalPageBox logicalPageBox) {
        PageAreaRenderBox pageAreaRenderBox = logicalPageBox.getHeaderArea();
        this.headerHeight = pageAreaRenderBox.getHeight();
        pageAreaRenderBox.setHeight(this.headerHeight);
        PageAreaRenderBox pageAreaRenderBox2 = logicalPageBox.getFooterArea();
        this.footerHeight = pageAreaRenderBox2.getHeight();
        pageAreaRenderBox2.setHeight(this.footerHeight);
        long[] lArray = logicalPageBox.getPhysicalBreaks(1);
        this.physicalBreaks = new long[lArray.length + 1];
        this.physicalBreaks[0] = this.pageStartOffset;
        for (int i = 0; i < lArray.length; ++i) {
            this.physicalBreaks[i + 1] = this.pageStartOffset + (lArray[i] - this.headerHeight);
        }
        int n = this.physicalBreaks.length - 1;
        this.physicalBreaks[n] = this.physicalBreaks[n] - this.footerHeight;
        long l = this.physicalBreaks[this.physicalBreaks.length - 1] - this.physicalBreaks[0];
        if (l + this.headerHeight + this.footerHeight != logicalPageBox.getPageHeight()) {
            throw new IllegalStateException("Assertation failed: Page height");
        }
        if (this.startBlockLevelBox(logicalPageBox)) {
            this.processBoxChilds(logicalPageBox);
        }
        this.finishBlockLevelBox(logicalPageBox);
    }

    @Override
    protected boolean startInlineLevelBox(RenderBox renderBox) {
        return false;
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox paragraphRenderBox) {
        for (RenderNode renderNode = paragraphRenderBox.getVisibleFirst(); renderNode != null; renderNode = renderNode.getVisibleNext()) {
            if (!(renderNode instanceof ParagraphPoolBox)) {
                throw new IllegalStateException("Encountered " + renderNode.getClass());
            }
            ParagraphPoolBox paragraphPoolBox = (ParagraphPoolBox)renderNode;
            if (this.startLine(paragraphPoolBox)) {
                this.processBoxChilds(paragraphPoolBox);
            }
            this.finishLine(paragraphPoolBox);
        }
    }

    private boolean isNodeProcessable(RenderNode renderNode) {
        if (renderNode.getStickyMarker() == this.stickyMarker) {
            return false;
        }
        long l = renderNode.getY() + renderNode.getHeight();
        if (l < this.pageStartOffset) {
            return false;
        }
        return !renderNode.isIgnorableForRendering();
    }

    @Override
    protected void processBlockLevelNode(RenderNode renderNode) {
        if (!this.isNodeProcessable(renderNode)) {
            return;
        }
        renderNode.setY(renderNode.getY() + this.shift);
        if (!this.isCrossingBreak(renderNode)) {
            return;
        }
        long l = this.getNextBreak(renderNode.getY()) - renderNode.getY();
        renderNode.setY(renderNode.getY() + l);
        this.boxShifter.extendHeight(renderNode, l);
        this.shift += l;
        renderNode.setStickyMarker(this.stickyMarker);
    }

    protected void processTable(TableRenderBox tableRenderBox) {
        long l;
        long l2;
        long l3 = this.shift;
        long l4 = tableRenderBox.getHeight();
        long l5 = tableRenderBox.getY();
        long l6 = this.shift + l5 + l4;
        if (l6 < this.pageStartOffset) {
            return;
        }
        if (tableRenderBox.isIgnorableForRendering()) {
            return;
        }
        long l7 = this.getNextBreak(l5 + this.shift);
        long l8 = l7 - (l5 + this.shift);
        if (l8 > 0L) {
            l2 = Math.min(l4, tableRenderBox.getOrphansSize() + tableRenderBox.getWidowsSize());
            if (tableRenderBox.isAvoidPagebreakInside() || l2 > l8 || tableRenderBox.getOrphansSize() > l8) {
                l = l7 - l5;
                if (l > 0L) {
                    tableRenderBox.setY(tableRenderBox.getY() + l);
                    this.boxShifter.extendHeight(tableRenderBox.getParent(), l - this.shift);
                    this.shift = l;
                    tableRenderBox.setStickyMarker(this.stickyMarker);
                } else if (l < 0L) {
                    tableRenderBox.setY(tableRenderBox.getY() + this.shift);
                    this.pageOverflow = true;
                }
            } else {
                tableRenderBox.setY(tableRenderBox.getY() + this.shift);
                tableRenderBox.setStickyMarker(this.stickyMarker);
            }
        } else {
            tableRenderBox.setY(tableRenderBox.getY() + this.shift);
            tableRenderBox.setStickyMarker(this.stickyMarker);
        }
        this.processTableSection(tableRenderBox, DisplayRole.TABLE_HEADER_GROUP);
        this.processTableSection(tableRenderBox, DisplayRole.TABLE_ROW_GROUP);
        this.processTableSection(tableRenderBox, DisplayRole.TABLE_FOOTER_GROUP);
        l2 = tableRenderBox.getHeight();
        l = l2 - l4;
        if (l < 0L) {
            throw new IllegalStateException("A table can/must not shrink!");
        }
    }

    private void processTableSection(TableRenderBox tableRenderBox, CSSConstant cSSConstant) {
        RenderNode renderNode = tableRenderBox.getFirstChild();
        while (renderNode != null) {
            if (!(renderNode instanceof TableSectionRenderBox)) {
                renderNode = renderNode.getNext();
                continue;
            }
            TableSectionRenderBox tableSectionRenderBox = (TableSectionRenderBox)renderNode;
            if (!cSSConstant.equals(tableSectionRenderBox.getDisplayRole())) {
                renderNode = renderNode.getNext();
                continue;
            }
            this.startProcessing(renderNode);
            renderNode = renderNode.getNext();
        }
    }

    @Override
    protected void processBlockLevelChild(RenderNode renderNode) {
        if (renderNode instanceof TableRenderBox) {
            TableRenderBox tableRenderBox = (TableRenderBox)renderNode;
            this.processTable(tableRenderBox);
        } else {
            super.processBlockLevelChild(renderNode);
        }
    }

    @Override
    protected boolean startBlockLevelBox(RenderBox renderBox) {
        if (!this.isNodeProcessable(renderBox)) {
            return false;
        }
        long l = renderBox.getY();
        if (renderBox instanceof TableCellRenderBox) {
            renderBox.setY(l + this.shift);
            renderBox.setStickyMarker(this.stickyMarker);
            return true;
        }
        if (this.isOverflow(renderBox)) {
            this.pageOverflow = true;
            this.boxShifter.shiftBox(renderBox, this.shift);
            return false;
        }
        if (!this.isCrossingBreak(renderBox)) {
            this.boxShifter.shiftBox(renderBox, this.shift);
            return false;
        }
        if (renderBox instanceof TableColumnGroupNode) {
            throw new IllegalArgumentException("This is not expected here");
        }
        long l2 = this.getNextBreak(l + this.shift);
        long l3 = l2 - (l + this.shift);
        long l4 = renderBox.getHeight();
        long l5 = Math.min(l4, renderBox.getOrphansSize() + renderBox.getWidowsSize());
        if (renderBox.isAvoidPagebreakInside() || l3 < 0L || l5 > l4 || renderBox.getOrphansSize() > l3) {
            long l6 = l2 - l;
            if (l6 > 0L) {
                this.boxShifter.shiftBox(renderBox, l6);
                this.boxShifter.extendHeight(renderBox.getParent(), l6 - this.shift);
                this.shift = l6;
                renderBox.setStickyMarker(this.stickyMarker);
                return false;
            }
            if (l6 < 0L) {
                this.boxShifter.shiftBox(renderBox, this.shift);
                this.pageOverflow = true;
                return false;
            }
            return false;
        }
        renderBox.setY(renderBox.getY() + this.shift);
        renderBox.setStickyMarker(this.stickyMarker);
        return true;
    }

    private boolean isOverflow(RenderNode renderNode) {
        long l = this.physicalBreaks[this.physicalBreaks.length - 1];
        return renderNode.getY() + this.shift > l;
    }

    private long getNextBreak(long l) {
        for (int i = 0; i < this.physicalBreaks.length; ++i) {
            long l2 = this.physicalBreaks[i];
            if (l >= l2) continue;
            return l2;
        }
        return this.physicalBreaks[this.physicalBreaks.length - 1];
    }

    protected boolean startLine(ParagraphPoolBox paragraphPoolBox) {
        if (!this.isNodeProcessable(paragraphPoolBox)) {
            return false;
        }
        if (this.isOverflow(paragraphPoolBox)) {
            this.boxShifter.shiftBox(paragraphPoolBox, this.shift);
            this.pageOverflow = true;
            return false;
        }
        long l = this.getNextBreak(paragraphPoolBox.getY() + this.shift);
        long l2 = l - (paragraphPoolBox.getY() + this.shift);
        if (paragraphPoolBox.getHeight() < l2) {
            this.boxShifter.shiftBox(paragraphPoolBox, this.shift);
            paragraphPoolBox.setStickyMarker(this.stickyMarker);
            return false;
        }
        long l3 = l - paragraphPoolBox.getY();
        if (l3 > 0L) {
            this.boxShifter.shiftBox(paragraphPoolBox, l3);
            this.boxShifter.extendHeight(paragraphPoolBox, l3 - this.shift);
            this.shift = l3;
            paragraphPoolBox.setStickyMarker(this.stickyMarker);
        } else if (l3 < 0L) {
            this.pageOverflow = true;
            this.boxShifter.shiftBox(paragraphPoolBox, this.shift);
        } else {
            this.boxShifter.shiftBox(paragraphPoolBox, this.shift);
        }
        return false;
    }

    protected void finishLine(ParagraphPoolBox paragraphPoolBox) {
    }
}

